/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.test.AbstractModularityTest;
import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.owlapi.OntologyUtils;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;

public abstract class ModularityUpdateTest
extends AbstractModularityTest {
    @Test
    public void addNonLocal() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.D)};
        this.createOntology(axioms);
        IncrementalClassifier modular = new IncrementalClassifier(manager);
        modular.loadOntologies(Collections.singleton(this.ontology));
        modular.classify();
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.A, (OWLDescription)this.B));
        Assert.assertFalse((boolean)modular.isSubClassOf((OWLDescription)this.B, (OWLDescription)this.C));
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.C, (OWLDescription)this.D));
        OntologyUtils.addAxioms((OWLOntology)this.ontology, Arrays.asList(OWL.equivalentClasses((OWLDescription)this.D, (OWLDescription)OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)this.D)), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.C)));
        modular.classify();
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.A, (OWLDescription)this.B));
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.B, (OWLDescription)this.C));
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.C, (OWLDescription)this.D));
        OntologyUtils.removeAxioms((OWLOntology)this.ontology, Arrays.asList(OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B)));
        modular.classify();
        Assert.assertFalse((boolean)modular.isSubClassOf((OWLDescription)this.A, (OWLDescription)this.B));
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.B, (OWLDescription)this.C));
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.D, (OWLDescription)this.D));
        modular.dispose();
    }

    @Test
    public void deleteNonLocal() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.D), OWL.equivalentClasses((OWLDescription)this.D, (OWLDescription)OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)this.D))};
        this.createOntology(axioms);
        IncrementalClassifier modular = new IncrementalClassifier(manager);
        modular.loadOntologies(Collections.singleton(this.ontology));
        modular.classify();
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.A, (OWLDescription)this.B));
        Assert.assertFalse((boolean)modular.isSubClassOf((OWLDescription)this.B, (OWLDescription)this.C));
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.C, (OWLDescription)this.D));
        OntologyUtils.removeAxioms((OWLOntology)this.ontology, Arrays.asList(OWL.equivalentClasses((OWLDescription)this.D, (OWLDescription)OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)this.D))));
        OntologyUtils.addAxioms((OWLOntology)this.ontology, Arrays.asList(OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.C)));
        modular.classify();
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.A, (OWLDescription)this.B));
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.B, (OWLDescription)this.C));
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.C, (OWLDescription)this.D));
        OntologyUtils.removeAxioms((OWLOntology)this.ontology, Arrays.asList(OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B)));
        modular.classify();
        Assert.assertFalse((boolean)modular.isSubClassOf((OWLDescription)this.A, (OWLDescription)this.B));
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.B, (OWLDescription)this.C));
        Assert.assertTrue((boolean)modular.isSubClassOf((OWLDescription)this.D, (OWLDescription)this.D));
        modular.dispose();
    }
}

