/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.Iterator;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.Ignore;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletReasoner;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.test.PelletTestSuite;

public class MiscTests {
    @org.junit.Test
    public void test() {
        PelletOptions.USE_ANNOTATION_SUPPORT = false;
        String aOnt = "file:" + PelletTestSuite.base + "misc/ticket-247-test-case.rdf";
        PelletReasoner aReasoner = (PelletReasoner)PelletReasonerFactory.theInstance().create();
        InfModel aModel = ModelFactory.createInfModel((Reasoner)aReasoner, (Model)ModelFactory.createDefaultModel());
        aModel.read(aOnt);
        String aQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT ?x WHERE { ?y rdfs:comment ?x . }";
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)QueryFactory.create((String)aQuery), (Model)aModel);
        qe.execSelect();
    }

    @org.junit.Test
    public void testUndefinedVarInProjection() {
        Binding aBinding;
        String aOnt = "file:" + PelletTestSuite.base + "misc/ticket-277-test-case.rdf";
        PelletReasoner aReasoner = (PelletReasoner)PelletReasonerFactory.theInstance().create();
        InfModel aModel = ModelFactory.createInfModel((Reasoner)aReasoner, (Model)ModelFactory.createDefaultModel());
        aModel.read(aOnt);
        String aQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT ?y ?foo WHERE { ?y rdf:type ?x . }";
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)QueryFactory.create((String)aQuery), (Model)aModel);
        ResultSet aResults = qe.execSelect();
        while (aResults.hasNext()) {
            aBinding = aResults.nextBinding();
            Iterator aVarIter = aBinding.vars();
            while (aVarIter.hasNext()) {
                Var aVar = (Var)aVarIter.next();
                aBinding.get(aVar);
            }
        }
        aQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT ?foo WHERE { ?y rdf:type ?x . }";
        qe = SparqlDLExecutionFactory.create((Query)QueryFactory.create((String)aQuery), (Model)aModel);
        aResults = qe.execSelect();
        while (aResults.hasNext()) {
            aBinding = aResults.nextBinding();
            Assert.assertFalse((boolean)aBinding.vars().hasNext());
        }
    }

    @org.junit.Test
    public void testSizeEstimateNPE() {
        boolean savedValue = PelletOptions.USE_ANNOTATION_SUPPORT;
        boolean[] arr$ = new boolean[]{false, true};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            boolean b;
            PelletOptions.USE_ANNOTATION_SUPPORT = b = arr$[i$];
            String aOnt = "file:" + PelletTestSuite.base + "misc/ticket-276-test-case.rdf";
            PelletReasoner aReasoner = (PelletReasoner)PelletReasonerFactory.theInstance().create();
            InfModel aModel = ModelFactory.createInfModel((Reasoner)aReasoner, (Model)ModelFactory.createDefaultModel());
            aModel.read(aOnt);
            String aQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT ?x WHERE { ?y rdf:type owl:Thing . ?y rdfs:comment ?x . }";
            QueryExecution qe = SparqlDLExecutionFactory.create((Query)QueryFactory.create((String)aQuery), (Model)aModel);
            ResultSet aResults = qe.execSelect();
            Assert.assertTrue((boolean)aResults.hasNext());
        }
        PelletOptions.USE_ANNOTATION_SUPPORT = savedValue;
    }

    @org.junit.Test
    public void test248() {
        String aOnt = "file:" + PelletTestSuite.base + "misc/pizza.owl";
        PelletReasoner aReasoner = (PelletReasoner)PelletReasonerFactory.theInstance().create();
        InfModel aModel = ModelFactory.createInfModel((Reasoner)aReasoner, (Model)ModelFactory.createDefaultModel());
        aModel.read(aOnt);
        String aQuery = "PREFIX xsd:<http://www.w3.org/2001/XMLSchema#>\nPREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl:<http://www.w3.org/2002/07/owl#>\nPREFIX pizza: <http://www.co-ode.org/ontologies/pizza/pizza.owl#>\nSELECT ?v0 WHERE\n{\n ?v0 rdf:type ?v1.\n ?v1 rdf:type owl:Restriction.\n ?v1 owl:onProperty pizza:hasTopping.\n ?v1 owl:allValuesFrom ?v2.\n}";
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)QueryFactory.create((String)aQuery), (Model)aModel);
        qe.execSelect();
    }

    @Ignore(value="I don't know if this is actually testing the bug reported in #196")
    @org.junit.Test
    public void test196() {
        String aOnt = "file:" + PelletTestSuite.base + "misc/pizza.owl";
        PelletReasoner aReasoner = (PelletReasoner)PelletReasonerFactory.theInstance().create();
        InfModel aModel = ModelFactory.createInfModel((Reasoner)aReasoner, (Model)ModelFactory.createDefaultModel());
        aModel.read(aOnt);
        String aQuery = "PREFIX xsd:<http://www.w3.org/2001/XMLSchema#>\nPREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl:<http://www.w3.org/2002/07/owl#>\nPREFIX pizza: <http://www.co-ode.org/ontologies/pizza/pizza.owl#>\nSELECT ?v0 WHERE\n{\n ?v0 ?v1 owl:ObjectProperty.\n}";
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)QueryFactory.create((String)aQuery), (Model)aModel);
        qe.execSelect();
    }

    public static Test suite() {
        return new JUnit4TestAdapter(MiscTests.class);
    }
}

