/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.datatypes;

import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.Ignore;
import org.mindswap.pellet.datatypes.DatatypeFacet;
import org.mindswap.pellet.datatypes.XSDFloat;
import org.mindswap.pellet.datatypes.XSDInteger;

public class TestDatatypes {
    public static Test suite() {
        return new JUnit4TestAdapter(TestDatatypes.class);
    }

    @org.junit.Test
    public void floatExclusiveInterval() {
        Assert.assertEquals((long)0L, (long)XSDFloat.instance.deriveByRestriction(DatatypeFacet.minExclusive, (Object)Float.valueOf(Float.intBitsToFloat(0))).deriveByRestriction(DatatypeFacet.maxExclusive, (Object)Float.valueOf(Float.intBitsToFloat(1))).size());
        Assert.assertEquals((long)7L, (long)XSDFloat.instance.deriveByRestriction(DatatypeFacet.minExclusive, (Object)Float.valueOf(Float.intBitsToFloat(0))).deriveByRestriction(DatatypeFacet.maxExclusive, (Object)Float.valueOf(Float.intBitsToFloat(8))).size());
    }

    @org.junit.Test
    public void floatExclusiveRandom() {
        long seed = System.currentTimeMillis();
        Random rand = new Random(seed);
        try {
            float high = rand.nextFloat();
            float low = rand.nextFloat();
            if (low > high) {
                float tmp = low;
                low = high;
                high = tmp;
            }
            Assert.assertEquals((long)(Float.floatToIntBits(high) - Float.floatToIntBits(low) - 1), (long)XSDFloat.instance.deriveByRestriction(DatatypeFacet.minExclusive, (Object)Float.valueOf(low)).deriveByRestriction(DatatypeFacet.maxExclusive, (Object)Float.valueOf(high)).size());
        }
        catch (AssertionError e) {
            System.err.println("Random seed: " + seed);
            throw e;
        }
    }

    @org.junit.Test
    public void floatTwoZeros() {
        Assert.assertEquals((long)2L, (long)XSDFloat.instance.deriveByRestriction(DatatypeFacet.minExclusive, (Object)Float.valueOf(-1.4E-45f)).deriveByRestriction(DatatypeFacet.maxExclusive, (Object)Float.valueOf(Float.MIN_VALUE)).size());
    }

    @org.junit.Test
    public void integerExclusiveInterval() {
        Assert.assertEquals((long)0L, (long)XSDInteger.instance.deriveByRestriction(DatatypeFacet.minExclusive, (Object)0).deriveByRestriction(DatatypeFacet.maxExclusive, (Object)1).size());
        Assert.assertEquals((long)1L, (long)XSDInteger.instance.deriveByRestriction(DatatypeFacet.minExclusive, (Object)-1).deriveByRestriction(DatatypeFacet.maxExclusive, (Object)1).size());
    }

    @org.junit.Test
    @Ignore(value="Current implementation of size is integer based, anything greater than maxint returns -1")
    public void integerExclusiveIntervalExtreme() {
        Assert.assertEquals((long)0x7FFFFFFDL, (long)XSDInteger.instance.deriveByRestriction(DatatypeFacet.minExclusive, (Object)0).deriveByRestriction(DatatypeFacet.maxExclusive, (Object)Integer.MAX_VALUE).size());
        Assert.assertEquals((long)0xFFFFFFFEL, (long)XSDInteger.instance.deriveByRestriction(DatatypeFacet.minExclusive, (Object)-2147483647).deriveByRestriction(DatatypeFacet.maxExclusive, (Object)Integer.MAX_VALUE).size());
    }

    @org.junit.Test
    public void integerExclusiveRandom() {
        long seed = System.currentTimeMillis();
        Random rand = new Random(seed);
        try {
            int low;
            int high = rand.nextInt();
            do {
                if ((low = rand.nextInt()) <= high) continue;
                int tmp = low;
                low = high;
                high = tmp;
            } while (Long.valueOf(high) - Long.valueOf(low) > Integer.MAX_VALUE);
            Assert.assertEquals((long)(high - low - 1), (long)XSDInteger.instance.deriveByRestriction(DatatypeFacet.minExclusive, (Object)low).deriveByRestriction(DatatypeFacet.maxExclusive, (Object)high).size());
        }
        catch (AssertionError e) {
            System.err.println("Random seed: " + seed);
            throw e;
        }
    }
}

