/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.el;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.el.SimplifiedELClassifier;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.Before;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELTests {
    private KnowledgeBase kb = null;
    private ATermAppl A = TermFactory.term((String)"A");
    private ATermAppl B = TermFactory.term((String)"B");
    private ATermAppl C = TermFactory.term((String)"C");
    private ATermAppl D = TermFactory.term((String)"D");
    private ATermAppl E = TermFactory.term((String)"E");
    private ATermAppl F = TermFactory.term((String)"F");
    private ATermAppl G = TermFactory.term((String)"G");
    private ATermAppl[] X = new ATermAppl[5];
    private ATermAppl p = TermFactory.term((String)"p");
    private ATermAppl q = TermFactory.term((String)"q");
    private ATermAppl r = TermFactory.term((String)"r");
    private ATermAppl s = TermFactory.term((String)"s");
    private Class<? extends TaxonomyBuilder> builderClass = SimplifiedELClassifier.class;

    public static Test suite() {
        return new JUnit4TestAdapter(ELTests.class);
    }

    @Before
    public void setUp() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(this.A);
        this.kb.addClass(this.B);
        this.kb.addClass(this.C);
        this.kb.addClass(this.D);
        this.kb.addClass(this.E);
        this.kb.addClass(this.F);
        this.kb.addClass(this.G);
        for (int i = 0; i < this.X.length; ++i) {
            this.X[i] = TermFactory.term((String)("X" + i));
            this.kb.addClass(this.X[i]);
        }
        this.kb.addObjectProperty((ATerm)this.p);
        this.kb.addObjectProperty((ATerm)this.q);
        this.kb.addObjectProperty((ATerm)this.r);
        this.kb.addObjectProperty((ATerm)this.s);
    }

    public static <T> Set<Set<T>> singletonSets(T ... es) {
        HashSet<Set<T>> set = new HashSet<Set<T>>();
        for (T e : es) {
            set.add(Collections.singleton(e));
        }
        return set;
    }

    public Taxonomy<ATermAppl> getHierarchy() {
        Assert.assertTrue((String)"Expressivity is not EL", (boolean)this.kb.getExpressivity().isEL());
        TaxonomyBuilder builder = null;
        try {
            builder = this.builderClass.newInstance();
            builder.setKB(this.kb);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        builder.classify();
        Taxonomy taxonomy = builder.getTaxonomy();
        return taxonomy;
    }

    @org.junit.Test
    public void testEL1() {
        this.kb.addSubClass(this.A, TermFactory.and((ATermAppl)this.B, (ATermAppl)TermFactory.some((ATermAppl)this.p, (ATermAppl)this.C)));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)ATermUtils.TOP), this.D);
        this.kb.addSubClass(TermFactory.and((ATermAppl)this.B, (ATermAppl)this.D), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.A), (Object)hierarchy.getSubs((Object)this.B, true));
    }

    @org.junit.Test
    public void testEL2() {
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.C));
        this.kb.addSubClass(this.C, this.D);
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)this.D), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.D), (Object)hierarchy.getSupers((Object)this.C, true));
        Assert.assertEquals(ELTests.singletonSets(this.E), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testEL3a() {
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.C));
        this.kb.addSubClass(this.C, this.D);
        this.kb.addSubClass(this.C, this.E);
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)TermFactory.and((ATermAppl)this.D, (ATermAppl)this.E)), this.F);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.D, this.E), (Object)hierarchy.getSupers((Object)this.C, true));
        Assert.assertEquals(ELTests.singletonSets(this.F), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testEL3b() {
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.C));
        this.kb.addSubClass(this.C, this.D);
        this.kb.addSubClass(this.C, this.E);
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)this.G), this.F);
        this.kb.addEquivalentClass(this.G, TermFactory.and((ATermAppl)this.D, (ATermAppl)this.E));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.D, this.E), (Object)hierarchy.getSupers((Object)this.G, true));
        Assert.assertEquals(ELTests.singletonSets(this.F), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testEL3c() {
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)TermFactory.and((ATermAppl)this.C, (ATermAppl)this.D)));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)this.C), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.E), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testEL4() {
        this.kb.addSubClass(this.A, TermFactory.and((ATermAppl[])new ATermAppl[]{this.B, this.C, this.D}));
        this.kb.addSubClass(TermFactory.and((ATermAppl)this.C, (ATermAppl)this.D), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.A), (Object)hierarchy.getSubs((Object)this.B, true));
    }

    @org.junit.Test
    public void testEL5a() {
        this.kb.addSubClass(TermFactory.and((ATermAppl)this.A, (ATermAppl)TermFactory.some((ATermAppl)this.p, (ATermAppl)TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B), (ATermAppl)this.C))), this.D);
        this.kb.addSubClass(this.E, this.A);
        this.kb.addSubClass(this.E, this.F);
        this.kb.addSubClass(this.F, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.G));
        this.kb.addSubClass(this.G, this.C);
        this.kb.addSubClass(this.G, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.A, this.D, this.F), (Object)hierarchy.getSupers((Object)this.E, true));
    }

    @org.junit.Test
    public void testEL5b() {
        this.kb.addSubClass(TermFactory.and((ATermAppl)this.A, (ATermAppl)this.X[1]), this.D);
        this.kb.addEquivalentClass(this.X[1], TermFactory.some((ATermAppl)this.p, (ATermAppl)this.X[2]));
        this.kb.addEquivalentClass(this.X[2], TermFactory.and((ATermAppl)this.X[3], (ATermAppl)this.C));
        this.kb.addEquivalentClass(this.X[3], TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        this.kb.addSubClass(this.E, this.A);
        this.kb.addSubClass(this.E, this.F);
        this.kb.addSubClass(this.F, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.G));
        this.kb.addSubClass(this.G, this.C);
        this.kb.addSubClass(this.G, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.A, this.D, this.F), (Object)hierarchy.getSupers((Object)this.E, true));
    }

    @org.junit.Test
    public void testEL6() {
        this.kb.addSubClass(TermFactory.and((ATermAppl)this.A, (ATermAppl)TermFactory.some((ATermAppl)this.p, (ATermAppl)TermFactory.and((ATermAppl)this.B, (ATermAppl)this.C))), this.D);
        this.kb.addSubClass(this.E, this.A);
        this.kb.addSubClass(this.E, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.G));
        this.kb.addSubClass(this.G, this.B);
        this.kb.addSubClass(this.G, this.C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.A, this.D), (Object)hierarchy.getSupers((Object)this.E, true));
    }

    @org.junit.Test
    public void testEL7() {
        this.kb.addSubClass(this.A, this.B);
        this.kb.addSubClass(TermFactory.and((ATermAppl)this.A, (ATermAppl)this.B), TermFactory.and((ATermAppl[])new ATermAppl[]{this.C, this.D, ATermUtils.TOP}));
        this.kb.addSubClass(TermFactory.and((ATermAppl)this.A, (ATermAppl)this.C), this.E);
        this.kb.addSubClass(TermFactory.and((ATermAppl[])new ATermAppl[]{this.A, this.D, ATermUtils.TOP}), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.B, this.C, this.D, this.E), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testEL8() {
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        this.kb.addSubClass(this.B, this.C);
        this.kb.addSubClass(this.C, this.D);
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)TermFactory.and((ATermAppl)this.D, (ATermAppl)ATermUtils.TOP)), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.E), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testELNormalization1() {
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)TermFactory.and((ATermAppl)this.B, (ATermAppl)this.C)));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)TermFactory.and((ATermAppl)this.C, (ATermAppl)this.B)), this.D);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.D), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testELNormalization2() {
        this.kb.addSubClass(this.A, TermFactory.and((ATermAppl)this.B, (ATermAppl)TermFactory.and((ATermAppl)this.C, (ATermAppl)this.D)));
        this.kb.addSubClass(TermFactory.and((ATermAppl)this.C, (ATermAppl)TermFactory.and((ATermAppl)this.B, (ATermAppl)this.D)), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.B, this.C, this.D, this.E), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testELNormalization3() {
        this.kb.addSubClass(this.A, TermFactory.and((ATermAppl)this.B, (ATermAppl)TermFactory.and((ATermAppl[])new ATermAppl[]{this.C, this.D, TermFactory.and((ATermAppl)this.E, (ATermAppl)this.F)})));
        this.kb.addSubClass(TermFactory.and((ATermAppl)TermFactory.and((ATermAppl)this.C, (ATermAppl)this.F), (ATermAppl)TermFactory.and((ATermAppl[])new ATermAppl[]{this.B, this.D, this.E})), this.G);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.B, this.C, this.D, this.E, this.F, this.G), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testBottom1() {
        this.kb.addSubClass(this.A, ATermUtils.BOTTOM);
        this.kb.addSubClass(this.C, TermFactory.and((ATermAppl)this.A, (ATermAppl)this.B));
        this.kb.addSubClass(ATermUtils.BOTTOM, this.D);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{this.A, this.C}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @org.junit.Test
    public void testBottom2() {
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B), this.C);
        this.kb.addSubClass(this.C, ATermUtils.BOTTOM);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{this.A, this.C}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @org.junit.Test
    public void testTop1() {
        this.kb.addSubClass(ATermUtils.TOP, this.A);
        this.kb.addSubClass(this.C, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)this.A), this.D);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.D), (Object)hierarchy.getSupers((Object)this.C, true));
    }

    @org.junit.Test
    public void testBottomWithSome1() {
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        this.kb.addSubClass(this.B, ATermUtils.BOTTOM);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{this.A, this.B}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @org.junit.Test
    public void testBottomWithSome2() {
        this.kb.addSubClass(this.B, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.A));
        this.kb.addSubClass(this.A, ATermUtils.BOTTOM);
        this.kb.addSubClass(this.C, TermFactory.some((ATermAppl)this.q, (ATermAppl)this.B));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{this.A, this.B, this.C}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @org.junit.Test
    public void testDisjoint() {
        this.kb.addSubClass(TermFactory.and((ATermAppl)this.A, (ATermAppl)this.B), ATermUtils.BOTTOM);
        this.kb.addSubClass(this.A, this.B);
        this.kb.addDisjointClass(this.C, this.D);
        this.kb.addEquivalentClass(this.C, this.D);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{this.A, this.C, this.D}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @org.junit.Test
    public void testDisjointWithSome1() {
        this.kb.addSubProperty((ATerm)this.p, this.q);
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        this.kb.addSubClass(this.A, this.D);
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B), TermFactory.some((ATermAppl)this.p, (ATermAppl)this.C));
        this.kb.addDisjointClass(TermFactory.some((ATermAppl)this.q, (ATermAppl)this.C), this.D);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{this.A}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @org.junit.Test
    public void testDisjointWithSome2() {
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)TermFactory.and((ATermAppl)this.B, (ATermAppl)this.C)));
        this.kb.addDisjointClass(this.B, this.C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{this.A}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @org.junit.Test
    public void testRoles1a() {
        this.kb.addSubProperty((ATerm)this.p, this.q);
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.q, (ATermAppl)this.B), this.C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.C), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testRoles1b() {
        this.kb.addSubProperty((ATerm)this.p, this.q);
        this.kb.addSubClass(this.A, TermFactory.and((ATermAppl)this.D, (ATermAppl)TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B)));
        this.kb.addSubClass(TermFactory.and((ATermAppl)this.D, (ATermAppl)TermFactory.some((ATermAppl)this.q, (ATermAppl)this.B)), this.C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.C, this.D), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testRoles2a() {
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{this.p, this.p}), this.p);
        this.kb.addSubProperty((ATerm)this.q, this.p);
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.q, (ATermAppl)TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B)));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B), this.C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.C), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testRoles2b() {
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{this.p, this.q}), this.p);
        this.kb.addSubProperty((ATerm)this.r, this.q);
        this.kb.addSubClass(this.A, TermFactory.and((ATermAppl)this.F, (ATermAppl)TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B)));
        this.kb.addSubClass(this.B, TermFactory.and((ATermAppl)this.G, (ATermAppl)TermFactory.some((ATermAppl)this.r, (ATermAppl)this.C)));
        this.kb.addSubClass(this.C, TermFactory.some((ATermAppl)this.q, (ATermAppl)this.D));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)this.D), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.E, this.F), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testRoles2c() {
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{this.p, this.q}), this.p);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{this.p, this.q}), this.r);
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        this.kb.addSubClass(this.B, TermFactory.some((ATermAppl)this.q, (ATermAppl)this.C));
        this.kb.addSubClass(this.C, TermFactory.some((ATermAppl)this.q, (ATermAppl)this.D));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.r, (ATermAppl)this.D), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.E), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testRoles3a() {
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{this.p, this.q, this.r}), this.p);
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        this.kb.addSubClass(this.B, TermFactory.some((ATermAppl)this.q, (ATermAppl)this.C));
        this.kb.addSubClass(this.C, TermFactory.some((ATermAppl)this.r, (ATermAppl)this.D));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)this.D), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.E), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testRoles3b() {
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{this.p, this.q, this.r}), this.p);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{this.p, this.q, this.s}), this.s);
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        this.kb.addSubClass(this.B, TermFactory.some((ATermAppl)this.q, (ATermAppl)this.C));
        this.kb.addSubClass(this.C, TermFactory.some((ATermAppl)this.r, (ATermAppl)this.D));
        this.kb.addSubClass(this.D, TermFactory.some((ATermAppl)this.q, (ATermAppl)this.E));
        this.kb.addSubClass(this.E, TermFactory.some((ATermAppl)this.s, (ATermAppl)this.F));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.s, (ATermAppl)this.F), this.G);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.G), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testRoles4() {
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{this.q, this.r}), this.s);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{this.p, this.q, this.r, this.s}), this.p);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{this.p, this.s}), this.p);
        this.kb.addSubClass(this.X[0], this.X[1]);
        this.kb.addSubClass(this.A, TermFactory.and((ATermAppl)this.X[0], (ATermAppl)TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B)));
        this.kb.addSubClass(this.B, TermFactory.and((ATermAppl)this.X[1], (ATermAppl)TermFactory.some((ATermAppl)this.q, (ATermAppl)this.C)));
        this.kb.addSubClass(this.C, TermFactory.and((ATermAppl)this.X[2], (ATermAppl)TermFactory.some((ATermAppl)this.r, (ATermAppl)this.D)));
        this.kb.addSubClass(this.D, TermFactory.and((ATermAppl)this.X[1], (ATermAppl)TermFactory.some((ATermAppl)this.s, (ATermAppl)this.E)));
        this.kb.addSubClass(TermFactory.and((ATermAppl)this.X[0], (ATermAppl)TermFactory.some((ATermAppl)this.p, (ATermAppl)this.E)), this.F);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.X[0], this.F), (Object)hierarchy.getSupers((Object)this.A, true));
    }

    @org.junit.Test
    public void testHeart() {
        this.kb = new KnowledgeBase();
        ATermAppl endocardium = TermFactory.term((String)"Endocardium");
        ATermAppl tissue = TermFactory.term((String)"Tissue");
        ATermAppl heartWall = TermFactory.term((String)"HeartWall");
        ATermAppl heartValve = TermFactory.term((String)"HeartValve");
        ATermAppl bodyWall = TermFactory.term((String)"BodyWall");
        ATermAppl bodyValve = TermFactory.term((String)"BodyValve");
        ATermAppl heart = TermFactory.term((String)"Heart");
        ATermAppl endocarditis = TermFactory.term((String)"Endocarditis");
        ATermAppl inflammation = TermFactory.term((String)"Inflammation");
        ATermAppl disease = TermFactory.term((String)"Disease");
        ATermAppl heartDisease = TermFactory.term((String)"HeartDisease");
        ATermAppl criticalDisease = TermFactory.term((String)"CriticalDisease");
        ATermAppl contIn = TermFactory.term((String)"cont-in");
        ATermAppl partOf = TermFactory.term((String)"part-of");
        ATermAppl hasLoc = TermFactory.term((String)"has-loc");
        ATermAppl actsOn = TermFactory.term((String)"acts-on");
        this.kb.addClass(endocardium);
        this.kb.addClass(tissue);
        this.kb.addClass(heartWall);
        this.kb.addClass(heartValve);
        this.kb.addClass(bodyWall);
        this.kb.addClass(bodyValve);
        this.kb.addClass(heart);
        this.kb.addClass(endocarditis);
        this.kb.addClass(inflammation);
        this.kb.addClass(disease);
        this.kb.addClass(heartDisease);
        this.kb.addClass(criticalDisease);
        this.kb.addObjectProperty((ATerm)contIn);
        this.kb.addObjectProperty((ATerm)partOf);
        this.kb.addObjectProperty((ATerm)hasLoc);
        this.kb.addObjectProperty((ATerm)actsOn);
        this.kb.addSubClass(endocardium, TermFactory.and((ATermAppl[])new ATermAppl[]{tissue, TermFactory.some((ATermAppl)contIn, (ATermAppl)heartWall), TermFactory.some((ATermAppl)contIn, (ATermAppl)heartValve)}));
        this.kb.addSubClass(heartWall, TermFactory.and((ATermAppl)bodyWall, (ATermAppl)TermFactory.some((ATermAppl)partOf, (ATermAppl)heart)));
        this.kb.addSubClass(heartValve, TermFactory.and((ATermAppl)bodyValve, (ATermAppl)TermFactory.some((ATermAppl)partOf, (ATermAppl)heart)));
        this.kb.addSubClass(endocarditis, TermFactory.and((ATermAppl)inflammation, (ATermAppl)TermFactory.some((ATermAppl)hasLoc, (ATermAppl)endocardium)));
        this.kb.addSubClass(inflammation, TermFactory.and((ATermAppl)disease, (ATermAppl)TermFactory.some((ATermAppl)actsOn, (ATermAppl)tissue)));
        this.kb.addSubClass(TermFactory.and((ATermAppl)heartDisease, (ATermAppl)TermFactory.some((ATermAppl)hasLoc, (ATermAppl)heartValve)), criticalDisease);
        this.kb.addEquivalentClass(heartDisease, TermFactory.and((ATermAppl)disease, (ATermAppl)TermFactory.some((ATermAppl)hasLoc, (ATermAppl)heart)));
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{partOf, partOf}), partOf);
        this.kb.addSubProperty((ATerm)partOf, contIn);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{hasLoc, contIn}), hasLoc);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(ATermUtils.TOP, inflammation, disease, heartDisease, criticalDisease), (Object)hierarchy.getSupers((Object)endocarditis));
    }

    @org.junit.Test
    public void testDomain1() {
        this.kb.addDomain((ATerm)this.p, this.A);
        this.kb.addSubClass(this.B, TermFactory.some((ATermAppl)this.p, (ATermAppl)ATermUtils.TOP));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.A), (Object)hierarchy.getSupers((Object)this.B, true));
    }

    @org.junit.Test
    public void testDomain2() {
        this.kb.addDomain((ATerm)this.p, TermFactory.and((ATermAppl)this.A, (ATermAppl)this.B));
        this.kb.addDomain((ATerm)this.p, this.C);
        this.kb.addSubClass(this.B, TermFactory.some((ATermAppl)this.p, (ATermAppl)ATermUtils.TOP));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.A, this.C), (Object)hierarchy.getSupers((Object)this.B, true));
    }

    @org.junit.Test
    public void testDomainAbsorption() {
        this.kb.addDomain((ATerm)this.p, this.A);
        this.kb.addSubClass(TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B), (ATermAppl)TermFactory.some((ATermAppl)this.p, (ATermAppl)ATermUtils.TOP)), this.C);
        this.kb.addSubClass(this.E, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.D));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.A), (Object)hierarchy.getSupers((Object)this.E, true));
    }

    @org.junit.Test
    public void testDomainBottom() {
        this.kb.addDomain((ATerm)this.p, ATermUtils.BOTTOM);
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{this.A}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @org.junit.Test
    public void testReflexiveRole() {
        this.kb.addReflexiveProperty(this.p);
        this.kb.addRange((ATerm)this.p, this.A);
        this.kb.addRange((ATerm)this.p, TermFactory.and((ATermAppl)this.B, (ATermAppl)this.C));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{this.A, this.B, this.C}), (Object)hierarchy.getEquivalents((Object)ATermUtils.TOP));
    }

    @org.junit.Test
    public void testRange1() {
        this.kb.addRange((ATerm)this.p, this.A);
        this.kb.addSubClass(this.B, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.C));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)this.A), this.D);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.D), (Object)hierarchy.getSupers((Object)this.B, true));
    }

    @org.junit.Test
    public void testRange2() {
        this.kb.addRange((ATerm)this.p, TermFactory.and((ATermAppl)this.A, (ATermAppl)this.B));
        this.kb.addSubClass(this.C, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.D));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)TermFactory.and((ATermAppl)this.A, (ATermAppl)this.B)), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.E), (Object)hierarchy.getSupers((Object)this.C, true));
    }

    @org.junit.Test
    public void testRange3() {
        this.kb.addRange((ATerm)this.p, TermFactory.and((ATermAppl)this.A, (ATermAppl)this.B));
        this.kb.addSubClass(this.C, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.D));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)this.A), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.E), (Object)hierarchy.getSupers((Object)this.C, true));
    }

    @org.junit.Test
    public void testRange5() {
        this.kb.addRange((ATerm)this.p, this.A);
        this.kb.addSubClass(this.B, TermFactory.and((ATermAppl)this.A, (ATermAppl)TermFactory.some((ATermAppl)this.p, (ATermAppl)this.C)));
        this.kb.addSubClass(this.C, this.A);
        this.kb.addEquivalentClass(this.D, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.C));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.B, this.C), (Object)hierarchy.getSubs((Object)this.A, true));
    }

    @org.junit.Test
    public void testDomainNormalization1() {
        this.kb.addDomain((ATerm)this.p, TermFactory.some((ATermAppl)this.q, (ATermAppl)this.C));
        this.kb.addDomain((ATerm)this.p, TermFactory.and((ATermAppl)this.B, (ATermAppl)this.C));
        this.kb.addSubClass(this.D, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.X[1]));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.q, (ATermAppl)this.C), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.B, this.C, this.E), (Object)hierarchy.getSupers((Object)this.D, true));
    }

    @org.junit.Test
    public void testRangeNormalization1() {
        this.kb.addRange((ATerm)this.p, this.A);
        this.kb.addRange((ATerm)this.p, TermFactory.and((ATermAppl)this.B, (ATermAppl)this.C));
        this.kb.addSubClass(this.D, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.X[1]));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)TermFactory.and((ATermAppl)TermFactory.and((ATermAppl)this.A, (ATermAppl)this.B), (ATermAppl)this.C)), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.E), (Object)hierarchy.getSupers((Object)this.D, true));
    }

    @org.junit.Test
    public void testRangeNormalization2() {
        this.kb.addRange((ATerm)this.p, TermFactory.some((ATermAppl)this.q, (ATermAppl)this.A));
        this.kb.addSubClass(this.B, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.X[0]));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)TermFactory.some((ATermAppl)this.q, (ATermAppl)this.A)), this.C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.C), (Object)hierarchy.getSupers((Object)this.B, true));
    }

    @org.junit.Test
    public void testDomainAndRange() {
        this.kb.addRange((ATerm)this.p, this.A);
        this.kb.addDomain((ATerm)this.q, this.B);
        this.kb.addSubClass(this.C, TermFactory.some((ATermAppl)this.p, (ATermAppl)ATermUtils.TOP));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)this.A), TermFactory.some((ATermAppl)this.q, (ATermAppl)ATermUtils.TOP));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.B), (Object)hierarchy.getSupers((Object)this.C, true));
    }

    @org.junit.Test
    public void testRange4() {
        this.kb.addRange((ATerm)this.p, this.C);
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        this.kb.addSubClass(TermFactory.and((ATermAppl)this.B, (ATermAppl)this.C), this.D);
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)this.D), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.A), (Object)hierarchy.getSubs((Object)this.E, true));
    }

    @org.junit.Test
    public void testSomeConjunction() {
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)TermFactory.and((ATermAppl[])new ATermAppl[]{this.B, this.C, this.D})));
        this.kb.addSubClass(TermFactory.some((ATermAppl)this.p, (ATermAppl)TermFactory.and((ATermAppl)this.B, (ATermAppl)this.C)), this.E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(this.A), (Object)hierarchy.getSubs((Object)this.E, true));
    }

    @org.junit.Test
    public void testDisjointRange() {
        this.kb.addRange((ATerm)this.p, this.C);
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        this.kb.addDisjointClass(this.B, this.C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{this.A}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @org.junit.Test
    public void testDisjointRangeSuper() {
        this.kb.addRange((ATerm)this.p, this.C);
        this.kb.addSubClass(this.A, TermFactory.some((ATermAppl)this.p, (ATermAppl)this.B));
        this.kb.addSubClass(this.B, this.D);
        this.kb.addDisjointClass(this.D, this.C);
        this.kb.addSubClass(this.A, this.E);
        this.kb.addSubClass(this.B, this.F);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{this.A}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }
}

