/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.owlapi;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.owlapi.OntologyUtils;
import com.clarkparsia.owlapi.SWRL;
import com.clarkparsia.owlapi.XSD;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.owlapi.AxiomConverter;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.progress.ConsoleProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.io.StringInputSource;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologyURIMapper;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import uk.ac.manchester.cs.owl.OWLOntologyURIMapperImpl;

public class OWLAPITests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(OWLAPITests.class);
    }

    @Before
    @After
    public void resetOntologyManager() {
        for (OWLOntology o : OWL.manager.getOntologies()) {
            OWL.manager.removeOntology(o.getURI());
        }
    }

    @Test
    public void testOWL2() throws OWLException {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "owl2.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.setOntology(ont);
        OWLClass C = OWL.Class((String)(ns + "C"));
        OWLClass D = OWL.Class((String)(ns + "D"));
        OWLClass D1 = OWL.Class((String)(ns + "D1"));
        OWLClass D2 = OWL.Class((String)(ns + "D2"));
        OWLClass D3 = OWL.Class((String)(ns + "D3"));
        OWLClass test1 = OWL.Class((String)(ns + "test1"));
        OWLClass test2 = OWL.Class((String)(ns + "test2"));
        OWLClass test3 = OWL.Class((String)(ns + "test3"));
        OWLClass OlderThan10 = OWL.Class((String)(ns + "OlderThan10"));
        OWLClass YoungerThan20 = OWL.Class((String)(ns + "YoungerThan20"));
        OWLClass Teenager = OWL.Class((String)(ns + "Teenager"));
        OWLClass Teen = OWL.Class((String)(ns + "Teen"));
        OWLIndividual ind1 = OWL.Individual((String)(ns + "ind1"));
        OWLIndividual ind3 = OWL.Individual((String)(ns + "ind3"));
        OWLIndividual ind4 = OWL.Individual((String)(ns + "ind4"));
        OWLIndividual ind5 = OWL.Individual((String)(ns + "ind5"));
        OWLIndividual ind6 = OWL.Individual((String)(ns + "ind6"));
        OWLObjectProperty p = OWL.ObjectProperty((String)(ns + "p"));
        OWLObjectProperty r = OWL.ObjectProperty((String)(ns + "r"));
        OWLObjectProperty invR = OWL.ObjectProperty((String)(ns + "invR"));
        OWLObjectProperty ir = OWL.ObjectProperty((String)(ns + "ir"));
        OWLObjectProperty as = OWL.ObjectProperty((String)(ns + "as"));
        OWLObjectProperty d1 = OWL.ObjectProperty((String)(ns + "d1"));
        OWLObjectProperty d2 = OWL.ObjectProperty((String)(ns + "d2"));
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.isReflexive(r));
        Assert.assertTrue((boolean)reasoner.isReflexive(invR));
        Assert.assertTrue((boolean)reasoner.isIrreflexive(ir));
        Assert.assertTrue((boolean)reasoner.isAntiSymmetric(as));
        Assert.assertTrue((boolean)reasoner.isEquivalentClass((OWLDescription)D, (OWLDescription)OWL.or((OWLDescription[])new OWLDescription[]{D1, D2, D3})));
        Assert.assertTrue((boolean)reasoner.isEquivalentClass((OWLDescription)D, (OWLDescription)test1));
        Assert.assertTrue((boolean)reasoner.isDisjointWith((OWLDescription)D1, (OWLDescription)D2));
        Assert.assertTrue((boolean)reasoner.isDisjointWith((OWLDescription)D1, (OWLDescription)D3));
        Assert.assertTrue((boolean)reasoner.isDisjointWith((OWLDescription)D2, (OWLDescription)D3));
        Assert.assertTrue((boolean)reasoner.isDisjointWith(d1, d2));
        Assert.assertTrue((boolean)reasoner.isDisjointWith(d2, d1));
        Assert.assertFalse((boolean)reasoner.isDisjointWith(p, r));
        Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(ind1, (OWLObjectPropertyExpression)r, ind1));
        Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(ind1, (OWLObjectPropertyExpression)invR, ind1));
        Assert.assertTrue((boolean)reasoner.isDifferentFrom(ind1, ind3));
        Assert.assertTrue((boolean)reasoner.isDifferentFrom(ind1, ind4));
        Assert.assertTrue((boolean)reasoner.isDifferentFrom(ind5, ind6));
        Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(ind1, (OWLObjectPropertyExpression)p, ind1));
        Assert.assertTrue((boolean)reasoner.hasType(ind1, (OWLDescription)test2));
        Assert.assertTrue((boolean)reasoner.hasType(ind1, (OWLDescription)test3));
        PelletTestCase.assertIteratorValues(SetUtils.union((Collection)reasoner.getTypes(ind1, false)).iterator(), new Object[]{OWL.Thing, C, test2, test3});
        Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)Teenager, (OWLDescription)OlderThan10));
        Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)Teenager, (OWLDescription)YoungerThan20));
        Assert.assertTrue((boolean)reasoner.isEquivalentClass((OWLDescription)Teenager, (OWLDescription)Teen));
    }

    @Test
    public void testUncle() throws OWLException {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "uncle.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.setOntology(ont);
        OWLIndividual Bob = OWL.Individual((String)(ns + "Bob"));
        OWLIndividual Sam = OWL.Individual((String)(ns + "Sam"));
        OWLObjectProperty uncleOf = OWL.ObjectProperty((String)(ns + "uncleOf"));
        OWLAPITests.assertPropertyValues(reasoner, Bob, uncleOf, Sam);
    }

    @Test
    public void testSibling() throws OWLException {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "sibling.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.setOntology(ont);
        OWLIndividual Bob = OWL.Individual((String)(ns + "Bob"));
        OWLIndividual John = OWL.Individual((String)(ns + "John"));
        OWLIndividual Jane = OWL.Individual((String)(ns + "Jane"));
        OWLObjectProperty hasBrother = OWL.ObjectProperty((String)(ns + "hasBrother"));
        OWLObjectProperty hasSister = OWL.ObjectProperty((String)(ns + "hasSister"));
        OWLAPITests.assertPropertyValues(reasoner, Bob, hasBrother, John);
        OWLAPITests.assertPropertyValues(reasoner, Bob, hasSister, Jane);
    }

    public static void assertPropertyValues(Reasoner reasoner, OWLIndividual subj, OWLObjectProperty pred, OWLIndividual ... values) {
        PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(subj, (OWLObjectPropertyExpression)pred).iterator(), values);
        PelletTestCase.assertIteratorValues(((Set)reasoner.getObjectPropertyRelationships(subj).get(pred)).iterator(), values);
    }

    @Test
    public void testPropertyChain() throws OWLException {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "propertyChain.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.setOntology(ont);
        OWLClass C = OWL.Class((String)(ns + "C"));
        OWLClass S0 = OWL.Class((String)(ns + "S0"));
        OWLClass R0 = OWL.Class((String)(ns + "R0"));
        OWLClass R1 = OWL.Class((String)(ns + "R1"));
        OWLObjectProperty r = OWL.ObjectProperty((String)(ns + "r"));
        OWLObjectProperty s = OWL.ObjectProperty((String)(ns + "s"));
        OWLIndividual[] a = new OWLIndividual[17];
        for (int i = 0; i < a.length; ++i) {
            a[i] = OWL.Individual((String)(ns + "a" + i));
        }
        Object[] theList = new OWLIndividual[]{a[1], a[2], a[3], a[4], a[5], a[6], a[8], a[10], a[12], a[14], a[16]};
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.isTransitive(r));
        Assert.assertFalse((boolean)reasoner.isTransitive(s));
        PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)C, false).iterator(), theList);
        PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)S0, false).iterator(), theList);
        PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)R0, false).iterator(), new OWLIndividual[]{a[7], a[9]});
        PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)R1, false).iterator(), new OWLIndividual[]{a[2], a[3], a[4], a[5], a[6]});
        PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(a[0], (OWLObjectPropertyExpression)r).iterator(), new OWLIndividual[]{a[7], a[9]});
        PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(a[1], (OWLObjectPropertyExpression)r).iterator(), new OWLIndividual[]{a[2], a[3], a[4], a[5], a[6]});
        PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(a[0], (OWLObjectPropertyExpression)s).iterator(), theList);
    }

    @Test
    public void testQualifiedCardinality1() throws OWLException {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "qcr.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.setOntology(ont);
        OWLClass sub = OWL.Class((String)(ns + "sub"));
        OWLClass sup = OWL.Class((String)(ns + "sup"));
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)sub, (OWLDescription)sup));
        Assert.assertTrue((boolean)reasoner.getDescendantClasses((OWLDescription)sup).contains(SetUtils.singleton((Object)sub)));
        Assert.assertTrue((boolean)reasoner.getAncestorClasses((OWLDescription)sub).contains(SetUtils.singleton((Object)sup)));
    }

    @Test
    public void testReflexive2() throws OWLException {
        String ns = "http://www.example.org/test#";
        String foaf = "http://xmlns.com/foaf/0.1/";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "reflexive.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.setOntology(ont);
        OWLObjectProperty[] knows = new OWLObjectProperty[]{OWL.ObjectProperty((String)(foaf + "knows")), OWL.ObjectProperty((String)(ns + "knows2")), OWL.ObjectProperty((String)(ns + "knows3"))};
        OWLIndividual[] people = new OWLIndividual[5];
        for (int i = 0; i < people.length; ++i) {
            people[i] = OWL.Individual((String)(ns + "P" + (i + 1)));
            for (int j = 0; j < knows.length; ++j) {
                Assert.assertTrue((String)(people[i] + " " + knows[j]), (boolean)reasoner.hasObjectPropertyRelationship(people[i], (OWLObjectPropertyExpression)knows[j], people[i]));
                PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(people[i], (OWLObjectPropertyExpression)knows[j]).iterator(), new OWLIndividual[]{people[i]});
            }
        }
        Map answers = PelletTestCase.createMap(new Object[][]{{people[0], people[0]}, {people[1], people[1]}, {people[2], people[2]}, {people[3], people[3]}, {people[4], people[4]}});
        Map result = reasoner.getObjectPropertyAssertions(knows[0]);
        Assert.assertEquals((Object)answers, (Object)result);
    }

    @Test
    public void testInfiniteChain() throws Exception {
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "infiniteChain.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.setOntology(ont);
        Assert.assertTrue((!reasoner.isConsistent() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveLiteral() throws Exception {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "RemoveLiteral.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.setOntology(ont);
        OWLDataProperty pInt = OWL.DataProperty((String)(ns + "pInt"));
        OWLDataProperty pDouble = OWL.DataProperty((String)(ns + "pDouble"));
        OWLDataProperty pBoolean = OWL.DataProperty((String)(ns + "pBoolean"));
        OWLIndividual ind = OWL.Individual((String)(ns + "ind"));
        Assert.assertTrue((boolean)reasoner.isConsistent());
        OWLConstant valDouble = reasoner.getRelatedValue(ind, (OWLDataPropertyExpression)pDouble);
        OntologyUtils.removeAxioms((OWLOntology)ont, (OWLAxiom[])new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)ind, (OWLDataPropertyExpression)pDouble, (OWLConstant)valDouble)});
        reasoner.refresh();
        Assert.assertTrue((boolean)reasoner.getRelatedValues(ind, (OWLDataPropertyExpression)pDouble).isEmpty());
        OWLConstant valInt = reasoner.getRelatedValue(ind, (OWLDataPropertyExpression)pInt);
        OntologyUtils.removeAxioms((OWLOntology)ont, (OWLAxiom[])new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)ind, (OWLDataPropertyExpression)pInt, (OWLConstant)valInt)});
        reasoner.refresh();
        Assert.assertTrue((boolean)reasoner.getRelatedValues(ind, (OWLDataPropertyExpression)pInt).isEmpty());
        OWLConstant valBoolean = reasoner.getRelatedValue(ind, (OWLDataPropertyExpression)pBoolean);
        OntologyUtils.removeAxioms((OWLOntology)ont, (OWLAxiom[])new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)ind, (OWLDataPropertyExpression)pBoolean, (OWLConstant)valBoolean)});
        reasoner.refresh();
        Assert.assertTrue((boolean)reasoner.getRelatedValues(ind, (OWLDataPropertyExpression)pBoolean).isEmpty());
        Assert.assertTrue((boolean)reasoner.getDataPropertyRelationships(ind).isEmpty());
        OWLTypedConstant newVal = OWL.constant((String)"0.0", (OWLDataType)XSD.DOUBLE);
        OntologyUtils.addAxioms((OWLOntology)ont, (OWLAxiom[])new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)ind, (OWLDataPropertyExpression)pDouble, (OWLConstant)newVal)});
        reasoner.refresh();
        Assert.assertTrue((boolean)reasoner.isConsistent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="AUTO_XML_SCHEMA_LOADING is not supported anymore")
    public void testUserDefinedDatatypes() throws Exception {
        PelletOptions.AUTO_XML_SCHEMA_LOADING = true;
        String ns = "http://www.mindswap.org/ontologies/family.owl#";
        OWLOntologyURIMapperImpl mapper = new OWLOntologyURIMapperImpl();
        OWL.manager.addURIMapper((OWLOntologyURIMapper)mapper);
        try {
            OWLOntology ont = OntologyUtils.loadOntology((String)(base + "family-ages.owl"));
            Reasoner reasoner = new Reasoner(OWL.manager);
            reasoner.setOntology(ont);
            OWLClass Child = OWL.Class((String)(ns + "Child"));
            OWLClass Teenage = OWL.Class((String)(ns + "Teenage"));
            OWLClass Adult = OWL.Class((String)(ns + "Adult"));
            OWLClass Senior = OWL.Class((String)(ns + "Senior"));
            OWLIndividual Daughter = OWL.Individual((String)(ns + "Daughter"));
            OWLIndividual Son = OWL.Individual((String)(ns + "Son"));
            OWLIndividual Dad = OWL.Individual((String)(ns + "Dad"));
            OWLIndividual Grandpa = OWL.Individual((String)(ns + "Grandpa"));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)Senior, (OWLDescription)Adult));
            PelletTestCase.assertIteratorValues(reasoner.getSubClasses((OWLDescription)Adult).iterator(), new Object[]{SetUtils.singleton((Object)Senior)});
            Assert.assertTrue((boolean)reasoner.hasType(Daughter, (OWLDescription)Child));
            Assert.assertTrue((boolean)reasoner.hasType(Son, (OWLDescription)Teenage));
            Assert.assertTrue((boolean)reasoner.hasType(Dad, (OWLDescription)Adult));
            Assert.assertTrue((boolean)reasoner.hasType(Grandpa, (OWLDescription)Senior));
        }
        finally {
            OWL.manager.removeURIMapper((OWLOntologyURIMapper)mapper);
            PelletOptions.AUTO_XML_SCHEMA_LOADING = false;
        }
    }

    @Test
    public void testFamily() throws OWLException {
        String ns = "http://www.example.org/family#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "family.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.setOntology(ont);
        OWLObjectProperty hasBrother = OWL.ObjectProperty((String)(ns + "hasBrother"));
        OWLObjectProperty hasSon = OWL.ObjectProperty((String)(ns + "hasSon"));
        OWLObjectProperty hasFather = OWL.ObjectProperty((String)(ns + "hasFather"));
        OWLObjectProperty hasParent = OWL.ObjectProperty((String)(ns + "hasParent"));
        OWLObjectProperty hasChild = OWL.ObjectProperty((String)(ns + "hasChild"));
        OWLObjectProperty hasMother = OWL.ObjectProperty((String)(ns + "hasMother"));
        OWLObjectProperty hasDaughter = OWL.ObjectProperty((String)(ns + "hasDaughter"));
        OWLObjectProperty hasAncestor = OWL.ObjectProperty((String)(ns + "hasAncestor"));
        OWLObjectProperty likes = OWL.ObjectProperty((String)(ns + "likes"));
        OWLObjectProperty isMarriedTo = OWL.ObjectProperty((String)(ns + "isMarriedTo"));
        OWLObjectProperty dislikes = OWL.ObjectProperty((String)(ns + "dislikes"));
        OWLObjectProperty hasSister = OWL.ObjectProperty((String)(ns + "hasSister"));
        OWLObjectProperty hasDescendant = OWL.ObjectProperty((String)(ns + "hasDescendant"));
        OWLObjectProperty hasSibling = OWL.ObjectProperty((String)(ns + "hasSibling"));
        OWLClass Child = OWL.Class((String)(ns + "Child"));
        OWLClass Person = OWL.Class((String)(ns + "Person"));
        OWLClass PersonWithAtLeastTwoMaleChildren = OWL.Class((String)(ns + "PersonWithAtLeastTwoMaleChildren"));
        OWLClass PersonWithAtLeastTwoFemaleChildren = OWL.Class((String)(ns + "PersonWithAtLeastTwoFemaleChildren"));
        OWLClass PersonWithAtLeastTwoChildren = OWL.Class((String)(ns + "PersonWithAtLeastTwoChildren"));
        OWLClass PersonWithAtLeastFourChildren = OWL.Class((String)(ns + "PersonWithAtLeastFourChildren"));
        OWLClass Teen = OWL.Class((String)(ns + "Teen"));
        OWLClass Teenager = OWL.Class((String)(ns + "Teenager"));
        OWLClass Male = OWL.Class((String)(ns + "Male"));
        OWLClass Adult = OWL.Class((String)(ns + "Adult"));
        OWLClass Female = OWL.Class((String)(ns + "Female"));
        OWLClass Senior = OWL.Class((String)(ns + "Senior"));
        OWLIndividual grandmother = OWL.Individual((String)(ns + "grandmother"));
        OWLIndividual grandfather = OWL.Individual((String)(ns + "grandfather"));
        OWLIndividual father = OWL.Individual((String)(ns + "father"));
        OWLIndividual son = OWL.Individual((String)(ns + "son"));
        OWLIndividual mother = OWL.Individual((String)(ns + "mother"));
        OWLIndividual daughter = OWL.Individual((String)(ns + "daughter"));
        OWLIndividual personX = OWL.Individual((String)(ns + "personX"));
        OWLIndividual personY = OWL.Individual((String)(ns + "personY"));
        OWLIndividual personZ = OWL.Individual((String)(ns + "personZ"));
        Assert.assertTrue((boolean)reasoner.isConsistent());
        KnowledgeBase kb = reasoner.getKB();
        for (int test = 0; test < 2; ++test) {
            if (test != 0) {
                kb.realize();
            }
            Assert.assertTrue((boolean)reasoner.isTransitive(hasAncestor));
            Assert.assertFalse((boolean)reasoner.isFunctional(hasAncestor));
            Assert.assertTrue((boolean)reasoner.isTransitive(hasDescendant));
            Assert.assertFalse((boolean)reasoner.isFunctional(hasDescendant));
            Assert.assertTrue((boolean)reasoner.isSymmetric(isMarriedTo));
            Assert.assertTrue((boolean)reasoner.isIrreflexive(isMarriedTo));
            Assert.assertTrue((boolean)reasoner.isSubPropertyOf(hasParent, hasAncestor));
            Assert.assertTrue((boolean)reasoner.isSubPropertyOf(hasFather, hasAncestor));
            Assert.assertTrue((boolean)reasoner.isSubPropertyOf(hasMother, hasAncestor));
            Assert.assertTrue((boolean)reasoner.isSubPropertyOf(hasChild, hasDescendant));
            Assert.assertTrue((boolean)reasoner.isDisjointWith(likes, dislikes));
            Assert.assertTrue((boolean)reasoner.isDisjointWith(dislikes, likes));
            Assert.assertTrue((boolean)reasoner.isDisjointWith(hasFather, hasMother));
            Assert.assertTrue((boolean)reasoner.isDisjointWith(hasMother, hasFather));
            Assert.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)PersonWithAtLeastTwoChildren));
            Assert.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)PersonWithAtLeastTwoMaleChildren));
            Assert.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)Male));
            Assert.assertTrue((boolean)reasoner.hasType(grandfather, (OWLDescription)Senior));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandfather, (OWLObjectPropertyExpression)isMarriedTo, grandmother));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandfather, (OWLObjectPropertyExpression)hasChild, father));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandfather, (OWLObjectPropertyExpression)hasSon, father));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, grandmother));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, father));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, mother));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, son));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(grandfather, daughter));
            Assert.assertTrue((boolean)reasoner.hasType(grandmother, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.hasType(grandmother, (OWLDescription)Female));
            Assert.assertTrue((boolean)reasoner.hasType(grandmother, (OWLDescription)Senior));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandmother, (OWLObjectPropertyExpression)isMarriedTo, grandfather));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(grandmother, (OWLObjectPropertyExpression)hasChild, father));
            Assert.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(grandmother, (OWLObjectPropertyExpression)hasSon, father));
            Assert.assertTrue((boolean)reasoner.hasType(father, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.hasType(father, (OWLDescription)Male));
            Assert.assertTrue((boolean)reasoner.hasType(father, (OWLDescription)Adult));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasParent, grandfather));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasParent, grandmother));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasFather, grandfather));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasMother, grandmother));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasChild, son));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasSon, son));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasChild, daughter));
            Assert.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(father, (OWLObjectPropertyExpression)hasDaughter, daughter));
            Assert.assertTrue((boolean)reasoner.hasType(mother, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.hasType(mother, (OWLDescription)Female));
            Assert.assertTrue((boolean)reasoner.hasType(son, (OWLDescription)Male));
            Assert.assertTrue((boolean)reasoner.hasType(son, (OWLDescription)Teenager));
            Assert.assertTrue((boolean)reasoner.hasType(son, (OWLDescription)Teen));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(son, (OWLObjectPropertyExpression)hasParent, father));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(son, (OWLObjectPropertyExpression)hasFather, father));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(son, (OWLObjectPropertyExpression)hasSibling, daughter));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(son, (OWLObjectPropertyExpression)hasSister, daughter));
            Assert.assertTrue((boolean)reasoner.hasType(daughter, (OWLDescription)Female));
            Assert.assertTrue((boolean)reasoner.hasType(daughter, (OWLDescription)Child));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasAncestor, grandfather));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasAncestor, grandmother));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasParent, father));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasFather, father));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasParent, mother));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasMother, mother));
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasSibling, son));
            Assert.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(daughter, (OWLObjectPropertyExpression)hasBrother, son));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(personX, personY));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(personX, personZ));
            Assert.assertTrue((boolean)reasoner.isDifferentFrom(personY, personZ));
            Assert.assertTrue((boolean)reasoner.isEquivalentClass((OWLDescription)Teen, (OWLDescription)Teenager));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)Senior, (OWLDescription)Adult));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoMaleChildren, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoFemaleChildren, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoChildren, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastFourChildren, (OWLDescription)Person));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastFourChildren, (OWLDescription)PersonWithAtLeastTwoChildren));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoMaleChildren, (OWLDescription)PersonWithAtLeastTwoChildren));
            Assert.assertTrue((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoFemaleChildren, (OWLDescription)PersonWithAtLeastTwoChildren));
            Assert.assertFalse((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoFemaleChildren, (OWLDescription)PersonWithAtLeastTwoMaleChildren));
            Assert.assertFalse((boolean)reasoner.isSubClassOf((OWLDescription)PersonWithAtLeastTwoMaleChildren, (OWLDescription)PersonWithAtLeastTwoFemaleChildren));
        }
    }

    @Test
    public void entityDeclarations() {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "/entityDeclarations.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.loadOntologies(Collections.singleton(ont));
        Assert.assertTrue((boolean)reasoner.isConsistent());
        KnowledgeBase kb = reasoner.getKB();
        Assert.assertTrue((boolean)reasoner.isDefined(OWL.Individual((String)(ns + "a"))));
        Assert.assertEquals((long)1L, (long)reasoner.getIndividuals().size());
        Assert.assertTrue((boolean)reasoner.isDefined(OWL.Class((String)(ns + "C"))));
        Assert.assertEquals((long)1L, (long)reasoner.getClasses().size());
        Assert.assertFalse((boolean)kb.isDatatype(ATermUtils.makeTermAppl((String)(ns + "C"))));
        Assert.assertFalse((boolean)reasoner.isDefined(OWL.Class((String)(ns + "D"))));
        Assert.assertTrue((boolean)true);
        Assert.assertFalse((boolean)reasoner.isDefined(OWL.DataProperty((String)(ns + "p"))));
        Assert.assertFalse((boolean)reasoner.isDefined(OWL.ObjectProperty((String)(ns + "p"))));
        Assert.assertTrue((boolean)reasoner.isDefined(OWL.ObjectProperty((String)(ns + "q"))));
        Assert.assertEquals((long)1L, (long)reasoner.getObjectProperties().size());
        Assert.assertFalse((boolean)kb.isAnnotationProperty((ATerm)ATermUtils.makeTermAppl((String)(ns + "r"))));
        Assert.assertFalse((boolean)reasoner.isDefined(OWL.DataProperty((String)(ns + "q"))));
        Assert.assertTrue((boolean)reasoner.isDefined(OWL.DataProperty((String)(ns + "r"))));
        Assert.assertEquals((long)1L, (long)reasoner.getDataProperties().size());
        Assert.assertFalse((boolean)kb.isAnnotationProperty((ATerm)ATermUtils.makeTermAppl((String)(ns + "r"))));
        Assert.assertFalse((boolean)reasoner.isDefined(OWL.ObjectProperty((String)(ns + "r"))));
    }

    @Test
    public void testAnonInverse() throws OWLException {
        String ns = "http://www.example.org/test#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "anon_inverse.owl"));
        OWLClass C = OWL.Class((String)(ns + "C"));
        OWLClass D = OWL.Class((String)(ns + "D"));
        OWLObjectProperty r = OWL.ObjectProperty((String)(ns + "r"));
        OWLObjectSomeRestriction desc = OWL.some((OWLObjectPropertyExpression)OWL.inverse((OWLObjectPropertyExpression)r), (OWLDescription)D);
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.loadOntologies(Collections.singleton(ont));
        Assert.assertEquals(Collections.singleton(Collections.singleton(C)), (Object)reasoner.getSubClasses((OWLDescription)desc));
        Assert.assertTrue((boolean)reasoner.isInverseFunctional(OWL.ObjectProperty((String)(ns + "functionalP"))));
        Assert.assertTrue((boolean)reasoner.isFunctional(OWL.ObjectProperty((String)(ns + "inverseFunctionalP"))));
        Assert.assertTrue((boolean)reasoner.isTransitive(OWL.ObjectProperty((String)(ns + "transitiveP"))));
        Assert.assertTrue((boolean)reasoner.isSymmetric(OWL.ObjectProperty((String)(ns + "symmetricP"))));
        Assert.assertTrue((boolean)reasoner.isReflexive(OWL.ObjectProperty((String)(ns + "reflexiveP"))));
        Assert.assertTrue((boolean)reasoner.isIrreflexive(OWL.ObjectProperty((String)(ns + "irreflexiveP"))));
        Assert.assertTrue((boolean)reasoner.isAntiSymmetric(OWL.ObjectProperty((String)(ns + "asymmetricP"))));
        OWLObjectProperty p1 = OWL.ObjectProperty((String)(ns + "p1"));
        OWLObjectProperty p2 = OWL.ObjectProperty((String)(ns + "p2"));
        OWLObjectProperty p3 = OWL.ObjectProperty((String)(ns + "p3"));
        Assert.assertTrue((boolean)reasoner.isEquivalentProperty(p1, p2));
        Assert.assertTrue((boolean)reasoner.isEquivalentProperty(p1, p3));
        Assert.assertTrue((boolean)reasoner.isEquivalentProperty(p2, p3));
    }

    @Test
    public void testDLSafeRules() throws OWLOntologyCreationException, OWLReasonerException {
        String ns = "http://owldl.com/ontologies/dl-safe.owl#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "dl-safe.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.setOntology(ont);
        OWLObjectProperty hates = OWL.ObjectProperty((String)(ns + "hates"));
        OWLObjectProperty sibling = OWL.ObjectProperty((String)(ns + "sibling"));
        OWLClass BadChild = OWL.Class((String)(ns + "BadChild"));
        OWLClass Child = OWL.Class((String)(ns + "Child"));
        OWLClass Grandchild = OWL.Class((String)(ns + "Grandchild"));
        OWLClass Person = OWL.Class((String)(ns + "Person"));
        OWLIndividual Abel = OWL.Individual((String)(ns + "Abel"));
        OWLIndividual Cain = OWL.Individual((String)(ns + "Cain"));
        OWLIndividual Oedipus = OWL.Individual((String)(ns + "Oedipus"));
        OWLIndividual Remus = OWL.Individual((String)(ns + "Remus"));
        OWLIndividual Romulus = OWL.Individual((String)(ns + "Romulus"));
        for (int test = 0; test < 2; ++test) {
            if (test != 0) {
                reasoner.realise();
            }
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(Abel, (OWLObjectPropertyExpression)sibling, Cain));
            PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(Abel, (OWLObjectPropertyExpression)sibling).iterator(), new Object[]{Cain});
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(Cain, (OWLObjectPropertyExpression)sibling, Abel));
            PelletTestCase.assertIteratorValues(reasoner.getRelatedIndividuals(Cain, (OWLObjectPropertyExpression)sibling).iterator(), new Object[]{Abel});
            Assert.assertTrue((boolean)reasoner.hasObjectPropertyRelationship(Cain, (OWLObjectPropertyExpression)hates, Abel));
            Assert.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(Abel, (OWLObjectPropertyExpression)hates, Cain));
            Assert.assertTrue((boolean)reasoner.hasType(Cain, (OWLDescription)Grandchild));
            Assert.assertTrue((boolean)reasoner.hasType(Cain, (OWLDescription)BadChild));
            Assert.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(Romulus, (OWLObjectPropertyExpression)sibling, Remus));
            Assert.assertTrue((boolean)reasoner.hasType(Romulus, (OWLDescription)Grandchild));
            Assert.assertFalse((boolean)reasoner.hasType(Romulus, (OWLDescription)BadChild));
            Assert.assertTrue((boolean)reasoner.hasType(Oedipus, (OWLDescription)Child));
        }
        PelletTestCase.assertIteratorValues(SetUtils.union((Collection)reasoner.getTypes(Cain, true)).iterator(), new Object[]{BadChild, Child, Person});
    }

    @Test
    public void testDLSafeConstants() throws OWLReasonerException, OWLOntologyCreationException {
        String ns = "http://owldl.com/ontologies/dl-safe-constants.owl#";
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "dl-safe-constants.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.setOntology(ont);
        OWLClass DreamTeamMember = OWL.Class((String)(ns + "DreamTeamMember"));
        OWLClass DreamTeamMember1 = OWL.Class((String)(ns + "DreamTeamMember1"));
        OWLClass DreamTeamMember2 = OWL.Class((String)(ns + "DreamTeamMember2"));
        OWLIndividual Alice = OWL.Individual((String)(ns + "Alice"));
        OWLIndividual Bob = OWL.Individual((String)(ns + "Bob"));
        OWLIndividual Charlie = OWL.Individual((String)(ns + "Charlie"));
        for (int test = 0; test < 1; ++test) {
            if (test != 0) {
                reasoner.realise();
            }
            PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)DreamTeamMember, false).iterator(), new Object[]{Alice, Bob, Charlie});
            PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)DreamTeamMember1, false).iterator(), new Object[]{Alice, Bob, Charlie});
            PelletTestCase.assertIteratorValues(reasoner.getIndividuals((OWLDescription)DreamTeamMember2, false).iterator(), new Object[]{Alice, Bob, Charlie});
        }
    }

    @Test
    public void testInvalidTransitivity() throws Exception {
        String ns = "http://www.example.org/test#";
        OWLClass C = OWL.Class((String)(ns + "C"));
        OWLObjectProperty p1 = OWL.ObjectProperty((String)(ns + "p1"));
        OWLObjectProperty p2 = OWL.ObjectProperty((String)(ns + "p2"));
        OWLIndividual x = OWL.Individual((String)(ns + "x"));
        OWLIndividual y = OWL.Individual((String)(ns + "y"));
        OWLIndividual z = OWL.Individual((String)(ns + "z"));
        OWLOntology ont = OntologyUtils.getOntologyFromAxioms((OWLAxiom[])new OWLAxiom[]{OWL.transitive((OWLObjectPropertyExpression)p1), OWL.classAssertion((OWLIndividual)x, (OWLDescription)OWL.all((OWLObjectPropertyExpression)p1, (OWLDescription)C)), OWL.propertyAssertion((OWLIndividual)x, (OWLObjectPropertyExpression)p1, (OWLIndividual)y), OWL.propertyAssertion((OWLIndividual)y, (OWLObjectPropertyExpression)p1, (OWLIndividual)z)});
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.setOntology(ont);
        Assert.assertTrue((boolean)reasoner.hasType(y, (OWLDescription)C));
        Assert.assertTrue((boolean)reasoner.hasType(z, (OWLDescription)C));
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.functional((OWLObjectPropertyExpression)p1), OWL.inverseFunctional((OWLObjectPropertyExpression)p1), OWL.irreflexive((OWLObjectPropertyExpression)p1), OWL.asymmetric((OWLObjectPropertyExpression)p1), OWL.disjointProperties((OWLObjectPropertyExpression)p1, (OWLObjectPropertyExpression)p2), OWL.subClassOf((OWLDescription)C, (OWLDescription)OWL.min((OWLObjectPropertyExpression)p1, (int)2)), OWL.classAssertion((OWLIndividual)x, (OWLDescription)OWL.max((OWLObjectPropertyExpression)p1, (int)3)), OWL.disjointClasses((OWLDescription)C, (OWLDescription)OWL.min((OWLObjectPropertyExpression)p1, (int)2))};
        for (int i = 0; i < axioms.length; ++i) {
            OntologyUtils.addAxioms((OWLOntology)ont, (OWLAxiom[])new OWLAxiom[]{axioms[i]});
            reasoner = new Reasoner(OWL.manager);
            reasoner.setOntology(ont);
            Assert.assertTrue((String)axioms[i].toString(), (boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)y, (OWLDescription)C)));
            Assert.assertFalse((String)axioms[i].toString(), (boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)z, (OWLDescription)C)));
            OntologyUtils.removeAxioms((OWLOntology)ont, (OWLAxiom[])new OWLAxiom[]{axioms[i]});
        }
    }

    @Test
    public void testInvalidTransitivity2() throws OWLOntologyCreationException {
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "invalidTransitivity.owl"));
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.setOntology(ont);
        KnowledgeBase kb = reasoner.getKB();
        kb.prepare();
        for (Role r : kb.getRBox().getRoles()) {
            Assert.assertTrue((String)r.toString(), (boolean)r.isSimple());
            Assert.assertFalse((String)r.toString(), (boolean)r.isTransitive());
        }
        for (ATermAppl p : kb.getObjectProperties()) {
            Assert.assertFalse((String)p.toString(), (boolean)kb.isTransitiveProperty(p));
        }
    }

    @Test
    public void testSameAs1() throws OWLException {
        String ns = "urn:test:";
        URI ontURI = URI.create(base + "invalidTransitivity.owl");
        OWLIndividual a = OWL.Individual((String)(ns + "a"));
        OWLIndividual b = OWL.Individual((String)(ns + "b"));
        OWLIndividual c = OWL.Individual((String)(ns + "c"));
        OWLObjectProperty p = OWL.ObjectProperty((String)(ns + "p"));
        OWLObjectProperty q = OWL.ObjectProperty((String)(ns + "q"));
        HashSet<Object> axioms = new HashSet<Object>();
        axioms.add(OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)c));
        axioms.add(OWL.propertyAssertion((OWLIndividual)b, (OWLObjectPropertyExpression)p, (OWLIndividual)b));
        axioms.add(OWL.propertyAssertion((OWLIndividual)c, (OWLObjectPropertyExpression)q, (OWLIndividual)a));
        axioms.add(OWL.sameAs((OWLIndividual)b, (OWLIndividual)c));
        axioms.add(OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)q, (OWLIndividual)c));
        OWLOntology ont = OntologyUtils.getOntologyFromAxioms(axioms, (URI)ontURI);
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.loadOntology(ont);
        Assert.assertEquals((Object)reasoner.getSameAsIndividuals(a), Collections.emptySet());
        Assert.assertEquals((Object)reasoner.getSameAsIndividuals(b), Collections.singleton(c));
        Assert.assertEquals((Object)reasoner.getSameAsIndividuals(c), Collections.singleton(b));
        Assert.assertEquals(reasoner.getObjectPropertyRelationships(a).get(p), (Object)SetUtils.create((Object[])new OWLIndividual[]{b, c}));
        Assert.assertEquals(reasoner.getObjectPropertyRelationships(a).get(q), (Object)SetUtils.create((Object[])new OWLIndividual[]{b, c}));
        Assert.assertEquals(reasoner.getObjectPropertyRelationships(b).get(p), (Object)SetUtils.create((Object[])new OWLIndividual[]{b, c}));
        Assert.assertEquals(reasoner.getObjectPropertyRelationships(b).get(q), (Object)SetUtils.create((Object[])new OWLIndividual[]{a}));
        Assert.assertEquals(reasoner.getObjectPropertyRelationships(c).get(p), (Object)SetUtils.create((Object[])new OWLIndividual[]{b, c}));
        Assert.assertEquals(reasoner.getObjectPropertyRelationships(c).get(q), (Object)SetUtils.create((Object[])new OWLIndividual[]{a}));
    }

    @Test
    public void testSameAs3() throws OWLException {
        String ns = "urn:test:";
        URI ontURI = URI.create(base + "test.owl");
        OWLIndividual i1 = OWL.Individual((String)(ns + "i1"));
        OWLIndividual i2 = OWL.Individual((String)(ns + "i2"));
        OWLIndividual i3 = OWL.Individual((String)(ns + "i3"));
        OWLClass c = OWL.Class((String)(ns + "c"));
        HashSet<Object> axioms = new HashSet<Object>();
        axioms.add(OWL.equivalentClasses((OWLDescription)c, (OWLDescription)OWL.oneOf((OWLIndividual[])new OWLIndividual[]{i1, i2})));
        axioms.add(OWL.classAssertion((OWLIndividual)i3, (OWLDescription)c));
        OWLOntology ont = OntologyUtils.getOntologyFromAxioms(axioms, (URI)ontURI);
        Reasoner reasoner = new Reasoner(OWL.manager);
        reasoner.loadOntology(ont);
        Assert.assertTrue((!reasoner.isSameAs(i1, i2) ? 1 : 0) != 0);
        Assert.assertTrue((!reasoner.isSameAs(i1, i3) ? 1 : 0) != 0);
        Assert.assertEquals((Object)reasoner.getSameAsIndividuals(i1), Collections.emptySet());
        Assert.assertTrue((!reasoner.isSameAs(i2, i1) ? 1 : 0) != 0);
        Assert.assertTrue((!reasoner.isSameAs(i2, i3) ? 1 : 0) != 0);
        Assert.assertEquals((Object)reasoner.getSameAsIndividuals(i2), Collections.emptySet());
        Assert.assertTrue((!reasoner.isSameAs(i3, i1) ? 1 : 0) != 0);
        Assert.assertTrue((!reasoner.isSameAs(i3, i2) ? 1 : 0) != 0);
        Assert.assertEquals((Object)reasoner.getSameAsIndividuals(i2), Collections.emptySet());
    }

    @Test
    public void testRealizeByIndividualsNPE() throws Exception {
        PelletOptions.REALIZE_INDIVIDUAL_AT_A_TIME = false;
        TimedProgressMonitor monitor = new TimedProgressMonitor(1);
        Reasoner pellet = new Reasoner(OWL.manager);
        KnowledgeBase kb = pellet.getKB();
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "food.owl"));
        pellet.loadOntology(ont);
        kb.classify();
        kb.getTaxonomyBuilder().setProgressMonitor((ProgressMonitor)monitor);
        kb.realize();
        Assert.assertFalse((boolean)kb.isRealized());
    }

    @Test
    public void testClassificationTimeout() throws Exception {
        boolean timeout = false;
        Reasoner pellet = new Reasoner(OWL.manager);
        KnowledgeBase kb = pellet.getKB();
        Timer timer = kb.timers.createTimer("classify");
        timer.setTimeout(1L);
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "food.owl"));
        pellet.loadOntology(ont);
        try {
            kb.classify();
        }
        catch (TimeoutException e) {
            timeout = true;
        }
        Assert.assertTrue((boolean)timeout);
        Assert.assertFalse((boolean)kb.isClassified());
    }

    @Test
    public void testRealizationTimeout() throws Exception {
        boolean timeout = false;
        Reasoner pellet = new Reasoner(OWL.manager);
        KnowledgeBase kb = pellet.getKB();
        Timer timer = kb.timers.createTimer("realize");
        timer.setTimeout(1L);
        OWLOntology ont = OntologyUtils.loadOntology((String)(base + "food.owl"));
        pellet.loadOntology(ont);
        try {
            kb.classify();
        }
        catch (TimeoutException e) {
            timeout = true;
        }
        Assert.assertFalse((boolean)timeout);
        Assert.assertTrue((boolean)kb.isClassified());
        try {
            kb.realize();
        }
        catch (TimeoutException e) {
            timeout = true;
        }
        Assert.assertTrue((boolean)timeout);
        Assert.assertFalse((boolean)kb.isRealized());
    }

    @Test
    public void testAxiomConverterRules1() {
        KnowledgeBase kb = new KnowledgeBase();
        AxiomConverter converter = new AxiomConverter(kb, OWL.manager.getOWLDataFactory());
        ATermAppl C = ATermUtils.makeTermAppl((String)"C");
        ATermAppl D = ATermUtils.makeTermAppl((String)"D");
        ATermAppl x = ATermUtils.makeVar((String)"x");
        kb.addClass(C);
        kb.addClass(D);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)D)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)C)};
        ATermAppl rule = ATermUtils.makeRule((ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLClassAtom> antecedent = new HashSet<SWRLClassAtom>();
        HashSet<SWRLClassAtom> consequent = new HashSet<SWRLClassAtom>();
        antecedent.add(SWRL.classAtom((OWLDescription)OWL.Class((String)"C"), (SWRLAtomIObject)SWRL.iVariable((String)"x")));
        consequent.add(SWRL.classAtom((OWLDescription)OWL.Class((String)"D"), (SWRLAtomIObject)SWRL.iVariable((String)"x")));
        SWRLRule expected = SWRL.rule(antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAxiomConverterRules1b() {
        KnowledgeBase kb = new KnowledgeBase();
        AxiomConverter converter = new AxiomConverter(kb, OWL.manager.getOWLDataFactory());
        ATermAppl C = ATermUtils.makeTermAppl((String)"C");
        ATermAppl D = ATermUtils.makeTermAppl((String)"D");
        ATermAppl x = ATermUtils.makeVar((String)"x");
        ATermAppl name = ATermUtils.makeTermAppl((String)"MyRule");
        kb.addClass(C);
        kb.addClass(D);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)D)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)C)};
        ATermAppl rule = ATermUtils.makeRule((ATermAppl)name, (ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLClassAtom> antecedent = new HashSet<SWRLClassAtom>();
        HashSet<SWRLClassAtom> consequent = new HashSet<SWRLClassAtom>();
        antecedent.add(SWRL.classAtom((OWLDescription)OWL.Class((String)"C"), (SWRLAtomIObject)SWRL.iVariable((String)"x")));
        consequent.add(SWRL.classAtom((OWLDescription)OWL.Class((String)"D"), (SWRLAtomIObject)SWRL.iVariable((String)"x")));
        SWRLRule expected = SWRL.rule((String)name.getName(), antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void testAxiomConverterRules1c() {
        KnowledgeBase kb = new KnowledgeBase();
        AxiomConverter converter = new AxiomConverter(kb, OWL.manager.getOWLDataFactory());
        ATermAppl C = ATermUtils.makeTermAppl((String)"C");
        ATermAppl D = ATermUtils.makeTermAppl((String)"D");
        ATermAppl x = ATermUtils.makeVar((String)"x");
        ATermAppl name = ATermUtils.makeBnode((String)"MyRule");
        kb.addClass(C);
        kb.addClass(D);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)D)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)C)};
        ATermAppl rule = ATermUtils.makeRule((ATermAppl)name, (ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLClassAtom> antecedent = new HashSet<SWRLClassAtom>();
        HashSet<SWRLClassAtom> consequent = new HashSet<SWRLClassAtom>();
        antecedent.add(SWRL.classAtom((OWLDescription)OWL.Class((String)"C"), (SWRLAtomIObject)SWRL.iVariable((String)"x")));
        consequent.add(SWRL.classAtom((OWLDescription)OWL.Class((String)"D"), (SWRLAtomIObject)SWRL.iVariable((String)"x")));
        SWRLRule expected = SWRL.rule((String)name.getArgument(0).toString(), (boolean)true, antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAxiomConverterRules2() {
        KnowledgeBase kb = new KnowledgeBase();
        AxiomConverter converter = new AxiomConverter(kb, OWL.manager.getOWLDataFactory());
        ATermAppl C = ATermUtils.makeTermAppl((String)"C");
        ATermAppl D = ATermUtils.makeTermAppl((String)"D");
        ATermAppl i = ATermUtils.makeTermAppl((String)"i");
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(i);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)i, (ATermAppl)D)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)i, (ATermAppl)C)};
        ATermAppl rule = ATermUtils.makeRule((ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLClassAtom> antecedent = new HashSet<SWRLClassAtom>();
        HashSet<SWRLClassAtom> consequent = new HashSet<SWRLClassAtom>();
        antecedent.add(SWRL.classAtom((OWLDescription)OWL.Class((String)"C"), (SWRLAtomIObject)SWRL.individual((OWLIndividual)OWL.Individual((String)"i"))));
        consequent.add(SWRL.classAtom((OWLDescription)OWL.Class((String)"D"), (SWRLAtomIObject)SWRL.individual((OWLIndividual)OWL.Individual((String)"i"))));
        SWRLRule expected = SWRL.rule(antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAxiomConverterRules3() {
        KnowledgeBase kb = new KnowledgeBase();
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory df = manager.getOWLDataFactory();
        AxiomConverter converter = new AxiomConverter(kb, df);
        ATermAppl p = ATermUtils.makeTermAppl((String)"p");
        ATermAppl q = ATermUtils.makeTermAppl((String)"q");
        ATermAppl x = ATermUtils.makeVar((String)"x");
        ATermAppl y = ATermUtils.makeVar((String)"y");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makePropAtom((ATermAppl)q, (ATermAppl)x, (ATermAppl)y)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)x, (ATermAppl)y)};
        ATermAppl rule = ATermUtils.makeRule((ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLObjectPropertyAtom> antecedent = new HashSet<SWRLObjectPropertyAtom>();
        HashSet<SWRLObjectPropertyAtom> consequent = new HashSet<SWRLObjectPropertyAtom>();
        antecedent.add(SWRL.propertyAtom((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"p"), (SWRLAtomIObject)SWRL.iVariable((String)"x"), (SWRLAtomIObject)SWRL.iVariable((String)"y")));
        consequent.add(SWRL.propertyAtom((OWLObjectPropertyExpression)OWL.ObjectProperty((String)"q"), (SWRLAtomIObject)SWRL.iVariable((String)"x"), (SWRLAtomIObject)SWRL.iVariable((String)"y")));
        SWRLRule expected = SWRL.rule(antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAxiomConverterRules4() {
        KnowledgeBase kb = new KnowledgeBase();
        AxiomConverter converter = new AxiomConverter(kb, OWL.manager.getOWLDataFactory());
        ATermAppl r = ATermUtils.makeTermAppl((String)"r");
        ATermAppl s = ATermUtils.makeTermAppl((String)"s");
        ATermAppl x = ATermUtils.makeVar((String)"x");
        ATermAppl y = ATermUtils.makeVar((String)"y");
        kb.addDatatypeProperty((ATerm)r);
        kb.addDatatypeProperty((ATerm)s);
        ATermAppl[] head = new ATermAppl[]{ATermUtils.makePropAtom((ATermAppl)r, (ATermAppl)x, (ATermAppl)y)};
        ATermAppl[] body = new ATermAppl[]{ATermUtils.makePropAtom((ATermAppl)s, (ATermAppl)x, (ATermAppl)y)};
        ATermAppl rule = ATermUtils.makeRule((ATermAppl[])head, (ATermAppl[])body);
        OWLAxiom actual = converter.convert(rule);
        HashSet<SWRLDataValuedPropertyAtom> antecedent = new HashSet<SWRLDataValuedPropertyAtom>();
        HashSet<SWRLDataValuedPropertyAtom> consequent = new HashSet<SWRLDataValuedPropertyAtom>();
        antecedent.add(SWRL.propertyAtom((OWLDataPropertyExpression)OWL.DataProperty((String)"s"), (SWRLAtomIObject)SWRL.iVariable((String)"x"), (SWRLAtomDObject)SWRL.dVariable((String)"y")));
        consequent.add(SWRL.propertyAtom((OWLDataPropertyExpression)OWL.DataProperty((String)"r"), (SWRLAtomIObject)SWRL.iVariable((String)"x"), (SWRLAtomDObject)SWRL.dVariable((String)"y")));
        SWRLRule expected = SWRL.rule(antecedent, consequent);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void typeInhertianceWithAnonIndividual() throws OWLOntologyCreationException {
        String ns = "foo://test#";
        String src = "@prefix ex: <" + ns + "> .\r\n" + "@prefix rdfs:  <http://www.w3.org/2000/01/rdf-schema#> .\r\n" + "@prefix owl: <http://www.w3.org/2002/07/owl#> .\r\n" + "\r\n" + "ex:C rdfs:subClassOf ex:D .\r\n" + "[] a ex:C .";
        Reasoner pellet = new Reasoner(OWL.manager);
        OWLOntology ont = OWL.manager.loadOntology((OWLOntologyInputSource)new StringInputSource(src));
        pellet.loadOntology(ont);
        OWLClass D = OWL.Class((String)(ns + "D"));
        Assert.assertTrue((pellet.getIndividuals((OWLDescription)D, true).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pellet.getIndividuals((OWLDescription)D, false).size() == 1 ? 1 : 0) != 0);
    }

    public static class TimedProgressMonitor
    extends ConsoleProgressMonitor {
        private int limit;

        public TimedProgressMonitor(int limit) {
            this.limit = limit;
        }

        public void taskFinished() {
            super.taskFinished();
        }

        public void taskStarted() {
            super.taskStarted();
        }

        public boolean isCanceled() {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            return elapsedTime > (long)this.limit;
        }
    }
}

