/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import aterm.ATermAppl;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.utils.ATermUtils;

public class TableResult2XML {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java TableResult2XML <filename> [-vars var1 [var2] ...]");
            System.out.println("\t\twhere <filename> is the path to the result file or a directory of result files");
            System.out.println("\t\t      -vars says that first line does not contain names of the vars and thus we supply them.");
            return;
        }
        ArrayList<String> files = new ArrayList<String>();
        if (new File(args[0]).isDirectory()) {
            for (File f : new File(args[0]).listFiles()) {
                if (f.isDirectory() || f.getAbsolutePath().endsWith(".srx")) continue;
                files.add(f.getAbsolutePath());
            }
        } else {
            files.add(args[0]);
        }
        List<String> varNames = null;
        if (args.length > 1) {
            if (!args[1].equals("-vars")) {
                System.out.println("Unknown parameter " + args[1] + " - ignoring.");
            } else {
                varNames = Arrays.asList(args).subList(2, args.length);
            }
        }
        for (String arg : files) {
            final ArrayList<String> vars = new ArrayList<String>();
            final ArrayList<QuerySolutionMap> solutions = new ArrayList<QuerySolutionMap>();
            try {
                StringTokenizer t;
                String line;
                FileInputStream f = new FileInputStream(arg);
                BufferedReader r = new BufferedReader(new InputStreamReader(f));
                if (varNames == null) {
                    line = r.readLine();
                    t = new StringTokenizer(line, " \t");
                    while (t.hasMoreTokens()) {
                        vars.add(t.nextToken());
                    }
                } else {
                    vars.addAll(varNames);
                }
                Model m = ModelFactory.createDefaultModel();
                while ((line = r.readLine()) != null) {
                    int i = 0;
                    t = new StringTokenizer(line, " \t");
                    QuerySolutionMap s = new QuerySolutionMap();
                    while (t.hasMoreTokens()) {
                        String token = t.nextToken();
                        if (token.startsWith("http://") || token.startsWith("file:///")) {
                            s.add((String)vars.get(i++), JenaUtils.makeRDFNode((ATermAppl)ATermUtils.makeTermAppl((String)token), (Model)m));
                            continue;
                        }
                        s.add((String)vars.get(i++), JenaUtils.makeRDFNode((ATermAppl)ATermUtils.makePlainLiteral((String)token), (Model)m));
                    }
                    solutions.add(s);
                }
                ResultSetFormatter.outputAsXML((OutputStream)new FileOutputStream(arg + ".srx"), (ResultSet)new ResultSet(){
                    private int index = 0;

                    public List<String> getResultVars() {
                        return vars;
                    }

                    public int getRowNumber() {
                        return this.index;
                    }

                    public boolean hasNext() {
                        return this.index < solutions.size();
                    }

                    public boolean isOrdered() {
                        return false;
                    }

                    public QuerySolution next() {
                        return this.nextSolution();
                    }

                    public Binding nextBinding() {
                        return BindingUtils.asBinding((QuerySolution)this.nextSolution());
                    }

                    public QuerySolution nextSolution() {
                        return (QuerySolution)solutions.get(this.index++);
                    }

                    public void remove() {
                        throw new IllegalArgumentException("Removing is not supported.");
                    }

                    public Model getResourceModel() {
                        return null;
                    }
                });
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Done.");
    }
}

