/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.CombinedQueryEngine;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.model.QueryImpl;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;

public class TestNegatedQueries {
    private static final ATermAppl A = TermFactory.term((String)"A");
    private static final ATermAppl B = TermFactory.term((String)"B");
    private static final ATermAppl C = TermFactory.term((String)"C");
    private static final ATermAppl p = TermFactory.term((String)"p");
    private static final ATermAppl q = TermFactory.term((String)"q");
    private static final ATermAppl a = TermFactory.term((String)"a");
    private static final ATermAppl b = TermFactory.term((String)"b");
    private static final ATermAppl c = TermFactory.term((String)"c");
    private static final ATermAppl x = ATermUtils.makeVar((String)"x");
    private static final ATermAppl y = ATermUtils.makeVar((String)"y");
    private static final ATermAppl z = ATermUtils.makeVar((String)"z");
    private KnowledgeBase kb;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestNegatedQueries.class);
    }

    private ATermAppl[] select(ATermAppl ... vars) {
        return vars;
    }

    private QueryAtom[] where(QueryAtom ... atoms) {
        return atoms;
    }

    private Query ask(QueryAtom ... atoms) {
        return this.query(new ATermAppl[0], atoms);
    }

    private Query query(ATermAppl[] vars, QueryAtom[] atoms) {
        QueryImpl q = new QueryImpl(this.kb, true);
        for (ATermAppl aTermAppl : vars) {
            q.addResultVar(aTermAppl);
        }
        for (ATermAppl aTermAppl : atoms) {
            q.add((QueryAtom)aTermAppl);
        }
        for (ATermAppl var : q.getUndistVars()) {
            q.addDistVar(var, Query.VarType.INDIVIDUAL);
        }
        return q;
    }

    private static void testQuery(Query query, boolean expected) {
        QueryResult result = QueryEngine.exec((Query)query);
        Assert.assertEquals((Object)expected, (Object)(!result.isEmpty() ? 1 : 0));
    }

    private static void testQuery(Query query, ATermAppl[] ... values) {
        List resultVars = query.getResultVars();
        HashMap<List<Object>, Integer> answers = new HashMap<List<Object>, Integer>();
        for (int i = 0; i < values.length; ++i) {
            List<ATermAppl> answer = Arrays.asList(values[i]);
            Integer count = (Integer)answers.get(answer);
            if (count == null) {
                answers.put(answer, 1);
                continue;
            }
            answers.put(answer, count + 1);
        }
        QueryResult result = QueryEngine.exec((Query)query);
        for (ResultBinding binding : result) {
            ArrayList<ATermAppl> list = new ArrayList<ATermAppl>(resultVars.size());
            for (ATermAppl var : resultVars) {
                list.add(binding.getValue(var));
            }
            Integer count = (Integer)answers.get(list);
            if (count == null) {
                junit.framework.Assert.fail((String)("Unexpected binding in the result: " + list));
                continue;
            }
            if (count == 1) {
                answers.remove(list);
                continue;
            }
            answers.put(list, count - 1);
        }
        junit.framework.Assert.assertTrue((String)("Unfound bindings: " + answers.keySet()), (boolean)answers.isEmpty());
    }

    @Before
    public void setUp() {
        this.kb = new KnowledgeBase();
        this.kb.addClass(A);
        this.kb.addClass(B);
        this.kb.addClass(C);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)q);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addIndividual(c);
    }

    @Test
    public void test1() {
        CombinedQueryEngine.log.setLevel(Level.FINEST);
        this.kb.addType(a, A);
        this.kb.addType(b, A);
        this.kb.addType(b, B);
        Query q = this.query(this.select(x), this.where(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)A), QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)B))));
        TestNegatedQueries.testQuery(q, new ATermAppl[][]{{a}});
    }

    @Test
    public void test2() {
        CombinedQueryEngine.log.setLevel(Level.FINEST);
        this.kb.addType(a, A);
        this.kb.addType(b, A);
        this.kb.addType(b, B);
        Query q = this.query(this.select(x), this.where(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)A), QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)TermFactory.not((ATermAppl)B)))));
        TestNegatedQueries.testQuery(q, {a}, {b});
    }

    @Test
    public void test3() {
        this.kb.addType(a, A);
        this.kb.addType(b, B);
        this.kb.addType(c, B);
        this.kb.addPropertyValue(p, a, c);
        Query q = this.query(this.select(x, y), this.where(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)A), QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.PropertyValueAtom((ATermAppl)x, (ATermAppl)p, (ATermAppl)y)), QueryAtomFactory.TypeAtom((ATermAppl)y, (ATermAppl)B)));
        TestNegatedQueries.testQuery(q, new ATermAppl[][]{{a, b}});
    }

    @Test
    public void test4() {
        Query q = this.ask(QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)B)));
        TestNegatedQueries.testQuery(q, true);
    }

    @Test
    public void test5() {
        this.kb.addType(b, B);
        Query q = this.ask(QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)B)));
        TestNegatedQueries.testQuery(q, false);
    }

    @Test
    public void test6() {
        this.kb.addType(b, B);
        Query q = this.query(this.select(x), this.where(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)TermFactory.TOP), QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)B))));
        TestNegatedQueries.testQuery(q, {a}, {c});
    }

    @Test
    public void test7() {
        this.kb.addType(a, A);
        this.kb.addType(b, A);
        this.kb.addType(b, B);
        Query q = this.query(this.select(x), this.where(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)A), QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)B))));
        TestNegatedQueries.testQuery(q, new ATermAppl[][]{{a}});
    }

    @Test
    public void test8() {
        this.kb.addType(a, A);
        Query q1 = this.query(this.select(x), this.where(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)TermFactory.TOP), QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)A)), QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)B))));
        TestNegatedQueries.testQuery(q1, {b}, {c});
        Query q2 = this.query(this.select(x), this.where(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)TermFactory.TOP), QueryAtomFactory.NotKnownAtom((QueryAtom[])new QueryAtom[]{QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)A), QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)B)})));
        TestNegatedQueries.testQuery(q2, {a}, {b}, {c});
    }

    @Test
    public void test9() {
        this.kb.addPropertyValue(p, a, b);
        Query q1 = this.query(this.select(x), this.where(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)TermFactory.TOP), QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.PropertyValueAtom((ATermAppl)x, (ATermAppl)p, (ATermAppl)y)), QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.PropertyValueAtom((ATermAppl)x, (ATermAppl)q, (ATermAppl)z))));
        TestNegatedQueries.testQuery(q1, {b}, {c});
        Query q2 = this.query(this.select(x), this.where(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)TermFactory.TOP), QueryAtomFactory.NotKnownAtom((QueryAtom[])new QueryAtom[]{QueryAtomFactory.PropertyValueAtom((ATermAppl)x, (ATermAppl)p, (ATermAppl)y), QueryAtomFactory.PropertyValueAtom((ATermAppl)x, (ATermAppl)q, (ATermAppl)z)})));
        TestNegatedQueries.testQuery(q2, {a}, {b}, {c});
    }
}

