/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.axiom;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellint.lintpattern.axiom.EquivalentToAllValuePattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLSubClassAxiom;

public class EquivalentToAllValuePatternTest
extends PellintTestCase {
    private EquivalentToAllValuePattern m_Pattern;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new EquivalentToAllValuePattern();
    }

    @Test
    public void testNone() throws OWLException {
        Assert.assertTrue((boolean)this.m_Pattern.isFixable());
        OWLSubClassAxiom axiom = OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_P0AllC0);
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        axiom = OWL.disjointClasses((OWLDescription)this.m_Cls[1], (OWLDescription)this.m_P0AllC0);
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        axiom = OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLDescription[]{this.m_Cls[0], this.m_P0AllC0, this.m_Cls[2]}));
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }

    @Test
    public void testOne() throws OWLException {
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_P0AllC0);
        Lint lint = this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom);
        Assert.assertNotNull((Object)lint);
        Assert.assertTrue((boolean)lint.getParticipatingClasses().contains(this.m_Cls[0]));
        LintFixer fixer = lint.getLintFixer();
        Assert.assertTrue((boolean)fixer.getAxiomsToRemove().contains(axiom));
        OWLSubClassAxiom expectedAxiom = OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_P0AllC0);
        Assert.assertTrue((boolean)fixer.getAxiomsToAdd().contains(expectedAxiom));
        Assert.assertNull((Object)lint.getSeverity());
        Assert.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }
}

