/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.axiom;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellint.lintpattern.axiom.GCIPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLSubClassAxiom;

public class GCIPatternTest
extends PellintTestCase {
    private GCIPattern m_Pattern;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new GCIPattern();
    }

    @Test
    public void testNone() throws OWLException {
        Assert.assertFalse((boolean)this.m_Pattern.isFixable());
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_Cls[1]);
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        axiom = OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLDescription[]{this.m_Cls[0], this.m_Cls[1], this.m_Cls[2]}));
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        axiom = OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLDescription[]{this.m_Cls[0], this.m_P0AllC0, this.m_Cls[2]}));
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }

    @Test
    public void testComplexEquivalence() throws OWLException {
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLDescription[]{this.m_Cls[0], this.m_P0AllC0, this.m_P0SomeC1}));
        Lint lint = this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom);
        Assert.assertNotNull((Object)lint);
        Assert.assertTrue((boolean)lint.getParticipatingClasses().isEmpty());
        Assert.assertTrue((boolean)lint.getParticipatingAxioms().contains(axiom));
        Assert.assertNull((Object)lint.getSeverity());
        Assert.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }

    @Test
    public void testOneOf() throws OWLException {
        OWLObjectOneOf oneOf = OWL.oneOf((OWLIndividual[])this.m_Ind);
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLDescription[]{this.m_P0AllC0, oneOf}));
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }

    @Test
    public void testGCI() throws OWLException {
        OWLSubClassAxiom axiom = OWL.subClassOf((OWLDescription)this.m_P0AllC0, (OWLDescription)this.m_Cls[1]);
        Lint lint = this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom);
        Assert.assertNotNull((Object)lint);
        Assert.assertTrue((boolean)lint.getParticipatingClasses().isEmpty());
        Assert.assertTrue((boolean)lint.getParticipatingAxioms().contains(axiom));
    }
}

