/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.axiom;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellint.lintpattern.axiom.LargeCardinalityPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.test.PellintTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLSubClassAxiom;

public class LargeCardinalityPatternTest
extends PellintTestCase {
    private LargeCardinalityPattern m_Pattern;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new LargeCardinalityPattern();
    }

    @Test
    public void testNone() throws OWLException {
        this.m_Pattern.setMaxAllowed(3);
        OWLObjectMaxCardinalityRestriction maxCard = OWL.max((OWLObjectPropertyExpression)this.m_Pro[0], (int)2);
        OWLSubClassAxiom axiom = OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)maxCard);
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        Assert.assertFalse((boolean)this.m_Pattern.isFixable());
    }

    @Test
    public void testOneMax() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLObjectMaxCardinalityRestriction maxCard = OWL.max((OWLObjectPropertyExpression)this.m_Pro[0], (int)3);
        OWLDisjointClassesAxiom axiom = OWL.disjointClasses((OWLDescription)this.m_Cls[0], (OWLDescription)maxCard);
        Lint lint = this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom);
        Assert.assertNotNull((Object)lint);
        Assert.assertSame((Object)this.m_Pattern, (Object)lint.getPattern());
        Assert.assertEquals((long)1L, (long)lint.getParticipatingAxioms().size());
        Assert.assertNull((Object)lint.getLintFixer());
        Assert.assertEquals((double)3.0, (double)lint.getSeverity().doubleValue(), (double)1.0E-6);
        Assert.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }

    @Test
    public void testTwoMin() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLObjectMinCardinalityRestriction minCard1 = OWL.min((OWLObjectPropertyExpression)this.m_Pro[0], (int)3, (OWLDescription)this.m_Cls[0]);
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLDescription)this.m_Cls[1], (OWLDescription)minCard1);
        Assert.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        OWLObjectMinCardinalityRestriction minCard2 = OWL.min((OWLObjectPropertyExpression)this.m_Pro[0], (int)100, (OWLDescription)this.m_Cls[2]);
        axiom = OWL.subClassOf((OWLDescription)minCard2, (OWLDescription)this.m_Cls[3]);
        Assert.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }

    @Test
    public void testNested() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLDescription exactCard = OWL.exactly((OWLObjectProperty)this.m_Pro[0], (int)3, (OWLDescription)this.m_Cls[0]);
        OWLObjectUnionOf and = OWL.or((OWLDescription[])new OWLDescription[]{this.m_Cls[1], exactCard});
        OWLSubClassAxiom axiom = OWL.subClassOf((OWLDescription)and, (OWLDescription)this.m_Cls[2]);
        Assert.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        OWLObjectMinCardinalityRestriction minCard = OWL.min((OWLObjectPropertyExpression)this.m_Pro[0], (int)3, (OWLDescription)this.m_Cls[0]);
        OWLObjectUnionOf union = OWL.or((OWLDescription[])new OWLDescription[]{this.m_Cls[1], minCard});
        axiom = OWL.subClassOf((OWLDescription)union, (OWLDescription)this.m_Cls[2]);
        Assert.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        OWLObjectMaxCardinalityRestriction maxCard1 = OWL.max((OWLObjectPropertyExpression)this.m_Pro[0], (int)3, (OWLDescription)this.m_Cls[1]);
        OWLObjectIntersectionOf and2 = OWL.and((OWLDescription[])new OWLDescription[]{this.m_Cls[2], maxCard1});
        axiom = OWL.subClassOf((OWLDescription)and2, (OWLDescription)this.m_Cls[3]);
        Assert.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        OWLObjectMaxCardinalityRestriction maxCard2 = OWL.max((OWLObjectPropertyExpression)this.m_Pro[0], (int)2, (OWLDescription)this.m_Cls[2]);
        axiom = OWL.subClassOf((OWLDescription)this.m_Cls[4], (OWLDescription)maxCard2);
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }
}

