/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.model;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellint.model.LintFixer;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntologyCreationException;

public class LintFixerTest
extends PellintTestCase {
    private OWLAxiom[] m_Axioms;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.m_Cls[0], (OWLDescription)OWL.or((OWLDescription[])new OWLDescription[]{this.m_Cls[1], this.m_Cls[2], this.m_Cls[3]})), OWL.equivalentClasses((OWLDescription)this.m_Cls[0], (OWLDescription)this.m_Cls[1]), OWL.differentFrom((OWLIndividual)this.m_Ind[2], (OWLIndividual)this.m_Ind[3])};
    }

    @Test
    public void testRemoveAndAdd() throws OWLException {
        this.addAxiom(this.m_Axioms[0]);
        this.addAxiom(this.m_Axioms[1]);
        Set axiomsToRemove = CollectionUtil.asSet((Object[])new OWLAxiom[]{this.m_Axioms[0], this.m_Axioms[1]});
        Set axiomsToAdd = CollectionUtil.asSet((Object[])new OWLAxiom[]{this.m_Axioms[2]});
        LintFixer fixer = new LintFixer(axiomsToRemove, axiomsToAdd);
        Assert.assertTrue((boolean)fixer.apply(this.m_Manager, this.m_Ontology));
        Set axioms = this.m_Ontology.getAxioms();
        Assert.assertEquals((long)1L, (long)axioms.size());
        Assert.assertTrue((boolean)axioms.contains(this.m_Axioms[2]));
    }

    @Test
    public void testOldAxiomsDontExist() throws OWLException {
        this.addAxiom(this.m_Axioms[0]);
        Set axiomsToRemove = CollectionUtil.asSet((Object[])new OWLAxiom[]{this.m_Axioms[0], this.m_Axioms[1]});
        Set axiomsToAdd = CollectionUtil.asSet((Object[])new OWLAxiom[]{this.m_Axioms[2]});
        LintFixer fixer = new LintFixer(axiomsToRemove, axiomsToAdd);
        Assert.assertFalse((boolean)fixer.apply(this.m_Manager, this.m_Ontology));
        Set axioms = this.m_Ontology.getAxioms();
        Assert.assertEquals((long)1L, (long)axioms.size());
        Assert.assertTrue((boolean)axioms.contains(this.m_Axioms[0]));
    }

    @Test
    public void testNewAxiomsAlreadyExist() throws OWLException {
        this.addAxiom(this.m_Axioms[0]);
        this.addAxiom(this.m_Axioms[1]);
        this.addAxiom(this.m_Axioms[2]);
        Set axiomsToRemove = CollectionUtil.asSet((Object[])new OWLAxiom[]{this.m_Axioms[0], this.m_Axioms[1]});
        Set axiomsToAdd = CollectionUtil.asSet((Object[])new OWLAxiom[]{this.m_Axioms[2]});
        LintFixer fixer = new LintFixer(axiomsToRemove, axiomsToAdd);
        Assert.assertTrue((boolean)fixer.apply(this.m_Manager, this.m_Ontology));
        Set axioms = this.m_Ontology.getAxioms();
        Assert.assertEquals((long)1L, (long)axioms.size());
        Assert.assertTrue((boolean)axioms.contains(this.m_Axioms[2]));
    }
}

