/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.TermFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.textui.TestRunner;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.XSDDecimal;
import org.mindswap.pellet.datatypes.XSDInteger;
import org.mindswap.pellet.datatypes.XSDString;
import org.mindswap.pellet.jena.JenaLoader;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.FileUtils;
import org.mindswap.pellet.utils.SetUtils;

public class MiscTests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";

    public static void main(String[] args) {
        TestRunner.run((junit.framework.Test)MiscTests.suite());
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(MiscTests.class);
    }

    @Test
    public void backtrackPreservesAssertedIndividuals() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addIndividual(TermFactory.term((String)"x"));
        kb.addClass(TermFactory.term((String)"C"));
        kb.addClass(TermFactory.term((String)"D"));
        kb.addDatatypeProperty((ATerm)TermFactory.term((String)"p"));
        kb.addFunctionalProperty(TermFactory.term((String)"p"));
        kb.addSubClass(TermFactory.term((String)"C"), ATermUtils.makeSomeValues((ATerm)TermFactory.term((String)"p"), (ATerm)ATermUtils.makeValue((ATerm)ATermUtils.makePlainLiteral((String)"0"))));
        kb.addSubClass(TermFactory.term((String)"D"), ATermUtils.makeSomeValues((ATerm)TermFactory.term((String)"p"), (ATerm)ATermUtils.makeValue((ATerm)ATermUtils.makePlainLiteral((String)"1"))));
        kb.addType(TermFactory.term((String)"x"), ATermUtils.makeOr((ATermList)ATermUtils.makeList((ATerm[])new ATerm[]{TermFactory.term((String)"C"), TermFactory.term((String)"D")})));
        Assert.assertTrue((boolean)kb.isConsistent());
        kb.addIndividual(TermFactory.term((String)"y"));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertNotNull((Object)kb.getABox().getIndividual((ATerm)TermFactory.term((String)"y")));
        kb.addPropertyValue(TermFactory.term((String)"p"), TermFactory.term((String)"x"), ATermUtils.makePlainLiteral((String)"2"));
        Assert.assertFalse((boolean)kb.isConsistent());
        Assert.assertNotNull((Object)kb.getABox().getIndividual((ATerm)TermFactory.term((String)"y")));
    }

    @Test
    public void testFileUtilsToURI() throws MalformedURLException {
        Assert.assertEquals((Object)new File("build.xml").toURI().toURL().toString(), (Object)FileUtils.toURI((String)"build.xml"));
        Assert.assertEquals((Object)"http://example.com/foo", (Object)FileUtils.toURI((String)"http://example.com/foo"));
        Assert.assertEquals((Object)"file:///foo", (Object)FileUtils.toURI((String)"file:///foo"));
        Assert.assertEquals((Object)"ftp://example.com/foo", (Object)FileUtils.toURI((String)"ftp://example.com/foo"));
        Assert.assertEquals((Object)"https://example.com/foo", (Object)FileUtils.toURI((String)"https://example.com/foo"));
    }

    @Test
    public void testQualifiedCardinality2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl f = TermFactory.term((String)"f");
        ATermAppl sub = TermFactory.term((String)"sub");
        ATermAppl sup = TermFactory.term((String)"sup");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)f);
        kb.addFunctionalProperty(f);
        kb.addClass(c);
        kb.addClass(d);
        kb.addClass(sub);
        kb.addClass(sup);
        kb.addSubClass(sub, sup);
        PelletTestCase.assertSatisfiable(kb, TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.and((ATermAppl)c, (ATermAppl)d)), TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)c), TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.or((ATermAppl)TermFactory.and((ATermAppl)c, (ATermAppl)TermFactory.not((ATermAppl)d)), (ATermAppl)c))}));
        PelletTestCase.assertSubClass(kb, TermFactory.min((ATermAppl)p, (int)4, (ATermAppl)TermFactory.TOP), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        PelletTestCase.assertNotSubClass(kb, TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.TOP), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        PelletTestCase.assertNotSubClass(kb, TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)d));
        PelletTestCase.assertNotSubClass(kb, TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)c), (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)c))), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)d));
        PelletTestCase.assertSubClass(kb, TermFactory.min((ATermAppl)p, (int)3, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c));
        PelletTestCase.assertSubClass(kb, TermFactory.min((ATermAppl)p, (int)3, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        PelletTestCase.assertSubClass(kb, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        PelletTestCase.assertNotSubClass(kb, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)d));
        PelletTestCase.assertSubClass(kb, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.and((ATermAppl)c, (ATermAppl)d)), TermFactory.some((ATermAppl)p, (ATermAppl)c));
        PelletTestCase.assertSubClass(kb, TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)sup), TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)sub));
        PelletTestCase.assertSubClass(kb, TermFactory.and((ATermAppl)TermFactory.max((ATermAppl)f, (int)1, (ATermAppl)TermFactory.TOP), (ATermAppl)TermFactory.all((ATermAppl)f, (ATermAppl)c)), TermFactory.max((ATermAppl)f, (int)1, (ATermAppl)c));
        PelletTestCase.assertSubClass(kb, TermFactory.and((ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c), (ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.not((ATermAppl)c))), TermFactory.min((ATermAppl)p, (int)4, (ATermAppl)TermFactory.TOP));
    }

    @Test
    public void testQualifiedCardinality3() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"z");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl e = TermFactory.term((String)"e");
        ATermAppl notD = TermFactory.term((String)"notD");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y3 = TermFactory.term((String)"y3");
        kb.addObjectProperty((ATerm)p);
        kb.addClass(c);
        kb.addClass(d);
        kb.addClass(e);
        kb.addClass(notD);
        kb.addDisjointClass(d, notD);
        kb.addIndividual(x);
        kb.addIndividual(y3);
        kb.addType(x, TermFactory.and((ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.and((ATermAppl)d, (ATermAppl)e)), (ATermAppl)TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)d)));
        kb.addType(y3, TermFactory.not((ATermAppl)e));
        kb.addType(y3, TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)TermFactory.value((ATermAppl)x)));
        kb.addType(y3, TermFactory.or((ATermAppl)d, (ATermAppl)c));
        Assert.assertTrue((boolean)kb.isConsistent());
    }

    @Test
    public void testSelfRestrictions() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl p = TermFactory.term((String)"p");
        kb.addClass(c);
        kb.addClass(d);
        kb.addObjectProperty((ATerm)p);
        kb.addRange((ATerm)p, d);
        kb.addSubClass(c, TermFactory.and((ATermAppl)TermFactory.self((ATermAppl)p), (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.TOP)));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isSatisfiable(c));
        Assert.assertTrue((boolean)kb.isSubClassOf(c, d));
    }

    @Test
    public void testSelfRestrictionRestore() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"c");
        ATermAppl D = TermFactory.term((String)"d");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl a = TermFactory.term((String)"a");
        kb.addClass(C);
        kb.addClass(D);
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addSubClass(C, TermFactory.or((ATermAppl)TermFactory.not((ATermAppl)TermFactory.self((ATermAppl)p)), (ATermAppl)TermFactory.not((ATermAppl)TermFactory.self((ATermAppl)q))));
        kb.addIndividual(a);
        kb.addType(a, C);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertFalse((boolean)kb.isType(a, TermFactory.not((ATermAppl)TermFactory.self((ATermAppl)p))));
        Assert.assertFalse((boolean)kb.isType(a, TermFactory.not((ATermAppl)TermFactory.self((ATermAppl)q))));
    }

    @Test
    public void testReflexive1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl sub = TermFactory.term((String)"sub");
        ATermAppl sup = TermFactory.term((String)"sup");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl weakR = TermFactory.term((String)"weakR");
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y = TermFactory.term((String)"y");
        kb.addClass(c);
        kb.addClass(d);
        kb.addClass(sub);
        kb.addClass(sup);
        kb.addSubClass(sub, sup);
        kb.addSubClass(TermFactory.some((ATermAppl)weakR, (ATermAppl)TermFactory.TOP), TermFactory.self((ATermAppl)weakR));
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)r);
        kb.addObjectProperty((ATerm)weakR);
        kb.addReflexiveProperty(r);
        kb.addRange((ATerm)r, d);
        kb.addIndividual(x);
        kb.addType(x, TermFactory.self((ATermAppl)p));
        kb.addType(x, TermFactory.not((ATermAppl)TermFactory.some((ATermAppl)weakR, (ATermAppl)TermFactory.value((ATermAppl)x))));
        kb.addIndividual(y);
        kb.addPropertyValue(weakR, y, x);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isSubClassOf(TermFactory.and((ATermAppl)c, (ATermAppl)TermFactory.self((ATermAppl)p)), TermFactory.some((ATermAppl)p, (ATermAppl)c)));
        Assert.assertTrue((boolean)kb.isSubClassOf(TermFactory.and((ATermAppl)c, (ATermAppl)TermFactory.min((ATermAppl)r, (int)1, (ATermAppl)TermFactory.not((ATermAppl)c))), TermFactory.min((ATermAppl)r, (int)2, (ATermAppl)TermFactory.TOP)));
        Assert.assertTrue((boolean)kb.isSubClassOf(TermFactory.min((ATermAppl)r, (int)1, (ATermAppl)c), d));
        Assert.assertTrue((boolean)kb.hasPropertyValue(x, p, x));
        Assert.assertTrue((boolean)kb.hasPropertyValue(y, weakR, y));
        Assert.assertTrue((boolean)kb.isDifferentFrom(x, y));
        Assert.assertTrue((boolean)kb.isDifferentFrom(y, x));
        Assert.assertTrue((boolean)kb.isType(x, TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.value((ATermAppl)x))));
        Assert.assertTrue((boolean)kb.isSatisfiable(TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.self((ATermAppl)p), TermFactory.self((ATermAppl)TermFactory.inv((ATermAppl)p)), TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)TermFactory.TOP)})));
    }

    @Test
    public void testReflexive2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl r = TermFactory.term((String)"r");
        kb.addIndividual(a);
        kb.addClass(c);
        kb.addSubClass(c, TermFactory.all((ATermAppl)r, (ATermAppl)TermFactory.BOTTOM));
        kb.addSubClass(c, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{a}));
        kb.addObjectProperty((ATerm)r);
        kb.addReflexiveProperty(r);
        PelletTestCase.assertSatisfiable(kb, c, false);
    }

    @Test
    public void testReflexive3() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl Cyclic = TermFactory.term((String)"Cyclic");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl r = TermFactory.term((String)"r");
        kb.addObjectProperty((ATerm)r);
        kb.addClass(Cyclic);
        kb.addEquivalentClass(Cyclic, TermFactory.self((ATermAppl)r));
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addPropertyValue(r, a, a);
        kb.addType(b, Cyclic);
        kb.addPropertyValue(r, c, a);
        kb.addPropertyValue(r, c, b);
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, r, a));
        Assert.assertTrue((boolean)kb.hasPropertyValue(b, r, b));
        Assert.assertFalse((boolean)kb.hasPropertyValue(c, r, c));
        Map allRs = kb.getPropertyValues(r);
        PelletTestCase.assertIteratorValues(((List)allRs.get(a)).iterator(), new ATermAppl[]{a});
        PelletTestCase.assertIteratorValues(((List)allRs.get(b)).iterator(), new ATermAppl[]{b});
        PelletTestCase.assertIteratorValues(((List)allRs.get(c)).iterator(), new ATermAppl[]{a, b});
        Assert.assertTrue((boolean)kb.isType(a, Cyclic));
        Assert.assertTrue((boolean)kb.isType(b, Cyclic));
        Assert.assertFalse((boolean)kb.isType(c, Cyclic));
        Assert.assertEquals((Object)kb.getInstances(Cyclic), (Object)SetUtils.create((Object[])new ATermAppl[]{a, b}));
    }

    @Test
    public void testAsymmetry() {
        ATermAppl p = TermFactory.term((String)"p");
        KnowledgeBase kb = new KnowledgeBase();
        kb.addObjectProperty((ATerm)p);
        kb.addAsymmetricProperty(p);
        Assert.assertTrue((boolean)kb.isIrreflexiveProperty(p));
    }

    @Test
    public void testResrictedDataRange() {
        byte MIN = 0;
        byte MAX = 127;
        int COUNT = MAX - MIN + 1;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        ATermAppl datatype = TermFactory.term((String)"datatype");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y = TermFactory.term((String)"y");
        kb.addClass(C);
        kb.addClass(D);
        kb.addClass(E);
        kb.addDatatype(datatype.getName(), (Datatype)XSDInteger.instance.restrictMinInclusive((Object)new Byte(MIN)).restrictMaxInclusive((Object)new Byte(MAX)));
        kb.addDatatypeProperty((ATerm)p);
        kb.addRange((ATerm)p, datatype);
        kb.addSubClass(C, TermFactory.card((ATermAppl)p, (int)(COUNT + 1), (ATermAppl)ATermUtils.TOP_LIT));
        kb.addSubClass(D, TermFactory.card((ATermAppl)p, (int)COUNT, (ATermAppl)ATermUtils.TOP_LIT));
        kb.addSubClass(E, TermFactory.card((ATermAppl)p, (int)(COUNT - 1), (ATermAppl)ATermUtils.TOP_LIT));
        kb.addIndividual(x);
        kb.addType(x, D);
        kb.addIndividual(y);
        kb.addType(y, E);
        Assert.assertFalse((boolean)kb.isSatisfiable(C));
        Assert.assertTrue((boolean)kb.isSatisfiable(D));
        Assert.assertTrue((boolean)kb.isSatisfiable(E));
        Assert.assertTrue((boolean)kb.hasPropertyValue(x, p, ATermUtils.makeTypedLiteral((String)"5", (String)XSDInteger.instance.getURI())));
        Assert.assertFalse((boolean)kb.hasPropertyValue(y, p, ATermUtils.makeTypedLiteral((String)"5", (String)XSDDecimal.instance.getURI())));
    }

    @Test
    public void testMaxCardinality() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addObjectProperty((ATerm)TermFactory.term((String)"p"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"q"));
        kb.addFunctionalProperty(TermFactory.term((String)"q"));
        kb.addClass(TermFactory.term((String)"C"));
        kb.addSubClass(TermFactory.term((String)"C"), ATermUtils.makeMax((ATerm)TermFactory.term((String)"p"), (int)2, (ATerm)ATermUtils.TOP));
        kb.addClass(TermFactory.term((String)"D1"));
        kb.addClass(TermFactory.term((String)"D2"));
        kb.addClass(TermFactory.term((String)"D3"));
        kb.addClass(TermFactory.term((String)"D4"));
        kb.addClass(TermFactory.term((String)"E1"));
        kb.addClass(TermFactory.term((String)"E2"));
        kb.addClass(TermFactory.term((String)"E3"));
        kb.addClass(TermFactory.term((String)"E4"));
        kb.addSubClass(TermFactory.term((String)"D1"), ATermUtils.makeSomeValues((ATerm)TermFactory.term((String)"q"), (ATerm)TermFactory.term((String)"E1")));
        kb.addSubClass(TermFactory.term((String)"D2"), ATermUtils.makeSomeValues((ATerm)TermFactory.term((String)"q"), (ATerm)TermFactory.term((String)"E2")));
        kb.addSubClass(TermFactory.term((String)"D3"), ATermUtils.makeSomeValues((ATerm)TermFactory.term((String)"q"), (ATerm)TermFactory.term((String)"E3")));
        kb.addSubClass(TermFactory.term((String)"D4"), ATermUtils.makeSomeValues((ATerm)TermFactory.term((String)"q"), (ATerm)TermFactory.term((String)"E4")));
        kb.addIndividual(TermFactory.term((String)"x"));
        kb.addType(TermFactory.term((String)"x"), TermFactory.term((String)"C"));
        kb.addIndividual(TermFactory.term((String)"x1"));
        kb.addType(TermFactory.term((String)"x1"), TermFactory.term((String)"D1"));
        kb.addIndividual(TermFactory.term((String)"x2"));
        kb.addType(TermFactory.term((String)"x2"), TermFactory.term((String)"D2"));
        kb.addIndividual(TermFactory.term((String)"x3"));
        kb.addType(TermFactory.term((String)"x3"), TermFactory.term((String)"D3"));
        kb.addIndividual(TermFactory.term((String)"x4"));
        kb.addType(TermFactory.term((String)"x4"), TermFactory.term((String)"D4"));
        kb.addPropertyValue(TermFactory.term((String)"p"), TermFactory.term((String)"x"), TermFactory.term((String)"x1"));
        kb.addPropertyValue(TermFactory.term((String)"p"), TermFactory.term((String)"x"), TermFactory.term((String)"x2"));
        kb.addPropertyValue(TermFactory.term((String)"p"), TermFactory.term((String)"x"), TermFactory.term((String)"x3"));
        kb.addPropertyValue(TermFactory.term((String)"p"), TermFactory.term((String)"x"), TermFactory.term((String)"x4"));
        kb.addDisjointClass(TermFactory.term((String)"E1"), TermFactory.term((String)"E2"));
        kb.addDisjointClass(TermFactory.term((String)"E1"), TermFactory.term((String)"E4"));
        kb.addDisjointClass(TermFactory.term((String)"E2"), TermFactory.term((String)"E3"));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isSameAs(TermFactory.term((String)"x1"), TermFactory.term((String)"x3")));
        Assert.assertTrue((boolean)kb.isSameAs(TermFactory.term((String)"x3"), TermFactory.term((String)"x1")));
        Assert.assertTrue((boolean)kb.isSameAs(TermFactory.term((String)"x2"), TermFactory.term((String)"x4")));
        Assert.assertTrue((boolean)kb.getSames(TermFactory.term((String)"x1")).contains(TermFactory.term((String)"x3")));
        Assert.assertTrue((boolean)kb.getSames(TermFactory.term((String)"x2")).contains(TermFactory.term((String)"x4")));
    }

    @Test
    public void testDifferentFrom2() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addClass(TermFactory.term((String)"C"));
        kb.addClass(TermFactory.term((String)"D"));
        kb.addDisjointClass(TermFactory.term((String)"C"), TermFactory.term((String)"D"));
        kb.addIndividual(TermFactory.term((String)"a"));
        kb.addType(TermFactory.term((String)"a"), TermFactory.term((String)"C"));
        kb.addIndividual(TermFactory.term((String)"b"));
        kb.addType(TermFactory.term((String)"b"), TermFactory.term((String)"D"));
        kb.classify();
        Assert.assertTrue((boolean)kb.getDifferents(TermFactory.term((String)"a")).contains(TermFactory.term((String)"b")));
        Assert.assertTrue((boolean)kb.getDifferents(TermFactory.term((String)"b")).contains(TermFactory.term((String)"a")));
    }

    @Test
    public void testSHOIN() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addObjectProperty((ATerm)TermFactory.term((String)"R1"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"invR1"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"R2"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"invR2"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"S1"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"invS1"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"S2"));
        kb.addObjectProperty((ATerm)TermFactory.term((String)"invS2"));
        kb.addInverseProperty(TermFactory.term((String)"R1"), TermFactory.term((String)"invR1"));
        kb.addInverseProperty(TermFactory.term((String)"R2"), TermFactory.term((String)"invR2"));
        kb.addInverseProperty(TermFactory.term((String)"S1"), TermFactory.term((String)"invS1"));
        kb.addInverseProperty(TermFactory.term((String)"S2"), TermFactory.term((String)"invS2"));
        kb.addIndividual(TermFactory.term((String)"o1"));
        kb.addIndividual(TermFactory.term((String)"o2"));
        kb.addSubClass(TermFactory.value((ATermAppl)TermFactory.term((String)"o1")), TermFactory.and((ATermAppl)TermFactory.max((ATermAppl)TermFactory.term((String)"invR1"), (int)2, (ATermAppl)ATermUtils.TOP), (ATermAppl)TermFactory.all((ATermAppl)TermFactory.term((String)"invR1"), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"S1"), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"invS2"), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"R2"), (ATermAppl)TermFactory.value((ATermAppl)TermFactory.term((String)"o2"))))))));
        kb.addSubClass(TermFactory.value((ATermAppl)TermFactory.term((String)"o2")), TermFactory.and((ATermAppl)TermFactory.max((ATermAppl)TermFactory.term((String)"invR2"), (int)2, (ATermAppl)ATermUtils.TOP), (ATermAppl)TermFactory.all((ATermAppl)TermFactory.term((String)"invR2"), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"S2"), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"invS1"), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"R1"), (ATermAppl)TermFactory.value((ATermAppl)TermFactory.term((String)"o1"))))))));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isSatisfiable(TermFactory.and((ATermAppl)TermFactory.value((ATermAppl)TermFactory.term((String)"o1")), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.term((String)"invR1"), (ATermAppl)TermFactory.TOP))));
    }

    @Test
    public void testCyclicTBox1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        kb.addEquivalentClass(C, TermFactory.not((ATermAppl)C));
        Assert.assertFalse((boolean)kb.isConsistent());
    }

    @Test
    public void testSimplePropertyChain() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addObjectProperty((ATerm)r);
        kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)D))));
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addPropertyValue(p, a, b);
        kb.addPropertyValue(q, b, c);
        Assert.assertTrue((boolean)kb.isSubClassOf(C, D));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, r, c));
        Assert.assertEquals(Arrays.asList(c), (Object)kb.getPropertyValues(r, a));
    }

    @Test
    @Ignore(value="See ticket #123")
    public void testTopClass2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addObjectProperty((ATerm)p);
        kb.addEquivalentClass(A, TermFactory.or((ATermAppl)B, (ATermAppl)TermFactory.not((ATermAppl)B)));
        kb.addSubClass(C, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        Assert.assertTrue((boolean)kb.isConsistent());
        kb.classify();
        Assert.assertTrue((boolean)kb.isEquivalentClass(A, TermFactory.TOP));
        Assert.assertFalse((boolean)kb.isEquivalentClass(B, TermFactory.TOP));
    }

    @Test
    @Ignore(value="See ticket #157")
    public void testTopClass2EL() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        kb.addClass(A);
        kb.addClass(B);
        kb.addEquivalentClass(A, TermFactory.or((ATermAppl)B, (ATermAppl)TermFactory.not((ATermAppl)B)));
        Assert.assertTrue((boolean)kb.isConsistent());
        kb.classify();
        Assert.assertTrue((boolean)kb.isEquivalentClass(A, TermFactory.TOP));
        Assert.assertFalse((boolean)kb.isEquivalentClass(B, TermFactory.TOP));
    }

    @Test
    public void testTopClass3() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addEquivalentClass(A, B);
        kb.addEquivalentClass(B, TermFactory.or((ATermAppl)B, (ATermAppl)TermFactory.not((ATermAppl)B)));
        kb.addSubClass(C, A);
        Assert.assertTrue((boolean)kb.isConsistent());
        kb.classify();
        Assert.assertTrue((boolean)kb.isEquivalentClass(A, TermFactory.TOP));
        Assert.assertTrue((boolean)kb.isEquivalentClass(B, TermFactory.TOP));
        Assert.assertFalse((boolean)kb.isEquivalentClass(C, TermFactory.TOP));
    }

    @Test
    public void testTopClass4() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addSubClass(TermFactory.not((ATermAppl)A), A);
        kb.addSubClass(B, A);
        Assert.assertTrue((boolean)kb.isConsistent());
        kb.classify();
        Assert.assertTrue((boolean)kb.isEquivalentClass(A, TermFactory.TOP));
    }

    @Test
    public void testNonDisjointness() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addSubClass(TermFactory.not((ATermAppl)A), B);
        kb.addSubClass(C, TermFactory.and((ATermAppl)A, (ATermAppl)B));
        Assert.assertTrue((boolean)kb.isConsistent());
        kb.classify();
        Assert.assertTrue((boolean)kb.isSatisfiable(C));
    }

    @Test
    public void testCyclicTBox2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        kb.addClass(B);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(C, B);
        kb.addSubClass(D, C);
        kb.addEquivalentClass(D, B);
        kb.classify();
        Assert.assertTrue((boolean)kb.isEquivalentClass(B, C));
        Assert.assertTrue((boolean)kb.isEquivalentClass(B, D));
        Assert.assertTrue((boolean)kb.isEquivalentClass(D, C));
    }

    @Test
    public void testCyclicTBox3() {
        List<ATermAppl> classes = Arrays.asList(TermFactory.term((String)"C0"), TermFactory.term((String)"C1"), TermFactory.term((String)"C2"));
        Taxonomy taxonomy = new Taxonomy(classes, (Object)ATermUtils.TOP, (Object)ATermUtils.BOTTOM);
        TaxonomyNode top = taxonomy.getTop();
        TaxonomyNode[] nodes = new TaxonomyNode[classes.size()];
        int i = 0;
        for (ATermAppl c : classes) {
            nodes[i++] = taxonomy.getNode((Object)c);
        }
        taxonomy.addSuper((Object)classes.get(1), (Object)classes.get(2));
        taxonomy.addSuper((Object)classes.get(0), (Object)classes.get(1));
        taxonomy.merge(top, nodes[0]);
        Assert.assertTrue((boolean)top.getSupers().isEmpty());
        Assert.assertTrue((boolean)top.getEquivalents().containsAll(classes));
    }

    @Test
    public void testComplexTypes() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        kb.addIndividual(a);
        kb.addType(a, TermFactory.min((ATermAppl)p, (int)3, (ATermAppl)TermFactory.TOP));
        kb.addType(a, TermFactory.max((ATermAppl)q, (int)2, (ATermAppl)TermFactory.TOP));
        kb.addType(a, TermFactory.min((ATermAppl)q, (int)1, (ATermAppl)TermFactory.TOP));
        kb.addType(a, TermFactory.min((ATermAppl)q, (int)1, (ATermAppl)TermFactory.TOP));
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        Assert.assertTrue((boolean)kb.isConsistent());
    }

    @Test
    public void testBottomSub() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"c");
        kb.addClass(c);
        kb.addSubClass(ATermUtils.BOTTOM, c);
        kb.classify();
        Assert.assertTrue((boolean)kb.isSubClassOf(ATermUtils.BOTTOM, c));
    }

    @Test
    public void testMergeRestore2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl e = TermFactory.term((String)"e");
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addIndividual(d);
        kb.addIndividual(e);
        kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        kb.addClass(D);
        kb.addClass(E);
        kb.addSubClass(E, TermFactory.not((ATermAppl)D));
        kb.addType(a, D);
        Assert.assertTrue((boolean)kb.isConsistent());
        ATermAppl mergedTo = kb.getABox().getIndividual((ATerm)a).getMergedTo().getName();
        kb.addType(mergedTo, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{d, e}));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isType(a, TermFactory.not((ATermAppl)E)));
    }

    @Test
    @Ignore(value="Known to fail because different lexical forms are stored in one canonical literal")
    public void testCanonicalLiteral() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl plain = ATermUtils.makePlainLiteral((String)"lit");
        ATermAppl typed = ATermUtils.makeTypedLiteral((String)"lit", (String)XSDString.instance.getURI());
        kb.addIndividual(a);
        kb.addDatatypeProperty((ATerm)p);
        kb.addDatatypeProperty((ATerm)q);
        kb.addPropertyValue(p, a, plain);
        kb.addPropertyValue(q, a, typed);
        PelletTestCase.assertIteratorValues(kb.getDataPropertyValues(p, a).iterator(), new ATermAppl[]{plain});
        PelletTestCase.assertIteratorValues(kb.getDataPropertyValues(q, a).iterator(), new ATermAppl[]{typed});
    }

    @Test
    public void testSimpleABoxRemove() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(a);
        kb.addType(a, C);
        kb.addType(a, D);
        kb.removeType(a, D);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isType(a, C));
        Assert.assertFalse((boolean)kb.isType(a, D));
    }

    @Test
    public void testABoxRemovalWithAllValues() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        kb.addClass(C);
        kb.addObjectProperty((ATerm)p);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addType(a, TermFactory.all((ATermAppl)p, (ATermAppl)C));
        kb.addType(b, C);
        kb.addPropertyValue(p, a, b);
        kb.removeType(b, C);
        kb.removePropertyValue(p, a, b);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertFalse((boolean)kb.isType(b, C));
        Assert.assertFalse((boolean)kb.hasPropertyValue(a, p, b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalTBoxDisjointRemove1() {
        boolean preTrace = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
        try {
            ATermAppl A = ATermUtils.makeTermAppl((String)"A");
            ATermAppl B = ATermUtils.makeTermAppl((String)"B");
            ATermAppl C = ATermUtils.makeTermAppl((String)"C");
            ATermAppl x = ATermUtils.makeTermAppl((String)"x");
            KnowledgeBase kb = new KnowledgeBase();
            kb.addClass(A);
            kb.addClass(B);
            kb.addClass(C);
            kb.addIndividual(x);
            kb.addSubClass(C, A);
            kb.addType(x, C);
            kb.addType(x, B);
            HashSet<Set<ATermAppl>> expectedTypes = new HashSet<Set<ATermAppl>>();
            expectedTypes.add(Collections.singleton(ATermUtils.TOP));
            expectedTypes.add(Collections.singleton(A));
            expectedTypes.add(Collections.singleton(B));
            expectedTypes.add(Collections.singleton(C));
            Assert.assertTrue((boolean)kb.isConsistent());
            Set actualTypes = kb.getTypes(x);
            Assert.assertEquals(expectedTypes, (Object)actualTypes);
            kb.addDisjointClass(A, B);
            Assert.assertFalse((boolean)kb.isConsistent());
            Assert.assertTrue((boolean)kb.removeAxiom(ATermUtils.makeDisjoint((ATerm)A, (ATerm)B)));
            Assert.assertTrue((boolean)kb.isConsistent());
            actualTypes = kb.getTypes(x);
            Assert.assertEquals(expectedTypes, (Object)actualTypes);
        }
        finally {
            PelletOptions.USE_TRACING = preTrace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalTBoxDisjointRemove2() {
        boolean preTrace = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
        try {
            ATermAppl A = ATermUtils.makeTermAppl((String)"A");
            ATermAppl B = ATermUtils.makeTermAppl((String)"B");
            ATermAppl C = ATermUtils.makeTermAppl((String)"C");
            ATermAppl x = ATermUtils.makeTermAppl((String)"x");
            KnowledgeBase kb = new KnowledgeBase();
            kb.addClass(A);
            kb.addClass(B);
            kb.addClass(C);
            kb.addIndividual(x);
            kb.addSubClass(C, A);
            kb.addType(x, C);
            kb.addType(x, B);
            HashSet<Set<ATermAppl>> expectedTypes = new HashSet<Set<ATermAppl>>();
            expectedTypes.add(Collections.singleton(ATermUtils.TOP));
            expectedTypes.add(Collections.singleton(A));
            expectedTypes.add(Collections.singleton(B));
            expectedTypes.add(Collections.singleton(C));
            Assert.assertTrue((boolean)kb.isConsistent());
            Set actualTypes = kb.getTypes(x);
            Assert.assertEquals(expectedTypes, (Object)actualTypes);
            kb.addSubClass(A, ATermUtils.makeNot((ATerm)B));
            Assert.assertFalse((boolean)kb.isConsistent());
            kb.addDisjointClass(A, B);
            Assert.assertFalse((boolean)kb.isConsistent());
            Assert.assertTrue((boolean)kb.removeAxiom(ATermUtils.makeDisjoint((ATerm)A, (ATerm)B)));
            Assert.assertFalse((boolean)kb.isConsistent());
            Assert.assertTrue((boolean)kb.removeAxiom(ATermUtils.makeSub((ATerm)A, (ATerm)ATermUtils.makeNot((ATerm)B))));
            Assert.assertTrue((boolean)kb.isConsistent());
            actualTypes = kb.getTypes(x);
            Assert.assertEquals(expectedTypes, (Object)actualTypes);
        }
        finally {
            PelletOptions.USE_TRACING = preTrace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalTBoxDisjointRemove3() {
        boolean preTrace = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
        try {
            ATermAppl A = ATermUtils.makeTermAppl((String)"A");
            ATermAppl B = ATermUtils.makeTermAppl((String)"B");
            ATermAppl C = ATermUtils.makeTermAppl((String)"C");
            ATermAppl D = ATermUtils.makeTermAppl((String)"D");
            ATermAppl x = ATermUtils.makeTermAppl((String)"x");
            KnowledgeBase kb = new KnowledgeBase();
            kb.addClass(A);
            kb.addClass(B);
            kb.addClass(C);
            kb.addClass(D);
            kb.addIndividual(x);
            kb.addSubClass(C, A);
            kb.addType(x, C);
            kb.addType(x, B);
            HashSet<Set<ATermAppl>> expectedTypes = new HashSet<Set<ATermAppl>>();
            expectedTypes.add(Collections.singleton(ATermUtils.TOP));
            expectedTypes.add(Collections.singleton(A));
            expectedTypes.add(Collections.singleton(B));
            expectedTypes.add(Collections.singleton(C));
            Assert.assertTrue((boolean)kb.isConsistent());
            Set actualTypes = kb.getTypes(x);
            Assert.assertEquals(expectedTypes, (Object)actualTypes);
            kb.addSubClass(A, ATermUtils.makeNot((ATerm)B));
            Assert.assertFalse((boolean)kb.isConsistent());
            ATermList list = ATermUtils.toSet((ATerm[])new ATerm[]{A, B, D}, (int)3);
            kb.addDisjointClasses(list);
            Assert.assertFalse((boolean)kb.isConsistent());
            Assert.assertTrue((boolean)kb.removeAxiom(ATermUtils.makeDisjoints((ATermList)list)));
            Assert.assertFalse((boolean)kb.isConsistent());
            Assert.assertTrue((boolean)kb.removeAxiom(ATermUtils.makeSub((ATerm)A, (ATerm)ATermUtils.makeNot((ATerm)B))));
            Assert.assertTrue((boolean)kb.isConsistent());
            actualTypes = kb.getTypes(x);
            Assert.assertEquals(expectedTypes, (Object)actualTypes);
        }
        finally {
            PelletOptions.USE_TRACING = preTrace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalTBoxDisjointRemove4() {
        boolean preTrace = PelletOptions.USE_TRACING;
        boolean preRoleAbsorption = PelletOptions.USE_ROLE_ABSORPTION;
        PelletOptions.USE_TRACING = true;
        PelletOptions.USE_ROLE_ABSORPTION = true;
        try {
            ATermAppl A = ATermUtils.makeTermAppl((String)"A");
            ATermAppl B = ATermUtils.makeTermAppl((String)"B");
            ATermAppl p = ATermUtils.makeTermAppl((String)"p");
            KnowledgeBase kb = new KnowledgeBase();
            kb.addClass(A);
            kb.addClass(B);
            kb.addObjectProperty((ATerm)p);
            ATermAppl or1 = TermFactory.or((ATermAppl)A, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)A));
            ATermAppl or2 = TermFactory.or((ATermAppl)B, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)B));
            ATermList list = ATermUtils.toSet((ATerm[])new ATerm[]{or1, or2}, (int)2);
            kb.addDisjointClasses(list);
            Assert.assertTrue((boolean)kb.isConsistent());
            ATermAppl disjoint = ATermUtils.makeDisjoints((ATermList)list);
            Assert.assertFalse((boolean)kb.removeAxiom(disjoint));
        }
        finally {
            PelletOptions.USE_TRACING = preTrace;
            PelletOptions.USE_ROLE_ABSORPTION = preRoleAbsorption;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalTBoxDisjointRemove5() {
        boolean preTrace = PelletOptions.USE_TRACING;
        boolean preRoleAbsorption = PelletOptions.USE_ROLE_ABSORPTION;
        PelletOptions.USE_TRACING = true;
        PelletOptions.USE_ROLE_ABSORPTION = true;
        try {
            ATermAppl A = ATermUtils.makeTermAppl((String)"A");
            ATermAppl B = ATermUtils.makeTermAppl((String)"B");
            ATermAppl p = ATermUtils.makeTermAppl((String)"p");
            KnowledgeBase kb = new KnowledgeBase();
            kb.addClass(A);
            kb.addClass(B);
            kb.addObjectProperty((ATerm)p);
            ATermAppl or1 = TermFactory.or((ATermAppl)A, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)A));
            ATermAppl or2 = TermFactory.or((ATermAppl)B, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)B));
            kb.addDisjointClass(or1, or2);
            Assert.assertTrue((boolean)kb.isConsistent());
            ATermAppl disjoint = ATermUtils.makeDisjoint((ATerm)or1, (ATerm)or2);
            Assert.assertFalse((boolean)kb.removeAxiom(disjoint));
        }
        finally {
            PelletOptions.USE_TRACING = preTrace;
            PelletOptions.USE_ROLE_ABSORPTION = preRoleAbsorption;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalTBoxDisjointRemove6() {
        boolean preTrace = PelletOptions.USE_TRACING;
        boolean preRoleAbsorption = PelletOptions.USE_ROLE_ABSORPTION;
        PelletOptions.USE_TRACING = true;
        PelletOptions.USE_ROLE_ABSORPTION = true;
        try {
            ATermAppl A = ATermUtils.makeTermAppl((String)"A");
            ATermAppl p = ATermUtils.makeTermAppl((String)"p");
            KnowledgeBase kb = new KnowledgeBase();
            kb.addClass(A);
            kb.addObjectProperty((ATerm)p);
            kb.addSubClass(TermFactory.TOP, TermFactory.all((ATermAppl)p, (ATermAppl)A));
            Role r = kb.getRole((ATerm)p);
            Assert.assertTrue((boolean)kb.isConsistent());
            Assert.assertTrue((boolean)r.getRanges().contains(A));
            Assert.assertFalse((boolean)kb.removeAxiom(ATermUtils.makeSub((ATerm)TermFactory.TOP, (ATerm)TermFactory.all((ATermAppl)p, (ATermAppl)A))));
        }
        finally {
            PelletOptions.USE_TRACING = preTrace;
            PelletOptions.USE_ROLE_ABSORPTION = preRoleAbsorption;
        }
    }

    @Test
    public void testAssertedSameAs() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl e = TermFactory.term((String)"e");
        ATermAppl f = TermFactory.term((String)"f");
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addIndividual(d);
        kb.addIndividual(e);
        kb.addIndividual(f);
        kb.addSame(a, b);
        kb.addSame(b, c);
        kb.addSame(c, d);
        kb.addSame(a, d);
        kb.addSame(b, d);
        kb.addSame(e, f);
        kb.addDifferent(e, f);
        Assert.assertFalse((boolean)kb.isConsistent());
    }

    @Test
    public void testSubPropertyRestore() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl invP = TermFactory.term((String)"invP");
        ATermAppl invQ = TermFactory.term((String)"invQ");
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addIndividual(d);
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addObjectProperty((ATerm)invP);
        kb.addObjectProperty((ATerm)invQ);
        kb.addPropertyValue(p, a, b);
        kb.addPropertyValue(q, a, b);
        kb.addSubProperty((ATerm)p, q);
        kb.addInverseProperty(p, invP);
        kb.addInverseProperty(q, invQ);
        kb.addType(b, TermFactory.or((ATermAppl)TermFactory.value((ATermAppl)c), (ATermAppl)TermFactory.value((ATermAppl)d)));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isType(b, TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)invP, (ATermAppl)TermFactory.value((ATermAppl)a)), (ATermAppl)TermFactory.some((ATermAppl)invQ, (ATermAppl)TermFactory.value((ATermAppl)a)))));
    }

    @Test
    public void testInverseProperty() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl invP = TermFactory.term((String)"invP");
        ATermAppl invQ = TermFactory.term((String)"invQ");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addObjectProperty((ATerm)invP);
        kb.addObjectProperty((ATerm)invQ);
        kb.addInverseProperty(p, invP);
        kb.addInverseProperty(q, invQ);
        Assert.assertEquals(Collections.singleton(invP), (Object)kb.getInverses((ATerm)p));
        Assert.assertEquals(Collections.singleton(invQ), (Object)kb.getInverses((ATerm)q));
        Assert.assertEquals(Collections.singleton(p), (Object)kb.getInverses((ATerm)invP));
        Assert.assertEquals(Collections.singleton(q), (Object)kb.getInverses((ATerm)invQ));
    }

    @Test
    public void testUndefinedTerms() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        kb.addClass(C);
        ATermAppl p = TermFactory.term((String)"p");
        kb.addObjectProperty((ATerm)p);
        ATermAppl undef = TermFactory.term((String)"undef");
        Assert.assertEquals(Collections.singleton(p), (Object)kb.getAllEquivalentProperties(p));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getEquivalentProperties(p));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSubProperties(p));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSuperProperties(p));
        Assert.assertEquals(Collections.singleton(C), (Object)kb.getAllEquivalentClasses(C));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getEquivalentClasses(C));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSubClasses(p));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSuperClasses(p));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getAllEquivalentProperties(undef));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getEquivalentProperties(undef));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSubProperties(undef));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSuperProperties(undef));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getAllEquivalentClasses(undef));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getEquivalentClasses(undef));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSubClasses(p));
        Assert.assertEquals(Collections.emptySet(), (Object)kb.getSuperClasses(p));
    }

    @Test
    public void testDatatypeReasoner() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        kb.addDatatypeProperty((ATerm)p);
        ATermAppl a = TermFactory.term((String)"a");
        kb.addIndividual(a);
        kb.addRange((ATerm)p, TermFactory.term((String)"http://www.w3.org/2001/XMLSchema#float"));
        kb.addPropertyValue(p, a, TermFactory.typedLiteral((String)"42.0", (String)"http://www.w3.org/2001/XMLSchema#float"));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isType(a, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.term((String)"http://www.w3.org/2001/XMLSchema#float"))));
    }

    @Test
    public void testCRonDTP() {
        PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING = false;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl c = TermFactory.and((ATermAppl)TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.value((ATermAppl)TermFactory.literal((String)"s"))), (ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.value((ATermAppl)TermFactory.literal((String)"l"))));
        kb.addDatatypeProperty((ATerm)p);
        Assert.assertFalse((boolean)kb.isSatisfiable(c));
        PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING = true;
    }

    @Test
    public void testInvalidTransitivity2() {
        KBLoader[] loaders;
        for (KBLoader loader : loaders = new KBLoader[]{new JenaLoader()}) {
            KnowledgeBase kb = loader.createKB(new String[]{base + "invalidTransitivity.owl"});
            for (Role r : kb.getRBox().getRoles()) {
                Assert.assertTrue((String)r.toString(), (boolean)r.isSimple());
                Assert.assertFalse((String)r.toString(), (boolean)r.isTransitive());
            }
            for (ATermAppl p : kb.getObjectProperties()) {
                Assert.assertFalse((String)p.toString(), (boolean)kb.isTransitiveProperty(p));
            }
        }
    }

    @Test
    public void testInversesInPropertyChain() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl hasMother = TermFactory.term((String)"hasMother");
        ATermAppl hasParent = TermFactory.term((String)"hasParent");
        ATermAppl hasChild = TermFactory.term((String)"hasChild");
        ATermAppl hasSibling = TermFactory.term((String)"hasSibling");
        kb.addObjectProperty((ATerm)hasMother);
        kb.addObjectProperty((ATerm)hasParent);
        kb.addObjectProperty((ATerm)hasChild);
        kb.addObjectProperty((ATerm)hasSibling);
        kb.addSubProperty((ATerm)hasMother, hasParent);
        kb.addInverseProperty(hasChild, hasParent);
        kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{hasParent, hasChild}), hasSibling);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addPropertyValue(hasMother, a, c);
        kb.addPropertyValue(hasMother, b, c);
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, hasSibling, b));
        Assert.assertTrue((boolean)kb.hasPropertyValue(b, hasSibling, a));
        PelletTestCase.assertIteratorValues(kb.getPropertyValues(hasSibling, a).iterator(), new ATermAppl[]{a, b});
        PelletTestCase.assertIteratorValues(kb.getPropertyValues(hasSibling, b).iterator(), new ATermAppl[]{a, b});
    }

    @Test
    public void testRoleAbsorptionWithPropertyChain() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addObjectProperty((ATerm)r);
        kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(C, B);
        kb.addEquivalentClass(C, TermFactory.some((ATermAppl)r, (ATermAppl)D));
        kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)D)));
        Assert.assertTrue((boolean)kb.isSubClassOf(A, C));
        kb.classify();
        Assert.assertTrue((boolean)kb.isSubClassOf(A, C));
    }

    @Test
    public void testInternalization() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addSubClass(TermFactory.TOP, TermFactory.and((ATermAppl)TermFactory.or((ATermAppl)B, (ATermAppl)TermFactory.not((ATermAppl)A)), (ATermAppl)TermFactory.or((ATermAppl)C, (ATermAppl)TermFactory.not((ATermAppl)B))));
        PelletTestCase.assertSubClass(kb, A, B);
        PelletTestCase.assertSubClass(kb, B, C);
        kb.classify();
    }

    @Test
    public void testNominalCache() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        kb.addClass(C);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addSubClass(C, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{a, b}));
        kb.addEquivalentClass(A, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{a}));
        kb.addEquivalentClass(B, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b}));
        kb.addDisjointClass(A, B);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isSatisfiable(C));
        PelletTestCase.assertNotSubClass(kb, C, A);
        PelletTestCase.assertNotSubClass(kb, C, B);
        PelletTestCase.assertNotSubClass(kb, A, C);
        PelletTestCase.assertNotSubClass(kb, B, C);
        Assert.assertFalse((boolean)kb.isType(a, C));
        Assert.assertFalse((boolean)kb.isType(b, C));
        Assert.assertFalse((boolean)kb.isType(a, TermFactory.not((ATermAppl)C)));
        Assert.assertFalse((boolean)kb.isType(b, TermFactory.not((ATermAppl)C)));
    }

    @Test
    public void testMultiEdgesWithTransitivity() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermAppl e = TermFactory.term((String)"e");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl s = TermFactory.term((String)"s");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)r);
        kb.addObjectProperty((ATerm)s);
        kb.addTransitiveProperty(r);
        kb.addTransitiveProperty(s);
        kb.addSubProperty((ATerm)r, p);
        kb.addSubProperty((ATerm)s, p);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addIndividual(d);
        kb.addIndividual(e);
        kb.addPropertyValue(r, a, b);
        kb.addPropertyValue(r, b, c);
        kb.addPropertyValue(r, b, d);
        kb.addPropertyValue(s, a, c);
        kb.addPropertyValue(s, c, b);
        kb.addPropertyValue(s, c, e);
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, b));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, c));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, d));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, e));
        PelletTestCase.assertIteratorValues(kb.getPropertyValues(p, a).iterator(), new ATermAppl[]{b, c, d, e});
    }

    @Test
    @Ignore(value="See ticket #250")
    public void testLiteralMerge() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl p = TermFactory.term((String)"p");
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addDatatypeProperty((ATerm)p);
        kb.addFunctionalProperty(p);
        kb.addType(a, TermFactory.some((ATermAppl)p, (ATermAppl)XSDInteger.instance.getName()));
        kb.addType(a, TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP_LIT));
        kb.addPropertyValue(p, b, TermFactory.literal((String)"b"));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isDifferentFrom(a, b));
    }

    @Test
    public void testDatatypeSubProperty1a() {
        ATermAppl[] ranges;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        for (ATermAppl rangeP : ranges = new ATermAppl[]{null, XSDInteger.instance.getName(), XSDString.instance.getName()}) {
            for (ATermAppl rangeQ : ranges) {
                kb.clear();
                kb.addDatatypeProperty((ATerm)p);
                kb.addDatatypeProperty((ATerm)q);
                if (rangeP != null) {
                    kb.addRange((ATerm)p, rangeP);
                }
                if (rangeQ != null) {
                    kb.addRange((ATerm)q, rangeQ);
                }
                Assert.assertTrue((boolean)kb.isConsistent());
                Assert.assertFalse((boolean)kb.isSubPropertyOf(p, q));
                Assert.assertFalse((boolean)kb.isSubPropertyOf(q, p));
                Assert.assertFalse((boolean)kb.isEquivalentProperty(p, q));
                Assert.assertFalse((boolean)kb.isEquivalentProperty(q, p));
            }
        }
    }

    @Test
    public void testDatatypeSubProperty1b() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        kb.addClass(C);
        kb.addDatatypeProperty((ATerm)p);
        kb.addDatatypeProperty((ATerm)q);
        kb.addDomain((ATerm)p, C);
        kb.addRange((ATerm)q, XSDInteger.instance.getName());
        kb.addSubClass(C, TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.TOP_LIT));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertFalse((boolean)kb.isSubPropertyOf(p, q));
        Assert.assertFalse((boolean)kb.isSubPropertyOf(q, p));
        Assert.assertFalse((boolean)kb.isEquivalentProperty(p, q));
        Assert.assertFalse((boolean)kb.isEquivalentProperty(q, p));
    }

    @Test
    public void testCachedNominalEdge() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addClass(D);
        kb.addObjectProperty((ATerm)p);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addEquivalentClass(A, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        kb.addEquivalentClass(B, TermFactory.hasValue((ATermAppl)p, (ATermAppl)b));
        kb.addEquivalentClass(C, TermFactory.hasValue((ATermAppl)p, (ATermAppl)c));
        kb.addEquivalentClass(D, TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.some((ATermAppl)p, (ATermAppl)A), TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.value((ATermAppl)b)), TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.value((ATermAppl)c)), TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)TermFactory.TOP)}));
        Assert.assertTrue((boolean)kb.isConsistent());
        kb.classify();
        Assert.assertTrue((boolean)kb.isSubClassOf(D, B));
        Assert.assertTrue((boolean)kb.isSubClassOf(D, C));
    }

    @Test
    public void testDisjoints() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(B, A);
        kb.addSubClass(D, C);
        kb.addComplementClass(B, C);
        Assert.assertTrue((boolean)kb.isConsistent());
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(TermFactory.TOP).iterator(), new Object[]{Collections.singleton(TermFactory.BOTTOM)});
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(A).iterator(), new Object[]{Collections.singleton(TermFactory.BOTTOM)});
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(B).iterator(), new Object[]{Collections.singleton(TermFactory.BOTTOM), Collections.singleton(C), Collections.singleton(D)});
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(C).iterator(), new Object[]{Collections.singleton(TermFactory.BOTTOM), Collections.singleton(B)});
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(D).iterator(), new Object[]{Collections.singleton(TermFactory.BOTTOM), Collections.singleton(B)});
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(TermFactory.BOTTOM).iterator(), new Object[]{Collections.singleton(TermFactory.TOP), Collections.singleton(A), Collections.singleton(B), Collections.singleton(C), Collections.singleton(D), Collections.singleton(TermFactory.BOTTOM)});
        PelletTestCase.assertIteratorValues(kb.getComplements(TermFactory.TOP).iterator(), new Object[]{TermFactory.BOTTOM});
        Assert.assertTrue((boolean)kb.getComplements(A).isEmpty());
        PelletTestCase.assertIteratorValues(kb.getComplements(B).iterator(), new Object[]{C});
        PelletTestCase.assertIteratorValues(kb.getComplements(C).iterator(), new Object[]{B});
        Assert.assertTrue((boolean)kb.getComplements(D).isEmpty());
        PelletTestCase.assertIteratorValues(kb.getComplements(TermFactory.BOTTOM).iterator(), new Object[]{TermFactory.TOP});
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(TermFactory.not((ATermAppl)A)).iterator(), new Object[]{Collections.singleton(TermFactory.BOTTOM), Collections.singleton(A), Collections.singleton(B)});
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(TermFactory.not((ATermAppl)B)).iterator(), new Object[]{Collections.singleton(TermFactory.BOTTOM), Collections.singleton(B)});
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(TermFactory.not((ATermAppl)C)).iterator(), new Object[]{Collections.singleton(TermFactory.BOTTOM), Collections.singleton(C), Collections.singleton(D)});
        PelletTestCase.assertIteratorValues(kb.getDisjointClasses(TermFactory.not((ATermAppl)D)).iterator(), new Object[]{Collections.singleton(TermFactory.BOTTOM), Collections.singleton(D)});
        PelletTestCase.assertIteratorValues(kb.getComplements(TermFactory.not((ATermAppl)A)).iterator(), new Object[]{A});
        PelletTestCase.assertIteratorValues(kb.getComplements(TermFactory.not((ATermAppl)B)).iterator(), new Object[]{B});
        PelletTestCase.assertIteratorValues(kb.getComplements(TermFactory.not((ATermAppl)C)).iterator(), new Object[]{C});
        PelletTestCase.assertIteratorValues(kb.getComplements(TermFactory.not((ATermAppl)D)).iterator(), new Object[]{D});
    }

    @Test
    public void testRemovePruned() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addObjectProperty((ATerm)p);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addEquivalentClass(A, TermFactory.value((ATermAppl)a));
        kb.addSubClass(A, TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)TermFactory.not((ATermAppl)B)));
        kb.addSubClass(B, TermFactory.or((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)A), (ATermAppl)C));
        kb.addType(b, B);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isType(b, C));
        Assert.assertFalse((boolean)kb.isType(a, C));
    }
}

