/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATermAppl;
import java.net.URI;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.owlapi.ConceptConverter;
import org.mindswap.pellet.owlapi.PelletVisitor;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.vocab.XSDVocabulary;

public class OWLAPIObjectConversionTests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";
    private static String ns = "urn:test:";
    private static OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    private static OWLDataFactory factory = manager.getOWLDataFactory();
    private static OWLClass c1 = factory.getOWLClass(URI.create(ns + "c1"));
    private static OWLClass c2 = factory.getOWLClass(URI.create(ns + "c2"));
    private static OWLObjectProperty op1 = factory.getOWLObjectProperty(URI.create(ns + "op1"));
    private static OWLDataProperty dp1 = factory.getOWLDataProperty(URI.create(ns + "dp1"));
    private static OWLIndividual ind1 = factory.getOWLIndividual(URI.create(ns + "ind1"));
    private static OWLIndividual ind2 = factory.getOWLIndividual(URI.create(ns + "ind2"));
    private static OWLIndividual ind3 = factory.getOWLAnonymousIndividual(URI.create(ns + "ind3"));
    private static OWLConstant uc1 = factory.getOWLUntypedConstant("lit1");
    private static OWLConstant uc2 = factory.getOWLUntypedConstant("lit2", "en");
    private static OWLConstant tc1 = factory.getOWLTypedConstant("lit3", factory.getOWLDataType(XSDVocabulary.STRING.getURI()));
    private static OWLConstant tc2 = factory.getOWLTypedConstant("1", factory.getOWLDataType(XSDVocabulary.INT.getURI()));
    private static OWLDataType d1 = factory.getOWLDataType(URI.create(ns + "d1"));
    private KnowledgeBase kb = new KnowledgeBase();
    private PelletVisitor atermConverter = new PelletVisitor(this.kb);
    private ConceptConverter owlapiConverter = new ConceptConverter(this.kb, factory);

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(OWLAPIObjectConversionTests.class);
    }

    private void testConversion(OWLObject object) {
        try {
            OWLObjectProperty p;
            this.kb.clear();
            this.atermConverter.clear();
            this.atermConverter.setAddAxiom(true);
            object.accept((OWLObjectVisitor)this.atermConverter);
            ATermAppl aterm = this.atermConverter.result();
            OWLSubClassAxiom axiom = null;
            if (object instanceof OWLDescription) {
                OWLDescription c = (OWLDescription)object;
                axiom = factory.getOWLSubClassAxiom(c, c);
            } else if (object instanceof OWLObjectProperty) {
                p = (OWLObjectProperty)object;
                axiom = factory.getOWLSubObjectPropertyAxiom((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)p);
            } else if (object instanceof OWLDataProperty) {
                p = (OWLDataProperty)object;
                axiom = factory.getOWLSubDataPropertyAxiom((OWLDataPropertyExpression)p, (OWLDataPropertyExpression)p);
            } else if (object instanceof OWLIndividual) {
                OWLIndividual ind = (OWLIndividual)object;
                axiom = factory.getOWLClassAssertionAxiom(ind, (OWLDescription)factory.getOWLThing());
            }
            if (axiom != null) {
                axiom.accept((OWLObjectVisitor)this.atermConverter);
            }
            OWLObject converted = this.owlapiConverter.convert(aterm);
            Assert.assertTrue((boolean)object.equals(converted));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Explanation failed");
        }
    }

    @Test
    public void testClass() {
        this.testConversion((OWLObject)c1);
    }

    @Test
    public void testIntersectionOf() {
        this.testConversion((OWLObject)factory.getOWLObjectIntersectionOf(SetUtils.create((Object[])new OWLClass[]{c1, c2})));
    }

    @Test
    public void testUnionOf() {
        this.testConversion((OWLObject)factory.getOWLObjectUnionOf(SetUtils.create((Object[])new OWLClass[]{c1, c2})));
    }

    @Test
    public void testComplementOf() {
        this.testConversion((OWLObject)factory.getOWLObjectComplementOf((OWLDescription)c1));
    }

    @Test
    public void testObjectSomeRestriction() {
        this.testConversion((OWLObject)factory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)op1, (OWLDescription)c1));
        this.testConversion((OWLObject)factory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)factory.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)op1), (OWLDescription)c1));
    }

    @Test
    public void testObjectAllRestriction() {
        this.testConversion((OWLObject)factory.getOWLObjectAllRestriction((OWLObjectPropertyExpression)op1, (OWLDescription)c1));
        this.testConversion((OWLObject)factory.getOWLObjectAllRestriction((OWLObjectPropertyExpression)factory.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)op1), (OWLDescription)c1));
    }

    public void testObjectValueRestriction() {
        this.testConversion((OWLObject)factory.getOWLObjectValueRestriction((OWLObjectPropertyExpression)op1, ind1));
        this.testConversion((OWLObject)factory.getOWLObjectValueRestriction((OWLObjectPropertyExpression)factory.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)op1), ind1));
    }

    @Test
    public void testObjectMinCardinalityRestriction() {
        this.testConversion((OWLObject)factory.getOWLObjectMinCardinalityRestriction((OWLObjectPropertyExpression)op1, 1));
        this.testConversion((OWLObject)factory.getOWLObjectMinCardinalityRestriction((OWLObjectPropertyExpression)op1, 1, (OWLDescription)c1));
        this.testConversion((OWLObject)factory.getOWLObjectMinCardinalityRestriction((OWLObjectPropertyExpression)factory.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)op1), 1, (OWLDescription)c1));
    }

    @Test
    public void testObjectExactCardinalityRestriction() {
        this.testConversion((OWLObject)factory.getOWLObjectExactCardinalityRestriction((OWLObjectPropertyExpression)op1, 1));
        this.testConversion((OWLObject)factory.getOWLObjectExactCardinalityRestriction((OWLObjectPropertyExpression)op1, 1, (OWLDescription)c1));
        this.testConversion((OWLObject)factory.getOWLObjectExactCardinalityRestriction((OWLObjectPropertyExpression)factory.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)op1), 1, (OWLDescription)c1));
    }

    @Test
    public void testObjectMaxCardinalityRestriction() {
        this.testConversion((OWLObject)factory.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)op1, 1));
        this.testConversion((OWLObject)factory.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)op1, 1, (OWLDescription)c1));
        this.testConversion((OWLObject)factory.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)factory.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)op1), 1, (OWLDescription)c1));
    }

    @Test
    public void testSelfRestriction() {
        this.testConversion((OWLObject)factory.getOWLObjectSelfRestriction((OWLObjectPropertyExpression)op1));
        this.testConversion((OWLObject)factory.getOWLObjectSelfRestriction((OWLObjectPropertyExpression)factory.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)op1)));
    }

    @Test
    public void testObjectOneOf() {
        this.testConversion((OWLObject)factory.getOWLObjectOneOf(SetUtils.create((Object[])new OWLIndividual[]{ind1, ind2})));
    }

    @Test
    public void testDataSomeRestriction() {
        this.testConversion((OWLObject)factory.getOWLDataSomeRestriction((OWLDataPropertyExpression)dp1, (OWLDataRange)d1));
    }

    @Test
    public void testDataAllRestriction() {
        this.testConversion((OWLObject)factory.getOWLDataAllRestriction((OWLDataPropertyExpression)dp1, (OWLDataRange)d1));
    }

    @Test
    public void testDataValueRestriction() {
        this.testConversion((OWLObject)factory.getOWLDataValueRestriction((OWLDataPropertyExpression)dp1, uc1));
        this.testConversion((OWLObject)factory.getOWLDataValueRestriction((OWLDataPropertyExpression)dp1, uc2));
        this.testConversion((OWLObject)factory.getOWLDataValueRestriction((OWLDataPropertyExpression)dp1, tc1));
        this.testConversion((OWLObject)factory.getOWLDataValueRestriction((OWLDataPropertyExpression)dp1, tc2));
    }

    @Test
    public void testDataMinCardinalityRestriction() {
        this.testConversion((OWLObject)factory.getOWLDataMinCardinalityRestriction((OWLDataPropertyExpression)dp1, 1, (OWLDataRange)d1));
    }

    @Test
    public void testDataExactCardinalityRestriction() {
        this.testConversion((OWLObject)factory.getOWLDataExactCardinalityRestriction((OWLDataPropertyExpression)dp1, 1, (OWLDataRange)d1));
    }

    @Test
    public void testDataMaxCardinalityRestriction() {
        this.testConversion((OWLObject)factory.getOWLDataMaxCardinalityRestriction((OWLDataPropertyExpression)dp1, 1, (OWLDataRange)d1));
    }

    @Test
    public void testDataType() {
        this.testConversion((OWLObject)d1);
    }

    @Ignore
    @Test
    public void testDataComplementOf() {
        this.testConversion((OWLObject)factory.getOWLDataComplementOf((OWLDataRange)d1));
    }

    @Test
    public void testDataOneOf() {
        this.testConversion((OWLObject)factory.getOWLDataOneOf(SetUtils.create((Object[])new OWLConstant[]{uc1, uc2, tc1, tc2})));
    }

    @Ignore
    @Test
    public void testDataRangeRestriction() {
    }

    @Test
    public void testTypedConstant() {
        this.testConversion((OWLObject)tc1);
        this.testConversion((OWLObject)tc2);
    }

    @Test
    public void testUntypedConstant() {
        this.testConversion((OWLObject)uc1);
        this.testConversion((OWLObject)uc2);
    }

    @Test
    public void testObjectProperty() {
        this.testConversion((OWLObject)op1);
    }

    @Test
    public void testObjectPropertyInverse() {
        this.testConversion((OWLObject)factory.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)op1));
    }

    @Test
    public void testDataProperty() {
        this.testConversion((OWLObject)dp1);
    }

    @Test
    public void testIndividual() {
        this.testConversion((OWLObject)ind1);
    }

    @Test
    public void testAnonymousIndividual() {
        this.testConversion((OWLObject)ind3);
    }
}

