/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.test.WebOntTest;
import org.mindswap.pellet.test.WebOntTestCase;
import org.mindswap.pellet.utils.AlphaNumericComparator;
import org.mindswap.pellet.utils.Comparators;

public class SWRLTestSuite
extends TestSuite {
    public static String base = PelletTestSuite.base + "swrl-test/";
    private static List<File> IGNORE = Arrays.asList(new Object[0]);

    public static void main(String[] args) {
        TestRunner.run((Test)SWRLTestSuite.suite());
    }

    public static TestSuite suite() {
        return new SWRLTestSuite();
    }

    public SWRLTestSuite() {
        super(SWRLTestSuite.class.getName());
        WebOntTest test = new WebOntTest();
        test.setAvoidFailTests(true);
        test.setBase("http://owldl.com/ontologies/swrl/tests/", "file:" + base);
        test.setShowStats(0);
        File testDir = new File(base);
        File[] dirs = testDir.listFiles();
        Arrays.sort(dirs, Comparators.stringComparator);
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i].isFile()) continue;
            File[] files = dirs[i].listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().indexOf("Manifest") != -1;
                }
            });
            Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
            for (int j = 0; j < files.length; ++j) {
                if (IGNORE.contains(files[j])) continue;
                this.addTest((Test)new WebOntTestCase(test, files[j], "swrl-" + dirs[i].getName() + "-" + files[j].getName()));
            }
        }
    }
}

