/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.impl.model;

import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.impl.model.ListFactory;
import org.semanticweb.owl.impl.model.OWLDataFactoryImpl;
import org.semanticweb.owl.impl.model.OWLImplHelper;
import org.semanticweb.owl.impl.model.OWLPropertyImpl;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;

public class OWLObjectPropertyImpl
extends OWLPropertyImpl
implements OWLObjectProperty {
    private Map inverses;
    private Set symmetric;
    private Set inverseFunctional;
    private Set oneToOne;
    private Set transitive;

    public OWLObjectPropertyImpl(OWLDataFactoryImpl factory, URI uri) {
        super(factory);
        this.uri = uri;
        this.inverses = ListFactory.getMap();
        this.symmetric = ListFactory.getSet();
        this.inverseFunctional = ListFactory.getSet();
        this.oneToOne = ListFactory.getSet();
        this.transitive = ListFactory.getSet();
    }

    boolean addRange(OWLOntology ontology, OWLDescription description) {
        return OWLImplHelper.getAppropriateSet(this.ranges, ontology).add(description);
    }

    boolean removeRange(OWLOntology ontology, OWLDescription description) {
        return OWLImplHelper.getAppropriateSet(this.ranges, ontology).remove(description);
    }

    public Set getInverses() {
        return OWLImplHelper.unionValues(this.inverses);
    }

    public Set getInverses(Set ontos) {
        return OWLImplHelper.selectValues(this.inverses, ontos);
    }

    public Set getInverses(OWLOntology o) {
        return OWLImplHelper.getAppropriateSet(this.inverses, o);
    }

    boolean addInverse(OWLOntology ontology, OWLObjectProperty prop) {
        OWLImplHelper.getAppropriateSet(this.inverses, ontology).add(prop);
        OWLObjectPropertyImpl propImpl = (OWLObjectPropertyImpl)prop;
        if (!propImpl.getInverses().contains(this)) {
            propImpl.addInverse(ontology, this);
        }
        return true;
    }

    boolean removeInverse(OWLOntology ontology, OWLObjectProperty prop) {
        OWLImplHelper.getAppropriateSet(this.inverses, ontology).remove(prop);
        OWLObjectPropertyImpl propImpl = (OWLObjectPropertyImpl)prop;
        if (propImpl.getInverses().contains(this)) {
            propImpl.removeInverse(ontology, this);
        }
        return true;
    }

    public boolean isSymmetric(OWLOntology o) {
        return this.symmetric.contains(o);
    }

    public boolean isSymmetric(Set ontos) {
        Iterator it = ontos.iterator();
        while (it.hasNext()) {
            if (!this.symmetric.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isSymmetric() {
        return !this.symmetric.isEmpty();
    }

    void setSymmetric(OWLOntology o, boolean b) {
        if (b) {
            this.symmetric.add(o);
        } else if (this.symmetric.contains(o)) {
            this.symmetric.remove(o);
        }
    }

    public boolean isInverseFunctional(OWLOntology o) {
        return this.inverseFunctional.contains(o);
    }

    public boolean isInverseFunctional(Set ontos) {
        Iterator it = ontos.iterator();
        while (it.hasNext()) {
            if (!this.inverseFunctional.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isInverseFunctional() {
        return !this.inverseFunctional.isEmpty();
    }

    void setInverseFunctional(OWLOntology o, boolean b) {
        if (b) {
            this.inverseFunctional.add(o);
        } else if (this.inverseFunctional.contains(o)) {
            this.inverseFunctional.remove(o);
        }
    }

    public boolean isOneToOne(OWLOntology o) {
        return this.oneToOne.contains(o);
    }

    public boolean isOneToOne(Set ontos) {
        Iterator it = ontos.iterator();
        while (it.hasNext()) {
            if (!this.oneToOne.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isOneToOne() {
        return !this.oneToOne.isEmpty();
    }

    void setOneToOne(OWLOntology o, boolean b) {
        if (b) {
            this.oneToOne.add(o);
        } else if (this.oneToOne.contains(o)) {
            this.oneToOne.remove(o);
        }
    }

    public boolean isTransitive(OWLOntology o) {
        return this.transitive.contains(o);
    }

    public boolean isTransitive(Set ontos) {
        Iterator it = ontos.iterator();
        while (it.hasNext()) {
            if (!this.transitive.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isTransitive() {
        return !this.transitive.isEmpty();
    }

    void setTransitive(OWLOntology o, boolean b) {
        if (b) {
            this.transitive.add(o);
        } else if (this.transitive.contains(o)) {
            this.transitive.remove(o);
        }
    }

    public void accept(OWLObjectVisitor visitor) throws OWLException {
        visitor.visit((OWLObjectProperty)this);
    }

    public void accept(OWLEntityVisitor visitor) throws OWLException {
        visitor.visit((OWLObjectProperty)this);
    }
}

