/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.FileUtils;

public abstract class KBLoader {
    public static final Logger log = Logger.getLogger(KBLoader.class.getName());
    protected String inputFormat;

    public abstract void clear();

    public KnowledgeBase createKB(String ... fileNameRegexList) {
        this.clear();
        this.parse(fileNameRegexList);
        this.load();
        return this.getKB();
    }

    public abstract KnowledgeBase getKB();

    public abstract void load();

    public void parse(String ... fileNameRegexList) {
        Collection<String> files = FileUtils.getFileURIs(fileNameRegexList);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Parsing (" + files.size() + ") files");
        }
        for (String fileNameRegex : files) {
            this.parseFile(fileNameRegex);
        }
        if (log.isLoggable(Level.INFO)) {
            log.fine("Parsing done.");
        }
    }

    protected abstract void parseFile(String var1);

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

