/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.branch;

import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class Branch {
    public static final Logger log = Logger.getLogger(ABox.class.getName());
    protected ABox abox;
    protected CompletionStrategy strategy;
    protected int branch;
    protected int tryCount;
    protected int tryNext;
    private DependencySet termDepends;
    private DependencySet prevDS;
    protected int anonCount;
    protected int nodeCount;

    Branch(ABox abox, CompletionStrategy strategy, DependencySet ds, int n) {
        this.abox = abox;
        this.setStrategy(strategy);
        this.setTermDepends(ds);
        this.setTryCount(n);
        this.prevDS = DependencySet.EMPTY;
        this.setTryNext(0);
        this.setBranch(abox.getBranch());
        this.setAnonCount(abox.getAnonCount());
        this.setNodeCount(abox.size());
        ATermUtils.assertTrue(this.getTryCount() > 0);
    }

    public void setLastClash(DependencySet ds) {
        if (this.getTryNext() >= 0) {
            this.prevDS = this.prevDS.union(ds, this.abox.doExplanation());
            if (PelletOptions.USE_INCREMENTAL_DELETION) {
                this.abox.getKB().getDependencyIndex().addCloseBranchDependency(this, ds);
            }
        }
    }

    public DependencySet getCombinedClash() {
        return this.prevDS;
    }

    public void setStrategy(CompletionStrategy strategy) {
        this.strategy = strategy;
    }

    public boolean tryNext() {
        if (this.getTryNext() == this.getTryCount()) {
            this.abox.getClash().setDepends(this.getCombinedClash());
        }
        if (!this.abox.isClosed()) {
            this.tryBranch();
        }
        if (this.abox.isClosed() && !PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getClash().getDepends().remove(this.getBranch());
        }
        return !this.abox.isClosed();
    }

    public abstract Branch copyTo(ABox var1);

    protected abstract void tryBranch();

    public abstract Node getNode();

    public String toString() {
        return "Branch on node " + this.getNode() + "  Branch number: " + this.getBranch() + " " + this.getTryNext() + "(" + this.getTryCount() + ")";
    }

    public abstract void shiftTryNext(int var1);

    public void setNodeCount(int nodeCount) {
        this.nodeCount = nodeCount;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void setBranch(int branch) {
        this.branch = branch;
    }

    public int getBranch() {
        return this.branch;
    }

    public int getAnonCount() {
        return this.anonCount;
    }

    public void setTryNext(int tryNext) {
        this.tryNext = tryNext;
    }

    public int getTryNext() {
        return this.tryNext;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTermDepends(DependencySet termDepends) {
        this.termDepends = termDepends;
    }

    public DependencySet getTermDepends() {
        return this.termDepends;
    }

    public void setAnonCount(int anonCount) {
        this.anonCount = anonCount;
    }
}

