/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.exceptions.TimeoutException;

public class Timer {
    private static final Logger log = Logger.getLogger(Timer.class.getCanonicalName());
    public static final long NOT_STARTED = -1L;
    public static final long NO_TIMEOUT = 0L;
    private String name;
    private long totalTime;
    private long startTime;
    private long count;
    private long startCount;
    private long timeout;
    private long lastTime;
    private Timer parent;

    public Timer(String name) {
        this(name, null);
    }

    public Timer(String name, Timer parent) {
        this.name = name;
        this.parent = parent;
        this.timeout = 0L;
        this.reset();
    }

    public void add(Timer timer) {
        this.totalTime += timer.totalTime;
        this.count += timer.count;
    }

    public void start() {
        if (this.startCount == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        ++this.startCount;
    }

    public long stop() {
        if (!this.isStarted()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("Ignoring attempt to stop a timer (\"%s\") that is not running. Timer results are incorrect for multi-threaded code.", this.name));
            }
            return -9223372036854775807L;
        }
        --this.startCount;
        if (!this.isStarted()) {
            this.lastTime = System.currentTimeMillis() - this.startTime;
            this.totalTime += this.lastTime;
            this.startTime = -1L;
            ++this.count;
            return this.lastTime;
        }
        return -1L;
    }

    public void reset() {
        this.totalTime = 0L;
        this.startTime = -1L;
        this.startCount = 0L;
        this.count = 0L;
    }

    public void restart() {
        if (this.isStarted()) {
            this.stop();
        }
        this.start();
    }

    public void check() throws TimeoutException {
        long elapsed = this.getElapsed();
        if (this.timeout != 0L && elapsed > this.timeout) {
            throw new TimeoutException("Running time of " + this.name + " exceeded timeout of " + this.timeout);
        }
        if (this.parent != null) {
            this.parent.check();
        }
    }

    public boolean isStarted() {
        return this.startCount > 0L;
    }

    public String getName() {
        return this.name;
    }

    public long getElapsed() {
        return this.isStarted() ? System.currentTimeMillis() - this.startTime : 0L;
    }

    public long getTotal() {
        return this.totalTime;
    }

    public long getCount() {
        return this.count;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public double getAverage() {
        return (double)this.totalTime / (double)this.count;
    }

    public long getLast() {
        return this.lastTime;
    }

    public void setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Cannot set the timeout to a negative value!");
        }
        this.timeout = timeout;
    }

    public String toString() {
        if (this.startCount > 0L) {
            return "Timer " + this.name + " Avg: " + this.getAverage() + " Count: " + this.count + " Total: " + this.getTotal() + " Still running: " + this.startCount;
        }
        return "Timer " + this.name + " Avg: " + this.getAverage() + " Count: " + this.count + " Total: " + this.getTotal();
    }

    public Timer getParent() {
        return this.parent;
    }
}

