/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLClassAxiomVisitor;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOr;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.OWLPropertyAxiomVisitor;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.helper.OWLClassAxiomVisitorAdapter;
import org.semanticweb.owl.model.helper.OWLObjectVisitorAdapter;
import org.semanticweb.owl.model.helper.OWLPropertyAxiomVisitorAdapter;
import org.semanticweb.owl.util.OWLManager;
import org.semanticweb.owl.validation.OWLValidationConstants;

public class ConstructChecker
implements org.semanticweb.owl.validation.ConstructChecker,
OWLValidationConstants {
    static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$owl$validation$SpeciesValidator == null ? (class$uk$ac$man$cs$img$owl$validation$SpeciesValidator = ConstructChecker.class$("uk.ac.man.cs.img.owl.validation.SpeciesValidator")) : class$uk$ac$man$cs$img$owl$validation$SpeciesValidator));
    protected Set constructs = new HashSet();
    ClassAxiomVisitor cav;
    PropertyAxiomVisitor pav;
    OWLObjectVisitor oov = new OWLObjectVisitor(this);
    static /* synthetic */ Class class$uk$ac$man$cs$img$owl$validation$SpeciesValidator;

    public ConstructChecker() {
        this.cav = new ClassAxiomVisitor(this, this.oov);
        this.pav = new PropertyAxiomVisitor(this);
    }

    public void reset() {
        this.constructs = new HashSet();
    }

    public Set constructsUsed(OWLOntology ontology) throws OWLException {
        OWLClassAxiom axiom;
        OWLObjectProperty prop;
        OWLDescription description;
        Iterator dit;
        Iterator it = ontology.getClasses().iterator();
        while (it.hasNext()) {
            OWLClass clazz = (OWLClass)it.next();
            if (!clazz.getSuperClasses(ontology).isEmpty()) {
                this.constructs.add(new Integer(1013));
                dit = clazz.getSuperClasses(ontology).iterator();
                while (dit.hasNext()) {
                    description = (OWLDescription)dit.next();
                    description.accept((org.semanticweb.owl.model.OWLObjectVisitor)this.oov);
                }
            }
            if (!clazz.getEquivalentClasses(ontology).isEmpty()) {
                this.constructs.add(new Integer(1014));
                dit = clazz.getEquivalentClasses(ontology).iterator();
                while (dit.hasNext()) {
                    description = (OWLDescription)dit.next();
                    description.accept((org.semanticweb.owl.model.OWLObjectVisitor)this.oov);
                }
            }
            if (clazz.getEnumerations(ontology).isEmpty()) continue;
            this.constructs.add(new Integer(1014));
            this.constructs.add(new Integer(1007));
        }
        if (!ontology.getDatatypes().isEmpty()) {
            this.constructs.add(new Integer(1008));
        }
        it = ontology.getObjectProperties().iterator();
        while (it.hasNext()) {
            prop = (OWLObjectProperty)it.next();
            if (!prop.getInverses(ontology).isEmpty()) {
                this.constructs.add(new Integer(1017));
            }
            if (prop.isFunctional(ontology)) {
                this.constructs.add(new Integer(1020));
            }
            if (prop.isTransitive(ontology)) {
                this.constructs.add(new Integer(1018));
            }
            if (prop.isSymmetric(ontology)) {
                this.constructs.add(new Integer(1019));
            }
            if (prop.isInverseFunctional(ontology)) {
                this.constructs.add(new Integer(1021));
            }
            dit = prop.getDomains(ontology).iterator();
            while (dit.hasNext()) {
                description = (OWLDescription)dit.next();
                description.accept((org.semanticweb.owl.model.OWLObjectVisitor)this.oov);
            }
            dit = prop.getRanges(ontology).iterator();
            while (dit.hasNext()) {
                description = (OWLDescription)dit.next();
                description.accept((org.semanticweb.owl.model.OWLObjectVisitor)this.oov);
            }
        }
        it = ontology.getDataProperties().iterator();
        while (it.hasNext()) {
            prop = (OWLDataProperty)it.next();
            if (prop.isFunctional(ontology)) {
                this.constructs.add(new Integer(1020));
            }
            dit = prop.getDomains(ontology).iterator();
            while (dit.hasNext()) {
                description = (OWLDescription)dit.next();
                description.accept((org.semanticweb.owl.model.OWLObjectVisitor)this.oov);
            }
            Iterator rit = prop.getRanges(ontology).iterator();
            while (rit.hasNext()) {
                OWLObject t = (OWLObject)rit.next();
                t.accept((org.semanticweb.owl.model.OWLObjectVisitor)this.oov);
            }
        }
        Iterator axit = ontology.getClassAxioms().iterator();
        while (axit.hasNext()) {
            axiom = (OWLClassAxiom)axit.next();
            axiom.accept((OWLClassAxiomVisitor)this.cav);
        }
        axit = ontology.getPropertyAxioms().iterator();
        while (axit.hasNext()) {
            axiom = (OWLPropertyAxiom)axit.next();
            axiom.accept((OWLPropertyAxiomVisitor)this.pav);
        }
        if (!ontology.getIndividuals().isEmpty()) {
            this.constructs.add(new Integer(1022));
        }
        Iterator indit = ontology.getIndividuals().iterator();
        while (indit.hasNext()) {
            OWLIndividual ind = (OWLIndividual)indit.next();
            if (!ind.getDataPropertyValues(ontology).isEmpty()) {
                // empty if block
            }
            dit = ind.getTypes(ontology).iterator();
            while (dit.hasNext()) {
                description = (OWLDescription)dit.next();
                description.accept((org.semanticweb.owl.model.OWLObjectVisitor)this.oov);
            }
            Map propertyValues = ind.getObjectPropertyValues(ontology);
            Iterator it2 = propertyValues.keySet().iterator();
            while (it2.hasNext()) {
                OWLObjectProperty prop2 = (OWLObjectProperty)it2.next();
                Set vals = (Set)propertyValues.get(prop2);
                if (vals.isEmpty()) continue;
                this.constructs.add(new Integer(1023));
            }
            Map dataValues = ind.getDataPropertyValues(ontology);
            Iterator it3 = dataValues.keySet().iterator();
            while (it3.hasNext()) {
                OWLDataProperty prop3 = (OWLDataProperty)it3.next();
                Set vals = (Set)dataValues.get(prop3);
                if (vals.isEmpty()) continue;
                this.constructs.add(new Integer(1024));
            }
        }
        return this.constructs;
    }

    public static List used(Set s) {
        ArrayList<String> used = new ArrayList<String>();
        Iterator it = s.iterator();
        while (it.hasNext()) {
            int i = (Integer)it.next();
            if (i == 1002) {
                used.add("Intersection");
            }
            if (i == 1003) {
                used.add("Union");
            }
            if (i == 1004) {
                used.add("Complement");
            }
            if (i == 1005) {
                used.add("ZeroOneCardinality");
            }
            if (i == 1006) {
                used.add("Cardinality");
            }
            if (i == 1007) {
                used.add("Oneof");
            }
            if (i == 1034) {
                used.add("Some");
            }
            if (i == 1035) {
                used.add("All");
            }
            if (i == 1008) {
                used.add("Datatype");
            }
            if (i == 1009) {
                used.add("DataRange");
            }
            if (i == 1010) {
                used.add("SubClass");
            }
            if (i == 1011) {
                used.add("Equivalence");
            }
            if (i == 1012) {
                used.add("Disjoint");
            }
            if (i == 1013) {
                used.add("Partial");
            }
            if (i == 1014) {
                used.add("Complete");
            }
            if (i == 1015) {
                used.add("Subproperty");
            }
            if (i == 1016) {
                used.add("Equivalentproperty");
            }
            if (i == 1017) {
                used.add("Inverse");
            }
            if (i == 1018) {
                used.add("Transitive");
            }
            if (i == 1019) {
                used.add("Symmetric");
            }
            if (i == 1020) {
                used.add("Functional");
            }
            if (i == 1021) {
                used.add("Inversefunctional");
            }
            if (i == 1022) {
                used.add("Individuals");
            }
            if (i == 1023) {
                used.add("Relatedindividuals");
            }
            if (i == 1024) {
                used.add("IndividualData");
            }
            if (i == 1025) {
                used.add("Sameindividual");
            }
            if (i != 1026) continue;
            used.add("Differentindividual");
        }
        return used;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.out.println("Usage: ConstructChecker url");
                System.exit(1);
            }
            BasicConfigurator.configure();
            URI uri = new URI(args[0]);
            OWLRDFParser parser = new OWLRDFParser();
            parser.setConnection(OWLManager.getOWLConnection());
            OWLOntology ontology = parser.parseOntology(uri);
            ConstructChecker cc = new ConstructChecker();
            Iterator it = ConstructChecker.used(cc.constructsUsed(ontology)).iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                System.out.print(s + " ");
            }
            System.out.println();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class OWLObjectVisitor
    extends OWLObjectVisitorAdapter {
        ConstructChecker parent;

        OWLObjectVisitor(ConstructChecker cc) {
            this.parent = cc;
        }

        public void visit(OWLOr node) throws OWLException {
            this.parent.constructs.add(new Integer(1003));
            Iterator dit = node.getOperands().iterator();
            while (dit.hasNext()) {
                OWLDescription description = (OWLDescription)dit.next();
                description.accept((org.semanticweb.owl.model.OWLObjectVisitor)this);
            }
        }

        public void visit(OWLAnd node) throws OWLException {
            this.parent.constructs.add(new Integer(1002));
            Iterator dit = node.getOperands().iterator();
            while (dit.hasNext()) {
                OWLDescription description = (OWLDescription)dit.next();
                description.accept((org.semanticweb.owl.model.OWLObjectVisitor)this);
            }
        }

        public void visit(OWLNot node) throws OWLException {
            this.parent.constructs.add(new Integer(1004));
            node.getOperand().accept((org.semanticweb.owl.model.OWLObjectVisitor)this);
        }

        public void visit(OWLEnumeration node) {
            this.parent.constructs.add(new Integer(1007));
        }

        public void visit(OWLObjectValueRestriction node) {
            this.parent.constructs.add(new Integer(1007));
            this.parent.constructs.add(new Integer(1034));
        }

        public void visit(OWLObjectSomeRestriction node) throws OWLException {
            this.parent.constructs.add(new Integer(1034));
            node.getDescription().accept((org.semanticweb.owl.model.OWLObjectVisitor)this);
        }

        public void visit(OWLObjectAllRestriction node) throws OWLException {
            this.parent.constructs.add(new Integer(1035));
            node.getDescription().accept((org.semanticweb.owl.model.OWLObjectVisitor)this);
        }

        public void visit(OWLObjectCardinalityRestriction node) throws OWLException {
            this.parent.constructs.add(new Integer(1006));
        }

        public void visit(OWLDataValueRestriction node) {
            this.parent.constructs.add(new Integer(1008));
        }

        public void visit(OWLDataSomeRestriction node) throws OWLException {
            this.parent.constructs.add(new Integer(1034));
            node.getDataType().accept((org.semanticweb.owl.model.OWLObjectVisitor)this);
        }

        public void visit(OWLDataAllRestriction node) throws OWLException {
            this.parent.constructs.add(new Integer(1035));
            node.getDataType().accept((org.semanticweb.owl.model.OWLObjectVisitor)this);
        }

        public void visit(OWLDataType node) {
            this.parent.constructs.add(new Integer(1008));
        }

        public void visit(OWLDataRange node) {
            this.parent.constructs.add(new Integer(1009));
        }

        public void visit(OWLDataCardinalityRestriction node) throws OWLException {
            this.parent.constructs.add(new Integer(1006));
        }
    }

    private class PropertyAxiomVisitor
    extends OWLPropertyAxiomVisitorAdapter {
        ConstructChecker parent;

        PropertyAxiomVisitor(ConstructChecker cc) {
            this.parent = cc;
        }
    }

    private class ClassAxiomVisitor
    extends OWLClassAxiomVisitorAdapter {
        ConstructChecker parent;
        OWLObjectVisitor oov;

        ClassAxiomVisitor(ConstructChecker cc, OWLObjectVisitor oov) {
            this.parent = cc;
            this.oov = oov;
        }

        public void visit(OWLEquivalentClassesAxiom axiom) throws OWLException {
            ConstructChecker.this.constructs.add(new Integer(1011));
            Iterator it = axiom.getEquivalentClasses().iterator();
            while (it.hasNext()) {
                OWLDescription desc = (OWLDescription)it.next();
                desc.accept((org.semanticweb.owl.model.OWLObjectVisitor)this.oov);
            }
        }

        public void visit(OWLDisjointClassesAxiom axiom) throws OWLException {
            ConstructChecker.this.constructs.add(new Integer(1012));
            Iterator it = axiom.getDisjointClasses().iterator();
            while (it.hasNext()) {
                OWLDescription desc = (OWLDescription)it.next();
                desc.accept((org.semanticweb.owl.model.OWLObjectVisitor)this.oov);
            }
        }

        public void visit(OWLSubClassAxiom axiom) throws OWLException {
            ConstructChecker.this.constructs.add(new Integer(1010));
            axiom.getSubClass().accept((org.semanticweb.owl.model.OWLObjectVisitor)this.oov);
            axiom.getSuperClass().accept((org.semanticweb.owl.model.OWLObjectVisitor)this.oov);
        }
    }
}

