/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owl.io.RendererException;
import org.semanticweb.owl.io.abstract_syntax.ObjectRenderer;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataEnumeration;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOr;
import org.semanticweb.owl.model.helper.OWLObjectVisitorAdapter;
import org.semanticweb.owl.validation.OWLValidationConstants;
import uk.ac.man.cs.img.owl.validation.ClassIdentifierVisitor;
import uk.ac.man.cs.img.owl.validation.ClassOrRestrictionIdentifier;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;

class ExpressionValidatorVisitor
extends OWLObjectVisitorAdapter
implements OWLValidationConstants {
    private int level = 0;
    private boolean topLevelDescription = false;
    private Set complexProperties;
    static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$owl$validation$ExpressionValidatorVisitor == null ? (class$uk$ac$man$cs$img$owl$validation$ExpressionValidatorVisitor = ExpressionValidatorVisitor.class$("uk.ac.man.cs.img.owl.validation.ExpressionValidatorVisitor")) : class$uk$ac$man$cs$img$owl$validation$ExpressionValidatorVisitor));
    private SpeciesValidator parent;
    private ObjectRenderer objectRenderer;
    static /* synthetic */ Class class$uk$ac$man$cs$img$owl$validation$ExpressionValidatorVisitor;

    public int getLevel() {
        return this.level;
    }

    public Set getComplexProperties() {
        return this.complexProperties;
    }

    public void setTopLevelDescription(boolean b) {
        this.topLevelDescription = b;
    }

    public ExpressionValidatorVisitor(SpeciesValidator parent, ObjectRenderer renderer) {
        this.parent = parent;
        this.objectRenderer = renderer;
        this.complexProperties = new HashSet();
    }

    public void reset() {
        this.level = 0;
        this.topLevelDescription = false;
    }

    public void visit(OWLOr node) {
        this.explain(1, 1003, "Or: " + this.renderNode((OWLObject)node));
        this.level |= 1;
    }

    public void visit(OWLNot node) {
        this.explain(1, 1004, "Not: " + this.renderNode((OWLObject)node));
        this.level |= 1;
    }

    public void visit(OWLEnumeration node) {
        this.explain(1, 1007, "Enumeration: " + this.renderNode((OWLObject)node));
        this.level |= 1;
    }

    public void visit(OWLDataEnumeration node) {
        this.explain(1, 1007, "Data Enumeration: " + this.renderNode((OWLObject)node));
        this.level |= 1;
    }

    public void visit(OWLObjectValueRestriction node) {
        this.explain(1, 1007, "Individual Value: " + this.renderNode((OWLObject)node));
        this.level |= 1;
    }

    public void visit(OWLObjectCardinalityRestriction node) throws OWLException {
        this.complexProperties.add(node.getProperty());
        if (node.isAtLeast() && node.getAtLeast() > 1 || node.isAtMost() && node.getAtMost() > 1) {
            this.explain(1, 1006, "Cardinality with > 1: " + this.renderNode((OWLObject)node));
            this.level |= 1;
        }
    }

    public void visit(OWLDataCardinalityRestriction node) throws OWLException {
        if (node.isAtLeast() && node.getAtLeast() > 1 || node.isAtMost() && node.getAtMost() > 1) {
            this.explain(1, 1006, "Cardinality with > 1: " + this.renderNode((OWLObject)node));
            this.level |= 1;
        }
    }

    public void visit(OWLDataValueRestriction node) {
        this.explain(1, 1007, "Data Value: " + this.renderNode((OWLObject)node));
        this.level |= 1;
    }

    public void visit(OWLAnd node) throws OWLException {
        if (this.topLevelDescription) {
            this.topLevelDescription = false;
            ClassOrRestrictionIdentifier cori = new ClassOrRestrictionIdentifier();
            Iterator it = node.getOperands().iterator();
            while (it.hasNext()) {
                OWLDescription description = (OWLDescription)it.next();
                cori.reset();
                description.accept((OWLObjectVisitor)cori);
                if (!cori.isClassOrRestriction()) {
                    this.explain(1, 1002, "And with non-class or restriction: " + this.renderNode((OWLObject)node));
                    this.level |= 1;
                    continue;
                }
                if (!cori.isRestriction()) continue;
                description.accept((OWLObjectVisitor)this);
            }
        } else {
            this.explain(1, 1002, "And: " + this.renderNode((OWLObject)node));
            this.level |= 1;
        }
    }

    public void visit(OWLObjectSomeRestriction node) throws OWLException {
        this.topLevelDescription = false;
        ClassIdentifierVisitor civ = new ClassIdentifierVisitor();
        node.getDescription().accept((OWLObjectVisitor)civ);
        if (!civ.isClass()) {
            this.explain(1, 1033, "Object restriction with non classID filler: " + this.renderNode((OWLObject)node));
            this.level |= 1;
        }
        node.getDescription().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLObjectAllRestriction node) throws OWLException {
        this.topLevelDescription = false;
        ClassIdentifierVisitor civ = new ClassIdentifierVisitor();
        node.getDescription().accept((OWLObjectVisitor)civ);
        if (!civ.isClass()) {
            this.explain(1, 1033, "Object restriction with non classID filler: " + this.renderNode((OWLObject)node));
            this.level |= 1;
        }
        node.getDescription().accept((OWLObjectVisitor)this);
    }

    private String renderNode(OWLObject node) {
        try {
            if (this.objectRenderer != null) {
                return this.objectRenderer.renderObject(node);
            }
        }
        catch (RendererException rendererException) {
            // empty catch block
        }
        return node.toString();
    }

    private void explain(int level, int code, String str) {
        if (this.parent != null) {
            this.parent.explain(level, code, str);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

