/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.io.Reader;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.semanticweb.owl.io.ParserException;
import org.semanticweb.owl.io.abstract_syntax.ObjectRenderer;
import org.semanticweb.owl.io.owl_rdf.OWLRDFErrorHandler;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.io.vocabulary.RDFVocabularyAdapter;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.helper.OntologyHelper;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;
import org.semanticweb.owl.validation.OWLValidationConstants;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import org.xml.sax.SAXException;
import uk.ac.man.cs.img.owl.validation.ExpressionValidatorVisitor;
import uk.ac.man.cs.img.owl.validation.SpeciesValidatorVisitor;

public class SpeciesValidator
implements org.semanticweb.owl.validation.SpeciesValidator,
OWLValidationConstants {
    static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$owl$validation$SpeciesValidator == null ? (class$uk$ac$man$cs$img$owl$validation$SpeciesValidator = SpeciesValidator.class$("uk.ac.man.cs.img.owl.validation.SpeciesValidator")) : class$uk$ac$man$cs$img$owl$validation$SpeciesValidator));
    static Logger resultLogger = Logger.getLogger((String)((class$uk$ac$man$cs$img$owl$validation$SpeciesValidator == null ? (class$uk$ac$man$cs$img$owl$validation$SpeciesValidator = SpeciesValidator.class$("uk.ac.man.cs.img.owl.validation.SpeciesValidator")) : class$uk$ac$man$cs$img$owl$validation$SpeciesValidator).getName() + "Results"));
    static Logger mainLogger = Logger.getLogger((String)((class$uk$ac$man$cs$img$owl$validation$SpeciesValidator == null ? (class$uk$ac$man$cs$img$owl$validation$SpeciesValidator = SpeciesValidator.class$("uk.ac.man.cs.img.owl.validation.SpeciesValidator")) : class$uk$ac$man$cs$img$owl$validation$SpeciesValidator).getName() + "Main"));
    private SpeciesValidatorReporter reporter;
    private Map options;
    protected static final int OTHER = 7;
    private OWLConnection connection;
    private OWLOntology ontology;
    private Set allOntologies;
    private Set reservedVocabulary;
    private Set classOnlyVocabulary;
    private Set propertyOnlyVocabulary;
    private boolean namespacesSeparated;
    private boolean correctOWLUsage;
    private boolean correctOWLNamespaceUsage;
    private boolean individualsTyped;
    private int classAxiomLevel;
    private int propertyAxiomLevel;
    private int expressivityLevel;
    private int syntaxLevel;
    private Set allURIs;
    private Set classURIs;
    private Set individualURIs;
    private Set objectPropertyURIs;
    private Set dataPropertyURIs;
    private Set annotationPropertyURIs;
    private Set datatypeURIs;
    private ObjectRenderer objectRenderer;
    private OWLRDFParser parser;
    static /* synthetic */ Class class$uk$ac$man$cs$img$owl$validation$SpeciesValidator;

    public void setConnection(OWLConnection connection) {
        this.connection = connection;
    }

    public SpeciesValidator() throws OWLException {
        this.setReporter(new SpeciesValidatorReporter(){

            public void ontology(OWLOntology onto) {
            }

            public void done(String str) {
            }

            public void message(String str) {
                System.out.println(str);
            }

            public void explain(int l, int code, String str) {
                System.out.println(SpeciesValidator.level(l) + " [" + SpeciesValidator.readableCode(code) + "]:\t" + str);
            }
        });
        this.reservedVocabulary = OWLVocabularyAdapter.INSTANCE.getReservedVocabulary();
        this.classOnlyVocabulary = new HashSet();
        this.classOnlyVocabulary.add(OWLVocabularyAdapter.INSTANCE.getStatement());
        this.classOnlyVocabulary.add(OWLVocabularyAdapter.INSTANCE.getSeq());
        this.classOnlyVocabulary.add(OWLVocabularyAdapter.INSTANCE.getBag());
        this.classOnlyVocabulary.add(OWLVocabularyAdapter.INSTANCE.getAlt());
        this.propertyOnlyVocabulary = new HashSet();
        this.propertyOnlyVocabulary.add(RDFVocabularyAdapter.INSTANCE.getSubject());
        this.propertyOnlyVocabulary.add(RDFVocabularyAdapter.INSTANCE.getPredicate());
        this.propertyOnlyVocabulary.add(RDFVocabularyAdapter.INSTANCE.getObject());
        this.options = new HashMap();
        this.connection = OWLManager.getOWLConnection();
        this.parser = new OWLRDFParser();
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("ignoreAnnotationContent", new Boolean(true));
    }

    public void setReporter(SpeciesValidatorReporter reporter) {
        this.reporter = reporter;
    }

    protected void explain(int l, int code, String str) {
        if (this.reporter != null) {
            this.reporter.explain(l, code, str);
        }
    }

    protected void message(String str) {
        if (this.reporter != null) {
            this.reporter.message(str);
        }
    }

    protected static String level(int l) {
        if (l == 0) {
            return "OWL-Lite";
        }
        if (l == 1) {
            return "OWL-DL  ";
        }
        if (l == 3) {
            return "OWL-Full";
        }
        return "OTHER   ";
    }

    private int species(OWLOntology ontology, boolean checkImport) {
        int result = 0;
        try {
            this.ontology = ontology;
            logger.info((Object)("Validating: " + (checkImport ? "[imports] " : "") + ontology.getURI()));
            if (this.reporter != null) {
                this.reporter.ontology(ontology);
            }
            this.allOntologies = OntologyHelper.importClosure((OWLOntology)ontology);
            if (checkImport) {
                Iterator it = this.allOntologies.iterator();
                while (it.hasNext()) {
                    OWLOntology importee = (OWLOntology)it.next();
                    logger.info((Object)("  " + importee.getURI().toString()));
                    SpeciesValidator sv = new SpeciesValidator();
                    sv.setReporter(this.reporter);
                    int importeeLevel = sv.species(importee, false);
                    logger.info((Object)("Import: " + SpeciesValidator.level(importeeLevel)));
                    result |= importeeLevel;
                }
            } else {
                this.gatherURIs();
                Iterator it = this.classURIs.iterator();
                while (it.hasNext()) {
                    logger.debug((Object)("C: " + it.next()));
                }
                it = this.individualURIs.iterator();
                while (it.hasNext()) {
                    logger.debug((Object)("I: " + it.next()));
                }
                this.namespacesSeparated = true;
                this.correctOWLUsage = true;
                this.correctOWLNamespaceUsage = true;
                this.individualsTyped = true;
                this.classAxiomLevel = 3;
                this.propertyAxiomLevel = 3;
                this.expressivityLevel = 3;
                this.objectRenderer = new ObjectRenderer(ontology);
                this.checkNamespaceSeparation();
                this.checkCorrectOWLUsage();
                this.checkCorrectOWLNamespaceUsage();
                this.checkClassAxioms();
                this.checkPropertyAxioms();
                this.checkExpressivity();
                result = !this.correctOWLNamespaceUsage ? 3 : (!this.namespacesSeparated || !this.correctOWLUsage || !this.individualsTyped ? 3 : this.classAxiomLevel | this.propertyAxiomLevel | this.expressivityLevel);
                if (this.reporter != null) {
                    this.reporter.done(SpeciesValidator.level(result));
                }
            }
        }
        catch (OWLException e) {
            result = 3;
            this.reporter.explain(3, 1001, "Exception occurred: " + e.getMessage());
        }
        logger.info((Object)("Result: " + SpeciesValidator.level(result)));
        return result;
    }

    public void setOptions(Map opts) {
        this.options.putAll(opts);
    }

    public Map getOptions() {
        return this.options;
    }

    private void setSyntaxLevel(int l) {
        this.syntaxLevel = l;
    }

    private OWLOntology parseFromURI(OWLRDFErrorHandler handler, URI uri) throws ParserException, OWLException {
        this.parser.setOptions(this.options);
        this.parser.setConnection(this.connection);
        this.parser.setOWLRDFErrorHandler(handler);
        OWLOntology onto = this.parser.parseOntology(uri);
        return onto;
    }

    private OWLOntology parseFromURI(OWLRDFErrorHandler handler, Reader r, URI uri) throws ParserException, OWLException {
        this.parser.setOptions(this.options);
        this.parser.setConnection(this.connection);
        this.parser.setOWLRDFErrorHandler(handler);
        OWLOntology onto = this.parser.parseOntology(r, uri);
        return onto;
    }

    public boolean isOWLLite(URI uri) {
        boolean result = false;
        try {
            this.syntaxLevel = 0;
            OWLRDFErrorHandler handler = new OWLRDFErrorHandler(){

                public void owlFullConstruct(int code, String message) throws SAXException {
                    SpeciesValidator.this.setSyntaxLevel(3);
                    SpeciesValidator.this.explain(3, code, message);
                }

                public void owlFullConstruct(int code, String message, Object obj) throws SAXException {
                    this.owlFullConstruct(code, message);
                }

                public void error(String message) throws SAXException {
                    throw new SAXException(message.toString());
                }

                public void warning(String message) throws SAXException {
                    SpeciesValidator.this.message(message.toString());
                }
            };
            OWLOntology o = this.parseFromURI(handler, uri);
            int species = this.species(o, true) | this.syntaxLevel;
            result = species == 0;
            this.releaseOntology(o);
        }
        catch (ParserException ex) {
            int code = 1001;
            if (ex.getCode() != 0) {
                code = ex.getCode();
            }
            this.explain(7, code, ex.getMessage());
        }
        catch (OWLException ex) {
            this.explain(7, 1001, ex.getMessage());
        }
        resultLogger.info((Object)(uri + " <" + (result ? "" : "Not ") + "Lite>"));
        return result;
    }

    public boolean isOWLDL(URI uri) {
        boolean result = false;
        try {
            this.syntaxLevel = 0;
            OWLRDFErrorHandler handler = new OWLRDFErrorHandler(){

                public void owlFullConstruct(int code, String message) throws SAXException {
                    SpeciesValidator.this.setSyntaxLevel(3);
                    SpeciesValidator.this.explain(3, code, message);
                }

                public void owlFullConstruct(int code, String message, Object obj) throws SAXException {
                    this.owlFullConstruct(code, message);
                }

                public void error(String message) throws SAXException {
                    throw new SAXException(message.toString());
                }

                public void warning(String message) throws SAXException {
                    SpeciesValidator.this.message(message.toString());
                }
            };
            OWLOntology o = this.parseFromURI(handler, uri);
            int species = this.species(o, true) | this.syntaxLevel;
            result = species == 1 || species == 0;
            this.releaseOntology(o);
        }
        catch (ParserException ex) {
            int code = 1001;
            if (ex.getCode() != 0) {
                code = ex.getCode();
            }
            this.explain(7, code, ex.getMessage());
        }
        catch (OWLException ex) {
            this.explain(7, 1001, ex.getMessage());
        }
        resultLogger.info((Object)(uri + " <" + (result ? "" : "Not ") + "DL>"));
        return result;
    }

    public boolean isOWLFull(URI uri) {
        boolean result = false;
        try {
            this.syntaxLevel = 0;
            OWLRDFErrorHandler handler = new OWLRDFErrorHandler(){

                public void owlFullConstruct(int code, String message) throws SAXException {
                    SpeciesValidator.this.setSyntaxLevel(3);
                    SpeciesValidator.this.explain(3, code, message);
                }

                public void owlFullConstruct(int code, String message, Object obj) throws SAXException {
                    this.owlFullConstruct(code, message);
                }

                public void error(String message) throws SAXException {
                    throw new SAXException(message);
                }

                public void warning(String message) throws SAXException {
                    SpeciesValidator.this.message(message.toString());
                }
            };
            OWLOntology o = this.parseFromURI(handler, uri);
            int species = this.species(o, true) | this.syntaxLevel;
            result = species == 1 || species == 0 || species == 3;
            this.releaseOntology(o);
        }
        catch (ParserException ex) {
            int code = 1001;
            if (ex.getCode() != 0) {
                code = ex.getCode();
            }
            this.explain(7, code, ex.getMessage());
        }
        catch (OWLException ex) {
            this.explain(7, 1001, ex.getMessage());
        }
        resultLogger.info((Object)(uri + " <" + (result ? "" : "Not ") + "Full>"));
        return result;
    }

    public boolean isOWLLite(Reader r, URI uri) {
        boolean result = false;
        try {
            this.syntaxLevel = 0;
            OWLRDFErrorHandler handler = new OWLRDFErrorHandler(){

                public void owlFullConstruct(int code, String message) throws SAXException {
                    SpeciesValidator.this.setSyntaxLevel(3);
                    SpeciesValidator.this.explain(3, code, message);
                }

                public void owlFullConstruct(int code, String message, Object obj) throws SAXException {
                    this.owlFullConstruct(code, message);
                }

                public void error(String message) throws SAXException {
                    throw new SAXException(message.toString());
                }

                public void warning(String message) throws SAXException {
                    SpeciesValidator.this.message(message.toString());
                }
            };
            OWLOntology o = this.parseFromURI(handler, r, uri);
            int species = this.species(o, true) | this.syntaxLevel;
            result = species == 0;
            this.releaseOntology(o);
        }
        catch (ParserException ex) {
            int code = 1001;
            if (ex.getCode() != 0) {
                code = ex.getCode();
            }
            this.explain(7, code, ex.getMessage());
        }
        catch (OWLException ex) {
            this.explain(7, 1001, ex.getMessage());
        }
        resultLogger.info((Object)(uri + " <" + (result ? "" : "Not ") + "Lite>"));
        return result;
    }

    public boolean isOWLDL(Reader r, URI uri) {
        boolean result = false;
        try {
            this.syntaxLevel = 0;
            OWLRDFErrorHandler handler = new OWLRDFErrorHandler(){

                public void owlFullConstruct(int code, String message) throws SAXException {
                    SpeciesValidator.this.setSyntaxLevel(3);
                    SpeciesValidator.this.explain(3, code, message);
                }

                public void owlFullConstruct(int code, String message, Object obj) throws SAXException {
                    this.owlFullConstruct(code, message);
                }

                public void error(String message) throws SAXException {
                    throw new SAXException(message.toString());
                }

                public void warning(String message) throws SAXException {
                    SpeciesValidator.this.message(message.toString());
                }
            };
            OWLOntology o = this.parseFromURI(handler, r, uri);
            int species = this.species(o, true) | this.syntaxLevel;
            result = species == 1 || species == 0;
            this.releaseOntology(o);
        }
        catch (ParserException ex) {
            int code = 1001;
            if (ex.getCode() != 0) {
                code = ex.getCode();
            }
            this.explain(7, code, ex.getMessage());
        }
        catch (OWLException ex) {
            this.explain(7, 1001, ex.getMessage());
        }
        resultLogger.info((Object)(uri + " <" + (result ? "" : "Not ") + "DL>"));
        return result;
    }

    public boolean isOWLFull(Reader r, URI uri) {
        boolean result = false;
        try {
            this.syntaxLevel = 0;
            OWLRDFErrorHandler handler = new OWLRDFErrorHandler(){

                public void owlFullConstruct(int code, String message) throws SAXException {
                    SpeciesValidator.this.setSyntaxLevel(3);
                    SpeciesValidator.this.explain(3, code, message);
                }

                public void owlFullConstruct(int code, String message, Object obj) throws SAXException {
                    this.owlFullConstruct(code, message);
                }

                public void error(String message) throws SAXException {
                    throw new SAXException(message);
                }

                public void warning(String message) throws SAXException {
                    SpeciesValidator.this.message(message.toString());
                }
            };
            OWLOntology o = this.parseFromURI(handler, r, uri);
            int species = this.species(o, true) | this.syntaxLevel;
            result = species == 1 || species == 0 || species == 3;
            this.releaseOntology(o);
        }
        catch (ParserException ex) {
            int code = 1001;
            if (ex.getCode() != 0) {
                code = ex.getCode();
            }
            this.explain(7, code, ex.getMessage());
        }
        catch (OWLException ex) {
            this.explain(7, 1001, ex.getMessage());
        }
        resultLogger.info((Object)(uri + " <" + (result ? "" : "Not ") + "Full>"));
        return result;
    }

    public boolean isOWLLite(OWLOntology ontology) throws OWLException {
        return this.species(ontology, true) == 0;
    }

    public boolean isOWLDL(OWLOntology ontology) throws OWLException {
        int species = this.species(ontology, true);
        return species == 0 || species == 1;
    }

    public boolean isOWLFull(OWLOntology ontology) throws OWLException {
        int species = this.species(ontology, true);
        return species == 0 || species == 1 || species == 3;
    }

    private void gatherURIs() throws OWLException {
        this.classURIs = new HashSet();
        this.individualURIs = new HashSet();
        this.objectPropertyURIs = new HashSet();
        this.dataPropertyURIs = new HashSet();
        this.annotationPropertyURIs = new HashSet();
        this.datatypeURIs = new HashSet();
        this.allURIs = new HashSet();
        Iterator it = this.allOntologies.iterator();
        while (it.hasNext()) {
            OWLNamedObject entity;
            OWLOntology onto = (OWLOntology)it.next();
            Iterator cit = onto.getClasses().iterator();
            while (cit.hasNext()) {
                entity = (OWLNamedObject)cit.next();
                this.classURIs.add(entity.getURI());
                this.allURIs.add(entity.getURI());
            }
            cit = onto.getIndividuals().iterator();
            while (cit.hasNext()) {
                entity = (OWLNamedObject)cit.next();
                this.individualURIs.add(entity.getURI());
                this.allURIs.add(entity.getURI());
            }
            cit = onto.getObjectProperties().iterator();
            while (cit.hasNext()) {
                entity = (OWLNamedObject)cit.next();
                this.objectPropertyURIs.add(entity.getURI());
                this.allURIs.add(entity.getURI());
            }
            cit = onto.getDataProperties().iterator();
            while (cit.hasNext()) {
                entity = (OWLNamedObject)cit.next();
                this.dataPropertyURIs.add(entity.getURI());
                this.allURIs.add(entity.getURI());
            }
            cit = onto.getAnnotationProperties().iterator();
            while (cit.hasNext()) {
                entity = (OWLNamedObject)cit.next();
                this.annotationPropertyURIs.add(entity.getURI());
                this.allURIs.add(entity.getURI());
            }
            cit = onto.getDatatypes().iterator();
            while (cit.hasNext()) {
                entity = (OWLDataType)cit.next();
                this.datatypeURIs.add(entity.getURI());
                this.allURIs.add(entity.getURI());
            }
        }
    }

    private void checkNamespaceSeparation() {
        Object u;
        Iterator it = this.classURIs.iterator();
        while (it.hasNext()) {
            u = it.next();
            if (this.individualURIs.contains(u)) {
                this.namespacesSeparated = false;
                logger.info((Object)(u + " Class+Individual"));
                this.explain(3, 1027, u + "\t used as Class and Individual");
                continue;
            }
            if (this.objectPropertyURIs.contains(u)) {
                this.namespacesSeparated = false;
                logger.info((Object)(u + " Class+ObjectProperty"));
                this.explain(3, 1027, u + "\t used as Class and ObjectProperty");
                continue;
            }
            if (this.dataPropertyURIs.contains(u)) {
                this.namespacesSeparated = false;
                logger.info((Object)(u + " Class+DataProperty"));
                this.explain(3, 1027, u + "\t used as Class and DataProperty");
                continue;
            }
            if (this.annotationPropertyURIs.contains(u)) {
                this.namespacesSeparated = false;
                logger.info((Object)(u + " Class+AnnotationProperty"));
                this.explain(3, 1027, u + "\t used as Class and AnnotationProperty");
                continue;
            }
            if (!this.datatypeURIs.contains(u)) continue;
            this.namespacesSeparated = false;
            logger.info((Object)(u + " Class+Datatype"));
            this.explain(3, 1027, u + "\t used as Class and Datatype");
        }
        it = this.individualURIs.iterator();
        while (it.hasNext()) {
            u = it.next();
            if (this.objectPropertyURIs.contains(u)) {
                this.namespacesSeparated = false;
                logger.info((Object)(u + " Individual+ObjectProperty"));
                this.explain(3, 1027, u + "\t used as Individual and Property");
                continue;
            }
            if (this.dataPropertyURIs.contains(u)) {
                this.namespacesSeparated = false;
                logger.info((Object)(u + " Individual+DataProperty"));
                this.explain(3, 1027, u + "\t used as Individual and DataProperty");
                continue;
            }
            if (this.annotationPropertyURIs.contains(u)) {
                this.namespacesSeparated = false;
                logger.info((Object)(u + " Individual+AnnotationProperty"));
                this.explain(3, 1027, u + "\t used as Individual and AnnotationProperty");
                continue;
            }
            if (!this.datatypeURIs.contains(u)) continue;
            this.namespacesSeparated = false;
            logger.info((Object)(u + " Individual+Datatype"));
            this.explain(3, 1027, u + "\t used as Individual and Datatype");
        }
        it = this.objectPropertyURIs.iterator();
        while (it.hasNext()) {
            u = it.next();
            if (this.dataPropertyURIs.contains(u)) {
                this.namespacesSeparated = false;
                logger.info((Object)(u + " ObjectProperty+DataProperty"));
                this.explain(3, 1027, u + "\t used as ObjectProperty and DataProperty");
                continue;
            }
            if (this.annotationPropertyURIs.contains(u)) {
                this.namespacesSeparated = false;
                logger.info((Object)(u + " ObjectProperty+AnnotationProperty"));
                this.explain(3, 1027, u + "\t used as ObjectProperty and AnnotationProperty");
                continue;
            }
            if (!this.datatypeURIs.contains(u)) continue;
            this.namespacesSeparated = false;
            logger.info((Object)(u + " ObjectProperty+Datatype"));
            this.explain(3, 1027, u + "\t used as ObjectProperty and Datatype");
        }
        it = this.dataPropertyURIs.iterator();
        while (it.hasNext()) {
            u = it.next();
            if (this.annotationPropertyURIs.contains(u)) {
                this.namespacesSeparated = false;
                logger.info((Object)(u + " DataProperty+AnnotationProperty"));
                this.explain(3, 1027, u + "\t used as DataProperty and AnnotationProperty");
                continue;
            }
            if (!this.datatypeURIs.contains(u)) continue;
            this.namespacesSeparated = false;
            logger.info((Object)(u + " DataProperty+Datatype"));
            this.explain(3, 1027, u + "\t used as DataProperty and Datatype");
        }
        it = this.annotationPropertyURIs.iterator();
        while (it.hasNext()) {
            u = it.next();
            if (!this.datatypeURIs.contains(u)) continue;
            this.namespacesSeparated = false;
            logger.info((Object)(u + " AnnotationProperty+Datatype"));
            this.explain(3, 1027, u + "\t used as AnnotationProperty and Datatype");
        }
    }

    private void checkClassAxioms() throws OWLException {
        this.classAxiomLevel = 0;
        Iterator it = this.allOntologies.iterator();
        while (it.hasNext()) {
            OWLOntology onto = (OWLOntology)it.next();
            Iterator axit = onto.getClassAxioms().iterator();
            while (axit.hasNext()) {
                OWLObject oo = (OWLObject)axit.next();
                logger.debug((Object)("Got Class Axiom: " + oo));
                SpeciesValidatorVisitor visitor = new SpeciesValidatorVisitor(this, this.objectRenderer);
                try {
                    oo.accept((OWLObjectVisitor)visitor);
                    this.classAxiomLevel |= visitor.getLevel();
                }
                catch (OWLException ex) {
                    this.classAxiomLevel = 7;
                }
            }
        }
    }

    private void checkIndividualTyping() throws OWLException {
        HashSet allIndividuals = new HashSet();
        Iterator it = this.allOntologies.iterator();
        while (it.hasNext()) {
            OWLOntology onto = (OWLOntology)it.next();
            Iterator indit = onto.getIndividuals().iterator();
            while (indit.hasNext()) {
                allIndividuals.add(indit.next());
            }
        }
        it = allIndividuals.iterator();
        while (it.hasNext()) {
            OWLIndividual i = (OWLIndividual)it.next();
            if (i.getTypes(this.allOntologies).size() != 0) continue;
            this.individualsTyped = false;
            this.explain(3, 1028, "Individual with no explicit type: " + i.getURI());
        }
    }

    private void checkPropertyAxioms() throws OWLException {
        this.propertyAxiomLevel = 0;
    }

    private void checkExpressivity() throws OWLException {
        this.expressivityLevel = 0;
        ExpressionValidatorVisitor evv = new ExpressionValidatorVisitor(this, this.objectRenderer);
        Iterator it = this.allOntologies.iterator();
        while (it.hasNext()) {
            Iterator dit;
            OWLDescription description;
            OWLOntology onto = (OWLOntology)it.next();
            Iterator cit = onto.getClasses().iterator();
            while (cit.hasNext()) {
                OWLClass clazz = (OWLClass)cit.next();
                if (!clazz.getEnumerations(onto).isEmpty()) {
                    this.expressivityLevel |= 1;
                    this.explain(1, 1007, "Enumeration used: " + clazz.getURI());
                }
                Iterator superit = clazz.getSuperClasses(onto).iterator();
                while (superit.hasNext()) {
                    description = (OWLDescription)superit.next();
                    evv.reset();
                    try {
                        description.accept((OWLObjectVisitor)evv);
                        this.expressivityLevel |= evv.getLevel();
                    }
                    catch (OWLException ex) {
                        this.explain(7, 1001, ex.getMessage());
                        this.expressivityLevel = 7;
                    }
                }
                superit = clazz.getEquivalentClasses(onto).iterator();
                while (superit.hasNext()) {
                    description = (OWLDescription)superit.next();
                    evv.reset();
                    evv.setTopLevelDescription(true);
                    try {
                        description.accept((OWLObjectVisitor)evv);
                        this.expressivityLevel |= evv.getLevel();
                    }
                    catch (OWLException ex) {
                        this.explain(7, 1001, ex.getMessage());
                        this.expressivityLevel = 7;
                    }
                }
            }
            Iterator iit = onto.getObjectProperties().iterator();
            while (iit.hasNext()) {
                OWLObjectProperty op = (OWLObjectProperty)iit.next();
                logger.debug((Object)op.getURI());
                dit = op.getDomains(onto).iterator();
                while (dit.hasNext()) {
                    description = (OWLDescription)dit.next();
                    evv.reset();
                    try {
                        description.accept((OWLObjectVisitor)evv);
                        this.expressivityLevel |= evv.getLevel();
                    }
                    catch (OWLException ex) {
                        this.explain(7, 1001, ex.getMessage());
                        this.expressivityLevel = 7;
                    }
                }
                dit = op.getRanges(onto).iterator();
                while (dit.hasNext()) {
                    description = (OWLDescription)dit.next();
                    evv.reset();
                    try {
                        description.accept((OWLObjectVisitor)evv);
                        this.expressivityLevel |= evv.getLevel();
                    }
                    catch (OWLException ex) {
                        this.explain(7, 1001, ex.getMessage());
                        this.expressivityLevel = 7;
                    }
                }
            }
            iit = onto.getDataProperties().iterator();
            while (iit.hasNext()) {
                OWLDataProperty dp = (OWLDataProperty)iit.next();
                logger.debug((Object)dp.getURI());
                dit = dp.getDomains(onto).iterator();
                while (dit.hasNext()) {
                    description = (OWLDescription)dit.next();
                    evv.reset();
                    try {
                        description.accept((OWLObjectVisitor)evv);
                        this.expressivityLevel |= evv.getLevel();
                    }
                    catch (OWLException ex) {
                        this.explain(7, 1001, ex.getMessage());
                        this.expressivityLevel = 7;
                    }
                }
                dit = dp.getRanges(onto).iterator();
                while (dit.hasNext()) {
                    description = (OWLDataRange)dit.next();
                    evv.reset();
                    try {
                        description.accept((OWLObjectVisitor)evv);
                        this.expressivityLevel |= evv.getLevel();
                    }
                    catch (OWLException ex) {
                        this.explain(7, 1001, ex.getMessage());
                        this.expressivityLevel = 7;
                    }
                }
            }
            iit = onto.getIndividuals().iterator();
            while (iit.hasNext()) {
                OWLIndividual ind = (OWLIndividual)iit.next();
                logger.debug((Object)ind.getURI());
                Iterator typeit = ind.getTypes(onto).iterator();
                while (typeit.hasNext()) {
                    description = (OWLDescription)typeit.next();
                    logger.debug((Object)(" -> " + description));
                    evv.reset();
                    try {
                        description.accept((OWLObjectVisitor)evv);
                        this.expressivityLevel |= evv.getLevel();
                    }
                    catch (OWLException ex) {
                        this.explain(7, 1001, ex.getMessage());
                        this.expressivityLevel = 7;
                    }
                }
            }
        }
        Set complexProperties = evv.getComplexProperties();
        Iterator it2 = this.allOntologies.iterator();
        while (it2.hasNext()) {
            OWLOntology onto = (OWLOntology)it2.next();
            Iterator pit = onto.getObjectProperties().iterator();
            while (pit.hasNext()) {
                OWLObjectProperty prop = (OWLObjectProperty)pit.next();
                if (!prop.isFunctional(onto) && !prop.isInverseFunctional(onto)) continue;
                complexProperties.add(prop);
            }
        }
        Iterator pit = complexProperties.iterator();
        while (pit.hasNext()) {
            OWLObjectProperty prop = (OWLObjectProperty)pit.next();
            Iterator it3 = this.allOntologies.iterator();
            while (it3.hasNext()) {
                OWLOntology onto = (OWLOntology)it3.next();
                if (!prop.isTransitive(onto)) continue;
                this.expressivityLevel = 3;
                this.explain(3, 1029, "Complex property " + prop.getURI() + " asserted to be transitive.");
            }
        }
    }

    private void checkCorrectOWLUsage() throws OWLException {
        URI uri;
        Iterator it = this.classURIs.iterator();
        while (it.hasNext()) {
            uri = (URI)it.next();
            if (uri == null || !this.reservedVocabulary.contains(uri.toString()) || this.classOnlyVocabulary.contains(uri.toString())) continue;
            this.correctOWLUsage = false;
            logger.info((Object)(uri.toString() + " "));
            this.explain(3, 1030, "Redefinition of: " + uri.toString());
        }
        it = this.individualURIs.iterator();
        while (it.hasNext()) {
            uri = (URI)it.next();
            if (uri == null || !this.reservedVocabulary.contains(uri.toString())) continue;
            this.correctOWLUsage = false;
            logger.info((Object)(uri.toString() + " "));
            this.explain(3, 1030, "Redefinition of: " + uri.toString());
        }
        it = this.objectPropertyURIs.iterator();
        while (it.hasNext()) {
            uri = (URI)it.next();
            if (uri == null || !this.reservedVocabulary.contains(uri.toString()) || this.propertyOnlyVocabulary.contains(uri.toString())) continue;
            this.correctOWLUsage = false;
            logger.info((Object)(uri.toString() + " "));
            this.explain(3, 1030, "Redefinition of: " + uri.toString());
        }
        it = this.dataPropertyURIs.iterator();
        while (it.hasNext()) {
            uri = (URI)it.next();
            if (uri == null || !this.reservedVocabulary.contains(uri.toString()) || this.propertyOnlyVocabulary.contains(uri.toString())) continue;
            this.correctOWLUsage = false;
            logger.info((Object)(uri.toString() + " "));
            this.explain(3, 1030, "Redefinition of: " + uri.toString());
        }
        it = this.datatypeURIs.iterator();
        while (it.hasNext()) {
            uri = (URI)it.next();
            if ((uri == null || !this.reservedVocabulary.contains(uri.toString())) && !uri.toString().equals(OWLVocabularyAdapter.INSTANCE.getThing()) && !uri.toString().equals(OWLVocabularyAdapter.INSTANCE.getNothing())) continue;
            this.correctOWLUsage = false;
            logger.info((Object)(uri.toString() + " "));
            this.explain(3, 1030, "Redefinition of: " + uri.toString());
        }
    }

    private void checkCorrectOWLNamespaceUsage() throws OWLException {
        Iterator it = this.allURIs.iterator();
        while (it.hasNext()) {
            URI uri = (URI)it.next();
            if (uri == null) continue;
            String str = uri.toString();
            if (!str.startsWith("http://www.w3.org/2002/07/owl#") || str.equals(OWLVocabularyAdapter.INSTANCE.getThing()) || str.equals(OWLVocabularyAdapter.INSTANCE.getNothing()) || OWLVocabularyAdapter.INSTANCE.getAnnotationProperties().contains(str)) continue;
            this.correctOWLNamespaceUsage = false;
            logger.info((Object)uri.toString());
            this.explain(3, 1031, uri.toString() + " in OWL Namespace");
        }
    }

    public static String readableCode(int code) {
        switch (code) {
            case 2001: {
                return "Unknown RDF Error";
            }
            case 2002: {
                return "Untyped Class";
            }
            case 2003: {
                return "Untyped Property";
            }
            case 2004: {
                return "Untyped Individual";
            }
            case 2005: {
                return "Untyped Ontology";
            }
            case 2006: {
                return "Untyped Datatype";
            }
            case 2007: {
                return "Untyped URI";
            }
            case 2008: {
                return "Malformed List";
            }
            case 2009: {
                return "Inverse Functional Data Property";
            }
            case 2010: {
                return "Unspecified Functional Property";
            }
            case 2011: {
                return "Structure Sharing";
            }
            case 2012: {
                return "Cyclical BNodes";
            }
            case 2013: {
                return "Multiple Definitions";
            }
            case 2014: {
                return "Malformed Restriction";
            }
            case 2015: {
                return "Malformed Description";
            }
            case 2016: {
                return "Unused Triples";
            }
            case 2017: {
                return "Illegal Sub Property";
            }
            case 2018: {
                return "Malformed Import";
            }
            case 2023: {
                return "Untyped Data Property";
            }
            case 2024: {
                return "Untyped Object Property";
            }
            case 2026: {
                return "SameAs used for Class";
            }
            case 2027: {
                return "SameAs used for Object Property";
            }
            case 2028: {
                return "SameAs used for Data Property";
            }
            case 1001: {
                return "Unknown";
            }
            case 1002: {
                return "Intersection";
            }
            case 1003: {
                return "Union";
            }
            case 1004: {
                return "Complement";
            }
            case 1005: {
                return "0/1 Cardinality";
            }
            case 1006: {
                return "Cardinality";
            }
            case 1007: {
                return "One Of";
            }
            case 1008: {
                return "DataType";
            }
            case 1009: {
                return "DataRange";
            }
            case 1010: {
                return "SubClass";
            }
            case 1011: {
                return "Equivalence";
            }
            case 1012: {
                return "Disjoint";
            }
            case 1013: {
                return "Partial";
            }
            case 1014: {
                return "Complete";
            }
            case 1015: {
                return "SubProperty";
            }
            case 1016: {
                return "EquivalentProperty";
            }
            case 1017: {
                return "Inverse";
            }
            case 1018: {
                return "Transitive";
            }
            case 1019: {
                return "Symmetric";
            }
            case 1020: {
                return "Functional";
            }
            case 1021: {
                return "InverseFunctional";
            }
            case 1022: {
                return "Individuals";
            }
            case 1023: {
                return "RelatedIndividuals";
            }
            case 1024: {
                return "IndividualData";
            }
            case 1025: {
                return "SameIndividual";
            }
            case 1026: {
                return "DifferentIndividuals";
            }
            case 1027: {
                return "Name Separation Violated";
            }
            case 1028: {
                return "Untyped Individual";
            }
            case 1029: {
                return "Complex Transitive Property";
            }
            case 1030: {
                return "Redefinition of Builtin Vocabulary";
            }
            case 1031: {
                return "Definition in OWL Namespace";
            }
            case 1032: {
                return "Expression used in Axiom";
            }
            case 1033: {
                return "Expression used in Restriction";
            }
        }
        return "---";
    }

    public void releaseOntology(OWLOntology o) throws OWLException {
        this.connection.notifyOntologyDeleted(o);
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.out.println("Usage: SpeciesValidator [-l|-d|-f] [-v] [-q] url");
                System.exit(1);
            }
            int species = 3;
            boolean quiet = false;
            boolean verbose = false;
            for (int i = 0; i < args.length - 1; ++i) {
                if (args[i].equals("-l")) {
                    species = 0;
                    continue;
                }
                if (args[i].equals("-d")) {
                    species = 1;
                    continue;
                }
                if (args[i].equals("-f")) {
                    species = 3;
                    continue;
                }
                if (args[i].equals("-q")) {
                    quiet = true;
                    continue;
                }
                if (!args[i].equals("-v")) continue;
                verbose = true;
            }
            BasicConfigurator.configure();
            URI uri = new URI(args[args.length - 1]);
            SpeciesValidator sv = new SpeciesValidator();
            if (!verbose) {
                sv.setReporter(new SpeciesValidatorReporter(){

                    public void ontology(OWLOntology onto) {
                    }

                    public void done(String str) {
                    }

                    public void message(String str) {
                    }

                    public void explain(int l, int code, String str) {
                    }
                });
            }
            switch (species) {
                case 0: {
                    boolean b = sv.isOWLLite(uri);
                    if (quiet) break;
                    System.out.println("OWL-Lite:\t" + (b ? "YES" : "NO"));
                    break;
                }
                case 1: {
                    boolean b = sv.isOWLDL(uri);
                    if (quiet) break;
                    System.out.println("OWL-DL  :\t" + (b ? "YES" : "NO"));
                    break;
                }
                case 3: {
                    boolean b = sv.isOWLFull(uri);
                    if (quiet) break;
                    System.out.println("OWL-Full:\t" + (b ? "YES" : "NO"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

