/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.semanticweb.owl.io.RendererException;
import org.semanticweb.owl.io.abstract_syntax.ObjectRenderer;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.helper.OWLObjectVisitorAdapter;
import org.semanticweb.owl.validation.OWLValidationConstants;
import uk.ac.man.cs.img.owl.validation.ClassOrRestrictionIdentifier;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;

class SpeciesValidatorVisitor
extends OWLObjectVisitorAdapter
implements OWLValidationConstants {
    private int level = 0;
    static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$owl$validation$SpeciesValidatorVisitor == null ? (class$uk$ac$man$cs$img$owl$validation$SpeciesValidatorVisitor = SpeciesValidatorVisitor.class$("uk.ac.man.cs.img.owl.validation.SpeciesValidatorVisitor")) : class$uk$ac$man$cs$img$owl$validation$SpeciesValidatorVisitor));
    private SpeciesValidator parent;
    private ObjectRenderer objectRenderer;
    static /* synthetic */ Class class$uk$ac$man$cs$img$owl$validation$SpeciesValidatorVisitor;

    public int getLevel() {
        return this.level;
    }

    public SpeciesValidatorVisitor(SpeciesValidator parent, ObjectRenderer renderer) {
        this.parent = parent;
        this.objectRenderer = renderer;
    }

    public void visit(OWLDisjointClassesAxiom node) {
        logger.debug((Object)"Visiting DisjointClassesAxiom");
        this.parent.explain(1, 1012, "Disjoint Classes axiom found: " + this.renderNode((OWLObject)node));
        this.level |= 1;
    }

    public void visit(OWLEquivalentClassesAxiom node) {
        logger.debug((Object)"Visiting EquivalentClassesAxiom");
        try {
            Iterator it = node.getEquivalentClasses().iterator();
            while (it.hasNext()) {
                OWLObject oo = (OWLObject)it.next();
                logger.debug((Object)("Object is: " + oo));
                if (this.isClassOrSimpleRestriction(oo)) continue;
                this.parent.explain(1, 1032, "Equivalent Classes axiom using expressions found: " + this.renderNode((OWLObject)node));
                this.level |= 1;
            }
        }
        catch (OWLException ex) {
            this.level |= 7;
        }
    }

    public void visit(OWLSubClassAxiom node) {
        try {
            OWLDescription superClass;
            OWLDescription subClass = node.getSubClass();
            if (!this.isClass((OWLObject)subClass)) {
                this.parent.explain(1, 1032, "SubClass axiom using expressions found: " + this.renderNode((OWLObject)node));
                this.level |= 1;
            }
            if (!this.isClassOrSimpleRestriction((OWLObject)(superClass = node.getSuperClass()))) {
                this.parent.explain(1, 1032, "SubClass axiom using expressions found: " + this.renderNode((OWLObject)node));
                this.level |= 1;
            }
        }
        catch (OWLException ex) {
            this.level |= 7;
        }
    }

    public void visit(OWLClass node) {
    }

    private boolean isClass(OWLObject oo) throws OWLException {
        ClassOrRestrictionIdentifier civ = new ClassOrRestrictionIdentifier();
        oo.accept((OWLObjectVisitor)civ);
        return civ.isClass();
    }

    private boolean isClassOrSimpleRestriction(OWLObject oo) throws OWLException {
        ClassOrRestrictionIdentifier civ = new ClassOrRestrictionIdentifier();
        oo.accept((OWLObjectVisitor)civ);
        return civ.isClassOrSimpleRestriction();
    }

    private String renderNode(OWLObject node) {
        try {
            return this.objectRenderer.renderObject(node);
        }
        catch (RendererException ex) {
            return node.toString();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

