/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore;

import de.dailab.jiactng.agentcore.AbstractAgentBeanMBean;
import de.dailab.jiactng.agentcore.IAgent;
import de.dailab.jiactng.agentcore.IAgentBean;
import de.dailab.jiactng.agentcore.action.Action;
import de.dailab.jiactng.agentcore.action.ActionResult;
import de.dailab.jiactng.agentcore.action.ActionResultListener;
import de.dailab.jiactng.agentcore.action.DoAction;
import de.dailab.jiactng.agentcore.action.Session;
import de.dailab.jiactng.agentcore.environment.ResultReceiver;
import de.dailab.jiactng.agentcore.knowledge.IMemory;
import de.dailab.jiactng.agentcore.lifecycle.AbstractLifecycle;
import de.dailab.jiactng.agentcore.lifecycle.ILifecycle;
import de.dailab.jiactng.agentcore.lifecycle.LifecycleException;
import de.dailab.jiactng.agentcore.management.Manager;
import de.dailab.jiactng.agentcore.ontology.IActionDescription;
import de.dailab.jiactng.agentcore.ontology.IAgentDescription;
import java.io.Serializable;
import javax.management.AttributeChangeNotification;
import org.springframework.beans.factory.BeanNameAware;

public abstract class AbstractAgentBean
extends AbstractLifecycle
implements IAgentBean,
AbstractAgentBeanMBean,
BeanNameAware {
    private int executeInterval = -1;
    private long nextExecutionTime = 0L;
    protected IAgent thisAgent = null;
    protected IMemory memory = null;
    protected String beanName = null;

    public final void setThisAgent(IAgent agent) {
        if (this.isManagementEnabled()) {
            Manager manager = this._manager;
            this.disableManagement();
            this.thisAgent = agent;
            this.enableManagement(manager);
        } else {
            this.thisAgent = agent;
        }
        this.setLog(this.thisAgent.getLog((IAgentBean)this));
    }

    public final void setMemory(IMemory mem) {
        this.memory = mem;
    }

    public final void setBeanName(String name) {
        if (this.isManagementEnabled()) {
            Manager manager = this._manager;
            this.disableManagement();
            this.beanName = name;
            this.enableManagement(manager);
        } else {
            this.beanName = name;
        }
        if (this.thisAgent != null) {
            this.setLog(this.thisAgent.getLog((IAgentBean)this));
        }
    }

    public final String getBeanName() {
        return this.beanName;
    }

    @Override
    public void doInit() throws Exception {
        if (this.log == null) {
            this.setLog(this.thisAgent.getLog((IAgentBean)this));
        }
    }

    @Override
    public void doStart() throws Exception {
    }

    @Override
    public void doStop() throws Exception {
    }

    @Override
    public void doCleanup() throws Exception {
    }

    public ActionResult cancelAction(DoAction doAction) {
        return null;
    }

    @Override
    public void enableManagement(Manager manager) {
        if (this.isManagementEnabled()) {
            return;
        }
        try {
            manager.registerAgentBean((IAgentBean)this, this.thisAgent);
        }
        catch (Exception e) {
            System.err.println("WARNING: Unable to register agent bean " + this.beanName + " of agent " + this.thisAgent.getAgentName() + " of agent node " + this.thisAgent.getAgentNode().getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
        super.enableManagement(manager);
    }

    @Override
    public void disableManagement() {
        if (!this.isManagementEnabled()) {
            return;
        }
        try {
            this._manager.unregisterAgentBean((IAgentBean)this, this.thisAgent);
        }
        catch (Exception e) {
            System.err.println("WARNING: Unable to deregister agent bean " + this.beanName + " of agent " + this.thisAgent.getAgentName() + " of agent node " + this.thisAgent.getAgentNode().getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
        super.disableManagement();
    }

    public final int getExecuteInterval() {
        return this.executeInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setExecuteInterval(int newExecuteInterval) {
        try {
            if (newExecuteInterval <= 0) {
                this.nextExecutionTime = 0L;
                return;
            }
            this.nextExecutionTime = this.nextExecutionTime > 0L ? this.nextExecutionTime - (long)this.executeInterval + (long)newExecuteInterval : System.currentTimeMillis() + (long)newExecuteInterval;
        }
        finally {
            this.executeInterval = newExecuteInterval;
        }
    }

    public final long getNextExecutionTime() {
        return this.nextExecutionTime;
    }

    public final void setNextExecutionTime(long newNextExecutionTime) {
        this.nextExecutionTime = newNextExecutionTime;
    }

    public void execute() {
    }

    public void handleLifecycleException(LifecycleException e, ILifecycle.LifecycleStates state) {
        throw new RuntimeException((Throwable)e);
    }

    protected final ActionResult invokeAndWaitForResult(IActionDescription a, Serializable[] inputParams) {
        return this.invokeAndWaitForResult(a, inputParams, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ActionResult invokeAndWaitForResult(IActionDescription a, Serializable[] inputParams, Long timeout) {
        ActionResultListener listener = new ActionResultListener();
        this.invoke(a, inputParams, listener, timeout);
        ActionResultListener actionResultListener = listener;
        synchronized (actionResultListener) {
            try {
                listener.wait();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return listener.getResult();
    }

    protected final String invoke(IActionDescription a, Serializable[] inputParams) {
        return this.invoke(a, inputParams, null);
    }

    protected final String invoke(IActionDescription a, Serializable[] inputParams, ResultReceiver receiver) {
        return this.invoke(a, inputParams, receiver, 60000L);
    }

    protected final String invoke(IActionDescription a, Serializable[] inputParams, ResultReceiver receiver, Long timeOut) {
        DoAction doAct = a.createDoAction(inputParams, receiver, timeOut);
        this.memory.write((Object)doAct);
        return doAct.getSessionId();
    }

    protected final String invoke(IActionDescription a, Session parent, Serializable[] inputParams, ResultReceiver receiver) {
        DoAction doAct = a.createDoAction(parent, inputParams, receiver);
        this.memory.write((Object)doAct);
        return doAct.getSessionId();
    }

    protected final void returnResult(DoAction origin, Serializable[] results) {
        ActionResult res = ((Action)origin.getAction()).createActionResult(origin, results);
        this.memory.write((Object)res);
    }

    protected final void returnFailure(DoAction origin, Serializable failure) {
        ActionResult res = new ActionResult(origin, failure);
        this.memory.write((Object)res);
    }

    protected final Action retrieveAction(String actionName) {
        Action retAct = (Action)this.memory.read((Object)new Action(actionName));
        if (retAct == null) {
            this.log.warn((Object)("Local memory does not contain '" + actionName + "'."));
        }
        return retAct;
    }

    protected final Action retrieveAction(String actionName, IAgentDescription provider) {
        Action template = new Action(actionName);
        template.setProviderDescription(provider);
        Action retAct = (Action)this.memory.read((Object)template);
        if (retAct == null) {
            this.log.warn((Object)("Local memory does not contain '" + actionName + "' with provider " + provider + "."));
        }
        return retAct;
    }

    protected final void sendAttributeChangeNotification(String attributeName, String attributeType, Object oldValue, Object newValue) {
        AttributeChangeNotification n = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "AgentBean Property " + attributeName + " changed", attributeName, attributeType, oldValue, newValue);
        this.sendNotification(n);
    }
}

