/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore;

import de.dailab.jiactng.agentcore.AgentMBean;
import de.dailab.jiactng.agentcore.IAgent;
import de.dailab.jiactng.agentcore.IAgentBean;
import de.dailab.jiactng.agentcore.IAgentNode;
import de.dailab.jiactng.agentcore.action.Action;
import de.dailab.jiactng.agentcore.action.DoAction;
import de.dailab.jiactng.agentcore.comm.CommunicationAddressFactory;
import de.dailab.jiactng.agentcore.directory.IDirectory;
import de.dailab.jiactng.agentcore.environment.IEffector;
import de.dailab.jiactng.agentcore.execution.IExecutionCycle;
import de.dailab.jiactng.agentcore.knowledge.IMemory;
import de.dailab.jiactng.agentcore.lifecycle.AbstractLifecycle;
import de.dailab.jiactng.agentcore.lifecycle.ILifecycle;
import de.dailab.jiactng.agentcore.lifecycle.ILifecycleListener;
import de.dailab.jiactng.agentcore.lifecycle.LifecycleEvent;
import de.dailab.jiactng.agentcore.lifecycle.LifecycleException;
import de.dailab.jiactng.agentcore.management.Manager;
import de.dailab.jiactng.agentcore.management.jmx.client.JmxAgentNodeTimerManagementClient;
import de.dailab.jiactng.agentcore.management.jmx.client.JmxManagementClient;
import de.dailab.jiactng.agentcore.ontology.AgentBeanDescription;
import de.dailab.jiactng.agentcore.ontology.AgentDescription;
import de.dailab.jiactng.agentcore.ontology.IActionDescription;
import de.dailab.jiactng.agentcore.ontology.IAgentDescription;
import de.dailab.jiactng.agentcore.ontology.ThisAgentDescription;
import de.dailab.jiactng.agentcore.util.IdFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.timer.TimerNotification;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.BeanNameAware;

public class Agent
extends AbstractLifecycle
implements IAgent,
AgentMBean,
BeanNameAware,
NotificationListener {
    public static final int DEFAULT_EXECUTION_INTERVAL = 5;
    public static final long DEFAULT_BEAN_EXECUTION_TIMEOUT = 300000L;
    public static final long AUTO_EXECUTION_DELAY = 3000L;
    public static final long AGENT_STARTTIME_DELAY = 3000L;
    public static final long CONTINUOUS_EXECUTION_INTERVAL = 30000L;
    private final String agentId;
    private IAgentNode agentNode = null;
    private String agentName = null;
    private String owner = null;
    protected IMemory memory = null;
    private IDirectory directory;
    protected final ArrayList<IAgentBean> agentBeans = new ArrayList();
    private boolean active = false;
    private IExecutionCycle execution = null;
    private Future<?> executionFuture = null;
    private int executionInterval = 5;
    private long beanExecutionTimeout = 300000L;
    private ArrayList<IActionDescription> actionList = null;
    private Integer startTimeId = null;
    private Long startTime = null;
    private Integer stopTimeId = null;
    private Long stopTime = null;
    private byte[] springConfigXml = null;
    private JmxAgentNodeTimerManagementClient timerClient = null;
    private Integer autoExecTimeId = null;
    private boolean singleExecutionsDone = false;

    public Agent() {
        this.agentId = IdFactory.createAgentId((int)this.hashCode());
    }

    public Agent(String agentID) {
        this.agentId = agentID;
    }

    public final void setMemory(IMemory newMemory) {
        if (this.isManagementEnabled() && this.memory != null) {
            this.memory.disableManagement();
        }
        this.memory = newMemory;
        newMemory.setThisAgent((IAgent)this);
        if (this.isManagementEnabled() && this.memory != null) {
            this.memory.enableManagement(this._manager);
        }
    }

    public final List<IAgentBean> getAgentBeans() {
        return Collections.unmodifiableList(this.agentBeans);
    }

    public final void setAgentBeans(List<IAgentBean> agentbeans) {
        if (this.isManagementEnabled() && this.agentBeans != null) {
            for (IAgentBean ab : this.agentBeans) {
                ab.disableManagement();
            }
        }
        this.agentBeans.clear();
        this.agentBeans.addAll(agentbeans);
        for (IAgentBean ab : this.agentBeans) {
            ab.setThisAgent((IAgent)this);
            if (!this.isManagementEnabled()) continue;
            ab.enableManagement(this._manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.executionInterval);
                    Agent agent = this;
                    synchronized (agent) {
                        if (!this.active) return;
                        this.executionFuture = this.agentNode.getThreadPool().submit((Runnable)this.execution);
                        FutureTask t = (FutureTask)this.executionFuture;
                        try {
                            t.get(this.beanExecutionTimeout, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException to) {
                            System.err.print("this: " + this.agentName);
                            to.printStackTrace();
                            t.cancel(true);
                            this.stop();
                            this.log.error((Object)"ExecutionCycle did not return: ", (Throwable)to);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Critical error in controlcycle of agent: " + this.agentName + ". Stopping Agent. Exception was: "), (Throwable)e);
                e.printStackTrace();
                try {
                    this.stop();
                }
                catch (LifecycleException e1) {
                    e1.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }

    public final void setBeanName(String name) {
        this.setAgentName(name);
    }

    public void onEvent(LifecycleEvent evt) {
    }

    public final void remove() throws LifecycleException {
        this.stop();
        this.cleanup();
        if (this.agentNode != null) {
            this.agentNode.removeAgent((IAgent)this);
        }
    }

    @Override
    public void doCleanup() throws LifecycleException {
        if (this.executionFuture != null) {
            this.executionFuture.cancel(true);
            this.executionFuture = null;
        }
        for (IAgentBean a : this.agentBeans) {
            try {
                this.setBeanState(a, ILifecycle.LifecycleStates.CLEANED_UP);
            }
            catch (LifecycleException e) {
                this.handleBeanException(a, e, ILifecycle.LifecycleStates.CLEANED_UP);
            }
        }
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info((Object)"Trying to cleanup memory and executioncycle");
        }
        this.memory.removeAll((Object)new Action());
        this.updateState(ILifecycle.LifecycleStates.CLEANED_UP);
        this.actionList = null;
        this.execution.cleanup();
        this.memory.cleanup();
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info((Object)("Memory and executioncycle switched to state " + ILifecycle.LifecycleStates.CLEANED_UP));
        }
        this.timerClient = null;
    }

    @Override
    public void doInit() throws LifecycleException {
        try {
            this.timerClient = new JmxManagementClient().getAgentNodeTimerManagementClient(this.agentNode.getUUID());
        }
        catch (MalformedObjectNameException e) {
            throw new LifecycleException("Error when initializing timer client", (Throwable)e);
        }
        this.actionList = new ArrayList();
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info((Object)"Trying to initalize memory and executioncycle");
        }
        this.memory.init();
        this.memory.write((Object)new ThisAgentDescription(this.agentId, this.agentName, ILifecycle.LifecycleStates.INITIALIZING.name(), CommunicationAddressFactory.createMessageBoxAddress(this.agentNode.getUUID() + '/' + this.agentId), this.agentNode.getUUID()));
        this.execution.setMemory(this.memory);
        this.execution.init();
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info((Object)("Memory and executioncycle switched to state " + ILifecycle.LifecycleStates.INITIALIZED));
        }
        for (IAgentBean ab : this.agentBeans) {
            List acts;
            try {
                ab.setMemory(this.memory);
                ab.addLifecycleListener((ILifecycleListener)this);
                this.setBeanState(ab, ILifecycle.LifecycleStates.INITIALIZED);
            }
            catch (LifecycleException e) {
                this.handleBeanException(ab, e, ILifecycle.LifecycleStates.INITIALIZED);
            }
            AgentDescription myDescription = this.getAgentDescription();
            if (!(ab instanceof IEffector) || (acts = ((IEffector)ab).getActions()) == null) continue;
            for (IActionDescription item : acts) {
                item.setProviderDescription((IAgentDescription)myDescription);
                if (item.getProviderBean() == null) {
                    item.setProviderBean((IEffector)ab);
                }
                this.memory.write((Object)item);
                this.actionList.add(item);
            }
        }
        this.updateState(ILifecycle.LifecycleStates.INITIALIZED);
        if (this.startTime != null && this.stopTime != null) {
            try {
                this.registerStartTime(this.startTime);
                this.registerStopTime(this.stopTime);
            }
            catch (InstanceNotFoundException e) {
                throw new LifecycleException("Error when initializing start/stoptime", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStart() throws LifecycleException {
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info((Object)"Trying to start memory and executioncycle");
        }
        this.memory.start();
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info((Object)("Memory and executioncycle switched to state " + ILifecycle.LifecycleStates.STARTED));
        }
        for (IAgentBean a : this.agentBeans) {
            try {
                this.setBeanState(a, ILifecycle.LifecycleStates.STARTED);
            }
            catch (LifecycleException e) {
                this.handleBeanException(a, e, ILifecycle.LifecycleStates.STARTED);
            }
        }
        this.execution.start();
        this.singleExecutionsDone = false;
        if (this.execution.getAutoExecutionServices() != null) {
            try {
                if (this.startTimeId == null && this.stopTimeId == null && this.autoExecTimeId == null) {
                    try {
                        this.timerClient.addTimerNotificationListener((NotificationListener)this);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.autoExecTimeId != null) {
                    try {
                        this.timerClient.removeNotification(this.autoExecTimeId);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.autoExecTimeId = this.timerClient.addNotification(null, null, null, new Date(System.currentTimeMillis() + 3000L));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InstanceNotFoundException e) {
                e.printStackTrace();
            }
        }
        Agent agent = this;
        synchronized (agent) {
            this.active = true;
        }
        this.updateState(ILifecycle.LifecycleStates.STARTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws LifecycleException {
        for (IAgentBean a : this.agentBeans) {
            try {
                this.setBeanState(a, ILifecycle.LifecycleStates.STOPPED);
            }
            catch (LifecycleException e) {
                this.handleBeanException(a, e, ILifecycle.LifecycleStates.STOPPED);
            }
        }
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info((Object)"Trying to stop memory and executioncycle");
        }
        Agent agent = this;
        synchronized (agent) {
            this.active = false;
            if (this.executionFuture != null) {
                this.executionFuture.cancel(false);
            }
        }
        this.execution.stop();
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info((Object)("Memory and executioncycle switched to state " + ILifecycle.LifecycleStates.STOPPED));
        }
        this.memory.stop();
        this.updateState(ILifecycle.LifecycleStates.STOPPED);
    }

    private void handleBeanException(IAgentBean a, LifecycleException e, ILifecycle.LifecycleStates state) {
        this.printCriticalMessage("Agentbean: '" + a.getBeanName() + "' could not switch to state: '" + state + "'! \n  Exception was: ", (Exception)((Object)e));
        try {
            a.handleLifecycleException(e, state);
            this.setBeanState(a, state);
            this.printCriticalMessage("Recovery for Agentbean: '" + a.getBeanName() + "' successful.", null);
        }
        catch (Exception newEx) {
            this.printCriticalMessage("Recovery for Agentbean: '" + a.getBeanName() + "' failed, removing Bean.", newEx);
        }
    }

    private void printCriticalMessage(String message, Exception e) {
        if (this.log != null) {
            this.log.error((Object)message, (Throwable)e);
        } else {
            System.err.println(message);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    private void updateState(ILifecycle.LifecycleStates newState) {
        this.memory.update((Object)new ThisAgentDescription(), (Object)new ThisAgentDescription(null, null, newState.name(), null, this.getAgentNode().getUUID()));
    }

    public final ILifecycle.LifecycleStates getAgentState() {
        return ILifecycle.LifecycleStates.valueOf((String)((ThisAgentDescription)this.memory.read((Object)new ThisAgentDescription())).getState());
    }

    public final void setBeanState(IAgentBean bean, ILifecycle.LifecycleStates newState) throws LifecycleException {
        String beanName = bean.getBeanName();
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info((Object)("Trying to switch bean: " + bean.getBeanName() + " to " + newState.toString()));
        }
        switch (newState) {
            case CLEANED_UP: {
                bean.cleanup();
                break;
            }
            case INITIALIZED: {
                bean.init();
                break;
            }
            case STOPPED: {
                bean.stop();
                break;
            }
            case STARTED: {
                bean.start();
                break;
            }
            default: {
                return;
            }
        }
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info((Object)("Bean " + bean.getBeanName() + " switched to state: " + newState.toString()));
        }
        this.memory.update((Object)new AgentBeanDescription(beanName, null), (Object)new AgentBeanDescription(null, newState.name()));
    }

    public final ILifecycle.LifecycleStates getBeanState(String beanName) {
        return ILifecycle.LifecycleStates.valueOf((String)((AgentBeanDescription)this.memory.read((Object)new AgentBeanDescription(beanName, null))).getState());
    }

    protected final void sendAttributeChangeNotification(String attributeName, String attributeType, Object oldValue, Object newValue) {
        AttributeChangeNotification n = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Agent property " + attributeName + " changed", attributeName, attributeType, oldValue, newValue);
        this.sendNotification(n);
    }

    public final String getAgentName() {
        return this.agentName;
    }

    public final void setAgentName(String agentname) {
        String oldName = this.agentName;
        this.agentName = agentname;
        this.sendAttributeChangeNotification("AgentName", "java.lang.String", oldName, agentname);
    }

    public final ExecutorService getThreadPool() {
        return this.agentNode.getThreadPool();
    }

    public final IExecutionCycle getExecution() {
        return this.execution;
    }

    public final void setExecution(IExecutionCycle newExecution) {
        if (this.isManagementEnabled() && this.execution != null) {
            this.execution.disableManagement();
        }
        this.execution = newExecution;
        this.execution.setThisAgent((IAgent)this);
        if (this.isManagementEnabled() && this.execution != null) {
            this.execution.enableManagement(this._manager);
        }
    }

    public final IAgentNode getAgentNode() {
        return this.agentNode;
    }

    public final void setAgentNode(IAgentNode newAgentNode) {
        if (this.isManagementEnabled()) {
            Manager manager = this._manager;
            this.disableManagement();
            this.agentNode = newAgentNode;
            this.enableManagement(manager);
        } else {
            this.agentNode = newAgentNode;
        }
        this.setLog(this.agentNode.getLog((IAgent)this));
    }

    public final String getOwner() {
        return this.owner;
    }

    public final void setOwner(String newOwner) {
        String oldOwner = this.owner;
        this.owner = newOwner;
        this.sendAttributeChangeNotification("owner", "java.lang.String", oldOwner, this.owner);
    }

    public final Log getLog(IAgentBean bean) {
        if (this.agentNode == null) {
            return null;
        }
        return this.agentNode.getLog((IAgent)this, bean);
    }

    public final Log getLog(IAgentBean bean, String extension) {
        if (this.agentNode == null) {
            return null;
        }
        return this.agentNode.getLog((IAgent)this, bean, extension);
    }

    public final long getBeanExecutionTimeout() {
        return this.beanExecutionTimeout;
    }

    public final void setBeanExecutionTimeout(long newBeanExecutionTimeout) {
        this.beanExecutionTimeout = newBeanExecutionTimeout;
    }

    public final String getAgentId() {
        return this.agentId;
    }

    public AgentDescription getAgentDescription() {
        return (AgentDescription)this.memory.read((Object)new ThisAgentDescription());
    }

    public final List<String> getAgentBeanNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (IAgentBean bean : this.getAgentBeans()) {
            ret.add(bean.getBeanName());
        }
        return ret;
    }

    public final List<IActionDescription> getActionList() {
        ArrayList tempList = new ArrayList();
        for (IAgentBean iab : this.agentBeans) {
            if (!(iab instanceof IEffector)) continue;
            tempList.addAll(((IEffector)iab).getActions());
        }
        for (IActionDescription a : tempList) {
            a.setProviderDescription((IAgentDescription)this.getAgentDescription());
        }
        this.actionList = tempList;
        return Collections.unmodifiableList(this.actionList);
    }

    public final void setActionList(List<IActionDescription> newActionList) {
        this.actionList = new ArrayList();
        this.actionList.addAll(newActionList);
    }

    public final List<String> getActionNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (IActionDescription action : this.getActionList()) {
            ret.add(action.getName());
        }
        return ret;
    }

    public final CompositeData getMemoryData() {
        if (this.memory == null) {
            return null;
        }
        String[] itemNames = new String[]{"class", "matcher", "updater"};
        try {
            CompositeType type = new CompositeType("javax.management.openmbean.CompositeDataSupport", "Memory information", itemNames, new String[]{"Implementation of the memory instance", "Implementation of the matcher instance", "Implementation of the updater instance"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
            return new CompositeDataSupport(type, itemNames, new Object[]{this.memory.getClass().getName(), this.memory.getMatcher() == null ? null : this.memory.getMatcher().getClass().getName(), this.memory.getUpdater() == null ? null : this.memory.getUpdater().getClass().getName()});
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public final String getExecutionCycleClass() {
        if (this.execution == null) {
            return null;
        }
        return this.execution.getClass().getName();
    }

    @Override
    public void enableManagement(Manager manager) {
        if (this.isManagementEnabled()) {
            return;
        }
        try {
            manager.registerAgent((IAgent)this);
        }
        catch (Exception e) {
            System.err.println("WARNING: Unable to register agent " + this.getAgentName() + " of agent node " + this.getAgentNode().getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
        for (IAgentBean ab : this.agentBeans) {
            ab.enableManagement(manager);
        }
        if (this.memory != null) {
            this.memory.enableManagement(manager);
        }
        if (this.execution != null) {
            this.execution.enableManagement(manager);
        }
        super.enableManagement(manager);
    }

    @Override
    public void disableManagement() {
        if (!this.isManagementEnabled()) {
            return;
        }
        if (this.memory != null) {
            this.memory.disableManagement();
        }
        if (this.execution != null) {
            this.execution.disableManagement();
        }
        for (IAgentBean ab : this.agentBeans) {
            ab.disableManagement();
        }
        try {
            this._manager.unregisterAgent((IAgent)this);
        }
        catch (Exception e) {
            System.err.println("WARNING: Unable to deregister agent " + this.getAgentName() + " of agent node " + this.getAgentNode().getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
        super.disableManagement();
    }

    public final int getExecutionInterval() {
        return this.executionInterval;
    }

    public final void setExecutionInterval(int newExecutionInterval) {
        int oldInterval = this.executionInterval;
        this.executionInterval = newExecutionInterval;
        this.sendAttributeChangeNotification("executionInterval", "java.lang.int", oldInterval, newExecutionInterval);
    }

    public final Long getStartTime() throws InstanceNotFoundException {
        if (this.startTimeId == null) {
            return null;
        }
        try {
            return this.timerClient.getDate(this.startTimeId).getTime();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (NullPointerException e) {
            return this.startTime;
        }
    }

    private void registerStartTime(Long regStartTime) throws InstanceNotFoundException {
        if (this.startTimeId == null && this.stopTimeId == null && this.autoExecTimeId == null && regStartTime != null) {
            try {
                this.timerClient.addTimerNotificationListener((NotificationListener)this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.startTimeId != null) {
            try {
                this.timerClient.removeNotification(this.startTimeId);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.startTimeId != null && this.stopTimeId == null && this.autoExecTimeId == null && regStartTime == null) {
            try {
                this.timerClient.removeTimerNotificationListener((NotificationListener)this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ListenerNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (regStartTime != null) {
            try {
                this.startTimeId = this.timerClient.addNotification(null, null, null, new Date(regStartTime));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public final void setStartTime(Long newStartTime) throws InstanceNotFoundException {
        if (newStartTime != null && newStartTime <= System.currentTimeMillis() + 3000L) {
            newStartTime = System.currentTimeMillis() + 3000L;
        }
        this.startTime = newStartTime;
        Long oldStartTime = this.getStartTime();
        if (this.memory.getState() != ILifecycle.LifecycleStates.UNDEFINED && this.getAgentState() != ILifecycle.LifecycleStates.UNDEFINED) {
            this.registerStartTime(newStartTime);
            this.sendAttributeChangeNotification("startTime", "java.lang.Long", oldStartTime, this.getStartTime());
        }
    }

    public final Long getStopTime() throws InstanceNotFoundException {
        if (this.stopTimeId == null) {
            return null;
        }
        try {
            return this.timerClient.getDate(this.stopTimeId).getTime();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (NullPointerException e) {
            return this.stopTime;
        }
    }

    private void registerStopTime(Long regStopTime) throws InstanceNotFoundException {
        if (this.startTimeId == null && this.stopTimeId == null && this.autoExecTimeId == null && regStopTime != null) {
            try {
                this.timerClient.addTimerNotificationListener((NotificationListener)this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.stopTimeId != null) {
            try {
                this.timerClient.removeNotification(this.stopTimeId);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.startTimeId == null && this.stopTimeId != null && this.autoExecTimeId == null && regStopTime == null) {
            try {
                this.timerClient.removeTimerNotificationListener((NotificationListener)this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ListenerNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (regStopTime != null) {
            try {
                this.stopTimeId = this.timerClient.addNotification(null, null, null, new Date(regStopTime));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public final void setStopTime(Long newStopTime) throws InstanceNotFoundException {
        this.stopTime = newStopTime;
        Long oldStopTime = this.getStopTime();
        if (this.memory.getState() != ILifecycle.LifecycleStates.UNDEFINED && this.getAgentState() != ILifecycle.LifecycleStates.UNDEFINED) {
            this.registerStopTime(newStopTime);
            this.sendAttributeChangeNotification("stopTime", "java.lang.Long", oldStopTime, this.getStopTime());
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof TimerNotification) {
            Integer id = ((TimerNotification)notification).getNotificationID();
            if (id.equals(this.startTimeId) && !this.getAgentState().equals((Object)ILifecycle.LifecycleStates.STARTED) && !this.getAgentState().equals((Object)ILifecycle.LifecycleStates.STARTING)) {
                try {
                    this.start();
                }
                catch (LifecycleException e) {
                    e.printStackTrace();
                }
            }
            if (id.equals(this.stopTimeId) && !this.getAgentState().equals((Object)ILifecycle.LifecycleStates.STOPPED) && !this.getAgentState().equals((Object)ILifecycle.LifecycleStates.STOPPING)) {
                try {
                    this.stop();
                }
                catch (LifecycleException e) {
                    e.printStackTrace();
                }
            }
            if (id.equals(this.autoExecTimeId) && this.getAgentState().equals((Object)ILifecycle.LifecycleStates.STARTED)) {
                if (!this.execution.getAutoExecutionType() && this.singleExecutionsDone) {
                    return;
                }
                if (this.execution.getAutoExecutionServices() != null) {
                    for (String serviceName : this.execution.getAutoExecutionServices()) {
                        Action service = (Action)this.memory.read((Object)new Action(serviceName));
                        if (service != null) {
                            if (this.log.isInfoEnabled()) {
                                this.log.info((Object)("Autoexecuting action: " + service));
                            }
                            DoAction doAct = service.createDoAction(new Serializable[0], null);
                            doAct.getSession().setOriginalService(serviceName);
                            doAct.getSession().setOriginalProvider(this.getOwner());
                            doAct.getSession().setOriginalUser(this.getOwner());
                            this.memory.write((Object)doAct);
                            continue;
                        }
                        this.log.warn((Object)("Could not find action for autoExecution: " + serviceName));
                    }
                    this.singleExecutionsDone = true;
                }
                if (this.execution.getAutoExecutionType()) {
                    try {
                        if (this.autoExecTimeId != null) {
                            this.timerClient.removeNotification(this.autoExecTimeId);
                        }
                        this.autoExecTimeId = this.timerClient.addNotification(null, null, null, new Date(System.currentTimeMillis() + 30000L));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InstanceNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public final List<String> getAutoExecutionServices() {
        if (this.execution != null) {
            return this.execution.getAutoExecutionServices();
        }
        return null;
    }

    public final boolean getAutoExecutionType() {
        if (this.execution != null) {
            return this.execution.getAutoExecutionType();
        }
        return false;
    }

    public final void setAutoExecutionServices(List<String> actionIds) {
        if (this.execution != null) {
            ArrayList oldActionIds = null;
            if (this.execution.getAutoExecutionServices() != null) {
                oldActionIds = new ArrayList();
                oldActionIds.addAll(this.execution.getAutoExecutionServices());
            }
            this.execution.setAutoExecutionServices(actionIds);
            this.sendAttributeChangeNotification("autoExecutionServices", "java.util.ArrayList<java.lang.String>", oldActionIds, actionIds);
        }
    }

    public final void setAutoExecutionType(boolean continous) {
        if (this.execution != null) {
            boolean oldValue = this.execution.getAutoExecutionType();
            this.execution.setAutoExecutionType(continous);
            this.sendAttributeChangeNotification("autoExecutionType", "java.lang.boolean", oldValue, continous);
        }
    }

    public final byte[] getSpringConfigXml() {
        if (this.springConfigXml != null) {
            return Arrays.copyOf(this.springConfigXml, this.springConfigXml.length);
        }
        return this.springConfigXml;
    }

    public final void setSpringConfigXml(byte[] springConfig) {
        this.springConfigXml = springConfig != null ? Arrays.copyOf(springConfig, springConfig.length) : springConfig;
    }

    public final IDirectory getDirectory() {
        return this.directory;
    }

    public final void setDirectory(IDirectory newDirectory) {
        this.directory = newDirectory;
    }

    public final void deregisterAction(IActionDescription actionDescription) {
        if (this.directory != null) {
            this.directory.deregisterAction(actionDescription);
        }
    }

    public final void modifyAction(IActionDescription oldDescription, IActionDescription newDescription) {
        if (this.directory != null) {
            this.directory.modifyAction(oldDescription, newDescription);
        }
    }

    public final void registerAction(IActionDescription actionDescription) {
        if (this.directory != null) {
            this.directory.registerAction(actionDescription);
        } else {
            this.log.warn((Object)"Agent has no reference to directory.");
        }
    }

    public final IActionDescription searchAction(IActionDescription template) {
        if (this.directory != null) {
            return this.directory.searchAction(template);
        }
        return null;
    }

    public final List<IActionDescription> searchAllActions(IActionDescription template) {
        if (this.directory != null) {
            return this.directory.searchAllActions(template);
        }
        this.log.warn((Object)"no directory found, returning empty list...");
        return new ArrayList<IActionDescription>();
    }

    public final void deregisterAgent(String aid) {
        if (this.directory != null) {
            this.directory.deregisterAgent(aid);
        }
    }

    public final void modifyAgent(IAgentDescription agentDescription) {
        if (this.directory != null) {
            this.directory.modifyAgent(agentDescription);
        }
    }

    public final void registerAgent(IAgentDescription agentDescription) {
        if (this.directory != null) {
            this.directory.registerAgent(agentDescription);
        }
    }

    public final IAgentDescription searchAgent(IAgentDescription template) {
        if (this.directory != null) {
            return this.directory.searchAgent(template);
        }
        return null;
    }

    public final List<IAgentDescription> searchAllAgents(IAgentDescription template) {
        if (this.directory != null) {
            return this.directory.searchAllAgents(template);
        }
        return null;
    }
}

