/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore;

import de.dailab.jiactng.Version;
import de.dailab.jiactng.agentcore.AbstractAgentNodeBean;
import de.dailab.jiactng.agentcore.Agent;
import de.dailab.jiactng.agentcore.IAgent;
import de.dailab.jiactng.agentcore.IAgentBean;
import de.dailab.jiactng.agentcore.IAgentNode;
import de.dailab.jiactng.agentcore.IAgentNodeBean;
import de.dailab.jiactng.agentcore.SimpleAgentNodeMBean;
import de.dailab.jiactng.agentcore.conf.GenericAgentProperties;
import de.dailab.jiactng.agentcore.directory.IDirectory;
import de.dailab.jiactng.agentcore.lifecycle.AbstractLifecycle;
import de.dailab.jiactng.agentcore.lifecycle.ILifecycleListener;
import de.dailab.jiactng.agentcore.lifecycle.LifecycleEvent;
import de.dailab.jiactng.agentcore.lifecycle.LifecycleException;
import de.dailab.jiactng.agentcore.management.Manager;
import de.dailab.jiactng.agentcore.management.jmx.JmxManager;
import de.dailab.jiactng.agentcore.util.IdFactory;
import de.dailab.jiactng.agentcore.util.jar.JAR;
import de.dailab.jiactng.agentcore.util.jar.JARClassLoader;
import de.dailab.jiactng.agentcore.util.jar.JARMemory;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.management.AttributeChangeNotification;
import javax.management.remote.JMXServiceURL;
import javax.management.timer.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Appender;
import org.apache.log4j.net.SocketAppender;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Log4jConfigurer;

public class SimpleAgentNode
extends AbstractLifecycle
implements IAgentNode,
InitializingBean,
BeanNameAware,
SimpleAgentNodeMBean {
    private ExecutorService threadPool = null;
    private String loggingConfig;
    protected String uuid = null;
    protected String name = null;
    private final ArrayList<IAgentNodeBean> agentNodeBeans;
    private final ArrayList<IAgent> agents;
    private HashMap<String, Future<?>> agentFutures = null;
    private Set<Map<String, Object>> jmxConnectors = null;
    private IDirectory directory = null;
    private Timer timer = null;
    private Set<JMXServiceURL> jmxURLs = null;
    private Thread shutdownhook = new Thread(){

        @Override
        public void run() {
            System.out.println("\nShutting down agent node '" + SimpleAgentNode.this.getName() + "'...");
            try {
                SimpleAgentNode.this.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public static void main(String[] args) {
        System.setProperty("log4j.configuration", "jiactng_log4j.properties");
        System.setProperty("spring.rootconfigfile", args[0]);
        new ClassPathXmlApplicationContext(args[0]);
    }

    public SimpleAgentNode() {
        this.uuid = IdFactory.createAgentNodeId((int)this.hashCode());
        this.setLog(LogFactory.getLog((String)this.uuid));
        this.agentNodeBeans = new ArrayList();
        this.agents = new ArrayList();
        this.timer = new Timer();
        this.timer.start();
    }

    public final void setJmxConnectors(Set<Map<String, Object>> newJmxConnectors) {
        this.jmxConnectors = newJmxConnectors;
    }

    public final Set<Map<String, Object>> getJmxConnectors() {
        return this.jmxConnectors;
    }

    public final void setAgents(List<IAgent> newAgents) {
        String owner = this.getOwner();
        for (IAgent agent : newAgents) {
            if (agent.getOwner() == null) {
                agent.setOwner(owner);
            }
            if (this.directory == null) continue;
            agent.addLifecycleListener((ILifecycleListener)this.directory);
        }
        this.agents.clear();
        this.agents.addAll(newAgents);
    }

    public final void setGenericAgents(List<GenericAgentProperties> agentProps) {
        if (agentProps != null && agentProps.size() > 0) {
            ArrayList<IAgent> genericAgents = new ArrayList<IAgent>();
            for (GenericAgentProperties gap : agentProps) {
                ClassPathXmlApplicationContext cpxac = new ClassPathXmlApplicationContext(gap.getAgentConfig());
                if (cpxac != null && cpxac.containsBeanDefinition(gap.getAgentBeanName())) {
                    for (int i = 1; i <= gap.getCount(); ++i) {
                        IAgent newAgent = (IAgent)cpxac.getBean(gap.getAgentBeanName());
                        newAgent.setAgentName(gap.createAgentName(i));
                        genericAgents.add(newAgent);
                    }
                    continue;
                }
                System.out.println(new StringBuffer("could not create xmlapplicationcontext from ").append(gap.getAgentConfig()).append(" or agentbean definition does not exist, beanname is: ").append(gap.getAgentBeanName()));
            }
            this.agents.addAll(genericAgents);
        } else {
            System.out.println("nothing to do - GenericAgentProperties list is null or empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addAgent(IAgent agent) {
        agent.setAgentNode((IAgentNode)this);
        List<String> oldAgentList = this.getAgents();
        ArrayList<IAgent> arrayList = this.agents;
        synchronized (arrayList) {
            this.agents.add(agent);
        }
        agent.addLifecycleListener(this.lifecycle.createLifecycleListener());
        if (this.directory != null) {
            agent.addLifecycleListener((ILifecycleListener)this.directory);
            ((Agent)agent).setDirectory(this.directory);
        }
        agent.enableManagement(this._manager);
        this.agentListChanged(oldAgentList, this.getAgents());
    }

    public final void removeAgent(IAgent agent) {
        agent.disableManagement();
        List<String> oldAgentList = this.getAgents();
        this.agents.remove(agent);
        this.agentListChanged(oldAgentList, this.getAgents());
    }

    private void agentListChanged(List<String> oldAgentList, List<String> newAgentList) {
        AttributeChangeNotification n = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Agents changed", "Agents", "java.util.ArrayList<java.lang.String>", oldAgentList, newAgentList);
        this.sendNotification(n);
    }

    public final List<IAgent> findAgents() {
        return Collections.unmodifiableList(this.agents);
    }

    public Log getLog(IAgentNodeBean nodeBean) {
        return LogFactory.getLog((String)(this.getUUID() + "." + nodeBean.getBeanName()));
    }

    public Log getLog(IAgent agent) {
        return LogFactory.getLog((String)(this.getUUID() + "." + agent.getAgentId()));
    }

    public Log getLog(IAgent agent, IAgentBean bean) {
        return LogFactory.getLog((String)(this.getUUID() + "." + agent.getAgentId() + "." + bean.getBeanName()));
    }

    public Log getLog(IAgent agent, IAgentBean bean, String extension) {
        return LogFactory.getLog((String)(this.getUUID() + "." + agent.getAgentId() + "." + bean.getBeanName() + "." + extension));
    }

    public String getJiacVersion() {
        return "JIAC TNG " + Version.getName() + " version " + Version.getNumber() + " (" + Version.getTimestamp() + ")";
    }

    public String getJiacVendor() {
        return "DAI-Labor, TU Berlin";
    }

    public final String getUUID() {
        return this.uuid;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String newName) {
        this.name = newName;
    }

    public final String getHost() throws UnknownHostException {
        return InetAddress.getLocalHost().toString();
    }

    public String getOwner() {
        return System.getProperty("user.name");
    }

    public final List<String> getAgents() {
        ArrayList<String> result = new ArrayList<String>();
        for (IAgent a : this.agents) {
            result.add(a.getAgentId());
        }
        return result;
    }

    public final List<String> addAgents(byte[] configuration, List<JARMemory> libraries, String owner) throws Exception {
        JARClassLoader cl = new JARClassLoader();
        for (JARMemory jar : libraries) {
            cl.addJAR((JAR)jar);
        }
        GenericApplicationContext appContext = new GenericApplicationContext();
        appContext.setClassLoader((ClassLoader)cl);
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
        xmlReader.loadBeanDefinitions((Resource)new ByteArrayResource(configuration));
        appContext.refresh();
        ArrayList<String> agentIds = new ArrayList<String>();
        Collection newAgents = appContext.getBeansOfType(IAgent.class).values();
        for (Object a : newAgents) {
            IAgent agent = (IAgent)a;
            agent.setOwner(owner);
            agent.setSpringConfigXml(configuration);
            this.addAgent(agent);
            agentIds.add(agent.getAgentId());
        }
        return agentIds;
    }

    public void setBeanName(String newName) {
        this.setName(newName);
    }

    public void onEvent(LifecycleEvent evt) {
        Object source = evt.getSource();
        if (this.agents.contains(source)) {
            IAgent agent = (IAgent)source;
            switch (evt.getState()) {
                case STARTED: {
                    Future<?> f1 = this.threadPool.submit((Runnable)agent);
                    this.agentFutures.put(agent.getAgentName(), f1);
                    break;
                }
                case STOPPED: {
                    Future<?> f2 = this.agentFutures.get(agent.getAgentName());
                    if (f2 == null) {
                        new LifecycleException("Agentfuture not found").printStackTrace();
                        break;
                    }
                    if (f2.cancel(false) || f2.isDone()) break;
                    this.log.warn((Object)("Agent " + agent.getAgentName() + " did not respond then stopping. Thread is forcecanceled."));
                    f2.cancel(true);
                }
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        Runtime.getRuntime().addShutdownHook(this.shutdownhook);
        this.addLifecycleListener((ILifecycleListener)this);
        for (IAgent a : this.agents) {
            a.setAgentNode((IAgentNode)this);
            a.addLifecycleListener(this.lifecycle.createLifecycleListener());
        }
        for (IAgentNodeBean nodeBean : this.agentNodeBeans) {
            nodeBean.setAgentNode((IAgentNode)this);
            nodeBean.addLifecycleListener(this.lifecycle.createLifecycleListener());
        }
        this.enableManagement((Manager)new JmxManager());
        this.init();
        this.start();
    }

    public void shutdown() throws LifecycleException {
        if (!this.shutdownhook.isAlive()) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownhook);
        }
        this.stop();
        this.cleanup();
        while (!this.agents.isEmpty()) {
            this.removeAgent(this.agents.get(this.agents.size() - 1));
        }
        this.disableManagement();
        this.agentNodeBeans.clear();
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.log.info((Object)("AgentNode " + this.getName() + " has been closed."));
    }

    @Override
    public void doInit() {
        this.threadPool = Executors.newCachedThreadPool();
        this.agentFutures = new HashMap();
        if (this.agentNodeBeans != null) {
            block4: for (IAgentNodeBean anb : this.agentNodeBeans) {
                try {
                    this.log.info((Object)("Trying to initialize agentnodebean: " + anb.getBeanName()));
                    anb.init();
                }
                catch (LifecycleException lce) {
                    this.log.error((Object)("Failure when initializing agentnodebean: " + anb.getBeanName()), (Throwable)lce);
                }
                if (this.directory != null) continue;
                for (IAgentNodeBean agentNodeBean : this.getAgentNodeBeans()) {
                    if (!(agentNodeBean instanceof IDirectory)) continue;
                    this.directory = (IDirectory)agentNodeBean;
                    continue block4;
                }
            }
        }
        for (IAgent a : this.agents) {
            if (this.directory != null) {
                a.addLifecycleListener((ILifecycleListener)this.directory);
                if (a instanceof Agent) {
                    ((Agent)a).setDirectory(this.directory);
                }
            }
            this.log.info((Object)("Initializing agent: " + a.getAgentName()));
            try {
                this.log.info((Object)("Trying to initialize agent: " + a.getAgentName()));
                a.init();
            }
            catch (LifecycleException e) {
                this.log.error((Object)("Failure when initializing agent: " + a.getAgentName()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStart() {
        if (this.agentNodeBeans != null) {
            for (IAgentNodeBean anb : this.agentNodeBeans) {
                try {
                    this.log.info((Object)("Trying to start agentnodebean: " + anb.getBeanName()));
                    anb.start();
                }
                catch (LifecycleException lce) {
                    lce.printStackTrace();
                }
            }
        }
        ArrayList<IAgent> arrayList = this.agents;
        synchronized (arrayList) {
            for (IAgent a : this.agents) {
                try {
                    if (((Agent)a).getStartTime() == null) {
                        this.log.info((Object)("Trying to start agent: " + a.getAgentName()));
                        a.start();
                        continue;
                    }
                    this.log.info((Object)("Agent has a startTime and is not started now: " + a.getAgentName()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.log.info((Object)("AgentNode " + this.getName() + " started with " + this.agents.size() + " agents"));
    }

    @Override
    public void doStop() {
        for (IAgent a : this.agents) {
            try {
                this.log.info((Object)("Trying to stop agent: " + a.getAgentName()));
                a.stop();
            }
            catch (LifecycleException e) {
                e.printStackTrace();
            }
        }
        if (this.agentNodeBeans != null) {
            for (int i = this.agentNodeBeans.size() - 1; i >= 0; --i) {
                IAgentNodeBean anb = this.agentNodeBeans.get(i);
                try {
                    this.log.info((Object)("Trying to stop agentnodebean: " + anb.getBeanName()));
                    anb.stop();
                    continue;
                }
                catch (LifecycleException lce) {
                    lce.printStackTrace();
                }
            }
        }
    }

    @Override
    public void doCleanup() {
        for (IAgent a : this.agents) {
            try {
                this.log.info((Object)("Trying to cleanup agent: " + a.getAgentName()));
                a.cleanup();
            }
            catch (LifecycleException e) {
                e.printStackTrace();
            }
        }
        if (this.agentNodeBeans != null) {
            for (int i = this.agentNodeBeans.size() - 1; i >= 0; --i) {
                IAgentNodeBean anb = this.agentNodeBeans.get(i);
                try {
                    this.log.info((Object)("Trying to cleanup agentnodebean: " + anb.getBeanName()));
                    anb.cleanup();
                    continue;
                }
                catch (LifecycleException lce) {
                    lce.printStackTrace();
                }
            }
        }
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }

    public String toString() {
        return this.getName();
    }

    public final ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public final List<IAgentNodeBean> getAgentNodeBeans() {
        return Collections.unmodifiableList(this.agentNodeBeans);
    }

    public final List<String> getAgentNodeBeanClasses() {
        ArrayList<String> ret = new ArrayList<String>();
        for (IAgentNodeBean bean : this.getAgentNodeBeans()) {
            ret.add(bean.getClass().getName());
        }
        return ret;
    }

    public final void setAgentNodeBeans(List<IAgentNodeBean> agentnodebeans) {
        this.agentNodeBeans.clear();
        this.agentNodeBeans.addAll(agentnodebeans);
    }

    public final String getLoggingConfig() {
        return this.loggingConfig;
    }

    public final void setLoggingConfig(String newLoggingConfig) {
        this.loggingConfig = newLoggingConfig;
        try {
            Log4jConfigurer.initLogging((String)newLoggingConfig);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
    }

    public void setAuthorizationPolicyFilename(String filename) {
        System.setProperty("java.security.policy", filename);
        System.setSecurityManager(new SecurityManager());
    }

    public final void addLog4JSocketAppender(String address, int port) {
        System.out.println("Add socket appender for " + address + ":" + port + " ...");
        SocketAppender appender = new SocketAppender(address, port);
        appender.setName(address + ":" + port);
        ((Log4JLogger)this.log).getLogger().addAppender((Appender)appender);
        System.out.println("Socket appender added.");
    }

    public final void removeLog4JSocketAppender(String address, int port) {
        System.out.println("Remove socket appender for " + address + ":" + port + " ...");
        ((Log4JLogger)this.log).getLogger().removeAppender(address + ":" + port);
        System.out.println("Socket appender removed.");
    }

    public final String getDirectoryName() {
        if (this.directory != null && this.directory instanceof AbstractAgentNodeBean) {
            return ((AbstractAgentNodeBean)this.directory).getBeanName();
        }
        return null;
    }

    public final Set<JMXServiceURL> getJmxURLs() {
        return this.jmxURLs;
    }

    @Override
    public void enableManagement(Manager manager) {
        if (this.isManagementEnabled()) {
            return;
        }
        try {
            manager.registerAgentNode((IAgentNode)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("WARNING: Unable to register agent node " + this.getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
        try {
            manager.registerAgentNodeResource((IAgentNode)this, "Timer", (Object)this.timer);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("WARNING: Unable to register timer of agent node " + this.getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
        if (this.agentNodeBeans != null) {
            for (IAgentNodeBean anb : this.agentNodeBeans) {
                anb.enableManagement(manager);
            }
        }
        for (IAgent a : this.agents) {
            a.enableManagement(manager);
        }
        if (this.jmxConnectors != null && manager instanceof JmxManager) {
            this.jmxURLs = ((JmxManager)manager).enableRemoteManagement((IAgentNode)this);
        }
        super.enableManagement(manager);
    }

    @Override
    public void disableManagement() {
        if (!this.isManagementEnabled()) {
            return;
        }
        this._manager.disableRemoteManagement((IAgentNode)this);
        for (IAgent a : this.agents) {
            a.disableManagement();
        }
        for (IAgentNodeBean anb : this.agentNodeBeans) {
            anb.disableManagement();
        }
        try {
            this._manager.unregisterAgentNodeResource((IAgentNode)this, "Timer");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("WARNING: Unable to deregister timer of agent node " + this.getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
        try {
            this._manager.unregisterAgentNode((IAgentNode)this);
        }
        catch (Exception e) {
            System.err.println("WARNING: Unable to deregister agent node " + this.getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
        super.disableManagement();
    }
}

