/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.action;

import de.dailab.jiactng.agentcore.AbstractAgentBean;
import de.dailab.jiactng.agentcore.action.AbstractActionAuthorizationBeanMBean;
import de.dailab.jiactng.agentcore.action.Action;
import de.dailab.jiactng.agentcore.action.ActionResult;
import de.dailab.jiactng.agentcore.action.DoAction;
import de.dailab.jiactng.agentcore.environment.IEffector;
import de.dailab.jiactng.agentcore.environment.ResultReceiver;
import de.dailab.jiactng.agentcore.lifecycle.ILifecycle;
import de.dailab.jiactng.agentcore.ontology.IActionDescription;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractActionAuthorizationBean
extends AbstractAgentBean
implements IEffector,
ResultReceiver,
AbstractActionAuthorizationBeanMBean {
    private String authorizationActionName = null;
    private Action authorizationAction = null;
    private HashMap<String, DoAction> doActionAuthorizations = new HashMap();

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (this.authorizationActionName != null) {
            List foundActs = this.thisAgent.searchAllActions((IActionDescription)new Action(this.authorizationActionName));
            if (foundActs != null && foundActs.size() >= 1) {
                this.authorizationAction = (Action)foundActs.get(0);
            } else {
                this.log.error((Object)("Authorization action not found: " + this.authorizationActionName));
            }
        }
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        this.authorizationAction = null;
    }

    public String getAuthorizationActionName() {
        return this.authorizationActionName;
    }

    public void setAuthorizationActionName(String newAuthorizationActionName) {
        String oldName = this.authorizationActionName;
        this.authorizationActionName = newAuthorizationActionName;
        this.authorizationAction = null;
        if (this.thisAgent != null && ILifecycle.LifecycleStates.STARTED.equals((Object)this.thisAgent.getState())) {
            List foundActs = this.thisAgent.searchAllActions((IActionDescription)new Action(newAuthorizationActionName));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("FOUND: " + foundActs));
            }
            if (foundActs != null && foundActs.size() >= 1) {
                this.authorizationAction = (Action)foundActs.get(0);
            } else {
                this.log.error((Object)("Authorization action not found: " + newAuthorizationActionName));
            }
        }
        this.sendAttributeChangeNotification("authorizationActionName", "java.lang.String", oldName, this.authorizationActionName);
    }

    protected Action getAuthorizationAction() {
        return this.authorizationAction;
    }

    public void receiveResult(ActionResult result) {
        block10: {
            DoAction doAction = this.doActionAuthorizations.remove(result.getSessionId());
            if (doAction != null) {
                Serializable[] results = result.getResults();
                if (results != null) {
                    if (results.length == 1) {
                        try {
                            if ((String)((Object)results[0]) != null) {
                                try {
                                    doAction.getSession().setOriginalUser((String)((Object)results[0]));
                                    this.doAction(doAction);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                break block10;
                            }
                            this.returnFailure(doAction, (Serializable)((Object)"Not authorized"));
                        }
                        catch (ClassCastException e) {
                            this.log.error((Object)"Got wrong type of authorization results");
                            this.returnFailure(doAction, (Serializable)((Object)"Unable to authorize"));
                        }
                    } else {
                        this.log.error((Object)"Got wrong number of authorization results");
                        this.returnFailure(doAction, (Serializable)((Object)"Unable to authorize"));
                    }
                } else {
                    this.log.error((Object)"Authorization action failed");
                    this.returnFailure(doAction, (Serializable)((Object)"Unable to authorize"));
                }
            }
        }
    }

    public final void authorize(DoAction doAction) throws Exception {
        if (this.authorizationActionName == null) {
            this.doAction(doAction);
        } else if (this.authorizationAction == null) {
            this.returnFailure(doAction, (Serializable)((Object)"Unable to authorize"));
        } else if (doAction.getSession() == null || doAction.getSession().getUserToken() == null) {
            this.returnFailure(doAction, (Serializable)((Object)"Unknown user token"));
        } else {
            String sessionId = this.invoke((IActionDescription)this.authorizationAction, doAction.getSession(), new Serializable[]{doAction.getSession().getUserToken(), doAction.getAction()}, this);
            this.doActionAuthorizations.put(sessionId, doAction);
        }
    }
}

