/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.action;

import de.dailab.jiactng.agentcore.action.AbstractActionAuthorizationBean;
import de.dailab.jiactng.agentcore.action.AbstractMethodExposingBeanMBean;
import de.dailab.jiactng.agentcore.action.Action;
import de.dailab.jiactng.agentcore.action.DoAction;
import de.dailab.jiactng.agentcore.action.IMethodExposingBean;
import de.dailab.jiactng.agentcore.action.scope.ActionScope;
import de.dailab.jiactng.agentcore.environment.IEffector;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public abstract class AbstractMethodExposingBean
extends AbstractActionAuthorizationBean
implements IMethodExposingBean,
AbstractMethodExposingBeanMBean {
    private static final Class<?>[] EMPTY_CLASSES = new Class[0];
    protected static final char METHOD_SEPARATING_CHAR = '#';

    static String getName(Method method) {
        String name = method.getAnnotation(IMethodExposingBean.Expose.class).name();
        if (name.length() == 0) {
            name = method.getDeclaringClass().getName() + '#' + method.getName();
        }
        return name;
    }

    static ActionScope getScope(Method method) {
        ActionScope scope = method.getAnnotation(IMethodExposingBean.Expose.class).scope();
        return scope;
    }

    static Class<?>[] getReturnTypes(Method method) {
        Class<?>[] returnTypes;
        IMethodExposingBean.Expose expAnno = method.getAnnotation(IMethodExposingBean.Expose.class);
        Class<?> returnType = method.getReturnType();
        if (returnType.isArray()) {
            Class[] classArray;
            if (expAnno.returnTypes().length > 0) {
                classArray = expAnno.returnTypes();
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = returnType;
            }
            returnTypes = classArray;
        } else {
            Class<?>[] classArray;
            if (returnType == Void.TYPE) {
                classArray = EMPTY_CLASSES;
            } else {
                Class[] classArray3 = new Class[1];
                classArray = classArray3;
                classArray3[0] = returnType;
            }
            returnTypes = classArray;
        }
        return returnTypes;
    }

    static ArrayList<Method> getExposedPublicMethods(Class<? extends AbstractMethodExposingBean> clazz) {
        HashSet<Class> processed = new HashSet<Class>();
        LinkedList nextStep = new LinkedList();
        ArrayList<Method> methods = new ArrayList<Method>();
        nextStep.offer(clazz);
        do {
            Class current;
            if (!processed.add(current = (Class)nextStep.poll())) continue;
            for (Method method : current.getDeclaredMethods()) {
                int modifiers = method.getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                if (method.isAnnotationPresent(IMethodExposingBean.Expose.class)) {
                    boolean insert = true;
                    for (Method collected : methods) {
                        if (!AbstractMethodExposingBean.equalsPublicMethod(collected, method)) continue;
                        insert = false;
                        break;
                    }
                    if (insert) {
                        methods.add(method);
                    }
                }
                if (current.getSuperclass() != null && current.getSuperclass() != AbstractMethodExposingBean.class) {
                    nextStep.offer(current.getSuperclass());
                }
                for (Class<?> superIntfc : current.getInterfaces()) {
                    nextStep.offer(superIntfc);
                }
            }
        } while (nextStep.size() > 0);
        return methods;
    }

    static boolean equalsPublicMethod(Method a, Method b) {
        Class<?>[] bParams;
        if (!a.getName().equals(b.getName())) {
            return false;
        }
        Class<?>[] aParams = a.getParameterTypes();
        if (aParams.length != (bParams = b.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < aParams.length; ++i) {
            if (aParams[i].equals(bParams[i])) continue;
            return false;
        }
        return true;
    }

    public final void doAction(DoAction doAction) throws Exception {
        Action action;
        Method method;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("typechecking is '" + doAction.typeCheck() + "'"));
        }
        if ((method = this.searchMethod((action = (Action)doAction.getAction()).getName(), action.getInputTypes())) != null) {
            Serializable result = (Serializable)method.invoke((Object)this, (Object[])doAction.getParams());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"action processed and about to write result...");
            }
            if (method.getReturnType() != Void.TYPE) {
                this.memory.write((Object)action.createActionResult(doAction, new Serializable[]{result}));
            } else {
                this.memory.write((Object)action.createActionResult(doAction, new Serializable[0]));
            }
            return;
        }
        this.log.debug((Object)"did not found exposed method -> call overrideDoAction");
        this.overrideDoAction(doAction);
    }

    public final List<? extends Action> getActions() {
        ArrayList<? extends Action> actions = new ArrayList<Action>();
        for (Method method : AbstractMethodExposingBean.getExposedPublicMethods(this.getClass())) {
            Class<?>[] returnTypes = AbstractMethodExposingBean.getReturnTypes(method);
            String name = AbstractMethodExposingBean.getName(method);
            ActionScope scope = AbstractMethodExposingBean.getScope(method);
            Action act = new Action(name, (IEffector)this, method.getParameterTypes(), returnTypes);
            act.setScope(scope);
            actions.add(act);
        }
        actions.addAll(this.overrideGetActions());
        return actions;
    }

    protected void overrideDoAction(DoAction doAction) throws Exception {
        throw new Exception("No implementation of overrideDoAction in " + this.getClass().getName());
    }

    protected List<? extends Action> overrideGetActions() {
        return Collections.emptyList();
    }

    private Method searchMethod(String name, List<Class<?>> parameters) {
        String originalName = name;
        String assumedMethodName = null;
        int sep = name.indexOf(35);
        if (sep > 0 && sep < name.length() - 1) {
            assumedMethodName = name.substring(sep + 1);
        }
        for (Method method : AbstractMethodExposingBean.getExposedPublicMethods(this.getClass())) {
            IMethodExposingBean.Expose exposeAnno = method.getAnnotation(IMethodExposingBean.Expose.class);
            List<Class<?>> mpar = Arrays.asList(method.getParameterTypes());
            if (mpar.size() != parameters.size() || !exposeAnno.name().equals(originalName) && (assumedMethodName == null || !method.getName().equals(assumedMethodName)) || !((Object)mpar).equals(parameters)) continue;
            return method;
        }
        return null;
    }

    public TabularData getActionList() {
        List<? extends Action> actions = this.getActions();
        if (actions.isEmpty()) {
            return null;
        }
        try {
            String[] itemNames = new String[]{"Name", "InputTypes", "ResultTypes", "ProviderBean"};
            OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, new ArrayType(1, SimpleType.STRING), new ArrayType(1, SimpleType.STRING), SimpleType.STRING};
            CompositeType rowType = new CompositeType(actions.get(0).getClass().getName(), "provided action", itemNames, itemNames, itemTypes);
            TabularType tabularType = new TabularType(actions.getClass().getName(), "list of provided actions", rowType, new String[]{"Name", "InputTypes"});
            TabularDataSupport actionList = new TabularDataSupport(tabularType);
            for (Action action : actions) {
                String[] inputTypeList = action.getInputTypeNames() == null ? null : action.getInputTypeNames().toArray(new String[action.getInputTypeNames().size()]);
                String[] resultTypeList = action.getResultTypeNames() == null ? null : action.getResultTypeNames().toArray(new String[action.getResultTypeNames().size()]);
                Object[] itemValues = new Object[]{action.getName(), inputTypeList, resultTypeList, action.getProviderBean().getBeanName()};
                CompositeDataSupport value = new CompositeDataSupport(rowType, itemNames, itemValues);
                actionList.put(value);
            }
            return actionList;
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }
}

