/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.action;

import de.dailab.jiactng.agentcore.action.ActionResult;
import de.dailab.jiactng.agentcore.action.DoAction;
import de.dailab.jiactng.agentcore.action.Session;
import de.dailab.jiactng.agentcore.action.scope.ActionScope;
import de.dailab.jiactng.agentcore.environment.IEffector;
import de.dailab.jiactng.agentcore.environment.ResultReceiver;
import de.dailab.jiactng.agentcore.ontology.AgentDescription;
import de.dailab.jiactng.agentcore.ontology.IActionDescription;
import de.dailab.jiactng.agentcore.ontology.IAgentDescription;
import de.dailab.jiactng.agentcore.util.EqualityChecker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class Action
implements IActionDescription {
    private static final long serialVersionUID = 2416102010976263587L;
    private String name;
    private transient IEffector providerBean;
    private List<String> inputTypeNames;
    private List<String> resultTypeNames;
    private IAgentDescription providerDescription;
    private ActionScope scope;

    public Action() {
        this(null, null, null, null, null);
    }

    public Action(String name) {
        this(name, null, null, null, null);
    }

    public Action(String name, IEffector providerBean, Class<?>[] inputTypes, Class<?>[] resultTypes) {
        this(name, providerBean, inputTypes != null ? Arrays.asList(inputTypes) : null, resultTypes != null ? Arrays.asList(resultTypes) : null);
    }

    public Action(String name, IEffector providerBean, List<Class<?>> inputTypes, List<Class<?>> resultTypes) {
        this(name, providerBean, inputTypes, resultTypes, ActionScope.AGENT);
    }

    public Action(String name, IEffector providerBean, List<Class<?>> inputTypes, List<Class<?>> resultTypes, ActionScope scope) {
        this.setName(name);
        this.setProviderBean(providerBean);
        this.setInputTypes(inputTypes);
        this.setResultTypes(resultTypes);
        this.setScope(scope);
    }

    public Action(Action action) {
        this.name = action.getName();
        this.providerBean = action.getProviderBean();
        this.scope = action.getScope();
        this.inputTypeNames = action.getInputTypeNames();
        this.resultTypeNames = action.getResultTypeNames();
    }

    public Action(CompositeData descr) {
        CompositeData provider;
        this.name = (String)descr.get("name");
        this.inputTypeNames = Arrays.asList((String[])descr.get("input types"));
        this.resultTypeNames = Arrays.asList((String[])descr.get("result types"));
        String actionScope = (String)descr.get("scope");
        if (actionScope != null) {
            this.scope = ActionScope.valueOf((String)actionScope);
        }
        if ((provider = (CompositeData)descr.get("agent")) != null) {
            this.providerDescription = new AgentDescription(provider);
        }
    }

    public final DoAction createDoAction(Serializable[] newParams, ResultReceiver source) {
        return new DoAction((IActionDescription)this, source, newParams);
    }

    public final DoAction createDoAction(Serializable[] newParams, ResultReceiver source, Long timeToLive) {
        return new DoAction((IActionDescription)this, source, newParams, timeToLive.longValue());
    }

    public final DoAction createDoAction(Session parent, Serializable[] newParams, ResultReceiver source) {
        return new DoAction(parent, (IActionDescription)this, source, newParams);
    }

    public final ActionResult createActionResult(DoAction source, Serializable[] results) {
        ActionResult ret = new ActionResult(source, results);
        ret.setMetaData(source.getMetaData());
        return ret;
    }

    public final String getName() {
        return this.name;
    }

    public final List<String> getInputTypeNames() {
        return this.inputTypeNames;
    }

    public final List<Class<?>> getInputTypes() throws ClassNotFoundException {
        if (this.inputTypeNames != null) {
            ArrayList list = new ArrayList();
            for (String type : this.inputTypeNames) {
                list.add(this.getClassForName(type));
            }
            return list;
        }
        return null;
    }

    public final IEffector getProviderBean() {
        return this.providerBean;
    }

    public final IAgentDescription getProviderDescription() {
        return this.providerDescription;
    }

    public final List<String> getResultTypeNames() {
        return this.resultTypeNames;
    }

    public final List<Class<?>> getResultTypes() throws ClassNotFoundException {
        if (this.resultTypeNames != null) {
            ArrayList list = new ArrayList();
            for (String type : this.resultTypeNames) {
                list.add(this.getClassForName(type));
            }
            return list;
        }
        return null;
    }

    public final void setName(String newName) {
        this.name = newName;
    }

    public final void setInputTypeNames(List<String> newInputTypeNames) {
        if (newInputTypeNames != null) {
            ArrayList<String> copy = new ArrayList<String>();
            copy.addAll(newInputTypeNames);
            this.inputTypeNames = Collections.unmodifiableList(copy);
        } else {
            this.inputTypeNames = null;
        }
    }

    public final void setInputTypes(List<Class<?>> newInputTypes) {
        if (newInputTypes != null) {
            ArrayList<String> copy = new ArrayList<String>();
            for (Class<?> type : newInputTypes) {
                copy.add(type.getName());
            }
            this.inputTypeNames = Collections.unmodifiableList(copy);
        } else {
            this.inputTypeNames = null;
        }
    }

    public final void setProviderBean(IEffector newProviderBean) {
        this.providerBean = newProviderBean;
    }

    public final void setProviderDescription(IAgentDescription newProviderDescription) {
        this.providerDescription = newProviderDescription;
    }

    public final void setResultTypeNames(List<String> newResultTypeNames) {
        if (newResultTypeNames != null) {
            ArrayList<String> copy = new ArrayList<String>();
            copy.addAll(newResultTypeNames);
            this.resultTypeNames = Collections.unmodifiableList(copy);
        } else {
            this.resultTypeNames = null;
        }
    }

    public final void setResultTypes(List<Class<?>> newResultTypes) {
        if (newResultTypes != null) {
            ArrayList<String> copy = new ArrayList<String>();
            for (Class<?> type : newResultTypes) {
                copy.add(type.getName());
            }
            this.resultTypeNames = Collections.unmodifiableList(copy);
        } else {
            this.resultTypeNames = null;
        }
    }

    public int hashCode() {
        int hash = Action.class.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Action)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Action other = (Action)obj;
        IAgentDescription myAgent = this.getProviderDescription();
        IAgentDescription otherAgent = other.getProviderDescription();
        if (myAgent != null && otherAgent != null && !EqualityChecker.equalsOrNull((Object)myAgent.getAid(), (Object)otherAgent.getAid())) {
            return false;
        }
        return EqualityChecker.equalsOrNull((Object)this.getName(), (Object)other.getName()) && EqualityChecker.equalsOrNull(this.getInputTypeNames(), other.getInputTypeNames()) && EqualityChecker.equalsOrNull(this.getResultTypeNames(), other.getResultTypeNames());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Action:\n name='").append(this.name).append("'");
        builder.append("\n parameters=");
        this.prettyPrintArray(builder, this.inputTypeNames);
        builder.append("\n results=");
        this.prettyPrintArray(builder, this.resultTypeNames);
        builder.append("\n bean=");
        builder.append(this.providerBean);
        builder.append("\n provider =");
        if (this.providerDescription != null) {
            builder.append(this.providerDescription.getName() + "(" + this.providerDescription.getAid() + ")");
        } else {
            builder.append(this.providerDescription);
        }
        builder.append("\n scope=").append(this.scope);
        builder.append("\n");
        return builder.toString();
    }

    private void prettyPrintArray(StringBuilder builder, List<String> list) {
        if (list == null) {
            builder.append("null");
        } else {
            builder.append('[');
            Iterator<String> iter = list.iterator();
            while (iter.hasNext()) {
                builder.append(iter.next());
                if (!iter.hasNext()) continue;
                builder.append("; ");
            }
            builder.append(']');
        }
    }

    private Class<?> getClassForName(String type) throws ClassNotFoundException {
        if (type.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (type.equals("byte")) {
            return Byte.TYPE;
        }
        if (type.equals("char")) {
            return Character.TYPE;
        }
        if (type.equals("short")) {
            return Short.TYPE;
        }
        if (type.equals("int")) {
            return Integer.TYPE;
        }
        if (type.equals("long")) {
            return Long.TYPE;
        }
        if (type.equals("float")) {
            return Float.TYPE;
        }
        if (type.equals("double")) {
            return Double.TYPE;
        }
        return Class.forName(type);
    }

    public final ActionScope getScope() {
        return this.scope;
    }

    public final void setScope(ActionScope newScope) {
        this.scope = newScope;
    }

    private String[] getItemNames() {
        return new String[]{"name", "input types", "result types", "scope", "bean", "agent"};
    }

    public OpenType<?> getDescriptionType() throws OpenDataException {
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, new ArrayType(SimpleType.STRING, false), new ArrayType(SimpleType.STRING, false), SimpleType.STRING, SimpleType.STRING, this.providerDescription != null ? this.providerDescription.getDescriptionType() : SimpleType.VOID};
        String[] itemDescriptions = this.getItemNames();
        return new CompositeType(this.getClass().getName(), "standard JIAC-TNG action", this.getItemNames(), itemDescriptions, itemTypes);
    }

    public Object getDescription() throws OpenDataException {
        Object[] itemValues = new Object[]{this.name, this.inputTypeNames.toArray(new String[this.resultTypeNames.size()]), this.resultTypeNames.toArray(new String[this.resultTypeNames.size()]), this.scope != null ? this.scope.toString() : null, this.providerBean != null ? this.providerBean.getBeanName() : null, this.providerDescription != null ? this.providerDescription.getDescription() : null};
        CompositeType type = (CompositeType)this.getDescriptionType();
        return new CompositeDataSupport(type, this.getItemNames(), itemValues);
    }
}

