/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.comm;

import de.dailab.jiactng.agentcore.comm.ICommunicationAddress;
import java.net.URI;
import java.net.URISyntaxException;

abstract class CommunicationAddress
implements ICommunicationAddress {
    private final CommunicationAddress unboundAddress;
    private final URI uri;
    private final String transportId;

    protected CommunicationAddress(String scheme, String schemeSpecificPart) throws URISyntaxException {
        this.uri = new URI(scheme + ':' + schemeSpecificPart);
        this.unboundAddress = this;
        this.transportId = null;
    }

    protected CommunicationAddress(URI predefined, String expectedScheme) {
        if (!predefined.getScheme().equals(expectedScheme)) {
            throw new IllegalArgumentException("'" + predefined + "' is not applicable to this address type");
        }
        this.uri = predefined;
        this.unboundAddress = this;
        this.transportId = null;
    }

    protected CommunicationAddress(CommunicationAddress unboundAddress, String transportId) throws URISyntaxException {
        if (unboundAddress.isBoundToTransport()) {
            throw new IllegalArgumentException("communication address can only be initialised with unbound address");
        }
        this.unboundAddress = unboundAddress;
        this.transportId = transportId;
        this.uri = new URI(transportId + ':' + unboundAddress.toURI());
    }

    public final boolean isBoundToTransport() {
        return this.transportId != null;
    }

    public CommunicationAddress toUnboundAddress() {
        return this.unboundAddress;
    }

    public final String getName() {
        return this.unboundAddress.toURI().getSchemeSpecificPart();
    }

    public final URI toURI() {
        return this.uri;
    }

    public final boolean equals(Object obj) {
        if (obj == null || !this.getClass().isInstance(obj)) {
            return false;
        }
        if (!(obj instanceof CommunicationAddress)) {
            return false;
        }
        CommunicationAddress other = (CommunicationAddress)obj;
        return this.toURI().equals(other.toURI());
    }

    public final int hashCode() {
        return this.uri.hashCode();
    }

    public final String toString() {
        return this.toURI().toString();
    }

    abstract CommunicationAddress bind(String var1) throws URISyntaxException;
}

