/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.comm;

import de.dailab.jiactng.agentcore.comm.GroupAddress;
import de.dailab.jiactng.agentcore.comm.ICommunicationAddress;
import de.dailab.jiactng.agentcore.comm.IGroupAddress;
import de.dailab.jiactng.agentcore.comm.IMessageBoxAddress;
import de.dailab.jiactng.agentcore.comm.MessageBoxAddress;
import java.net.URI;
import java.net.URISyntaxException;

public final class CommunicationAddressFactory {
    public static IGroupAddress createGroupAddress(String groupName) {
        try {
            return new GroupAddress(groupName);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("groupName is not valid", use);
        }
    }

    public static IMessageBoxAddress createMessageBoxAddress(String boxName) {
        try {
            return new MessageBoxAddress(boxName);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("boxName is not valid", use);
        }
    }

    public static ICommunicationAddress createFromURI(String uri) {
        int colon = uri.indexOf(58);
        if (colon <= 0) {
            throw new IllegalArgumentException("'" + uri + "' is not a valid communication address");
        }
        String prefix = uri.substring(0, colon);
        String name = uri.substring(colon + 1);
        if (prefix.equalsIgnoreCase("group")) {
            return CommunicationAddressFactory.createGroupAddress(name);
        }
        if (prefix.equalsIgnoreCase("msgbox")) {
            return CommunicationAddressFactory.createMessageBoxAddress(name);
        }
        return CommunicationAddressFactory.createFromURI(name);
    }

    public static ICommunicationAddress createFromURI(URI uri) {
        return CommunicationAddressFactory.createFromURI(uri.toString());
    }
}

