/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.comm;

import de.dailab.jiactng.agentcore.IAgentBean;
import de.dailab.jiactng.agentcore.action.AbstractMethodExposingBean;
import de.dailab.jiactng.agentcore.comm.CommunicationAddress;
import de.dailab.jiactng.agentcore.comm.CommunicationBeanMBean;
import de.dailab.jiactng.agentcore.comm.CommunicationException;
import de.dailab.jiactng.agentcore.comm.ICommunicationAddress;
import de.dailab.jiactng.agentcore.comm.ICommunicationBean;
import de.dailab.jiactng.agentcore.comm.IGroupAddress;
import de.dailab.jiactng.agentcore.comm.IMessageBoxAddress;
import de.dailab.jiactng.agentcore.comm.ListenerContext;
import de.dailab.jiactng.agentcore.comm.MessageBoxAddress;
import de.dailab.jiactng.agentcore.comm.message.IJiacMessage;
import de.dailab.jiactng.agentcore.comm.message.JiacMessage;
import de.dailab.jiactng.agentcore.comm.transport.MessageTransport;
import de.dailab.jiactng.agentcore.management.Manager;
import de.dailab.jiactng.agentcore.management.jmx.MessageExchangeNotification;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.commons.logging.Log;

public final class CommunicationBean
extends AbstractMethodExposingBean
implements ICommunicationBean,
CommunicationBeanMBean {
    private final MessageTransport.IMessageTransportDelegate defaultDelegate = new MessageTransportDelegate();
    private Map<String, MessageTransport> transports = new HashMap<String, MessageTransport>();
    protected final Map<ICommunicationAddress, List<ListenerContext>> addressToListenerMap = new Hashtable<ICommunicationAddress, List<ListenerContext>>();

    private static <T> T saveCast(Object object, Class<T> targetType) {
        if (!targetType.isInstance(object)) {
            throw new IllegalArgumentException("argument is not valid");
        }
        return targetType.cast(object);
    }

    private static IJiacMessage cloneTemplate(IJiacMessage template) {
        if (template == null) {
            return null;
        }
        JiacMessage result = new JiacMessage();
        for (String key : template.getHeaderKeys()) {
            result.setHeader(key, template.getHeader(key));
        }
        return result;
    }

    public synchronized void setTransports(Set<MessageTransport> newTransports) throws Exception {
        Set<MessageTransport> workingCopy;
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info((Object)("CommunicationBean is setting it's transports to: " + newTransports.toString()));
        }
        if (newTransports == null) {
            workingCopy = Collections.emptySet();
        } else {
            workingCopy = new HashSet<MessageTransport>();
            workingCopy.addAll(newTransports);
        }
        if (this.transports.size() > 0) {
            HashSet<MessageTransport> toRemove = new HashSet<MessageTransport>();
            toRemove.addAll(this.transports.values());
            toRemove.removeAll(workingCopy);
            workingCopy.removeAll(this.transports.values());
            for (MessageTransport transport : toRemove) {
                this.removeTransport(transport.getTransportIdentifier());
            }
        }
        for (MessageTransport transport : workingCopy) {
            this.addTransport(transport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCleanup() throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"CommunicationBean starts commencing cleanup");
            this.log.info((Object)"Cleaning up transports");
        }
        Map<String, MessageTransport> map = this.transports;
        synchronized (map) {
            for (MessageTransport transport : this.transports.values()) {
                try {
                    transport.doCleanup();
                }
                catch (Exception e) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn((Object)("transport '" + transport.getTransportIdentifier() + "' did not cleanup correctly"), (Throwable)e);
                }
            }
        }
        super.doCleanup();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"CommunicationBean commenced cleanup");
        }
    }

    @Override
    public synchronized void doInit() throws Exception {
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info((Object)"CommunicationBean begins with initialization");
        }
        super.doInit();
        this.log.info((Object)"initializing Transports");
        Iterator<MessageTransport> iter = this.transports.values().iterator();
        while (iter.hasNext()) {
            MessageTransport transport = iter.next();
            transport.setDefaultDelegate(this.defaultDelegate);
            try {
                transport.doInit();
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("transport '" + transport.getTransportIdentifier() + "' did not initialised correctly -> will be removed"), (Throwable)e);
                }
                try {
                    transport.doCleanup();
                }
                catch (Exception x) {
                    // empty catch block
                }
                iter.remove();
                this.deregisterTransport(transport.getTransportIdentifier());
            }
        }
        this.establishMessageBox(this.thisAgent.getAgentDescription().getMessageBoxAddress());
        if (this.transports.size() <= 0) {
            this.log.warn((Object)"no transports available yet!");
        }
        this.log.info((Object)"CommunicationBean has finished it's initialization");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTransport(MessageTransport transport) throws Exception {
        String id;
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info((Object)("Adding Transport '" + transport + "' to CommunicationBean"));
        }
        if (this.transports.containsKey(id = transport.getTransportIdentifier())) {
            throw new IllegalArgumentException("the transport '" + id + "' already exists");
        }
        try {
            if (this.isActive()) {
                transport.setDefaultDelegate(this.defaultDelegate);
                transport.doInit();
                this.registerAllToTransport(transport);
            }
        }
        finally {
            this.transports.put(id, transport);
            this.registerTransport(transport);
        }
    }

    public synchronized void removeTransport(String transportIdentifier) {
        MessageTransport transport = this.transports.remove(transportIdentifier);
        if (transport == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Transport '" + transportIdentifier + "' not found to remove from CommunicationBean"));
            }
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Transport '" + transportIdentifier + "' removed from CommunicationBean"));
        }
        this.deregisterTransport(transportIdentifier);
        switch (this.getState()) {
            case INITIALIZED: 
            case STARTED: 
            case STOPPED: {
                try {
                    transport.doCleanup();
                    break;
                }
                catch (Exception e) {
                    if (!this.log.isWarnEnabled()) break;
                    this.log.warn((Object)("transport '" + transportIdentifier + "' did not cleanup correctly"), (Throwable)e);
                }
            }
        }
    }

    public synchronized void joinGroup(IGroupAddress group) throws CommunicationException {
        this.register((ICommunicationAddress)group, null);
    }

    public synchronized void leaveGroup(IGroupAddress group) throws CommunicationException {
        this.unregister((ICommunicationAddress)group, null);
    }

    public boolean isLocal(IMessageBoxAddress messageBox) {
        String name = messageBox.getName();
        return name.startsWith(this.thisAgent.getAgentNode().getUUID());
    }

    public synchronized void establishMessageBox(IMessageBoxAddress messageBox) throws CommunicationException {
        this.register((ICommunicationAddress)messageBox, null);
    }

    public synchronized void destroyMessageBox(IMessageBoxAddress messageBox) throws CommunicationException {
        this.unregister((ICommunicationAddress)messageBox, null);
    }

    public synchronized void send(IJiacMessage message, ICommunicationAddress address) throws CommunicationException {
        this.send(message, address, 0L);
    }

    public synchronized void send(IJiacMessage message, ICommunicationAddress address, long timeToLive) throws CommunicationException {
        if (message == null) {
            throw new IllegalArgumentException("message must not be null");
        }
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        this.internalSend(CommunicationBean.saveCast(message, JiacMessage.class), CommunicationBean.saveCast(address, CommunicationAddress.class), timeToLive);
    }

    @Deprecated
    public synchronized void register(ICommunicationAddress address) throws CommunicationException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("CommunicationBean begins to listen at address '" + address + "'"));
        }
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        this.internalRegister(CommunicationBean.saveCast(address, CommunicationAddress.class), null);
    }

    @Deprecated
    public synchronized void unregister(ICommunicationAddress address) throws CommunicationException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("CommunicationBean stops to listen at address '" + address + "'"));
        }
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        this.internalUnregister(CommunicationBean.saveCast(address, CommunicationAddress.class), null);
    }

    public synchronized void register(ICommunicationAddress address, IJiacMessage selectorTemplate) throws CommunicationException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("CommunicationBean begins to listen at address '" + address + "' with Selector '" + selectorTemplate + "'"));
        }
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        this.internalRegister(CommunicationBean.saveCast(address, CommunicationAddress.class), selectorTemplate);
    }

    public synchronized void unregister(ICommunicationAddress address, IJiacMessage selectorTemplate) throws CommunicationException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("CommunicationBean stops to listen at address '" + address + "' with selector '" + selectorTemplate + "'"));
        }
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        this.internalUnregister(CommunicationBean.saveCast(address, CommunicationAddress.class), selectorTemplate);
    }

    protected void processMessage(MessageTransport source, IJiacMessage message, CommunicationAddress at) {
        this.messageExchanged(MessageExchangeNotification.MessageExchangeAction.RECEIVE, at, message, source.getTransportIdentifier());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("CommunicationBean is receiving Message over transport '" + source.getTransportIdentifier() + "' from '" + at + "'"));
            this.log.debug((Object)("received message ' " + message + "' at '" + at + "'"));
        }
        message.setHeader("JiacTNGSendToAddress", at.getName());
        this.memory.write((Object)message);
    }

    protected void processError(MessageTransport source, Exception error) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)("message transport '" + source.getTransportIdentifier() + "' threw an exception"), (Throwable)error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void internalSend(JiacMessage message, CommunicationAddress address, long timeToLive) throws CommunicationException {
        if (this.transports.size() <= 0) {
            throw new CommunicationException("no transport available");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"send message...");
        }
        CommunicationAddress unboundAddress = address.toUnboundAddress();
        message.setSender((ICommunicationAddress)this.thisAgent.getAgentDescription().getMessageBoxAddress());
        if (address instanceof MessageBoxAddress) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"address is a message box address -> choosing one transport");
            }
            MessageTransport transport = null;
            if (address.isBoundToTransport()) {
                String transportId = address.toURI().getScheme();
                transport = this.transports.get(transportId);
            } else {
                transport = this.transports.values().iterator().next();
            }
            if (transport == null) throw new CommunicationException("does not have transport for '" + address + "'");
            transport.send(message, unboundAddress, timeToLive);
            this.messageExchanged(MessageExchangeNotification.MessageExchangeAction.SEND, unboundAddress, message, transport.getTransportIdentifier());
            return;
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"address is a group address -> choosing all transports");
            }
            for (MessageTransport transport : this.transports.values()) {
                transport.send(message, unboundAddress, timeToLive);
                this.messageExchanged(MessageExchangeNotification.MessageExchangeAction.SEND, unboundAddress, message, transport.getTransportIdentifier());
            }
        }
    }

    private synchronized void internalRegister(CommunicationAddress address, IJiacMessage selectorTemplate) throws CommunicationException {
        CommunicationAddress unboundAddress = address.toUnboundAddress();
        selectorTemplate = CommunicationBean.cloneTemplate(selectorTemplate);
        ListenerContext context = new ListenerContext(selectorTemplate);
        List<ListenerContext> registeredContexts = this.addressToListenerMap.get(unboundAddress);
        if (registeredContexts != null) {
            int index = registeredContexts.indexOf(context);
            if (index >= 0) {
                context = registeredContexts.get(index);
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Another Listener registeres for address '" + address + "' with selectortemplate '" + selectorTemplate + "'"));
                }
                ++context.listeners;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("added further listener for '" + unboundAddress + "' : '" + selectorTemplate + "'"));
                }
                return;
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("first listener for '" + unboundAddress + "'"));
            }
            registeredContexts = new LinkedList<ListenerContext>();
            this.addressToListenerMap.put(unboundAddress, registeredContexts);
        }
        context.listeners = 1;
        registeredContexts.add(context);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"registering new address and listeners on transports");
        }
        if (this.isActive()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("isActive -> registering listeners for new address '" + unboundAddress + "'"));
            }
            for (MessageTransport transport : this.transports.values()) {
                transport.listen(address, context.selector);
            }
        }
    }

    private synchronized void registerAllToTransport(MessageTransport transport) throws CommunicationException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Registering all addresses and listeners on transport '" + transport.getTransportIdentifier() + "'"));
        }
        for (ICommunicationAddress address : this.addressToListenerMap.keySet()) {
            for (ListenerContext context : this.addressToListenerMap.get(address)) {
                transport.listen(address, context.selector);
            }
        }
    }

    private synchronized void internalUnregister(CommunicationAddress address, IJiacMessage selectorTemplate) throws CommunicationException {
        CommunicationAddress unboundAddress = address.toUnboundAddress();
        selectorTemplate = CommunicationBean.cloneTemplate(selectorTemplate);
        List<ListenerContext> registeredContexts = this.addressToListenerMap.remove(unboundAddress);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing nonWildcardListener with address '" + address + "' and selector '" + selectorTemplate + "'"));
        }
        if (registeredContexts == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Aborted Unregister: There is no listener registered for this address '" + address + "'"));
            }
            return;
        }
        ListenerContext context = new ListenerContext(selectorTemplate);
        int index = registeredContexts.indexOf(context);
        if (index >= 0) {
            context = registeredContexts.remove(index);
            --context.listeners;
            if (context.listeners <= 0) {
                if (this.isActive()) {
                    for (MessageTransport transport : this.transports.values()) {
                        transport.stopListen(unboundAddress, context.selector);
                    }
                }
            } else {
                registeredContexts.add(context);
                this.addressToListenerMap.put(unboundAddress, registeredContexts);
            }
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Aborted Unregister: There is no listener registered for this address '" + address + "' and selector '" + selectorTemplate + "'"));
        }
        if (registeredContexts.size() > 0) {
            this.addressToListenerMap.put(unboundAddress, registeredContexts);
        }
    }

    private boolean isActive() {
        switch (this.getState()) {
            case INITIALIZED: 
            case STARTED: 
            case INITIALIZING: 
            case STARTING: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void enableManagement(Manager manager) {
        if (this.isManagementEnabled()) {
            return;
        }
        super.enableManagement(manager);
        for (MessageTransport transport : this.transports.values()) {
            this.registerTransport(transport);
        }
    }

    @Override
    public void disableManagement() {
        if (!this.isManagementEnabled()) {
            return;
        }
        for (String transportId : this.transports.keySet()) {
            this.deregisterTransport(transportId);
        }
        super.disableManagement();
    }

    private void registerTransport(MessageTransport transport) {
        if (!this.isManagementEnabled()) {
            return;
        }
        try {
            this._manager.registerAgentBeanResource((IAgentBean)this, this.thisAgent, "MessageTransport", transport.getTransportIdentifier(), (Object)transport);
        }
        catch (Exception e) {
            if (this.log != null && this.log.isErrorEnabled()) {
                this.log.error((Object)("WARNING: Unable to register message transport " + transport.getTransportIdentifier() + " of agent bean " + this.beanName + " of agent " + this.thisAgent.getAgentName() + " of agent node " + this.thisAgent.getAgentNode().getName() + " as JMX resource."));
                this.log.error((Object)e.getMessage());
            }
            System.err.println("WARNING: Unable to register message transport " + transport.getTransportIdentifier() + " of agent bean " + this.beanName + " of agent " + this.thisAgent.getAgentName() + " of agent node " + this.thisAgent.getAgentNode().getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
    }

    private void deregisterTransport(String transportId) {
        if (!this.isManagementEnabled()) {
            return;
        }
        try {
            this._manager.unregisterAgentBeanResource((IAgentBean)this, this.thisAgent, "MessageTransport", transportId);
        }
        catch (Exception e) {
            if (this.log != null && this.log.isErrorEnabled()) {
                this.log.error((Object)("WARNING: Unable to deregister message transport " + transportId + " of agent bean " + this.beanName + " of agent " + this.thisAgent.getAgentName() + " of agent node " + this.thisAgent.getAgentNode().getName() + " as JMX resource."));
                this.log.error((Object)e.getMessage());
            }
            System.err.println("WARNING: Unable to deregister message transport " + transportId + " of agent bean " + this.beanName + " of agent " + this.thisAgent.getAgentName() + " of agent node " + this.thisAgent.getAgentNode().getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
    }

    public CompositeData getSelectorsOfAddresses() {
        CompositeDataSupport data = null;
        int size = this.addressToListenerMap.size();
        String[] itemNames = new String[size];
        OpenType[] itemTypes = new OpenType[size];
        Object[] itemValues = new Object[size];
        Object[] addresses = this.addressToListenerMap.keySet().toArray();
        try {
            for (int i = 0; i < size; ++i) {
                ICommunicationAddress address = (ICommunicationAddress)addresses[i];
                itemNames[i] = address.getName();
                itemTypes[i] = new ArrayType(1, SimpleType.STRING);
                List<ListenerContext> values = this.addressToListenerMap.get(address);
                String[] value = new String[values.size()];
                Iterator<ListenerContext> it = values.iterator();
                int j = 0;
                while (it.hasNext()) {
                    IJiacMessage selector = it.next().selector;
                    value[j] = selector == null ? "null" : selector.toString();
                    ++j;
                }
                itemValues[i] = value;
            }
            CompositeType compositeType = new CompositeType(this.addressToListenerMap.getClass().getName(), "addresses of the communication bean", itemNames, itemNames, itemTypes);
            data = new CompositeDataSupport(compositeType, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            e.printStackTrace();
        }
        return data;
    }

    public void messageExchanged(MessageExchangeNotification.MessageExchangeAction action, ICommunicationAddress receiver, IJiacMessage jiacMessage, String transport) {
        MessageExchangeNotification n = new MessageExchangeNotification((Object)this, this.sequenceNumber++, System.currentTimeMillis(), "Message exchanged", action, receiver, jiacMessage, transport);
        this.sendNotification((Notification)n);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo info;
        MBeanNotificationInfo[] parent = super.getNotificationInfo();
        int size = parent.length;
        MBeanNotificationInfo[] result = new MBeanNotificationInfo[size + 1];
        for (int i = 0; i < size; ++i) {
            result[i] = parent[i];
        }
        String[] types = new String[]{"jiactng.message.exchange"};
        String name = MessageExchangeNotification.class.getName();
        String description = "A message with another agent was exchanged";
        result[size] = info = new MBeanNotificationInfo(types, name, "A message with another agent was exchanged");
        return result;
    }

    private final class MessageTransportDelegate
    implements MessageTransport.IMessageTransportDelegate {
        protected MessageTransportDelegate() {
        }

        @Override
        public void onAsynchronousException(MessageTransport source, Exception e) {
            CommunicationBean.this.processError(source, e);
        }

        @Override
        public void onMessage(MessageTransport source, IJiacMessage message, ICommunicationAddress at) {
            CommunicationBean.this.processMessage(source, message, (CommunicationAddress)CommunicationBean.saveCast(at.toUnboundAddress(), CommunicationAddress.class));
        }

        @Override
        public Log getLog(String extension) {
            return CommunicationBean.this.thisAgent.getLog((IAgentBean)CommunicationBean.this, extension);
        }
    }
}

