/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.comm.broker;

import de.dailab.jiac.net.SourceAwareDiscoveryNetworkConnector;
import de.dailab.jiactng.agentcore.AbstractAgentNodeBean;
import de.dailab.jiactng.agentcore.comm.broker.ActiveMQTransportConnector;
import de.dailab.jiactng.agentcore.comm.broker.ConnectionFactoryProxy;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.network.NetworkConnector;

public class ActiveMQBroker
extends AbstractAgentNodeBean {
    protected static ActiveMQBroker INSTANCE = null;
    protected String _brokerName = null;
    protected BrokerService _broker = null;
    protected Set<ActiveMQTransportConnector> _connectors = new HashSet<ActiveMQTransportConnector>();
    protected boolean _persistent = false;
    protected int _networkTTL = 1;

    static void initialiseProxy(ConnectionFactoryProxy proxy) {
        if (INSTANCE == null) {
            throw new IllegalStateException("no broker is running");
        }
        proxy.connectionFactory = new ActiveMQConnectionFactory("vm://" + INSTANCE.getBrokerName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQBroker() {
        Class<ActiveMQBroker> clazz = ActiveMQBroker.class;
        synchronized (ActiveMQBroker.class) {
            if (INSTANCE == null) {
                INSTANCE = this;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setNetworkTTL(int networkTTL) throws Exception {
        if (this._networkTTL != networkTTL && this._broker != null) {
            List netcons = this._broker.getNetworkConnectors();
            for (NetworkConnector net : netcons) {
                this._broker.removeNetworkConnector(net);
                net.setNetworkTTL(networkTTL);
                this._broker.addNetworkConnector(net);
            }
        }
        this._networkTTL = networkTTL;
    }

    @Override
    public void doInit() throws Exception {
        this.log.debug((Object)"initializing embedded broker");
        this._brokerName = this.agentNode.getUUID() + this.getBeanName();
        this._broker = new BrokerService();
        this._broker.setBrokerName(this.getBrokerName());
        if (this.agentNode.isManagementEnabled()) {
            this._broker.setUseJmx(true);
            ManagementContext context = new ManagementContext();
            context.setJmxDomainName("de.dailab.jiactng");
            context.setCreateConnector(false);
            this._broker.setManagementContext(context);
        } else {
            this._broker.setUseJmx(false);
        }
        try {
            for (ActiveMQTransportConnector amtc : this._connectors) {
                this.log.debug((Object)("embedded broker initializing transport:: " + amtc.toString()));
                if (amtc.getNetworkURI() != null) {
                    URI networkUri = new URI(amtc.getNetworkURI());
                    NetworkConnector networkConnector = this._broker.addNetworkConnector(networkUri);
                    networkConnector.setDuplex(amtc.isDuplex());
                    networkConnector.setNetworkTTL(amtc.getNetworkTTL());
                }
                this._broker.setPersistent(this._persistent);
                TransportConnector connector = this._broker.addConnector(new URI(amtc.getTransportURI()));
                if (amtc.getDiscoveryURI() == null) continue;
                URI uri = new URI(amtc.getDiscoveryURI());
                URI discoveryURI = new URI(amtc.getDiscoveryURI());
                connector.setDiscoveryUri(discoveryURI);
                SourceAwareDiscoveryNetworkConnector networkConnector = new SourceAwareDiscoveryNetworkConnector(uri);
                networkConnector.setNetworkTTL(this._networkTTL);
                this._broker.addNetworkConnector((NetworkConnector)networkConnector);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.toString());
        }
        this._broker.start();
        this.log.debug((Object)"started broker");
    }

    @Override
    public void doCleanup() throws Exception {
        this.log.debug((Object)"stopping broker");
        this._broker.stop();
        this.log.debug((Object)"stopping broker done");
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    public void setConnectors(Set<ActiveMQTransportConnector> connectors) {
        this._connectors = connectors;
    }

    protected String getBrokerName() {
        if (this._brokerName == null) {
            throw new IllegalStateException("broker is not initialised");
        }
        return this._brokerName;
    }
}

