/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.comm.broker;

import de.dailab.jiactng.agentcore.comm.broker.ActiveMQBroker;
import de.dailab.jiactng.agentcore.comm.broker.ActiveMQTransportConnector;
import java.net.URI;
import java.security.SecureRandom;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.network.NetworkConnector;

public class StaticActiveMQBroker
extends ActiveMQBroker {
    public StaticActiveMQBroker() {
        INSTANCE = this;
    }

    @Override
    public void doInit() throws Exception {
        this.log.debug((Object)"initializing embedded broker");
        this._brokerName = this.agentNode.getName() + this.getBeanName() + SecureRandom.getInstance("SHA1PRNG").nextLong();
        this._broker = new BrokerService();
        this._broker.setBrokerName(this.getBrokerName());
        if (this.agentNode.isManagementEnabled()) {
            this._broker.setUseJmx(true);
            ManagementContext context = new ManagementContext();
            context.setJmxDomainName("de.dailab.jiactng");
            context.setCreateConnector(false);
            this._broker.setManagementContext(context);
        } else {
            this._broker.setUseJmx(false);
        }
        try {
            for (ActiveMQTransportConnector amtc : this._connectors) {
                this.log.debug((Object)("embedded broker initializing transport:: " + amtc.toString()));
                if (amtc.getNetworkURI() != null) {
                    URI networkUri = new URI(amtc.getNetworkURI());
                    NetworkConnector networkConnector = this._broker.addNetworkConnector(networkUri);
                    networkConnector.setNetworkTTL(this._networkTTL);
                }
                this._broker.setPersistent(this._persistent);
                if (amtc.getTransportURI() == null) continue;
                URI transportUri = new URI(amtc.getTransportURI());
                this._broker.addConnector(transportUri);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.toString());
        }
        this._broker.start();
        this.log.debug((Object)"started broker");
    }
}

