/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.comm.message;

import de.dailab.jiactng.agentcore.comm.CommunicationAddressFactory;
import de.dailab.jiactng.agentcore.comm.ICommunicationAddress;
import de.dailab.jiactng.agentcore.comm.message.IJiacMessage;
import de.dailab.jiactng.agentcore.knowledge.IFact;
import de.dailab.jiactng.agentcore.management.jmx.JmxDescriptionSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class JiacMessage
implements IJiacMessage {
    private IFact payload;
    private Map<String, String> headers;
    private transient boolean recursionDetected = false;

    public JiacMessage() {
        this(null, null);
    }

    public JiacMessage(IFact payload) {
        this(payload, null);
    }

    public JiacMessage(IFact payload, ICommunicationAddress replyToAddress) {
        this.payload = payload;
        this.headers = new Hashtable<String, String>();
        if (replyToAddress != null) {
            this.setHeader("JiacTNGReplyToAddress", replyToAddress.toString());
        }
    }

    public JiacMessage(CompositeData descr) {
        this.headers = new Hashtable<String, String>();
        CompositeData messageHeaders = (CompositeData)descr.get("headers");
        for (String key : messageHeaders.getCompositeType().keySet()) {
            this.headers.put(key, (String)messageHeaders.get(key));
        }
    }

    public IFact getPayload() {
        return this.payload;
    }

    public void setPayload(IFact newPayload) {
        this.payload = newPayload;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public void setHeader(String key, String value) {
        if (value == null) {
            this.headers.remove(key);
        } else {
            this.headers.put(key, value);
        }
    }

    public Set<String> getHeaderKeys() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.headers.keySet());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object obj) {
        if (this.recursionDetected) {
            return true;
        }
        try {
            this.recursionDetected = true;
            if (obj == this) {
                boolean bl = true;
                return bl;
            }
            if (obj == null || !(obj instanceof JiacMessage)) {
                boolean bl = false;
                return bl;
            }
            JiacMessage other = (JiacMessage)obj;
            Set<String> otherKeys = other.getHeaderKeys();
            if (otherKeys.size() != this.headers.size()) {
                boolean bl = false;
                return bl;
            }
            for (String key : otherKeys) {
                String myValue = this.headers.get(key);
                if (myValue != null && other.getHeader(key).equals(myValue)) continue;
                boolean bl = false;
                return bl;
            }
            IFact otherPayload = other.getPayload();
            boolean bl = otherPayload != null && this.payload != null ? otherPayload.equals(this.payload) : otherPayload == this.payload;
            return bl;
        }
        finally {
            this.recursionDetected = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int hashCode() {
        if (this.recursionDetected) {
            return 0;
        }
        try {
            this.recursionDetected = true;
            int hashCode = JiacMessage.class.hashCode();
            for (String key : this.getHeaderKeys()) {
                hashCode ^= key.hashCode() << 7;
                hashCode ^= this.getHeader(key).hashCode();
            }
            if (this.payload != null) {
                hashCode ^= this.payload.hashCode();
            }
            int n = hashCode;
            return n;
        }
        finally {
            this.recursionDetected = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String toString() {
        if (this.recursionDetected) {
            return "<recursion>";
        }
        try {
            this.recursionDetected = true;
            StringBuilder builder = new StringBuilder();
            builder.append("[Headers: {");
            int counter = this.headers.size() - 1;
            for (String key : this.headers.keySet()) {
                builder.append(key).append("=>").append(this.headers.get(key));
                if (counter > 0) {
                    builder.append(";");
                }
                --counter;
            }
            builder.append("}");
            builder.append(", Payload: ").append(this.getPayload()).append(", Sender: ").append(this.getSender());
            builder.append("]");
            String string = builder.toString();
            return string;
        }
        finally {
            this.recursionDetected = false;
        }
    }

    public ICommunicationAddress getSender() {
        String uri = this.getHeader("JiacTNGSenderAddress");
        if (uri != null) {
            return CommunicationAddressFactory.createFromURI(uri);
        }
        return null;
    }

    public ICommunicationAddress getReplyToAddress() {
        String uri = this.getHeader("JiacTNGReplyToAddress");
        if (uri != null) {
            return CommunicationAddressFactory.createFromURI(uri);
        }
        return null;
    }

    public void setProtocol(String protocol) {
        this.setHeader("JiacTNGProtocolID", protocol);
    }

    public String getProtocol() {
        return this.getHeader("JiacTNGProtocolID");
    }

    public void setSender(ICommunicationAddress sender) {
        this.setHeader("JiacTNGSenderAddress", sender != null ? sender.toString() : null);
    }

    public OpenType<?> getDescriptionType() throws OpenDataException {
        int i;
        ArrayList<String> itemNames = new ArrayList<String>();
        ArrayList<OpenType> itemTypes = new ArrayList<OpenType>();
        if (this.payload != null) {
            itemNames.add("payload");
            if (this.payload instanceof JmxDescriptionSupport) {
                itemTypes.add(((JmxDescriptionSupport)this.payload).getDescriptionType());
            } else {
                itemTypes.add(SimpleType.STRING);
            }
        }
        if (this.headers != null) {
            itemNames.add("headers");
            String[] headerNames = this.getHeaderKeys().toArray(new String[this.getHeaderKeys().size()]);
            int headerSize = headerNames.length;
            OpenType[] headerTypes = new OpenType[headerSize];
            for (i = 0; i < headerSize; ++i) {
                headerTypes[i] = SimpleType.STRING;
            }
            itemTypes.add(new CompositeType(this.headers.getClass().getName(), "headers of a JIAC-TNG message", headerNames, headerNames, headerTypes));
        }
        ArrayList<String> itemDescriptions = itemNames;
        int compositeSize = itemTypes.size();
        OpenType[] itemTypesArray = new OpenType[compositeSize];
        for (i = 0; i < compositeSize; ++i) {
            itemTypesArray[i] = (OpenType)itemTypes.get(i);
        }
        return new CompositeType(this.getClass().getName(), "standard JIAC-TNG message", itemNames.toArray(new String[itemNames.size()]), itemDescriptions.toArray(new String[itemDescriptions.size()]), itemTypesArray);
    }

    public Object getDescription() throws OpenDataException {
        HashMap<String, Object> items = new HashMap<String, Object>();
        CompositeType type = (CompositeType)this.getDescriptionType();
        if (this.payload != null) {
            if (this.payload instanceof JmxDescriptionSupport) {
                items.put("payload", ((JmxDescriptionSupport)this.payload).getDescription());
            } else {
                items.put("payload", this.payload.toString());
            }
        }
        if (this.headers != null) {
            String[] headerNames = this.getHeaderKeys().toArray(new String[this.getHeaderKeys().size()]);
            int headerSize = headerNames.length;
            Object[] headerValues = new Object[headerSize];
            for (int i = 0; i < headerSize; ++i) {
                headerValues[i] = this.getHeader(headerNames[i]);
            }
            items.put("headers", new CompositeDataSupport((CompositeType)type.getType("headers"), headerNames, headerValues));
        }
        return new CompositeDataSupport(type, items);
    }
}

