/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.comm.transport;

import de.dailab.jiactng.agentcore.comm.CommunicationException;
import de.dailab.jiactng.agentcore.comm.ICommunicationAddress;
import de.dailab.jiactng.agentcore.comm.message.IJiacMessage;
import de.dailab.jiactng.agentcore.comm.transport.MessageTransportMBean;
import java.net.URI;
import org.apache.commons.logging.Log;

public abstract class MessageTransport
implements MessageTransportMBean {
    private final String transportIdentifier;
    private IMessageTransportDelegate delegate;
    protected Log log;
    public static final long DEFAULT_TIMEOUT = 0L;
    protected long timeToLive = 0L;

    protected MessageTransport(String transportIdentifier) {
        this.transportIdentifier = transportIdentifier.toLowerCase();
    }

    public final void setDefaultDelegate(IMessageTransportDelegate newDelegate) {
        this.delegate = newDelegate;
        if (this.delegate.getLog(this.transportIdentifier) == null) {
            this.log.error((Object)"IMessageTransportDelegate.getLog() returned null! This can cause exceptions! ");
        }
        this.log = this.delegate.getLog(this.transportIdentifier);
    }

    public URI getConnectorURI() {
        return null;
    }

    public final String getTransportIdentifier() {
        return this.transportIdentifier;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof MessageTransport) {
            return this.getTransportIdentifier().equals(((MessageTransport)obj).getTransportIdentifier());
        }
        return false;
    }

    public final int hashCode() {
        return this.getTransportIdentifier().hashCode();
    }

    public void doInit() throws Exception {
    }

    public void doCleanup() throws Exception {
    }

    public abstract void send(IJiacMessage var1, ICommunicationAddress var2, long var3) throws CommunicationException;

    public abstract void listen(ICommunicationAddress var1, IJiacMessage var2) throws CommunicationException;

    public abstract void stopListen(ICommunicationAddress var1, IJiacMessage var2) throws CommunicationException;

    public final void delegateException(Exception exception) {
        this.delegate.onAsynchronousException(this, exception);
    }

    public final void delegateMessage(IJiacMessage message, ICommunicationAddress at) {
        this.delegate.onMessage(this, message, at);
    }

    protected Log createChildLog(String name) {
        return this.delegate.getLog(this.transportIdentifier + "." + name);
    }

    public final long getTimeToLive() {
        return this.timeToLive;
    }

    public final void setTimeToLive(long newTimeToLive) {
        this.timeToLive = newTimeToLive;
    }

    public static interface IMessageTransportDelegate {
        public void onAsynchronousException(MessageTransport var1, Exception var2);

        public void onMessage(MessageTransport var1, IJiacMessage var2, ICommunicationAddress var3);

        public Log getLog(String var1);
    }
}

