/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.comm.transport.jms;

import de.dailab.jiactng.agentcore.comm.CommunicationException;
import de.dailab.jiactng.agentcore.comm.ICommunicationAddress;
import de.dailab.jiactng.agentcore.comm.message.BinaryContent;
import de.dailab.jiactng.agentcore.comm.message.IJiacMessage;
import de.dailab.jiactng.agentcore.comm.message.JiacMessage;
import de.dailab.jiactng.agentcore.comm.transport.MessageTransport;
import de.dailab.jiactng.agentcore.comm.transport.jms.JMSReceiver;
import de.dailab.jiactng.agentcore.comm.transport.jms.JMSSender;
import de.dailab.jiactng.agentcore.knowledge.IFact;
import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;

public class JMSMessageTransport
extends MessageTransport {
    private ConnectionFactory _connectionFactory;
    private Connection _connection;
    private JMSSender sender;
    private JMSReceiver receiver;

    public JMSMessageTransport() {
        this("jms");
    }

    public JMSMessageTransport(String transportIdentifier) {
        super(transportIdentifier);
    }

    @Override
    public synchronized void doInit() throws Exception {
        if (this.log == null) {
            throw new Exception("logging was not set!");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JMSMessageTransport initializing...");
        }
        if (this._connectionFactory == null) {
            throw new Exception("NullPointer Exception: No ConnectionFactory Set!");
        }
        this._connection = this._connectionFactory.createConnection();
        this.sender = new JMSSender(this._connection, this.createChildLog("sender"));
        this.receiver = new JMSReceiver(this._connection, this, this.createChildLog("receiver"));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JMSMessageTransport initialized");
        }
        this._connection.start();
    }

    @Override
    public synchronized void doCleanup() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JMSMessageTransport commences Cleanup");
        }
        try {
            this._connection.stop();
        }
        catch (JMSException e) {
            this.log.warn((Object)"could not stop JMS connection ", (Throwable)e);
        }
        try {
            this._connection.close();
        }
        catch (Exception e) {
            this.log.warn((Object)"could not close connection ", (Throwable)e);
        }
        this._connection = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JMSMessageTransport cleaned up");
        }
    }

    static IJiacMessage unpack(Message message) throws JMSException {
        IFact payload;
        if (message instanceof BytesMessage) {
            int length = (int)((BytesMessage)message).getBodyLength();
            byte[] data = new byte[length];
            ((BytesMessage)message).readBytes(data);
            payload = new BinaryContent(data);
        } else {
            payload = (IFact)((ObjectMessage)message).getObject();
        }
        JiacMessage result = new JiacMessage(payload);
        Enumeration keys = message.getPropertyNames();
        while (keys.hasMoreElements()) {
            String key;
            Object valueObj;
            Object keyObj = keys.nextElement();
            if (!(keyObj instanceof String) || !((valueObj = message.getObjectProperty(key = (String)keyObj)) instanceof String)) continue;
            result.setHeader(key, (String)valueObj);
        }
        return result;
    }

    static Message pack(IJiacMessage message, Session session) throws JMSException {
        IFact payload = message.getPayload();
        try {
            ObjectMessage result;
            if (payload != null && payload instanceof BinaryContent) {
                result = session.createBytesMessage();
                ((BytesMessage)result).writeBytes(((BinaryContent)payload).getData());
            } else {
                result = session.createObjectMessage();
                result.setObject((Serializable)payload);
            }
            for (String key : message.getHeaderKeys()) {
                result.setStringProperty(key, message.getHeader(key));
            }
            return result;
        }
        catch (RuntimeException re) {
            if (payload != null) {
                System.out.println("\n\tund das is der payload: " + payload.getClass());
                System.out.println("\terror message: " + re.getMessage() + "\n");
            }
            throw re;
        }
    }

    @Override
    public void send(IJiacMessage message, ICommunicationAddress commAdd, long ttl) throws CommunicationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("JMSMessageTransport sends Message to address '" + commAdd.toUnboundAddress() + "'"));
        }
        try {
            this.sender.send(message, commAdd, ttl == 0L ? this.timeToLive : ttl);
        }
        catch (JMSException jms) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Sending of Message to address '" + commAdd.toUnboundAddress() + "' through JMS failed! Errorcause reads '" + jms.getCause() + "'"));
            }
            throw new CommunicationException("error while sending message", (Throwable)jms);
        }
    }

    @Override
    public void listen(ICommunicationAddress address, IJiacMessage selector) throws CommunicationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("JMSMessageTransports starts to listen at '" + address.toUnboundAddress() + "' with selector'" + selector + "'"));
        }
        try {
            this.receiver.listen(address, selector);
        }
        catch (JMSException jms) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Listening to address '" + address.toUnboundAddress() + "' through JMS failed!"));
                this.log.error((Object)("Errorcause reads '" + jms.getCause() + "'"));
            }
            throw new CommunicationException("error while registrating", (Throwable)jms);
        }
    }

    @Override
    public void stopListen(ICommunicationAddress address, IJiacMessage selector) {
        this.receiver.stopListen(address, selector);
    }

    public void setConnectionFactory(ConnectionFactory newConnectionFactory) {
        this._connectionFactory = newConnectionFactory;
    }
}

