/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.comm.transport.jms;

import de.dailab.jiactng.agentcore.comm.CommunicationAddressFactory;
import de.dailab.jiactng.agentcore.comm.ICommunicationAddress;
import de.dailab.jiactng.agentcore.comm.IGroupAddress;
import de.dailab.jiactng.agentcore.comm.message.IJiacMessage;
import de.dailab.jiactng.agentcore.comm.transport.jms.JMSMessageTransport;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.commons.logging.Log;

class JMSReceiver
implements MessageListener {
    protected final Log log;
    private Session session;
    private JMSMessageTransport parent;
    private Map<String, MessageConsumer> consumers;

    protected static String getStringRepresentation(ICommunicationAddress address, String selector) {
        StringBuilder result = new StringBuilder();
        result.append(address.toString());
        if (selector != null) {
            result.append('?').append(selector);
        }
        return result.toString();
    }

    protected static String templateToSelector(IJiacMessage jiacMessage) {
        if (jiacMessage == null) {
            return null;
        }
        StringBuilder selector = new StringBuilder();
        Set keys = jiacMessage.getHeaderKeys();
        Object[] sortedKeys = keys.toArray(new String[keys.size()]);
        Arrays.sort(sortedKeys);
        for (Object key : sortedKeys) {
            if (selector.length() > 0) {
                selector.append(" AND ");
            }
            selector.append((String)key).append(" = '").append(jiacMessage.getHeader((String)key)).append("'");
        }
        return selector.toString();
    }

    public JMSReceiver(Connection connection, JMSMessageTransport parent, Log log) throws JMSException {
        this.parent = parent;
        this.log = log;
        this.session = connection.createSession(false, 1);
        this.consumers = new HashMap<String, MessageConsumer>();
    }

    public synchronized void listen(ICommunicationAddress address, IJiacMessage selectorTemplate) throws JMSException {
        String selector = JMSReceiver.templateToSelector(selectorTemplate);
        String key = JMSReceiver.getStringRepresentation(address, selector);
        if (this.consumers.containsKey(key)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("there is already a listener for '" + key + "' registered"));
            }
            return;
        }
        MessageConsumer consumer = this.initialiseConsumer(address, selector);
        this.consumers.put(key, consumer);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Now listening to '" + key + "'"));
        }
    }

    public synchronized void stopListen(ICommunicationAddress address, IJiacMessage selectorTemplate) {
        String selector = JMSReceiver.templateToSelector(selectorTemplate);
        String key = JMSReceiver.getStringRepresentation(address, selector);
        MessageConsumer consumer = this.consumers.remove(key);
        if (consumer != null) {
            this.destroyConsumer(consumer);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("stopped listening to address '" + address + "' with selector '" + selector + "'"));
        }
    }

    public synchronized void stopListenAll() {
        for (MessageConsumer consumer : this.consumers.values()) {
            this.destroyConsumer(consumer);
        }
        this.consumers.clear();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Stopped Listening to all JMS Addresses");
        }
    }

    public void onMessage(Message message) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"JMSReceiver receiving message... delegating message");
            }
            Destination receivedAt = message.getJMSDestination();
            IGroupAddress at = null;
            if (receivedAt instanceof Topic) {
                Topic topic = (Topic)receivedAt;
                at = CommunicationAddressFactory.createGroupAddress(topic.getTopicName());
            } else {
                Queue queue = (Queue)receivedAt;
                at = CommunicationAddressFactory.createMessageBoxAddress(queue.getQueueName());
            }
            this.parent.delegateMessage(JMSMessageTransport.unpack(message), (ICommunicationAddress)at);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("An error receiving a message occured. Cause is '" + e.getCause() + "'"));
            }
            this.parent.delegateException(e);
        }
    }

    private MessageConsumer initialiseConsumer(ICommunicationAddress address, String selector) throws JMSException {
        MessageConsumer consumer = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Listener initializing for '" + address.toString() + "' with '" + selector + "'"));
            }
            String add = address.getName();
            Topic dest = address instanceof IGroupAddress ? this.session.createTopic(add) : this.session.createQueue(add);
            consumer = this.session.createConsumer((Destination)dest, selector == null ? null : selector);
            consumer.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Listener couldn't be initialized cause of '" + e.getCause() + "'"));
                this.log.error((Object)"Listener will be destroyed");
            }
            this.destroyConsumer(consumer);
            throw e;
        }
        return consumer;
    }

    void destroyConsumer(MessageConsumer consumer) {
        block3: {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException e) {
                    if (!this.log.isErrorEnabled()) break block3;
                    this.log.error((Object)("Couldn't destroy consumer cause of '" + e.getCause() + "'"));
                }
            }
        }
    }
}

