/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.comm.transport.jms;

import de.dailab.jiactng.agentcore.comm.ICommunicationAddress;
import de.dailab.jiactng.agentcore.comm.IGroupAddress;
import de.dailab.jiactng.agentcore.comm.message.IJiacMessage;
import de.dailab.jiactng.agentcore.comm.transport.jms.JMSMessageTransport;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.commons.logging.Log;

class JMSSender {
    private final Log log;
    private final Session _session;
    private final MessageProducer _producer;

    public JMSSender(Connection connection, Log log) throws JMSException {
        this.log = log;
        this._session = connection.createSession(false, 1);
        this._producer = this._session.createProducer(null);
    }

    public void send(IJiacMessage message, ICommunicationAddress address, long timeToLive) throws JMSException {
        Object destination = null;
        destination = address instanceof IGroupAddress ? this._session.createTopic(address.getName()) : this._session.createQueue(address.getName());
        this.sendMessage(message, (Destination)destination, timeToLive);
    }

    private void sendMessage(IJiacMessage message, Destination destination, long timeToLive) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"pack message");
        }
        Message jmsMessage = JMSMessageTransport.pack(message, this._session);
        jmsMessage.setJMSDestination(destination);
        this._producer.send(destination, jmsMessage, this._producer.getDeliveryMode(), this._producer.getPriority(), timeToLive);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("JMSSender sent Message to '" + destination + "'"));
        }
    }
}

