/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.directory;

import de.dailab.jiactng.agentcore.AbstractAgentNodeBean;
import de.dailab.jiactng.agentcore.Agent;
import de.dailab.jiactng.agentcore.IAgentBean;
import de.dailab.jiactng.agentcore.IAgentNodeBean;
import de.dailab.jiactng.agentcore.action.Action;
import de.dailab.jiactng.agentcore.action.scope.ActionScope;
import de.dailab.jiactng.agentcore.comm.CommunicationAddressFactory;
import de.dailab.jiactng.agentcore.comm.ICommunicationAddress;
import de.dailab.jiactng.agentcore.comm.message.IJiacMessage;
import de.dailab.jiactng.agentcore.comm.message.JiacMessage;
import de.dailab.jiactng.agentcore.comm.transport.MessageTransport;
import de.dailab.jiactng.agentcore.directory.Advertisement;
import de.dailab.jiactng.agentcore.directory.DirectoryAgentNodeBeanMBean;
import de.dailab.jiactng.agentcore.directory.IDirectory;
import de.dailab.jiactng.agentcore.directory.IOntologyStorage;
import de.dailab.jiactng.agentcore.directory.IServiceMatcher;
import de.dailab.jiactng.agentcore.environment.IEffector;
import de.dailab.jiactng.agentcore.lifecycle.ILifecycle;
import de.dailab.jiactng.agentcore.lifecycle.LifecycleEvent;
import de.dailab.jiactng.agentcore.ontology.AgentNodeDescription;
import de.dailab.jiactng.agentcore.ontology.IActionDescription;
import de.dailab.jiactng.agentcore.ontology.IAgentDescription;
import de.dailab.jiactng.agentcore.ontology.IServiceDescription;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectoryAgentNodeBean
extends AbstractAgentNodeBean
implements IDirectory,
MessageTransport.IMessageTransportDelegate,
DirectoryAgentNodeBeanMBean {
    private boolean dump = false;
    public static final String ADDRESS_NAME = "df";
    public static final String ALIVE = "df:alive";
    public static final String BYE = "df:bye";
    public static final String ADVERTISE = "df:advertise";
    public static final String ALL = "df:all";
    private long aliveInterval = 2000L;
    private IServiceMatcher serviceMatcher = null;
    private IOntologyStorage ontologyStorage = null;
    private long advertiseInterval = 10800L;
    private String myAgentNode;
    ICommunicationAddress myAddress;
    ICommunicationAddress groupAddress;
    private MessageTransport messageTransport;
    private Set<IActionDescription> localActions = new HashSet<IActionDescription>();
    private Hashtable<String, Set<IActionDescription>> remoteActions = new Hashtable();
    private Hashtable<String, IAgentDescription> localAgents = new Hashtable();
    private Hashtable<String, IAgentDescription> remoteAgents = new Hashtable();
    private Hashtable<String, AgentNodeDescription> nodes = new Hashtable();
    private Timer timer;

    @Override
    public void doInit() throws Exception {
        super.doInit();
        this.myAgentNode = this.agentNode.getUUID();
        this.messageTransport.setDefaultDelegate(this);
        try {
            this.messageTransport.doInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.myAddress = CommunicationAddressFactory.createMessageBoxAddress("df@" + this.myAgentNode);
        this.log.info((Object)("myAddress=" + this.myAddress));
        this.groupAddress = CommunicationAddressFactory.createGroupAddress("df@dfgroup");
        this.log.info((Object)("groupAddress=" + this.groupAddress));
        try {
            this.messageTransport.listen(this.myAddress, null);
            this.messageTransport.listen(this.groupAddress, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (IAgentNodeBean ianb : this.agentNode.getAgentNodeBeans()) {
            if (ianb instanceof IServiceMatcher) {
                this.serviceMatcher = (IServiceMatcher)ianb;
                continue;
            }
            if (!(ianb instanceof IOntologyStorage)) continue;
            this.ontologyStorage = (IOntologyStorage)ianb;
        }
        if (this.serviceMatcher != null) {
            this.log.info((Object)"Found a ServiceMatcher for this agentnode");
        } else {
            this.log.info((Object)"No ServiceMatcher was found on this agentode, complex matching will not be possible!");
        }
        if (this.ontologyStorage != null) {
            this.log.info((Object)"Found an OntologyStorage for this agentnode");
        } else {
            this.log.info((Object)"No OntologyStorage was found on this agentode, ontology-handling will not be possible!");
        }
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new AgentNodePinger(), this.aliveInterval, this.aliveInterval);
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        this.timer.cancel();
        JiacMessage byeMessage = new JiacMessage();
        byeMessage.setProtocol(BYE);
        this.sendMessage(byeMessage, this.groupAddress);
    }

    @Override
    public void doCleanup() throws Exception {
        super.doCleanup();
        this.serviceMatcher = null;
        this.ontologyStorage = null;
        try {
            this.messageTransport.stopListen(this.myAddress, null);
            this.messageTransport.stopListen(this.groupAddress, null);
            this.messageTransport.doCleanup();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void registerAgent(IAgentDescription agentDescription) {
        if (agentDescription == null) {
            this.log.error((Object)"Cannot register agent: null!");
            return;
        }
        String uuid = null;
        try {
            uuid = agentDescription.getAgentNodeUUID();
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot register agent! No UUID!");
            return;
        }
        if (uuid == null) {
            this.log.error((Object)"Cannot register agent! No UUID!");
            return;
        }
        if (uuid.equals(this.myAgentNode)) {
            this.localAgents.put(agentDescription.getAid(), agentDescription);
        } else {
            this.remoteAgents.put(agentDescription.getAid(), agentDescription);
        }
    }

    public void deregisterAgent(String aid) {
        if (aid == null) {
            this.log.error((Object)"Cannot deregister agent: null!");
            return;
        }
        IAgentDescription agent = this.localAgents.remove(aid);
        if (agent == null) {
            this.remoteAgents.remove(aid);
        }
        this.dump("deregisterAgent " + aid);
    }

    public void modifyAgent(IAgentDescription agentDescription) {
        if (agentDescription == null) {
            this.log.error((Object)"Cannot modify agent: null!");
            return;
        }
        this.registerAgent(agentDescription);
    }

    public IAgentDescription searchAgent(IAgentDescription template) {
        IAgentDescription agentDescription;
        if (template == null) {
            this.log.error((Object)"Cannot find agent: null!");
            return null;
        }
        for (String key : this.localAgents.keySet()) {
            agentDescription = this.localAgents.get(key);
            if (!agentDescription.equals(template)) continue;
            return agentDescription;
        }
        for (String key : this.remoteAgents.keySet()) {
            agentDescription = this.remoteAgents.get(key);
            if (!agentDescription.equals(template)) continue;
            return agentDescription;
        }
        this.log.warn((Object)("Cannot find agent:\n" + template.toString()));
        return null;
    }

    public List<IAgentDescription> searchAllLocalAgents(IAgentDescription template) {
        ArrayList<IAgentDescription> agents = new ArrayList<IAgentDescription>();
        for (String key : this.localAgents.keySet()) {
            IAgentDescription agentDescription = this.localAgents.get(key);
            if (!agentDescription.equals(template)) continue;
            agents.add(agentDescription);
        }
        return agents;
    }

    public List<IAgentDescription> searchAllAgents(IAgentDescription template) {
        IAgentDescription agentDescription;
        ArrayList<IAgentDescription> agents = new ArrayList<IAgentDescription>();
        for (String key : this.localAgents.keySet()) {
            agentDescription = this.localAgents.get(key);
            if (!agentDescription.equals(template)) continue;
            agents.add(agentDescription);
        }
        for (String key : this.remoteAgents.keySet()) {
            agentDescription = this.remoteAgents.get(key);
            if (!agentDescription.equals(template)) continue;
            agents.add(agentDescription);
        }
        return agents;
    }

    public void registerAction(IActionDescription actionDescription) {
        if (actionDescription == null) {
            this.log.error((Object)"Cannot register action: null!");
            return;
        }
        String uuid = null;
        try {
            uuid = actionDescription.getProviderDescription().getAgentNodeUUID();
        }
        catch (Exception e) {
            this.log.error((Object)("(" + e.getClass().getSimpleName() + ") Cannot register action!\n" + actionDescription.toString()));
            return;
        }
        if (uuid == null) {
            this.log.error((Object)("Provider information incomplete. Missing UUID. Cannot register action!\n" + actionDescription.toString()));
            return;
        }
        if (this.myAgentNode.equals(uuid)) {
            boolean success = this.localActions.add(actionDescription);
            if (!success) {
                this.log.warn((Object)("Action to register already registered. Substituting with new action:\n" + actionDescription.toString()));
                this.localActions.remove(actionDescription);
                this.localActions.add(actionDescription);
            }
        } else {
            if (!this.remoteActions.containsKey(uuid)) {
                this.log.error((Object)("UUID unknown. Cannot register action!\n" + actionDescription.toString()));
                return;
            }
            Set<IActionDescription> actions = this.remoteActions.get(uuid);
            boolean success = actions.add(actionDescription);
            if (!success) {
                this.log.warn((Object)("Action to register already registered. Substituting with new action:\n" + actionDescription.toString()));
                actions.remove(actionDescription);
                actions.add(actionDescription);
            }
        }
        this.log.info((Object)("Registered action:\n" + actionDescription.toString()));
        this.dump("registerAction " + actionDescription.getName());
    }

    public void deregisterAction(IActionDescription actionDescription) {
        if (actionDescription == null) {
            this.log.error((Object)"Cannot remove action: null!");
            return;
        }
        String uuid = null;
        try {
            uuid = actionDescription.getProviderDescription().getAgentNodeUUID();
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot deregister action!\n" + actionDescription.toString()));
            return;
        }
        if (uuid == null) {
            this.log.error((Object)("Provider information incomplete. Missing UUID. Cannot deregister action!\n" + actionDescription.toString()));
            return;
        }
        if (uuid.equals(this.myAgentNode)) {
            if (!this.localActions.remove(actionDescription)) {
                this.log.warn((Object)("Cannot deregister action! Unknown action '" + actionDescription.getName() + "'!"));
            }
        } else {
            Set<IActionDescription> ad = this.remoteActions.get(uuid);
            if (ad == null) {
                this.log.warn((Object)("Cannot deregister action! Unknown UUID: " + uuid));
                return;
            }
            if (!ad.remove(actionDescription)) {
                this.log.warn((Object)("Cannot deregister action! Unknown action:\n" + actionDescription.toString()));
            }
        }
        this.dump("deregisterAction " + actionDescription.toString());
    }

    public void modifyAction(IActionDescription oldDescription, IActionDescription newDescription) {
        if (oldDescription == null || newDescription == null) {
            this.log.error((Object)("Cannot modify action (old:\n" + oldDescription + "\nnew:\n" + newDescription));
            return;
        }
        String uuid = null;
        try {
            uuid = oldDescription.getProviderDescription().getAgentNodeUUID();
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot modify action!\n" + oldDescription.toString()));
            return;
        }
        if (uuid == null) {
            this.log.error((Object)("Provider information incomplete. Missing UUID. Cannot modify action!\n" + oldDescription.toString()));
            return;
        }
        if (uuid.equals(this.myAgentNode)) {
            if (!this.localActions.remove(oldDescription)) {
                this.log.warn((Object)("Cannot deregister action:\n" + oldDescription.toString()));
            }
        } else {
            Set<IActionDescription> ad = this.remoteActions.get(uuid);
            if (ad == null) {
                this.log.warn((Object)("Cannot deregister action! Unknown UUID: " + uuid));
            } else if (!ad.remove(oldDescription)) {
                this.log.warn((Object)("Cannot deregister action! Unknown action:\n" + oldDescription.toString()));
            }
        }
        this.registerAction(newDescription);
    }

    public IActionDescription searchAction(IActionDescription template) {
        if (template == null) {
            this.log.error((Object)"Cannot find action: null!");
            return null;
        }
        if (template instanceof IServiceDescription) {
            if (this.serviceMatcher != null) {
                ArrayList<IServiceDescription> serviceDescList = this.findAllComplexServices();
                IServiceDescription matcherResult = this.serviceMatcher.findBestMatch((IServiceDescription)template, serviceDescList);
                if (matcherResult != null) {
                    return matcherResult;
                }
                this.log.warn((Object)"Matcher found no result, trying normal template matching...");
            } else {
                this.log.error((Object)"This agentnode has no servicematcher - no complex matching possible!");
            }
        }
        if (this.localActions.contains(template)) {
            for (IActionDescription ad : this.localActions) {
                if (!ad.equals(template)) continue;
                return ad;
            }
        }
        for (String key : this.remoteActions.keySet()) {
            Set<IActionDescription> adset = this.remoteActions.get(key);
            if (!adset.contains(template)) continue;
            for (IActionDescription ad : adset) {
                if (!ad.equals(template)) continue;
                return ad;
            }
        }
        this.log.warn((Object)("Cannot find action:\n" + template));
        return null;
    }

    public List<IActionDescription> searchAllActions(IActionDescription template) {
        ArrayList<IActionDescription> actions = new ArrayList<IActionDescription>();
        if (template == null) {
            this.log.error((Object)"Cannot find action: null!");
            return actions;
        }
        if (template instanceof IServiceDescription) {
            if (this.serviceMatcher != null) {
                ArrayList<IServiceDescription> serviceDescList = this.findAllComplexServices();
                ArrayList matcherResults = this.serviceMatcher.findAllMatches((IServiceDescription)template, serviceDescList);
                if (matcherResults != null && matcherResults.size() > 0) {
                    actions.addAll(matcherResults);
                } else {
                    this.log.warn((Object)"Matcher found no result, trying normal template matching...");
                }
            } else {
                this.log.error((Object)"This agentnode has no servicematcher - no complex matching possible!");
            }
        }
        if (this.localActions.contains(template)) {
            for (IActionDescription actionDescription : this.localActions) {
                if (!actionDescription.equals(template)) continue;
                actions.add(actionDescription);
            }
        }
        for (String key : this.remoteActions.keySet()) {
            Set<IActionDescription> adset = this.remoteActions.get(key);
            if (!adset.contains(template)) continue;
            for (IActionDescription ad : adset) {
                if (!ad.equals(template)) continue;
                actions.add(ad);
            }
        }
        return actions;
    }

    public void onEvent(LifecycleEvent event) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.myAgentNode + "::" + event.getSource() + " State: " + event.getState()));
        }
        if (event.getState() == ILifecycle.LifecycleStates.INITIALIZED) {
            if (event.getSource() instanceof Agent) {
                Agent agent = (Agent)event.getSource();
                this.registerAgent(agent.getAgentDescription());
                List<IAgentBean> beans = agent.getAgentBeans();
                if (beans != null && !beans.isEmpty()) {
                    for (IAgentBean ab : beans) {
                        if (!(ab instanceof IEffector)) continue;
                        IEffector effector = (IEffector)ab;
                        List actions = effector.getActions();
                        if (actions != null && !actions.isEmpty()) {
                            for (IActionDescription action : actions) {
                                if (action.getScope() == null || !action.getScope().contains(ActionScope.NODE)) continue;
                                action.setProviderDescription((IAgentDescription)agent.getAgentDescription());
                                this.registerAction(action);
                            }
                            continue;
                        }
                        this.log.warn((Object)("Effector: " + ab.getBeanName() + " has no Actions?!?"));
                    }
                } else {
                    this.log.warn((Object)("Agent: " + agent.getAgentId() + " has no AgentBeans?!?"));
                }
            }
        } else if (event.getState() == ILifecycle.LifecycleStates.STOPPING && event.getSource() instanceof Agent) {
            String agent = ((Agent)event.getSource()).getAgentId();
            ArrayList<IActionDescription> actions = new ArrayList<IActionDescription>();
            for (IActionDescription action : this.localActions) {
                if (!action.getProviderDescription().getAid().equals(agent)) continue;
                actions.add(action);
            }
            for (IActionDescription action : actions) {
                this.localActions.remove(action);
            }
            this.deregisterAgent(agent);
        }
    }

    @Override
    public void onMessage(MessageTransport source, IJiacMessage message, ICommunicationAddress at) {
        ICommunicationAddress senderAddress = message.getSender();
        if (senderAddress == null || senderAddress.equals(this.myAddress)) {
            return;
        }
        String protocol = message.getProtocol();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sender=" + senderAddress + " protocol=" + protocol));
        }
        if (protocol.equals(ALIVE)) {
            this.refreshAgentNode(senderAddress);
            return;
        }
        if (protocol.equals(BYE)) {
            String uuid = senderAddress.getName();
            if (this.nodes.containsKey(uuid)) {
                this.removeRemoteAgentOfNode(uuid);
                this.remoteActions.remove(uuid);
                this.nodes.remove(uuid);
            }
            this.dump(uuid + " says bye");
            return;
        }
        if (protocol.equals(ADVERTISE)) {
            Set<JMXServiceURL> connectors = ((Advertisement)message.getPayload()).getJmxURLs();
            this.refreshAgentNode(senderAddress, connectors);
            Set<IActionDescription> actions = ((Advertisement)message.getPayload()).getActions();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("receive ADVERTISE: " + actions.size()));
            }
            HashSet<Object> receivedActions = new HashSet<Object>();
            for (IActionDescription iad : actions) {
                if (iad instanceof IServiceDescription) {
                    IServiceDescription isd = (IServiceDescription)iad;
                    if (isd.getOntologySource() == null) continue;
                    IServiceDescription tempService = null;
                    try {
                        tempService = this.ontologyStorage.deserializeServiceDescription(isd.getOntologySource());
                        if (tempService != null) {
                            ((Action)tempService).setInputTypes(isd.getInputTypes());
                            ((Action)tempService).setResultTypes(isd.getResultTypes());
                            ((Action)tempService).setProviderDescription(isd.getProviderDescription());
                            ((Action)tempService).setScope(isd.getScope());
                        }
                    }
                    catch (Exception ex) {
                        this.log.error((Object)"Caught exception when reading service description: ", (Throwable)ex);
                    }
                    if (tempService == null) continue;
                    receivedActions.add(tempService);
                    continue;
                }
                receivedActions.add(iad);
            }
            this.remoteActions.put(senderAddress.getName(), receivedActions);
            Hashtable<String, IAgentDescription> agents = ((Advertisement)message.getPayload()).getAgents();
            for (IAgentDescription agent : agents.values()) {
                this.registerAgent(agent);
            }
            this.dump("ADVERTISE " + senderAddress.getName());
        } else if (protocol.equals(ALL)) {
            this.sendAdvertisement(senderAddress);
        }
    }

    public ICommunicationAddress getCommunicationAddressOfANode(String uuidOfNode) {
        if (uuidOfNode == null || uuidOfNode.equals("")) {
            return null;
        }
        ICommunicationAddress ret = null;
        if (this.nodes.containsKey(uuidOfNode)) {
            AgentNodeDescription nodeDescription = this.nodes.get(uuidOfNode);
            ret = nodeDescription.getAddress();
        }
        return ret;
    }

    public Set<String> getAllKnownAgentNodes() {
        return this.nodes.keySet();
    }

    private void refreshAgentNode(ICommunicationAddress node) {
        String uuid = node.getName();
        if (this.nodes.containsKey(uuid)) {
            this.nodes.get(uuid).setAlive(System.currentTimeMillis());
        } else {
            AgentNodeDescription description = new AgentNodeDescription(node, System.currentTimeMillis());
            this.nodes.put(uuid, description);
        }
    }

    private void refreshAgentNode(ICommunicationAddress node, Set<JMXServiceURL> jmxConnectors) {
        String uuid = node.getName();
        this.refreshAgentNode(node);
        this.nodes.get(uuid).setJmxURLs(jmxConnectors);
    }

    @Override
    public Log getLog(String extension) {
        return LogFactory.getLog((String)(this.getClass().getName() + "." + extension));
    }

    @Override
    public void onAsynchronousException(MessageTransport source, Exception e) {
        e.printStackTrace();
    }

    public MessageTransport getMessageTransport() {
        return this.messageTransport;
    }

    public void setMessageTransport(MessageTransport newMessageTransport) {
        this.messageTransport = newMessageTransport;
    }

    public long getAliveInterval() {
        return this.aliveInterval;
    }

    public void setAliveInterval(long interval) {
        this.aliveInterval = interval;
    }

    public long getAdvertiseInterval() {
        return this.advertiseInterval;
    }

    public void setAdvertiseInterval(long interval) {
        this.advertiseInterval = interval;
    }

    private ArrayList<IServiceDescription> findAllComplexServices() {
        ArrayList<IServiceDescription> ret = new ArrayList<IServiceDescription>();
        for (IActionDescription localAct : this.localActions) {
            if (!(localAct instanceof IServiceDescription)) continue;
            ret.add((IServiceDescription)localAct);
        }
        for (String key : this.remoteActions.keySet()) {
            Set<IActionDescription> remoteActSet = this.remoteActions.get(key);
            for (IActionDescription remoteAct : remoteActSet) {
                if (!(remoteAct instanceof IServiceDescription)) continue;
                ret.add((IServiceDescription)remoteAct);
            }
        }
        return ret;
    }

    private void sendMessage(JiacMessage message, ICommunicationAddress address) {
        message.setSender(this.myAddress);
        message.setHeader("UUID", this.agentNode.getUUID());
        try {
            this.messageTransport.send(message, address, 0L);
        }
        catch (Exception e) {
            this.log.error((Object)("sendMessage failed. Message:\n" + message.toString()), (Throwable)e);
        }
    }

    private void sendAdvertisement(ICommunicationAddress destination) {
        JiacMessage adMessage = new JiacMessage();
        adMessage.setSender(this.myAddress);
        adMessage.setHeader("UUID", this.agentNode.getUUID());
        adMessage.setProtocol(ADVERTISE);
        HashSet<IActionDescription> advActions = new HashSet<IActionDescription>();
        for (IActionDescription iad : this.localActions) {
            if (iad instanceof IServiceDescription) {
                IServiceDescription isd = (IServiceDescription)iad;
                isd.setOntologySource(this.ontologyStorage.serializeServiceDescription(isd));
            }
            advActions.add(iad);
        }
        Advertisement ad = new Advertisement(this.localAgents, advActions);
        ad.setJmxURLs(this.agentNode.getJmxURLs());
        adMessage.setPayload(ad);
        Advertisement payload = (Advertisement)adMessage.getPayload();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sendAdvertisement: jmxURLs=" + payload.getJmxURLs().size() + " agents=" + payload.getAgents().size() + " actions=" + payload.getActions().size()));
        }
        try {
            this.messageTransport.send(adMessage, destination, 0L);
        }
        catch (Exception e) {
            this.log.error((Object)("sendMessage failed. Message:\n" + adMessage.toString()), (Throwable)e);
        }
    }

    private void removeRemoteAgentOfNode(String nodeId) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : this.remoteAgents.keySet()) {
            IAgentDescription agent = this.remoteAgents.get(key);
            if (!nodeId.equals(agent.getAgentNodeUUID())) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            this.remoteAgents.remove(key);
        }
    }

    private void dump(String cause) {
        if (this.dump) {
            System.out.println("\n####Dump " + this.myAgentNode + " " + cause);
            System.out.println("Registered local agents:   " + this.localAgents.size());
            System.out.println("Registered local actions:  " + this.localActions.size());
            int actions = 0;
            for (String key : this.remoteActions.keySet()) {
                actions += this.remoteActions.get(key).size();
            }
            System.out.println("Registered remote agents:  " + this.remoteAgents.size());
            System.out.println("Registered remote actions: " + actions);
            System.out.println("Known agentnodes:          " + this.nodes.size());
            System.out.println("####End dump\n");
        }
    }

    public boolean isDump() {
        return this.dump;
    }

    public void setDump(boolean newDump) {
        this.dump = newDump;
    }

    public TabularData getKnownNodes() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        Set<Map.Entry<String, AgentNodeDescription>> entries = this.nodes.entrySet();
        try {
            String[] itemNames = new String[]{"UUID", "description"};
            CompositeType nodeType = new CompositeType(entries.iterator().next().getClass().getName(), "agent node description corresponding to an agent node UUID", itemNames, itemNames, new OpenType[]{SimpleType.STRING, entries.iterator().next().getValue().getDescriptionType()});
            TabularType type = new TabularType(this.nodes.getClass().getName(), "node descriptions stored in the directory", nodeType, new String[]{"UUID"});
            TabularDataSupport data = new TabularDataSupport(type);
            for (Map.Entry<String, AgentNodeDescription> node : entries) {
                CompositeDataSupport nodeData = new CompositeDataSupport(nodeType, itemNames, new Object[]{node.getKey(), node.getValue().getDescription()});
                data.put(nodeData);
            }
            return data;
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TabularData getLocalActions() {
        if (this.localActions.isEmpty()) {
            return null;
        }
        try {
            TabularType type = new TabularType(this.localActions.getClass().getName(), "local actions stored in the directory", (CompositeType)this.localActions.iterator().next().getDescriptionType(), new String[]{"name", "input types", "result types", "agent"});
            TabularDataSupport data = new TabularDataSupport(type);
            for (IActionDescription action : this.localActions) {
                data.put((CompositeData)action.getDescription());
            }
            return data;
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TabularData getLocalAgents() {
        if (this.localAgents.isEmpty()) {
            return null;
        }
        Set<Map.Entry<String, IAgentDescription>> entries = this.localAgents.entrySet();
        try {
            String[] itemNames = new String[]{"Agent ID", "description"};
            CompositeType agentType = new CompositeType(entries.iterator().next().getClass().getName(), "local agent description corresponding to an agent id", itemNames, itemNames, new OpenType[]{SimpleType.STRING, entries.iterator().next().getValue().getDescriptionType()});
            TabularType type = new TabularType(this.localAgents.getClass().getName(), "local agent descriptions stored in the directory", agentType, new String[]{"Agent ID"});
            TabularDataSupport data = new TabularDataSupport(type);
            for (Map.Entry<String, IAgentDescription> agent : entries) {
                CompositeDataSupport agentData = new CompositeDataSupport(agentType, itemNames, new Object[]{agent.getKey(), agent.getValue().getDescription()});
                data.put(agentData);
            }
            return data;
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TabularData getRemoteActions() {
        if (this.remoteActions.isEmpty()) {
            return null;
        }
        Set<Map.Entry<String, Set<IActionDescription>>> entries = this.remoteActions.entrySet();
        try {
            String[] itemNames = new String[]{"agent node UUID", "remote actions"};
            CompositeType entryType = new CompositeType(entries.iterator().next().getClass().getName(), "remote action descriptions corresponding to an agent node UUID", itemNames, itemNames, new OpenType[]{SimpleType.STRING, ArrayType.getArrayType(new Action().getDescriptionType())});
            TabularType type = new TabularType(this.remoteActions.getClass().getName(), "remote action descriptions stored in the directory", entryType, new String[]{"agent node UUID"});
            TabularDataSupport data = new TabularDataSupport(type);
            for (Map.Entry<String, Set<IActionDescription>> entry : entries) {
                int i = 0;
                Set<IActionDescription> values = entry.getValue();
                CompositeData[] actions = new CompositeData[values.size()];
                for (IActionDescription action : values) {
                    actions[i++] = (CompositeData)action.getDescription();
                }
                CompositeDataSupport entryData = new CompositeDataSupport(entryType, itemNames, new Object[]{entry.getKey(), actions});
                data.put(entryData);
            }
            return data;
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TabularData getRemoteAgents() {
        if (this.remoteAgents.isEmpty()) {
            return null;
        }
        Set<Map.Entry<String, IAgentDescription>> entries = this.remoteAgents.entrySet();
        try {
            String[] itemNames = new String[]{"Agent ID", "description"};
            CompositeType agentType = new CompositeType(entries.iterator().next().getClass().getName(), "remote agent description corresponding to an agent id", itemNames, itemNames, new OpenType[]{SimpleType.STRING, entries.iterator().next().getValue().getDescriptionType()});
            TabularType type = new TabularType(this.remoteAgents.getClass().getName(), "remote agent descriptions stored in the directory", agentType, new String[]{"Agent ID"});
            TabularDataSupport data = new TabularDataSupport(type);
            for (Map.Entry<String, IAgentDescription> agent : entries) {
                CompositeDataSupport agentData = new CompositeDataSupport(agentType, itemNames, new Object[]{agent.getKey(), agent.getValue().getDescription()});
                data.put(agentData);
            }
            return data;
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    class AgentNodePinger
    extends TimerTask {
        private long counter = 0L;

        AgentNodePinger() {
        }

        @Override
        public void run() {
            if (this.counter < DirectoryAgentNodeBean.this.advertiseInterval) {
                JiacMessage aliveMessage = new JiacMessage();
                aliveMessage.setProtocol(DirectoryAgentNodeBean.ALIVE);
                DirectoryAgentNodeBean.this.sendMessage(aliveMessage, DirectoryAgentNodeBean.this.groupAddress);
                this.counter += DirectoryAgentNodeBean.this.aliveInterval;
            } else {
                this.counter = 0L;
                DirectoryAgentNodeBean.this.sendAdvertisement(DirectoryAgentNodeBean.this.groupAddress);
            }
            HashSet<String> deadNodes = new HashSet<String>();
            for (String key : DirectoryAgentNodeBean.this.nodes.keySet()) {
                if (((AgentNodeDescription)DirectoryAgentNodeBean.this.nodes.get(key)).getAlive() >= System.currentTimeMillis() - 5L * DirectoryAgentNodeBean.this.aliveInterval) continue;
                deadNodes.add(key);
            }
            if (deadNodes.size() > 0) {
                DirectoryAgentNodeBean.this.log.warn((Object)"removing node:\n");
                for (String key : deadNodes) {
                    DirectoryAgentNodeBean.this.log.warn((Object)("\t" + key));
                    DirectoryAgentNodeBean.this.remoteActions.remove(key);
                    DirectoryAgentNodeBean.this.removeRemoteAgentOfNode(key);
                    DirectoryAgentNodeBean.this.nodes.remove(key);
                }
            }
        }
    }
}

