/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.execution;

import de.dailab.jiactng.agentcore.AbstractAgentBean;
import de.dailab.jiactng.agentcore.IAgentBean;
import de.dailab.jiactng.agentcore.action.AbstractActionAuthorizationBean;
import de.dailab.jiactng.agentcore.action.Action;
import de.dailab.jiactng.agentcore.action.ActionResult;
import de.dailab.jiactng.agentcore.action.DoAction;
import de.dailab.jiactng.agentcore.action.Session;
import de.dailab.jiactng.agentcore.environment.IEffector;
import de.dailab.jiactng.agentcore.environment.ResultReceiver;
import de.dailab.jiactng.agentcore.execution.AbstractExecutionCycleMBean;
import de.dailab.jiactng.agentcore.execution.IExecutionCycle;
import de.dailab.jiactng.agentcore.execution.RemoteExecutor;
import de.dailab.jiactng.agentcore.management.Manager;
import de.dailab.jiactng.agentcore.management.jmx.ActionPerformedNotification;
import de.dailab.jiactng.agentcore.management.jmx.DoActionState;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;

public abstract class AbstractExecutionCycle
extends AbstractAgentBean
implements IExecutionCycle,
AbstractExecutionCycleMBean {
    private int[] workload = new int[]{0, 0, 0};
    private static final String[] ATTRIBUTES = new String[]{"ExecutionWorkload", "DoActionWorkload", "ActionResultWorkload"};
    protected static final int EXECUTION = 0;
    protected static final int DO_ACTION = 1;
    protected static final int ACTION_RESULT = 2;
    private int queueSize = 100;
    private LinkedBlockingQueue[] queues = new LinkedBlockingQueue[]{new LinkedBlockingQueue(this.queueSize), new LinkedBlockingQueue(this.queueSize), new LinkedBlockingQueue(this.queueSize)};
    private List<String> autoExecutionServices = null;
    private boolean continousAutoExecution = false;
    private RemoteExecutor remoteExecutor;
    private boolean useRemoteExecutor = true;

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (this.useRemoteExecutor) {
            this.remoteExecutor = new RemoteExecutor(this.memory, this.thisAgent.getLog((IAgentBean)this, "RemoteExecutor"));
        }
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        if (this.useRemoteExecutor) {
            this.remoteExecutor.cleanup();
            this.remoteExecutor = null;
        }
    }

    protected void performDoAction(DoAction act) {
        if (this.useRemoteExecutor && act.getAction().getProviderDescription() != null && !act.getAction().getProviderDescription().getAid().equals(this.thisAgent.getAgentId())) {
            this.remoteExecutor.executeRemote(act);
            return;
        }
        this.actionPerformed(act, DoActionState.invoked, null);
        IEffector providerBean = ((Action)act.getAction()).getProviderBean();
        if (providerBean != null) {
            try {
                Session session;
                if (act.getAction().getResultTypes() != null && act.getAction().getResultTypes().size() > 0) {
                    session = act.getSession();
                    if (session.getCurrentCallDepth() == null) {
                        session.setCurrentCallDepth(1);
                    } else {
                        session.setCurrentCallDepth(session.getCurrentCallDepth() + 1);
                    }
                    this.memory.write((Object)act.getSession());
                }
                if ((session = act.getSession()).getUserToken() == null && session.getOriginalProvider() != null && session.getOriginalUser() != null && session.getOriginalUser().equals(session.getOriginalProvider())) {
                    providerBean.doAction(act);
                } else if (providerBean instanceof AbstractActionAuthorizationBean) {
                    ((AbstractActionAuthorizationBean)providerBean).authorize(act);
                } else {
                    providerBean.doAction(act);
                }
                this.actionPerformed(act, DoActionState.started, null);
            }
            catch (Throwable t) {
                this.memory.write((Object)new ActionResult(act, (Serializable)t));
                this.log.error((Object)("--- action failed: " + act.getAction().getName()), t);
            }
        } else {
            this.actionPerformed(act, DoActionState.failed, new Object[]{"Action without provider bean"});
            this.log.error((Object)("--- found action without bean: " + act.getAction().getName()));
        }
    }

    protected void processResult(ActionResult actionResult) {
        Object[] objectArray;
        DoAction doAct = (DoAction)actionResult.getSource();
        DoActionState doActionState = actionResult.getFailure() == null ? DoActionState.success : DoActionState.failed;
        if (actionResult.getFailure() == null) {
            objectArray = actionResult.getResults();
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = actionResult.getFailure();
        }
        this.actionPerformed(doAct, doActionState, objectArray);
        Session session = doAct.getSession();
        if (session.getCurrentCallDepth() == null) {
            session.setCurrentCallDepth(1);
        }
        session.setCurrentCallDepth(session.getCurrentCallDepth() - 1);
        if (this.memory.read((Object)session) == null) {
            if (doAct.getAction().getResultTypeNames() != null && doAct.getAction().getResultTypeNames().size() > 0) {
                this.log.warn((Object)("ActionResult for Action " + actionResult.getAction().getName() + " written with non existing Session."));
            }
        } else if (session.getCurrentCallDepth() <= 0) {
            this.memory.remove((Object)session);
            this.log.debug((Object)("Session removed for action " + doAct.getAction().getName()));
        }
        if (doAct.getSource() == null) {
            this.log.debug((Object)("No ResultReceiver for action " + doAct.getAction().getName()));
        } else {
            ((ResultReceiver)doAct.getSource()).receiveResult(actionResult);
            this.log.debug((Object)("ResultReceiver informed about result of action " + doAct.getAction().getName()));
        }
    }

    public int getExecutionWorkload() {
        return this.workload[0];
    }

    public int getDoActionWorkload() {
        return this.workload[1];
    }

    public int getActionResultWorkload() {
        return this.workload[2];
    }

    protected void updateWorkload(int type, boolean active) {
        LinkedBlockingQueue queue = this.queues[type];
        if (queue.remainingCapacity() == 0) {
            queue.poll();
        }
        queue.offer(active);
        int actives = 0;
        Iterator i$ = queue.iterator();
        while (i$.hasNext()) {
            boolean elem = (Boolean)i$.next();
            if (!elem) continue;
            ++actives;
        }
        int oldWorkload = this.workload[type];
        this.workload[type] = actives * 100 / this.queueSize;
        if (oldWorkload != this.workload[type]) {
            this.workloadChanged(ATTRIBUTES[type], oldWorkload, this.workload[type]);
        }
    }

    private void workloadChanged(String attribute, int oldWorkload, int newWorkload) {
        AttributeChangeNotification n = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Workload changed ", attribute, "int", oldWorkload, newWorkload);
        this.sendNotification(n);
    }

    public void actionPerformed(DoAction action, DoActionState state, Object[] result) {
        ActionPerformedNotification n = new ActionPerformedNotification((Object)this, this.sequenceNumber++, System.currentTimeMillis(), "Action performed", action, state, result);
        this.sendNotification((Notification)n);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo info;
        MBeanNotificationInfo[] parent = super.getNotificationInfo();
        int size = parent.length;
        MBeanNotificationInfo[] result = new MBeanNotificationInfo[size + 1];
        for (int i = 0; i < size; ++i) {
            result[i] = parent[i];
        }
        String[] types = new String[]{"jiactng.action.perform"};
        String name = ActionPerformedNotification.class.getName();
        String description = "An action was performed";
        result[size] = info = new MBeanNotificationInfo(types, name, "An action was performed");
        return result;
    }

    @Override
    public void enableManagement(Manager manager) {
        if (this.isManagementEnabled()) {
            return;
        }
        try {
            manager.registerAgentResource(this.thisAgent, "ExecutionCycle", (Object)this);
        }
        catch (Exception e) {
            System.err.println("WARNING: Unable to register execution cycle of agent " + this.thisAgent.getAgentName() + " of agent node " + this.thisAgent.getAgentNode().getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
        this._manager = manager;
    }

    @Override
    public void disableManagement() {
        if (!this.isManagementEnabled()) {
            return;
        }
        try {
            this._manager.unregisterAgentResource(this.thisAgent, "ExecutionCycle");
        }
        catch (Exception e) {
            System.err.println("WARNING: Unable to deregister execution cycle of agent " + this.thisAgent.getAgentName() + " of agent node " + this.thisAgent.getAgentNode().getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
        this._manager = null;
    }

    public void setAutoExecutionServices(List<String> actionIds) {
        this.autoExecutionServices = actionIds;
    }

    public List<String> getAutoExecutionServices() {
        return this.autoExecutionServices;
    }

    public void setAutoExecutionType(boolean continous) {
        this.continousAutoExecution = continous;
    }

    public boolean getAutoExecutionType() {
        return this.continousAutoExecution;
    }

    public boolean isUseRemoteExecutor() {
        return this.useRemoteExecutor;
    }

    public void setUseRemoteExecutor(boolean newUseRemoteExecutor) {
        this.useRemoteExecutor = newUseRemoteExecutor;
    }

    public static class TimeoutException
    extends RuntimeException {
        public TimeoutException(String s) {
            super(s);
        }
    }
}

