/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.execution;

import de.dailab.jiactng.agentcore.IAgentBean;
import de.dailab.jiactng.agentcore.action.Action;
import de.dailab.jiactng.agentcore.action.ActionResult;
import de.dailab.jiactng.agentcore.action.DoAction;
import de.dailab.jiactng.agentcore.action.Session;
import de.dailab.jiactng.agentcore.action.SessionEvent;
import de.dailab.jiactng.agentcore.environment.ResultReceiver;
import de.dailab.jiactng.agentcore.execution.AbstractExecutionCycle;
import de.dailab.jiactng.agentcore.execution.NonBlockingExecutionCycleMBean;
import de.dailab.jiactng.agentcore.lifecycle.ILifecycle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Future;

public class NonBlockingExecutionCycle
extends AbstractExecutionCycle
implements NonBlockingExecutionCycleMBean {
    private static final Session SESSION_TEMPLATE = new Session();
    private static final ActionResult ACTIONRESULT_TEMPLATE = new ActionResult(null, null);
    private static final DoAction DOACTION_TEMPLATE = new DoAction(null, null, null, null);
    private Set<ActionResult> pendingResults = new HashSet<ActionResult>();
    private TreeMap<Long, Future<?>> futures = new TreeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long now = System.currentTimeMillis();
        while (!this.futures.isEmpty() && this.futures.firstKey() < now) {
            Future<?> future = this.futures.pollFirstEntry().getValue();
            if (future.cancel(true)) {
                this.log.warn((Object)"Handler was interrupted by the execution cycle due to timeout constraints");
                continue;
            }
            if (future.isCancelled() || future.isDone()) continue;
            this.log.warn((Object)"Handler can not be canceled by the execution cycle");
        }
        Long[] keys = this.futures.keySet().toArray(new Long[this.futures.keySet().size()]);
        for (int i = 0; i < keys.length; ++i) {
            Future<?> future = this.futures.get(keys[i]);
            if (!future.isCancelled() && !future.isDone()) continue;
            this.futures.remove(keys[i]);
        }
        if (this.getState() == ILifecycle.LifecycleStates.STARTED) {
            NonBlockingExecutionCycle nonBlockingExecutionCycle;
            long timeout = now + this.thisAgent.getBeanExecutionTimeout();
            IAgentBean minBean = null;
            long minExecutionTime = Long.MAX_VALUE;
            for (IAgentBean bean : this.thisAgent.getAgentBeans()) {
                if (bean.getState() != ILifecycle.LifecycleStates.STARTED || bean.getExecuteInterval() <= 0 || bean.getNextExecutionTime() > now || bean.getNextExecutionTime() > minExecutionTime) continue;
                minBean = bean;
                minExecutionTime = bean.getNextExecutionTime();
            }
            boolean executionDone = false;
            if (minBean != null) {
                executionDone = true;
                Future<?> executionFuture = this.thisAgent.getThreadPool().submit(new ExecutionHandler(minBean));
                this.futures.put(timeout++, executionFuture);
                minBean.setNextExecutionTime(now + (long)minBean.getExecuteInterval());
            }
            this.updateWorkload(0, executionDone);
            DoAction act = (DoAction)this.memory.remove((Object)DOACTION_TEMPLATE);
            boolean actionPerformed = false;
            if (act != null) {
                actionPerformed = true;
                NonBlockingExecutionCycle nonBlockingExecutionCycle2 = this;
                synchronized (nonBlockingExecutionCycle2) {
                    Future<?> doActionFuture = this.thisAgent.getThreadPool().submit(new DoActionHandler(act));
                    this.futures.put(timeout++, doActionFuture);
                }
            }
            this.updateWorkload(1, actionPerformed);
            Set resultSet = this.memory.removeAll((Object)ACTIONRESULT_TEMPLATE);
            int countNew = 0;
            for (ActionResult ar : resultSet) {
                NonBlockingExecutionCycle nonBlockingExecutionCycle3 = this;
                synchronized (nonBlockingExecutionCycle3) {
                    this.pendingResults.add(ar);
                    ++countNew;
                }
            }
            boolean resultProcessed = false;
            if (!this.pendingResults.isEmpty()) {
                resultProcessed = true;
                nonBlockingExecutionCycle = this;
                synchronized (nonBlockingExecutionCycle) {
                    ActionResult actionResult = this.pendingResults.iterator().next();
                    Future<?> actionResultFuture = this.thisAgent.getThreadPool().submit(new ActionResultHandler(actionResult));
                    this.futures.put(timeout++, actionResultFuture);
                    this.pendingResults.remove(actionResult);
                }
            }
            this.updateWorkload(2, resultProcessed);
            nonBlockingExecutionCycle = this.memory;
            synchronized (nonBlockingExecutionCycle) {
                Set sessions = this.memory.readAll((Object)SESSION_TEMPLATE);
                for (Session session : sessions) {
                    if (!session.isTimeout()) continue;
                    ArrayList history = session.getHistory();
                    boolean doActionFound = false;
                    for (SessionEvent event : history) {
                        if (!(event instanceof DoAction)) continue;
                        doActionFound = true;
                        DoAction doAction = (DoAction)event;
                        if (!(doAction.getAction() instanceof Action)) continue;
                        Future<?> sessionTimeoutFuture = this.thisAgent.getThreadPool().submit(new SessionTimeoutHandler(session, doAction));
                        this.futures.put(timeout++, sessionTimeoutFuture);
                    }
                    if (!doActionFound) {
                        this.log.warn((Object)("Session with no DoAction was deleted due to timeout. Session: " + session));
                    }
                    this.memory.remove((Object)session);
                }
            }
        }
        this.log.error((Object)("Trying to run NonBlockingExecutionCycle in state " + this.getState()));
    }

    public int getRunningHandlers() {
        return this.futures.size();
    }

    private class SessionTimeoutHandler
    implements Runnable {
        private Session session;
        private DoAction doAction;

        public SessionTimeoutHandler(Session session, DoAction doAction) {
            this.session = session;
            this.doAction = doAction;
        }

        @Override
        public void run() {
            Action action = (Action)this.doAction.getAction();
            NonBlockingExecutionCycle.this.log.debug((Object)("canceling DoAction " + this.doAction));
            ActionResult result = action.getProviderBean().cancelAction(this.doAction);
            if (this.session.getSource() != null) {
                NonBlockingExecutionCycle.this.log.debug((Object)("sending timeout Result to source of Session " + this.session));
                ResultReceiver receiver = this.session.getSource();
                if (result == null) {
                    result = new ActionResult(this.doAction, (Serializable)new AbstractExecutionCycle.TimeoutException("DoAction has timeout"));
                }
                receiver.receiveResult(result);
            } else {
                NonBlockingExecutionCycle.this.log.warn((Object)("Session without Source: DoAction has to be canceled due to sessiontimeout " + this.doAction));
            }
        }
    }

    private class ActionResultHandler
    implements Runnable {
        private ActionResult actionResult;

        public ActionResultHandler(ActionResult actionResult) {
            this.actionResult = actionResult;
        }

        @Override
        public void run() {
            NonBlockingExecutionCycle.this.processResult(this.actionResult);
        }
    }

    private class DoActionHandler
    implements Runnable {
        private DoAction act;

        public DoActionHandler(DoAction act) {
            this.act = act;
        }

        @Override
        public void run() {
            NonBlockingExecutionCycle.this.performDoAction(this.act);
        }
    }

    private class ExecutionHandler
    implements Runnable {
        private IAgentBean minBean;

        public ExecutionHandler(IAgentBean minBean) {
            this.minBean = minBean;
        }

        @Override
        public void run() {
            try {
                this.minBean.execute();
            }
            catch (Exception ex) {
                NonBlockingExecutionCycle.this.log.error((Object)("Error when executing bean '" + this.minBean.getBeanName() + "'"), (Throwable)ex);
            }
        }
    }
}

