/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.execution;

import de.dailab.jiactng.agentcore.action.Action;
import de.dailab.jiactng.agentcore.action.ActionResult;
import de.dailab.jiactng.agentcore.action.DoAction;
import de.dailab.jiactng.agentcore.action.Session;
import de.dailab.jiactng.agentcore.comm.ICommunicationAddress;
import de.dailab.jiactng.agentcore.comm.IMessageBoxAddress;
import de.dailab.jiactng.agentcore.comm.message.IJiacMessage;
import de.dailab.jiactng.agentcore.comm.message.JiacMessage;
import de.dailab.jiactng.agentcore.environment.ResultReceiver;
import de.dailab.jiactng.agentcore.execution.RemoteExecutionException;
import de.dailab.jiactng.agentcore.knowledge.IFact;
import de.dailab.jiactng.agentcore.knowledge.IMemory;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.sercho.masp.space.event.SpaceEvent;
import org.sercho.masp.space.event.SpaceObserver;
import org.sercho.masp.space.event.WriteCallEvent;

public class RemoteExecutor
implements SpaceObserver<IFact>,
ResultReceiver {
    private static final long serialVersionUID = -6391933561226831472L;
    private static final String INVOKE = "invoke";
    private IMemory memory;
    private Log log;
    private Action sendAction;
    private HashMap<String, DoAction> remoteInvocations = new HashMap();
    private HashMap<String, JiacMessage> localInvocations = new HashMap();

    public RemoteExecutor(IMemory memory, Log log) {
        this.memory = memory;
        this.log = log;
        JiacMessage template = new JiacMessage();
        template.setProtocol(INVOKE);
        memory.attach((SpaceObserver)this, (Object)template);
        this.sendAction = (Action)memory.read((Object)new Action("de.dailab.jiactng.agentcore.comm.ICommunicationBean#send", null, new Class[]{IJiacMessage.class, ICommunicationAddress.class}, null));
    }

    public void notify(SpaceEvent<? extends IFact> event) {
        JiacMessage message;
        WriteCallEvent writeCallEvent;
        if (event instanceof WriteCallEvent && (writeCallEvent = (WriteCallEvent)event).getObject() instanceof JiacMessage && (message = (JiacMessage)writeCallEvent.getObject()).getProtocol().equals(INVOKE)) {
            if (this.memory.remove((Object)message) == null) {
                this.log.warn((Object)"Received JIAC message already removed from memory by another agent component.");
            }
            if (message.getPayload() instanceof DoAction) {
                DoAction doAction = (DoAction)message.getPayload();
                Action localAction = (Action)this.memory.read((Object)doAction.getAction());
                if (localAction != null) {
                    DoAction localDoAction = localAction.createDoAction(doAction.getSession(), doAction.getParams(), this);
                    this.localInvocations.put(localDoAction.getSessionId(), message);
                    this.memory.write((Object)localDoAction);
                } else {
                    RemoteExecutionException ree = new RemoteExecutionException("No action found at provider!" + doAction.getAction().getProviderDescription().getAid());
                    ActionResult failure = new ActionResult(doAction, (Serializable)ree);
                    JiacMessage failureMessage = new JiacMessage((IFact)failure);
                    failureMessage.setProtocol(INVOKE);
                    Serializable[] params = new Serializable[]{failureMessage, message.getSender()};
                    DoAction sendDoAction = this.sendAction.createDoAction(params, this);
                    this.memory.write((Object)sendDoAction);
                }
            } else if (message.getPayload() instanceof ActionResult) {
                ActionResult result = (ActionResult)message.getPayload();
                result.setSource((Object)this.remoteInvocations.get(result.getSessionId()));
                this.memory.write((Object)result);
            } else {
                System.err.println("Got strange message: " + message.toString());
            }
        }
    }

    public void executeRemote(DoAction doAction) {
        IMessageBoxAddress destination = doAction.getAction().getProviderDescription().getMessageBoxAddress();
        if (destination == null) {
            this.memory.write((Object)new ActionResult(doAction, (Serializable)new RemoteExecutionException("Provider has no address!")));
            return;
        }
        JiacMessage message = new JiacMessage((IFact)doAction);
        message.setProtocol(INVOKE);
        Serializable[] params = new Serializable[]{message, destination};
        DoAction sendDoAction = this.sendAction.createDoAction(params, this);
        this.memory.write((Object)sendDoAction);
        this.remoteInvocations.put(doAction.getSessionId(), doAction);
        Action act = (Action)doAction.getAction();
        try {
            if (act.getResultTypes() != null && act.getResultTypes().size() > 0) {
                Session session = doAction.getSession();
                if (session.getCurrentCallDepth() == null) {
                    session.setCurrentCallDepth(1);
                } else {
                    session.setCurrentCallDepth(session.getCurrentCallDepth() + 1);
                }
                this.memory.write((Object)doAction.getSession());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void cleanup() {
        this.memory.detach((SpaceObserver)this);
    }

    public void receiveResult(ActionResult result) {
        ActionResult resultToSend;
        if (result.getAction().equals(this.sendAction)) {
            return;
        }
        JiacMessage message = this.localInvocations.get(result.getSessionId());
        DoAction doAction = (DoAction)message.getPayload();
        if (result.getResults() != null) {
            Action action = (Action)doAction.getAction();
            resultToSend = action.createActionResult(doAction, result.getResults());
        } else {
            resultToSend = new ActionResult(doAction, result.getFailure());
        }
        JiacMessage resultMessage = new JiacMessage((IFact)resultToSend);
        resultMessage.setProtocol(INVOKE);
        Serializable[] params = new Serializable[]{resultMessage, message.getSender()};
        DoAction sendDoAction = this.sendAction.createDoAction(params, this);
        this.memory.write((Object)sendDoAction);
    }
}

