/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.execution;

import de.dailab.jiactng.agentcore.IAgentBean;
import de.dailab.jiactng.agentcore.action.Action;
import de.dailab.jiactng.agentcore.action.ActionResult;
import de.dailab.jiactng.agentcore.action.DoAction;
import de.dailab.jiactng.agentcore.action.Session;
import de.dailab.jiactng.agentcore.action.SessionEvent;
import de.dailab.jiactng.agentcore.environment.ResultReceiver;
import de.dailab.jiactng.agentcore.execution.AbstractExecutionCycle;
import de.dailab.jiactng.agentcore.lifecycle.ILifecycle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class SimpleExecutionCycle
extends AbstractExecutionCycle {
    private static final Session SESSION_TEMPLATE = new Session();
    private static final ActionResult ACTIONRESULT_TEMPLATE = new ActionResult(null, null);
    private static final DoAction DOACTION_TEMPLATE = new DoAction(null, null, null, null);
    private Set<ActionResult> pendingResults = new HashSet<ActionResult>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.getState() == ILifecycle.LifecycleStates.STARTED) {
            SimpleExecutionCycle simpleExecutionCycle;
            IAgentBean minBean = null;
            long minExecutionTime = Long.MAX_VALUE;
            long now = System.currentTimeMillis();
            for (IAgentBean bean : this.thisAgent.getAgentBeans()) {
                if (bean.getState() != ILifecycle.LifecycleStates.STARTED || bean.getExecuteInterval() <= 0 || bean.getNextExecutionTime() > now || bean.getNextExecutionTime() > minExecutionTime) continue;
                minBean = bean;
                minExecutionTime = bean.getNextExecutionTime();
            }
            boolean executionDone = false;
            if (minBean != null) {
                executionDone = true;
                try {
                    minBean.execute();
                }
                catch (Exception ex) {
                    this.log.error((Object)("Error when executing bean '" + minBean.getBeanName() + "'"), (Throwable)ex);
                }
                minBean.setNextExecutionTime(now + (long)minBean.getExecuteInterval());
            }
            this.updateWorkload(0, executionDone);
            DoAction act = (DoAction)this.memory.remove((Object)DOACTION_TEMPLATE);
            boolean actionPerformed = false;
            if (act != null) {
                actionPerformed = true;
                SimpleExecutionCycle simpleExecutionCycle2 = this;
                synchronized (simpleExecutionCycle2) {
                    this.performDoAction(act);
                }
            }
            this.updateWorkload(1, actionPerformed);
            Set resultSet = this.memory.removeAll((Object)ACTIONRESULT_TEMPLATE);
            int countNew = 0;
            for (ActionResult ar : resultSet) {
                SimpleExecutionCycle simpleExecutionCycle3 = this;
                synchronized (simpleExecutionCycle3) {
                    this.pendingResults.add(ar);
                    ++countNew;
                }
            }
            boolean resultProcessed = false;
            if (!this.pendingResults.isEmpty()) {
                resultProcessed = true;
                simpleExecutionCycle = this;
                synchronized (simpleExecutionCycle) {
                    ActionResult actionResult = this.pendingResults.iterator().next();
                    this.processResult(actionResult);
                    this.pendingResults.remove(actionResult);
                }
            }
            this.updateWorkload(2, resultProcessed);
            simpleExecutionCycle = this.memory;
            synchronized (simpleExecutionCycle) {
                Set sessions = this.memory.readAll((Object)SESSION_TEMPLATE);
                for (Session session : sessions) {
                    if (!session.isTimeout()) continue;
                    ArrayList history = session.getHistory();
                    boolean doActionFound = false;
                    for (SessionEvent event : history) {
                        if (!(event instanceof DoAction)) continue;
                        doActionFound = true;
                        DoAction doAction = (DoAction)event;
                        if (!(doAction.getAction() instanceof Action)) continue;
                        Action action = (Action)doAction.getAction();
                        this.log.debug((Object)("canceling DoAction " + doAction));
                        ActionResult result = null;
                        if (action == null) {
                            this.log.warn((Object)("Found doAction with missing action:" + doAction));
                        } else if (action.getProviderBean() == null) {
                            this.log.warn((Object)("Found doAction with missing providerBean:" + action));
                        } else {
                            result = action.getProviderBean().cancelAction(doAction);
                        }
                        if (session.getSource() != null) {
                            this.log.debug((Object)("sending timeout Result to source of Session " + session));
                            ResultReceiver receiver = session.getSource();
                            if (result == null) {
                                result = new ActionResult(doAction, (Serializable)new AbstractExecutionCycle.TimeoutException("DoAction has timeout"));
                            }
                            receiver.receiveResult(result);
                            continue;
                        }
                        this.log.warn((Object)("Session without Source: DoAction has to be canceled due to sessiontimeout " + doAction));
                    }
                    if (!doActionFound) {
                        this.log.warn((Object)("Session with no DoAction was deleted due to timeout. Session: " + session));
                    }
                    this.memory.remove((Object)session);
                }
            }
        }
        this.log.error((Object)("Trying to run SimpleExecutionCycle in state " + this.getState()));
    }
}

