/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.knowledge;

import de.dailab.jiactng.agentcore.IAgent;
import de.dailab.jiactng.agentcore.knowledge.IFact;
import de.dailab.jiactng.agentcore.knowledge.IMemory;
import de.dailab.jiactng.agentcore.knowledge.MemoryMBean;
import de.dailab.jiactng.agentcore.lifecycle.AbstractLifecycle;
import de.dailab.jiactng.agentcore.management.Manager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.security.auth.DestroyFailedException;
import org.sercho.masp.space.ObjectMatcher;
import org.sercho.masp.space.ObjectUpdater;
import org.sercho.masp.space.SimpleObjectSpace;
import org.sercho.masp.space.TupleSpace;
import org.sercho.masp.space.event.EventedSpaceWrapper;
import org.sercho.masp.space.event.EventedTupleSpace;
import org.sercho.masp.space.event.SpaceObserver;

public class Memory
extends AbstractLifecycle
implements IMemory,
MemoryMBean {
    private static final long serialVersionUID = -5229424084593098741L;
    private EventedSpaceWrapper.SpaceDestroyer<IFact> destroyer = null;
    private EventedTupleSpace<IFact> space = null;
    private transient IAgent thisAgent = null;

    @Override
    public void doInit() {
        this.destroyer = EventedSpaceWrapper.getSpaceWithDestroyer((TupleSpace)new SimpleObjectSpace("FactBase"));
        this.space = this.destroyer.destroybleSpace;
    }

    @Override
    public void doStart() {
    }

    @Override
    public void doStop() {
    }

    @Override
    public void doCleanup() {
        try {
            this.destroyer.destroy();
        }
        catch (DestroyFailedException e) {
            e.printStackTrace();
        }
        this.space = null;
        this.destroyer = null;
    }

    public String getID() {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        return this.space.getID();
    }

    public ObjectMatcher getMatcher() {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        return this.space.getMatcher();
    }

    public ObjectUpdater getUpdater() {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        return this.space.getUpdater();
    }

    public <E extends IFact> E read(E template) {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        return (E)((IFact)this.space.read(template));
    }

    public <E extends IFact> E read(E template, long timeout) {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        return (E)((IFact)this.space.read(template, timeout));
    }

    public <E extends IFact> Set<E> readAll(E template) {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        return this.space.readAll(template);
    }

    public <E extends IFact> Set<E> readAllOfType(Class<E> c) {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        return this.space.readAllOfType(c);
    }

    public <E extends IFact> E remove(E template) {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        return (E)((IFact)this.space.remove(template));
    }

    public <E extends IFact> E remove(E template, long timeout) {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        return (E)((IFact)this.space.remove(template, timeout));
    }

    public <E extends IFact> Set<E> removeAll(E template) {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        return this.space.removeAll(template);
    }

    public <E extends IFact> boolean update(E template, E pattern) {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        return this.space.update(template, pattern);
    }

    public void write(IFact fact) {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        this.space.write((Object)fact);
    }

    public Iterator<IFact> iterator() {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        return this.space.iterator();
    }

    public void attach(SpaceObserver<? super IFact> observer) {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        this.space.attach(observer);
    }

    public void attach(SpaceObserver<? super IFact> observer, IFact template) {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        this.space.attach(observer, (Object)template);
    }

    public void detach(SpaceObserver<? super IFact> observer) {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        this.space.detach(observer);
    }

    public void setThisAgent(IAgent agent) {
        this.thisAgent = agent;
    }

    public CompositeData getSpace() {
        Set<IFact> facts = this.readAllOfType(IFact.class);
        if (facts.isEmpty()) {
            return null;
        }
        Hashtable<String, ArrayList<String>> map = new Hashtable<String, ArrayList<String>>();
        for (IFact fact : facts) {
            String classname = fact.getClass().getName();
            ArrayList<String> values = (ArrayList<String>)map.get(classname);
            if (values == null) {
                values = new ArrayList<String>();
                map.put(classname, values);
            }
            values.add(fact.toString());
        }
        CompositeDataSupport data = null;
        int size = map.size();
        String[] itemNames = new String[size];
        OpenType[] itemTypes = new OpenType[size];
        Object[] itemValues = new Object[size];
        Object[] classes = map.keySet().toArray();
        try {
            for (int i = 0; i < size; ++i) {
                String classname;
                itemNames[i] = classname = (String)classes[i];
                itemTypes[i] = new ArrayType(1, SimpleType.STRING);
                List values = (List)map.get(classname);
                String[] value = new String[values.size()];
                Iterator it = values.iterator();
                int j = 0;
                while (it.hasNext()) {
                    value[j] = (String)it.next();
                    ++j;
                }
                itemValues[i] = value;
            }
            CompositeType compositeType = new CompositeType(map.getClass().getName(), "facts stored in the memory", itemNames, itemNames, itemTypes);
            data = new CompositeDataSupport(compositeType, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            e.printStackTrace();
        }
        return data;
    }

    @Override
    public void enableManagement(Manager manager) {
        if (this.isManagementEnabled()) {
            return;
        }
        try {
            manager.registerAgentResource(this.thisAgent, "Memory", (Object)this);
        }
        catch (Exception e) {
            System.err.println("WARNING: Unable to register memory of agent " + this.thisAgent.getAgentName() + " of agent node " + this.thisAgent.getAgentNode().getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
        super.enableManagement(manager);
    }

    @Override
    public void disableManagement() {
        if (!this.isManagementEnabled()) {
            return;
        }
        try {
            this._manager.unregisterAgentResource(this.thisAgent, "Memory");
        }
        catch (Exception e) {
            System.err.println("WARNING: Unable to deregister memory of agent " + this.thisAgent.getAgentName() + " of agent node " + this.thisAgent.getAgentNode().getName() + " as JMX resource.");
            System.err.println(e.getMessage());
        }
        super.disableManagement();
    }

    public Set<IFact> readAll() {
        if (this.space == null) {
            throw new RuntimeException("Memory has not yet been initialized!");
        }
        return this.space.readAll();
    }
}

