/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.lifecycle;

import de.dailab.jiactng.agentcore.lifecycle.AbstractLifecycleMBean;
import de.dailab.jiactng.agentcore.lifecycle.DefaultLifecycleHandler;
import de.dailab.jiactng.agentcore.lifecycle.ILifecycle;
import de.dailab.jiactng.agentcore.lifecycle.ILifecycleListener;
import de.dailab.jiactng.agentcore.lifecycle.LifecycleException;
import de.dailab.jiactng.agentcore.management.Manager;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Level;

public abstract class AbstractLifecycle
extends NotificationBroadcasterSupport
implements ILifecycle,
AbstractLifecycleMBean {
    protected DefaultLifecycleHandler lifecycle = new DefaultLifecycleHandler(this);
    protected Log log = null;
    private String logLevel = null;
    protected Manager _manager = null;
    protected long sequenceNumber = 1L;

    public void init() throws LifecycleException {
        try {
            this.lifecycle.beforeInit();
        }
        catch (IllegalStateException e) {
            switch (this.getState()) {
                case INITIALIZED: 
                case STOPPED: 
                case STARTED: {
                    return;
                }
            }
            throw new LifecycleException("Initialization not allowed in state " + this.getState(), (Throwable)e);
        }
        try {
            this.doInit();
        }
        catch (Throwable t) {
            this.lifecycle.afterInit(false);
            if (t instanceof LifecycleException) {
                throw (LifecycleException)t;
            }
            throw new LifecycleException("Failed to initialize", t);
        }
        this.lifecycle.afterInit(true);
    }

    public void start() throws LifecycleException {
        try {
            this.lifecycle.beforeStart();
        }
        catch (IllegalStateException e) {
            switch (this.getState()) {
                case STARTED: {
                    return;
                }
            }
            throw new LifecycleException("Starting not allowed in state " + this.getState(), (Throwable)e);
        }
        try {
            this.doStart();
        }
        catch (Throwable t) {
            this.lifecycle.afterStart(false);
            if (t instanceof LifecycleException) {
                throw (LifecycleException)t;
            }
            throw new LifecycleException("Failed to start", t);
        }
        this.lifecycle.afterStart(true);
    }

    public void stop() throws LifecycleException {
        try {
            this.lifecycle.beforeStop();
        }
        catch (IllegalStateException e) {
            switch (this.getState()) {
                case INITIALIZED: 
                case STOPPED: 
                case UNDEFINED: 
                case CLEANED_UP: {
                    return;
                }
            }
            throw new LifecycleException("Stopping not allowed in state " + this.getState(), (Throwable)e);
        }
        try {
            this.doStop();
        }
        catch (Throwable t) {
            this.lifecycle.afterStop();
            if (t instanceof LifecycleException) {
                throw (LifecycleException)t;
            }
            throw new LifecycleException("Failed to stop", t);
        }
        this.lifecycle.afterStop();
    }

    public void cleanup() throws LifecycleException {
        try {
            this.lifecycle.beforeCleanup();
        }
        catch (IllegalStateException e) {
            switch (this.getState()) {
                case UNDEFINED: 
                case CLEANED_UP: {
                    return;
                }
            }
            throw new LifecycleException("Cleaning up not allowed in state " + this.getState(), (Throwable)e);
        }
        try {
            this.doCleanup();
        }
        catch (Throwable t) {
            this.lifecycle.afterCleanup();
            if (t instanceof LifecycleException) {
                throw (LifecycleException)t;
            }
            throw new LifecycleException("Failed to clean up", t);
        }
        this.lifecycle.afterCleanup();
    }

    public void addLifecycleListener(ILifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(ILifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public ILifecycle.LifecycleStates getState() {
        return this.lifecycle.getState();
    }

    public String getLifecycleState() {
        return this.getState().toString();
    }

    public void stateChanged(ILifecycle.LifecycleStates oldState, ILifecycle.LifecycleStates newState) {
        AttributeChangeNotification n = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "LifecycleState changed", "LifecycleState", "java.lang.String", oldState.toString(), newState.toString());
        this.sendNotification(n);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"jmx.attribute.change"};
        String name = AttributeChangeNotification.class.getName();
        String description = "An attribute of this MBean has changed";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, "An attribute of this MBean has changed");
        return new MBeanNotificationInfo[]{info};
    }

    public String getLogLevel() {
        if (this.log != null && this.log instanceof Log4JLogger) {
            this.logLevel = ((Log4JLogger)this.log).getLogger().getEffectiveLevel().toString();
        }
        return this.logLevel;
    }

    public void setLogLevel(String level) {
        this.logLevel = level;
        if (this.log != null && this.log instanceof Log4JLogger) {
            ((Log4JLogger)this.log).getLogger().setLevel(Level.toLevel((String)this.logLevel));
        }
    }

    protected void setLog(Log newLog) {
        this.log = newLog;
        if (this.log != null && this.logLevel != null && this.log instanceof Log4JLogger) {
            ((Log4JLogger)this.log).getLogger().setLevel(Level.toLevel((String)this.logLevel));
        }
    }

    public CompositeData getLogger() {
        if (this.log == null) {
            return null;
        }
        String[] itemNames = new String[]{"class", "debug", "error", "fatal", "info", "trace", "warn"};
        try {
            CompositeType type = new CompositeType("javax.management.openmbean.CompositeDataSupport", "Logger information", itemNames, new String[]{"Implementation of the logger instance", "debug", "error", "fatal", "info", "trace", "warn"}, new OpenType[]{SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.BOOLEAN});
            return new CompositeDataSupport(type, itemNames, new Object[]{this.log.getClass().getName(), this.log.isDebugEnabled(), this.log.isErrorEnabled(), this.log.isFatalEnabled(), this.log.isInfoEnabled(), this.log.isTraceEnabled(), this.log.isWarnEnabled()});
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void enableManagement(Manager manager) {
        this._manager = manager;
    }

    public void disableManagement() {
        this._manager = null;
    }

    public boolean isManagementEnabled() {
        return this._manager != null;
    }

    public abstract void doInit() throws Exception;

    public abstract void doStart() throws Exception;

    public abstract void doStop() throws Exception;

    public abstract void doCleanup() throws Exception;
}

