/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.lifecycle;

import de.dailab.jiactng.agentcore.lifecycle.ILifecycle;
import de.dailab.jiactng.agentcore.lifecycle.ILifecycleListener;
import de.dailab.jiactng.agentcore.lifecycle.LifecycleEvent;
import java.util.ArrayList;
import java.util.List;

public class DefaultLifecycleHandler {
    protected ILifecycle.LifecycleStates state = ILifecycle.LifecycleStates.UNDEFINED;
    protected ILifecycle lifecycle = null;
    protected List<ILifecycleListener> listeners = new ArrayList<ILifecycleListener>();

    public DefaultLifecycleHandler(ILifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public ILifecycle.LifecycleStates getState() {
        return this.state;
    }

    public ILifecycleListener createLifecycleListener() {
        return new AnonymousLifecycleListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireLifecycleEvent(LifecycleEvent evt) {
        List<ILifecycleListener> list = this.listeners;
        synchronized (list) {
            for (ILifecycleListener ll : this.listeners) {
                ll.onEvent(evt);
            }
        }
    }

    public void addLifecycleListener(ILifecycleListener listener) {
        if (listener instanceof AnonymousLifecycleListener && ((AnonymousLifecycleListener)listener).getCreator() == this) {
            throw new IllegalArgumentException("You cannot add a listener to the handler that created it");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeLifecycleListener(ILifecycleListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void beforeInit() throws IllegalStateException {
        if (!this.state.equals((Object)ILifecycle.LifecycleStates.UNDEFINED) && !this.state.equals((Object)ILifecycle.LifecycleStates.CLEANED_UP)) {
            throw new IllegalStateException("Lifecycle is not in state UNDEFINED or CLEANED_UP.");
        }
        ILifecycle.LifecycleStates oldState = this.state;
        this.state = ILifecycle.LifecycleStates.INITIALIZING;
        this.lifecycle.stateChanged(oldState, this.state);
        this.fireLifecycleEvent(new LifecycleEvent(this.lifecycle, this.state));
    }

    public void afterInit(boolean success) throws IllegalStateException {
        ILifecycle.LifecycleStates oldState = this.state;
        this.state = success ? ILifecycle.LifecycleStates.INITIALIZED : ILifecycle.LifecycleStates.UNDEFINED;
        this.lifecycle.stateChanged(oldState, this.state);
        this.fireLifecycleEvent(new LifecycleEvent(this.lifecycle, this.state));
    }

    public void beforeStart() throws IllegalStateException {
        switch (this.state) {
            case INITIALIZED: 
            case STOPPED: {
                break;
            }
            case UNDEFINED: 
            case CLEANED_UP: {
                try {
                    this.lifecycle.init();
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            default: {
                throw new IllegalStateException("Lifecycle is already in state STARTED.");
            }
        }
        ILifecycle.LifecycleStates oldState = this.state;
        this.state = ILifecycle.LifecycleStates.STARTING;
        this.lifecycle.stateChanged(oldState, this.state);
        this.fireLifecycleEvent(new LifecycleEvent(this.lifecycle, this.state));
    }

    public void afterStart(boolean success) throws IllegalStateException {
        ILifecycle.LifecycleStates oldState = this.state;
        this.state = success ? ILifecycle.LifecycleStates.STARTED : ILifecycle.LifecycleStates.INITIALIZED;
        this.lifecycle.stateChanged(oldState, this.state);
        this.fireLifecycleEvent(new LifecycleEvent(this.lifecycle, this.state));
    }

    public void beforeStop() throws IllegalStateException {
        if (!this.state.equals((Object)ILifecycle.LifecycleStates.STARTED)) {
            throw new IllegalStateException("Lifecycle is not in state STARTED.");
        }
        ILifecycle.LifecycleStates oldState = this.state;
        this.state = ILifecycle.LifecycleStates.STOPPING;
        this.lifecycle.stateChanged(oldState, this.state);
        this.fireLifecycleEvent(new LifecycleEvent(this.lifecycle, this.state));
    }

    public void afterStop() throws IllegalStateException {
        ILifecycle.LifecycleStates oldState = this.state;
        this.state = ILifecycle.LifecycleStates.STOPPED;
        this.lifecycle.stateChanged(oldState, this.state);
        this.fireLifecycleEvent(new LifecycleEvent(this.lifecycle, this.state));
    }

    public void beforeCleanup() throws IllegalStateException {
        switch (this.state) {
            case INITIALIZED: 
            case STOPPED: {
                break;
            }
            case STARTED: {
                try {
                    this.lifecycle.stop();
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            default: {
                throw new IllegalStateException("Lifecycle is already in state CLEANED_UP or UNDEFINED.");
            }
        }
        ILifecycle.LifecycleStates oldState = this.state;
        this.state = ILifecycle.LifecycleStates.CLEANING_UP;
        this.lifecycle.stateChanged(oldState, this.state);
        this.fireLifecycleEvent(new LifecycleEvent(this.lifecycle, this.state));
    }

    public void afterCleanup() throws IllegalStateException {
        ILifecycle.LifecycleStates oldState = this.state;
        this.state = ILifecycle.LifecycleStates.CLEANED_UP;
        this.lifecycle.stateChanged(oldState, this.state);
        this.fireLifecycleEvent(new LifecycleEvent(this.lifecycle, this.state));
    }

    protected void setState(ILifecycle.LifecycleStates targetState) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected class AnonymousLifecycleListener
    implements ILifecycleListener {
        DefaultLifecycleHandler creator = null;

        AnonymousLifecycleListener(DefaultLifecycleHandler creator) {
            this.creator = creator;
        }

        public void onEvent(LifecycleEvent evt) {
            this.creator.fireLifecycleEvent(evt);
        }

        protected DefaultLifecycleHandler getCreator() {
            return this.creator;
        }
    }
}

