/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.management.jmx;

import de.dailab.jiactng.agentcore.management.jmx.JaasConfigurationEntry;
import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class JaasAuthenticator
implements JMXAuthenticator {
    protected Configuration configuration;

    @Override
    public Subject authenticate(Object credentials) {
        if (!(credentials instanceof String[])) {
            if (credentials == null) {
                throw new SecurityException("Credentials required");
            }
            throw new SecurityException("Credentials should be String[]");
        }
        String[] aCredentials = (String[])credentials;
        if (aCredentials.length != 2) {
            throw new SecurityException("Credentials should have 2 elements");
        }
        try {
            LoginContext lc = new LoginContext("LoginJaas", null, new JaasCallbackHandler(aCredentials[0], aCredentials[1].toCharArray()), this.configuration);
            lc.login();
            Set<Principal> principals = lc.getSubject().getPrincipals();
            HashSet<JMXPrincipal> jmxPrincipals = new HashSet<JMXPrincipal>();
            for (Principal principal : principals) {
                jmxPrincipals.add(new JMXPrincipal(principal.getName()));
            }
            lc.logout();
            return new Subject(true, jmxPrincipals, Collections.EMPTY_SET, Collections.EMPTY_SET);
        }
        catch (LoginException le) {
            le.printStackTrace();
            throw new SecurityException("Authentication failed");
        }
        catch (SecurityException se) {
            se.printStackTrace();
            throw se;
        }
    }

    public void setConfiguration(List<JaasConfigurationEntry> entries) {
        this.configuration = new JaasConfiguration(entries);
    }

    public void setSystemProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            System.setProperty(property.getKey(), property.getValue());
        }
    }

    private class JaasCallbackHandler
    implements CallbackHandler {
        private String username;
        private char[] password;

        public JaasCallbackHandler(String username, char[] password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof TextOutputCallback) {
                    TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                    switch (toc.getMessageType()) {
                        case 0: {
                            System.out.println(toc.getMessage());
                            break;
                        }
                        case 2: {
                            System.out.println("ERROR: " + toc.getMessage());
                            break;
                        }
                        case 1: {
                            System.out.println("WARNING: " + toc.getMessage());
                            break;
                        }
                        default: {
                            throw new IOException("Unsupported message type: " + toc.getMessageType());
                        }
                    }
                    continue;
                }
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(this.username);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    pc.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }

    private class JaasConfiguration
    extends Configuration {
        private AppConfigurationEntry[] entries;

        public JaasConfiguration(List<JaasConfigurationEntry> entries) {
            int size = entries.size();
            this.entries = new AppConfigurationEntry[size];
            for (int i = 0; i < size; ++i) {
                JaasConfigurationEntry entry = entries.get(i);
                String controlFlag = entry.getControlFlag();
                AppConfigurationEntry.LoginModuleControlFlag flag = null;
                if (controlFlag.equals("optional")) {
                    flag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
                } else if (controlFlag.equals("required")) {
                    flag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                } else if (controlFlag.equals("requisite")) {
                    flag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
                } else if (controlFlag.equals("sufficient")) {
                    flag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
                }
                this.entries[i] = new AppConfigurationEntry(entry.getLoginModuleName(), flag, entry.getOptions());
            }
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return this.entries;
        }
    }
}

