/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.ontology;

import de.dailab.jiactng.agentcore.comm.CommunicationAddressFactory;
import de.dailab.jiactng.agentcore.comm.IMessageBoxAddress;
import de.dailab.jiactng.agentcore.ontology.IAgentDescription;
import de.dailab.jiactng.agentcore.util.EqualityChecker;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class AgentDescription
implements IAgentDescription {
    private static final long serialVersionUID = -5364612545330522105L;
    private String aid;
    private String name;
    private String state;
    private IMessageBoxAddress messageBoxAddress;
    private String agentNodeUUID;
    private Boolean isMobile = false;

    public AgentDescription() {
        this(null, null, null, null, null, null);
    }

    public AgentDescription(String aid, String name, String state, IMessageBoxAddress messageBoxAddress, String agentNodeUUID) {
        this(aid, name, state, messageBoxAddress, agentNodeUUID, false);
    }

    public AgentDescription(String aid, String name, String state, IMessageBoxAddress messageBoxAddress, String agentNodeUUID, Boolean mobile) {
        this.aid = aid;
        this.name = name;
        this.state = state;
        this.messageBoxAddress = messageBoxAddress;
        this.agentNodeUUID = agentNodeUUID;
        this.isMobile = mobile;
    }

    public AgentDescription(CompositeData descr) {
        this.aid = (String)descr.get("id");
        this.name = (String)descr.get("name");
        this.agentNodeUUID = (String)descr.get("node UUID");
        this.state = (String)descr.get("state");
        this.isMobile = (Boolean)descr.get("mobile");
        String address = (String)descr.get("message box address");
        if (address != null) {
            this.messageBoxAddress = CommunicationAddressFactory.createMessageBoxAddress(address);
        }
    }

    public String getAid() {
        return this.aid;
    }

    public void setAid(String newAid) {
        this.aid = newAid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String newState) {
        this.state = newState;
    }

    public IMessageBoxAddress getMessageBoxAddress() {
        return this.messageBoxAddress;
    }

    public void setMessageBoxAddress(IMessageBoxAddress newMessageBoxAddress) {
        this.messageBoxAddress = newMessageBoxAddress;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AgentDescription)) {
            return false;
        }
        AgentDescription other = (AgentDescription)obj;
        return EqualityChecker.equalsOrNull((Object)this.aid, (Object)other.aid);
    }

    public int hashCode() {
        return AgentDescription.class.hashCode() ^ (this.aid != null ? this.aid.hashCode() : 0);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Agent:\n name=");
        if (this.name != null) {
            builder.append("'").append(this.name).append("'");
        } else {
            builder.append("null");
        }
        builder.append("\n aid=");
        if (this.aid != null) {
            builder.append("'").append(this.aid).append("'");
        } else {
            builder.append("null");
        }
        builder.append("\n state=");
        if (this.state != null) {
            builder.append("'").append(this.state).append("'");
        } else {
            builder.append("null");
        }
        if (this.messageBoxAddress != null) {
            builder.append("\n messageBoxAddress=").append(this.messageBoxAddress.toString());
        } else {
            builder.append("\n messageBoxAddress=null");
        }
        if (this.isMobile != null) {
            builder.append("\n mobile=").append(this.isMobile.toString());
        } else {
            builder.append("\n mobile=null");
        }
        builder.append('\n');
        return builder.toString();
    }

    public String getAgentNodeUUID() {
        return this.agentNodeUUID;
    }

    public void setAgentNodeUUID(String uuid) {
        this.agentNodeUUID = uuid;
    }

    public void setMobile(Boolean mobile) {
        if (mobile == null) {
            return;
        }
        this.isMobile = mobile;
    }

    public Boolean isMobile() {
        return this.isMobile;
    }

    private String[] getItemNames() {
        return new String[]{"id", "name", "node UUID", "state", "mobile", "message box address"};
    }

    public OpenType<?> getDescriptionType() throws OpenDataException {
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING};
        String[] itemDescriptions = this.getItemNames();
        return new CompositeType(this.getClass().getName(), "standard JIAC-TNG agent description", this.getItemNames(), itemDescriptions, itemTypes);
    }

    public Object getDescription() throws OpenDataException {
        Object[] itemValues = new Object[]{this.aid, this.name, this.agentNodeUUID, this.state, this.isMobile, this.messageBoxAddress != null ? this.messageBoxAddress.getName() : null};
        CompositeType type = (CompositeType)this.getDescriptionType();
        return new CompositeDataSupport(type, this.getItemNames(), itemValues);
    }
}

