/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.ontology;

import de.dailab.jiactng.agentcore.comm.CommunicationAddressFactory;
import de.dailab.jiactng.agentcore.comm.ICommunicationAddress;
import de.dailab.jiactng.agentcore.ontology.IAgentNodeDescription;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.remote.JMXServiceURL;

public class AgentNodeDescription
implements IAgentNodeDescription {
    private static final long serialVersionUID = -7460322120270381260L;
    private ICommunicationAddress address;
    private Set<JMXServiceURL> jmxURLs;
    private long alive;

    public AgentNodeDescription(ICommunicationAddress address, long alive) {
        this.address = address;
        this.alive = alive;
    }

    public AgentNodeDescription(CompositeData descr) {
        String commAddress = (String)descr.get("address");
        if (commAddress != null) {
            this.address = CommunicationAddressFactory.createMessageBoxAddress(commAddress);
        }
        this.jmxURLs = new HashSet<JMXServiceURL>();
        for (String url : (String[])descr.get("jmxURLs")) {
            try {
                this.jmxURLs.add(new JMXServiceURL(url));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        try {
            this.alive = DateFormat.getInstance().parse((String)descr.get("alive")).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public final ICommunicationAddress getAddress() {
        return this.address;
    }

    public final void setAddress(ICommunicationAddress newAddress) {
        this.address = newAddress;
    }

    public final Set<JMXServiceURL> getJmxURLs() {
        return this.jmxURLs;
    }

    public final void setJmxURLs(Set<JMXServiceURL> newJmxURLs) {
        this.jmxURLs = Collections.unmodifiableSet(newJmxURLs);
    }

    public final long getAlive() {
        return this.alive;
    }

    public final void setAlive(long newAlive) {
        this.alive = newAlive;
    }

    private String[] getItemNames() {
        return new String[]{"address", "jmxURLs", "alive"};
    }

    public OpenType<?> getDescriptionType() throws OpenDataException {
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, ArrayType.getArrayType(SimpleType.STRING), SimpleType.STRING};
        String[] itemDescriptions = this.getItemNames();
        return new CompositeType(this.getClass().getName(), "standard JIAC-TNG agent node description", this.getItemNames(), itemDescriptions, itemTypes);
    }

    public Object getDescription() throws OpenDataException {
        String[] urls = null;
        if (this.jmxURLs != null) {
            int i = 0;
            urls = new String[this.jmxURLs.size()];
            for (JMXServiceURL url : this.jmxURLs) {
                urls[i++] = url.toString();
            }
        }
        Object[] itemValues = new Object[]{this.address != null ? this.address.getName() : null, urls, new Date(this.alive).toString()};
        CompositeType type = (CompositeType)this.getDescriptionType();
        return new CompositeDataSupport(type, this.getItemNames(), itemValues);
    }
}

