/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class IdentityHashSet<E>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8782662619051723940L;
    private transient IdentityHashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(Collection<? extends E> c) {
        this.map = new IdentityHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 32));
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public Object clone() {
        try {
            IdentityHashSet newSet = (IdentityHashSet)super.clone();
            newSet.map = (IdentityHashMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.map.size());
        Iterator<E> i = this.map.keySet().iterator();
        while (i.hasNext()) {
            s.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.map = new IdentityHashMap(size);
        for (int i = 0; i < size; ++i) {
            Object e = s.readObject();
            this.map.put(e, PRESENT);
        }
    }
}

